/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.impl.TemplateManagerUtilBase;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.TemplateStateBase;
import com.intellij.database.Dbms;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.SqlQualifiedResolveResult;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlPrefixedElement;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlWindowClauseImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlInsertHandlers {
    public static final InsertHandler<LookupElement> TEMPLATE_SAFE_INSERT_HANDLER = new TemplateSafeInsertHandler("", false);
    public static final InsertHandler<LookupElement> DOT_INSERT_HANDLER = (context, item) -> {
        if (context.getCompletionChar() != '.') {
            boolean alreadyDot;
            String text2 = context.getDocument().getText();
            boolean bl = alreadyDot = text2.length() > context.getTailOffset() && text2.charAt(context.getTailOffset()) == '.';
            if (!alreadyDot) {
                context.getDocument().insertString(context.getTailOffset(), (CharSequence)".");
            }
            context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
            AutoPopupController.getInstance((Project)context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
        }
    };
    public static final InsertHandler<LookupElement> INSIDE_QUOT_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            LeafPsiElement leaf;
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            Document document = context.getDocument();
            CharSequence text2 = document.getCharsSequence();
            int end = context.getTailOffset();
            SqlReferenceExpression reference = (SqlReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), SqlReferenceExpression.class, (boolean)false);
            if (reference != null && !reference.isQuotedIdentifier()) {
                return;
            }
            SqlReferenceExpression anchor2 = reference;
            if (anchor2 == null && (leaf = (LeafPsiElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), LeafPsiElement.class, (boolean)false)) != null && leaf.getElementType() == SqlTokens.SQL_UNCLOSED_TOKEN) {
                anchor2 = leaf;
            }
            Dbms dbms = SqlImplUtil.getDbms((PsiElement)context.getFile());
            char closeQuote = this.guessQuote((PsiElement)anchor2, NamingServices.getNamingService(dbms).getClosingQuote());
            if (end >= text2.length() || text2.charAt(end) != closeQuote) {
                document.insertString(end, (CharSequence)String.valueOf(closeQuote));
            }
            context.getEditor().getCaretModel().moveToOffset(context.getEditor().getCaretModel().getOffset() + 1);
            context.setTailOffset(end + 1);
        }

        private char guessQuote(@Nullable PsiElement anchor2, char dialectQuote) {
            if (anchor2 == null) {
                return dialectQuote;
            }
            String text2 = (String)ContainerUtil.getLastItem((List)StringUtil.split((String)anchor2.getText(), (String)"."));
            char c2 = text2 == null ? (char)' ' : (char)text2.charAt(0);
            return c2 == '\"' || c2 == '\'' ? c2 : dialectQuote;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/completion/SqlInsertHandlers$1";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    static final InsertHandler<LookupElement> ADD_TABLE_ALIAS_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            int offset;
            PsiFile file;
            PsiReference reference;
            if (context == null) {
                2.$$$reportNull$$$0(0);
            }
            if (item == null) {
                2.$$$reportNull$$$0(1);
            }
            if (!((reference = (file = context.getFile()).findReferenceAt((offset = context.getTailOffset()) - 1)) instanceof SqlReferenceImpl) || ((SqlReferenceImpl)reference).getReferenceElementType() != SqlCompositeElementTypes.SQL_TABLE_REFERENCE) {
                return;
            }
            PsiElement element2 = reference.getElement();
            if (!(element2 instanceof SqlReferenceExpression)) {
                return;
            }
            PsiElement resolveResult = ((SqlReferenceExpression)element2).resolve();
            if (!(resolveResult instanceof DasTable)) {
                return;
            }
            String aliasName = SqlNamesGenerator.suggestAliasName(((DasTable)resolveResult).getName(), element2);
            Case keywordCase = SqlPsiMiscUtil.settings(element2.getContainingFile()).getKeywordCase();
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(element2);
            String delimiter = dialect.requiresAsForAliasAt(element2) ? " " + keywordCase.apply("as") + " " : " ";
            context.getDocument().insertString(offset, (CharSequence)(delimiter + aliasName));
            context.getEditor().getCaretModel().moveToOffset(offset + aliasName.length() + delimiter.length());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/completion/SqlInsertHandlers$2";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final InsertHandler<LookupElement> INSIDE_QUOT_DOT_INSERT_HANDLER = SqlInsertHandlers.chainHandlers(INSIDE_QUOT_INSERT_HANDLER, DOT_INSERT_HANDLER);
    public static final InsertHandler<LookupElement> QUOT_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            int endOff;
            boolean rightIsQuote;
            DasSymbol symbol;
            ObjectKind kind;
            String toInsertQuoted;
            if (context == null) {
                3.$$$reportNull$$$0(0);
            }
            if (item == null) {
                3.$$$reportNull$$$0(1);
            }
            if (this.isForBuiltInFunction(item)) {
                return;
            }
            Dbms dbms = SqlImplUtil.getDbms((PsiElement)context.getFile());
            NamingService namingService2 = NamingServices.getNamingService(dbms);
            String toInsert2 = item.getLookupString();
            if (toInsert2.equals(toInsertQuoted = SqlCompletionUtil.getNameQuotationSettingAware(toInsert2, kind = (symbol = SqlCompletionUtil.getTargetSymbol(item)) == null ? null : symbol.getKind(), context.getFile()))) {
                return;
            }
            Document document = context.getDocument();
            CharSequence text2 = document.getCharsSequence();
            int start2 = context.getStartOffset();
            int end = context.getTailOffset();
            char leftChar = start2 > 0 ? text2.charAt(start2 - 1) : (char)'\u0000';
            char rightExpected = ((Character)ObjectUtils.notNull((Object)namingService2.closingQuoteFor(leftChar), (Object)Character.valueOf('\u0000'))).charValue();
            boolean leftIsQuote = rightExpected != '\u0000';
            char rightChar = end < document.getTextLength() ? text2.charAt(end) : (char)'\u0000';
            boolean bl = rightIsQuote = namingService2.getClosingQuotes().indexOf(rightChar) != -1;
            if (!leftIsQuote) {
                document.insertString(start2, (CharSequence)toInsertQuoted.substring(0, 1));
            }
            int n = endOff = !leftIsQuote ? 1 : 0;
            if (leftIsQuote && (!rightIsQuote || rightExpected != rightChar)) {
                document.insertString(end + endOff, (CharSequence)String.valueOf(rightExpected));
            } else if (!leftIsQuote) {
                document.insertString(end + endOff, (CharSequence)toInsertQuoted.substring(toInsertQuoted.length() - 1));
            }
            context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
        }

        private boolean isForBuiltInFunction(@NotNull LookupElement item) {
            if (item == null) {
                3.$$$reportNull$$$0(2);
            }
            return item.getObject() instanceof BuiltinFunction.Prototype;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/completion/SqlInsertHandlers$3";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleInsert";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isForBuiltInFunction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final InsertHandler<LookupElement> QUOT_DOT_INSERT_HANDLER = SqlInsertHandlers.chainHandlers(QUOT_INSERT_HANDLER, DOT_INSERT_HANDLER);
    public static final InsertHandler<LookupElement> NEW_LINE_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            int lineEnd;
            if (context == null) {
                4.$$$reportNull$$$0(0);
            }
            if (item == null) {
                4.$$$reportNull$$$0(1);
            }
            String text2 = context.getDocument().getText();
            boolean insert = true;
            int offset = context.getTailOffset();
            if (text2.length() > offset && (lineEnd = context.getDocument().getLineEndOffset(context.getDocument().getLineNumber(offset))) > offset && !StringUtil.isEmptyOrSpaces((String)context.getDocument().getText(TextRange.create((int)offset, (int)lineEnd)))) {
                insert = false;
            }
            if (insert) {
                context.getDocument().insertString(offset, (CharSequence)"\n");
                context.getEditor().getCaretModel().moveToOffset(offset + 1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/completion/SqlInsertHandlers$4";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final InsertHandler<LookupElement> DUMMY_HANDLER = (context, item) -> {};
    static final InsertHandler<LookupElement> WHITESPACE_PROTECTED = new TemplateSafeInsertHandler(",;", false);
    static final InsertHandler<LookupElement> WHITESPACE_POPUP_PROTECTED = new TemplateSafeInsertHandler(",;", true);
    public static final InsertHandler<LookupElement> ADD_RPAREN_LOOKUP_HANDLER = (context, item) -> {
        if (context.getCompletionChar() != ')') {
            SqlValuesExpression values2;
            Editor editor2 = context.getEditor();
            Document document = editor2.getDocument();
            context.commitDocument();
            int offset = context.getTailOffset();
            PsiElement at = context.getFile().findElementAt(offset > 1 ? offset - 1 : offset);
            SqlElement tcl = (SqlElement)PsiTreeUtil.getParentOfType((PsiElement)at, SqlTableColumnsList.class);
            if (tcl == null) {
                tcl = (SqlElement)PsiTreeUtil.getParentOfType((PsiElement)at, SqlReferenceList.class);
            }
            if ((values2 = (SqlValuesExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)tcl, SqlValuesExpression.class)) != null) {
                return;
            }
            SqlReferenceList list = (SqlReferenceList)PsiTreeUtil.getParentOfType((PsiElement)at, SqlReferenceList.class);
            if (list != null) {
                ASTNode right = list.getNode().findChildByType((IElementType)SqlCommonTokens.SQL_RIGHT_PAREN);
                String what = right == null ? ") " : " ";
                int where2 = right == null ? offset : right.getStartOffset() + 1;
                document.insertString(where2, (CharSequence)what);
                editor2.getCaretModel().moveToOffset(where2 + what.length());
                AutoPopupController.getInstance((Project)at.getProject()).autoPopupMemberLookup(editor2, null);
            }
        }
    };

    public static InsertHandler<LookupElement> chainHandlers(InsertHandler<LookupElement> ... handlers) {
        if (handlers.length == 0) {
            return DUMMY_HANDLER;
        }
        if (handlers.length == 1) {
            return handlers[0];
        }
        if (handlers.length == 2) {
            if (handlers[0] == null) {
                return handlers[1];
            }
            if (handlers[1] == null) {
                return handlers[0];
            }
        }
        return (context, item) -> {
            for (InsertHandler handler2 : handlers) {
                if (handler2 == null) continue;
                handler2.handleInsert(context, item);
                context.commitDocument();
            }
        };
    }

    @NotNull
    public static InsertHandler<LookupElement> createQualifierHandler(NamingService namingService2) {
        return SqlInsertHandlers.createQualifierHandler(namingService2, false, ContainerUtil.emptyList());
    }

    @NotNull
    public static InsertHandler<LookupElement> createQualifierHandler(final NamingService namingService2, final boolean qualifyWholeList, final List<PsiElement> customQualifiers) {
        return new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                SqlIdentifier identifier;
                List<String> forcedContext;
                if (context == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    5.$$$reportNull$$$0(1);
                }
                context.commitDocument();
                if (!context.getOffsetMap().containsOffset(InsertionContext.TAIL_OFFSET)) {
                    return;
                }
                int offset = context.getTailOffset();
                DasSymbol symbol = SqlCompletionUtil.getTargetSymbol(item);
                if (symbol == null) {
                    return;
                }
                DasObject obj2 = symbol.getDasObject();
                if (obj2 == null) {
                    return;
                }
                SqlQualifiedResolveResult resolveResult = (SqlQualifiedResolveResult)ObjectUtils.tryCast((Object)item.getObject(), SqlQualifiedResolveResult.class);
                List<String> list = forcedContext = resolveResult == null ? null : resolveResult.getQualification();
                if (forcedContext == null) {
                    forcedContext = this.qualification(obj2.getDasParent());
                }
                SqlReferenceExpression ref2 = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(offset > 1 ? offset - 1 : offset), SqlReferenceExpression.class, (boolean)false);
                SqlIdentifier sqlIdentifier = identifier = ref2 == null ? null : ref2.getIdentifier();
                if (identifier == null || ref2.getQualifierExpression() != null || ref2.getParent() instanceof SqlReferenceExpression) {
                    return;
                }
                Condition filter2 = obj2 instanceof SqlElement ? rr -> SqlImplUtil.canBeQualifier(rr) && rr.getElement() instanceof SqlElement : rr -> SqlImplUtil.canBeQualifier(rr) && !(rr.getElement() instanceof SqlElement);
                List resolveResults = ContainerUtil.filter((Object[])ref2.multiResolve(false), (Condition)filter2);
                if (!this.shouldQualify(ref2, resolveResults)) {
                    return;
                }
                SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)context.getFile());
                List<List<ObjectName>> qualifiers = this.getQualifier(language, resolveResults, forcedContext, obj2, identifier, (Condition<ResolveResult>)filter2);
                if ((!qualifyWholeList || customQualifiers.isEmpty()) && qualifiers.isEmpty()) {
                    return;
                }
                if (!qualifyWholeList) {
                    SqlIntentionUtil.qualifyReference(qualifiers, namingService2, identifier, context.getEditor());
                } else {
                    PsiElement parent2 = ref2.getParent();
                    List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)parent2, SqlReferenceExpression.class);
                    for (int i2 = 0; i2 < list2.size(); ++i2) {
                        PsiElement qualifier;
                        SqlIdentifier ident;
                        SqlReferenceExpression expression = (SqlReferenceExpression)list2.get(i2);
                        if (expression.getQualifierExpression() != null || (ident = expression.getIdentifier()) == null) continue;
                        if (i2 < customQualifiers.size() && (qualifier = (PsiElement)customQualifiers.get(i2)) instanceof DasObject) {
                            JBIterable<String> qualification = this.qualification((DasObject)qualifier);
                            resolveResults = ContainerUtil.filter((Object[])expression.multiResolve(false), (Condition)filter2);
                            qualifiers = this.getQualifier(language, resolveResults, (Iterable<String>)qualification, null, identifier, (Condition<ResolveResult>)filter2);
                        }
                        context.getEditor().getCaretModel().moveToOffset(expression.getTextRange().getEndOffset());
                        SqlIntentionUtil.qualifyReference(qualifiers, namingService2, ident, context.getEditor());
                        context.commitDocument();
                    }
                }
            }

            private boolean shouldQualify(@NotNull SqlReferenceExpression ref2, List<ResolveResult> resolveResults) {
                if (ref2 == null) {
                    5.$$$reportNull$$$0(2);
                }
                SqlEditorOptions options2 = SqlEditorOptions.getInstance();
                ObjectKind kind = ObjectKind.NONE;
                for (ResolveResult result2 : resolveResults) {
                    PsiElement qualifier = SqlImplUtil.getQualifier(result2);
                    if (qualifier instanceof DasObject) {
                        kind = DasUtil.getKind((DasObject)qualifier);
                    } else if (qualifier instanceof SqlQueryExpression) {
                        kind = ObjectKind.TABLE;
                    }
                    if (kind == ObjectKind.NONE) continue;
                    break;
                }
                SqlEditorOptions.QualificationType qualification = kind != ObjectKind.NONE ? DbSqlUtilCore.getQualificationByParentKind(kind) : DbSqlUtilCore.getQualification(ref2.getReferenceElementType().getTargetKind(), SqlImplUtil.getDbms((PsiElement)ref2));
                qualification = qualification.and(options2.getCompletionQualification());
                return qualification.shouldQualify(resolveResults.size());
            }

            private List<List<ObjectName>> getQualifierForUnresolvedRef(@NotNull DasObject obj2, @NotNull SqlIdentifier identifier, Condition<ResolveResult> filter2) {
                List resolveResults;
                SqlLanguageDialectEx dialect;
                String schemaName;
                SqlReferenceExpression ref2;
                DasObject grandParent;
                DasObject parent2;
                if (obj2 == null) {
                    5.$$$reportNull$$$0(3);
                }
                if (identifier == null) {
                    5.$$$reportNull$$$0(4);
                }
                if ((parent2 = obj2.getDasParent()) == null || parent2.getName().isEmpty()) {
                    return Collections.emptyList();
                }
                SmartList paths2 = new SmartList();
                paths2.add(DbSqlUtilCore.getName(parent2));
                if (parent2.getKind() == ObjectKind.SCHEMA && (grandParent = parent2.getDasParent()) != null && grandParent.getKind() == ObjectKind.DATABASE && !grandParent.getName().isEmpty() && (ref2 = SqlPsiElementFactory.createReferenceFromText(schemaName = NamingServices.getNamingService((dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)identifier)).getDbms()).enquote(parent2.getName(), parent2.getKind()), dialect, SqlCompositeElementTypes.SQL_SCHEMA_REFERENCE, (PsiElement)identifier)) != null && this.shouldQualify(ref2, resolveResults = ContainerUtil.filter((Object[])ref2.multiResolve(false), filter2))) {
                    paths2.add(0, DbSqlUtilCore.getName(grandParent));
                }
                return Collections.singletonList(paths2);
            }

            @NotNull
            private List<List<ObjectName>> getQualifier(@NotNull CasingProvider casingProvider, @NotNull List<ResolveResult> results2, @Nullable Iterable<String> forcedContext, @Nullable DasObject obj2, @NotNull SqlIdentifier identifier, Condition<ResolveResult> filter2) {
                if (casingProvider == null) {
                    5.$$$reportNull$$$0(5);
                }
                if (results2 == null) {
                    5.$$$reportNull$$$0(6);
                }
                if (identifier == null) {
                    5.$$$reportNull$$$0(7);
                }
                if (results2.isEmpty() && obj2 != null) {
                    List<List<ObjectName>> list = this.getQualifierForUnresolvedRef(obj2, identifier, filter2);
                    if (list == null) {
                        5.$$$reportNull$$$0(8);
                    }
                    return list;
                }
                LinkedHashSet<DasObject> qualifiers = new LinkedHashSet<DasObject>();
                HashSet<DasObject> all2 = new HashSet<DasObject>();
                for (ResolveResult result2 : results2) {
                    boolean kindUnsuitable;
                    PsiElement psi = SqlCompletionUtil.getQualifier(result2);
                    DasObject qual = (DasObject)ObjectUtils.tryCast((Object)psi, DasObject.class);
                    DasObject elem = (DasObject)ObjectUtils.tryCast((Object)result2.getElement(), DasObject.class);
                    ObjectKind elementKind = elem == null ? null : elem.getKind();
                    boolean bl = kindUnsuitable = elementKind != ObjectKind.TABLE && elementKind != ObjectKind.VIEW && elementKind != ObjectKind.COLUMN && (elementKind != SqlDbElementType.LOCAL_ALIAS || qual != null && qual.getKind() != SqlDbElementType.LOCAL_ALIAS);
                    if (psi != null && qual == null || elem == null || kindUnsuitable) continue;
                    if (qual == null) {
                        qual = elem.getDasParent();
                    }
                    if (qual == null) continue;
                    if ((obj2 == null || Objects.equals(elem.getName(), obj2.getName())) && this.eq((Iterable<String>)this.qualification(qual), forcedContext)) {
                        qualifiers.add(qual);
                    }
                    all2.add(qual);
                }
                SmartList qualPaths = new SmartList();
                for (DasObject qualifier : qualifiers) {
                    SmartList list = new SmartList();
                    all2.remove(qualifier);
                    this.appendQualification(qualifier, all2, (List<ObjectName>)list, casingProvider);
                    all2.add(qualifier);
                    if (list.isEmpty()) continue;
                    qualPaths.add(list);
                }
                SmartList smartList = qualPaths;
                if (smartList == null) {
                    5.$$$reportNull$$$0(9);
                }
                return smartList;
            }

            @Contract(value="null -> null; !null -> !null")
            private JBIterable<String> qualification(@Nullable DasObject obj2) {
                return obj2 == null ? null : DasUtil.dasParents(obj2).transform(DasUtil.TO_NAME);
            }

            private boolean eq(@Nullable Iterable<String> it1, @Nullable Iterable<String> it2) {
                if (it1 == null || it2 == null) {
                    return it1 == it2;
                }
                Iterator<String> i1 = it1.iterator();
                Iterator<String> i2 = it2.iterator();
                while (i1.hasNext() && i2.hasNext()) {
                    if (Objects.equals(i1.next(), i2.next())) continue;
                    return false;
                }
                return i1.hasNext() == i2.hasNext();
            }

            private void appendQualification(@Nullable DasObject qualifier, @NotNull Set<DasObject> other, @NotNull List<ObjectName> path, @NotNull CasingProvider casingProvider) {
                if (other == null) {
                    5.$$$reportNull$$$0(10);
                }
                if (path == null) {
                    5.$$$reportNull$$$0(11);
                }
                if (casingProvider == null) {
                    5.$$$reportNull$$$0(12);
                }
                if (qualifier == null || StringUtil.isEmpty((String)qualifier.getName())) {
                    return;
                }
                List qualifications = ContainerUtil.map(other, current -> this.fullQualification((DasObject)current));
                List<DasObject> qualification = this.fullQualification(qualifier);
                path.addAll(ContainerUtil.map(this.cutAllFromFirstDifferentElement(qualification, qualifications, casingProvider), DbSqlUtilCore::getName));
            }

            @NotNull
            private List<DasObject> fullQualification(@NotNull DasObject object) {
                if (object == null) {
                    5.$$$reportNull$$$0(13);
                }
                List list = ContainerUtil.reverse((List)DasUtil.dasParents(object).toList());
                if (list == null) {
                    5.$$$reportNull$$$0(14);
                }
                return list;
            }

            @NotNull
            private List<DasObject> cutAllFromFirstDifferentElement(@NotNull List<DasObject> qualification, @NotNull List<List<DasObject>> qualifications, @NotNull CasingProvider provider) {
                OptionalInt indices;
                if (qualification == null) {
                    5.$$$reportNull$$$0(15);
                }
                if (qualifications == null) {
                    5.$$$reportNull$$$0(16);
                }
                if (provider == null) {
                    5.$$$reportNull$$$0(17);
                }
                int firstDifferentIndex = Math.max((indices = qualifications.stream().mapToInt(list -> this.firstDifferentElement(qualification, (List<DasObject>)list, provider)).min()).isPresent() ? indices.getAsInt() : qualification.size() - 1, 0);
                List list2 = ContainerUtil.subList(qualification, (int)firstDifferentIndex);
                if (list2 == null) {
                    5.$$$reportNull$$$0(18);
                }
                return list2;
            }

            private int firstDifferentElement(@NotNull List<DasObject> first2, @NotNull List<DasObject> second, @NotNull CasingProvider provider) {
                if (first2 == null) {
                    5.$$$reportNull$$$0(19);
                }
                if (second == null) {
                    5.$$$reportNull$$$0(20);
                }
                if (provider == null) {
                    5.$$$reportNull$$$0(21);
                }
                int firstIdx = first2.size() - 1;
                for (int secondIdx = second.size() - 1; firstIdx >= 0 && secondIdx >= 0 && DasUtil.byName(first2.get(firstIdx).getName(), provider).value((Object)second.get(secondIdx)); --firstIdx, --secondIdx) {
                }
                return firstIdx;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 8, 9, 14, 18 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ref";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "obj";
                        break;
                    }
                    case 4: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "identifier";
                        break;
                    }
                    case 5: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "casingProvider";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "results";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 14: 
                    case 18: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/completion/SqlInsertHandlers$5";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "other";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "object";
                        break;
                    }
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "qualification";
                        break;
                    }
                    case 16: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "qualifications";
                        break;
                    }
                    case 17: 
                    case 21: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "provider";
                        break;
                    }
                    case 19: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "first";
                        break;
                    }
                    case 20: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "second";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/completion/SqlInsertHandlers$5";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getQualifier";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fullQualification";
                        break;
                    }
                    case 18: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cutAllFromFirstDifferentElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "handleInsert";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "shouldQualify";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getQualifierForUnresolvedRef";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "getQualifier";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 14: 
                    case 18: {
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "appendQualification";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray;
                        objectArray[2] = "fullQualification";
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: {
                        objectArray = objectArray;
                        objectArray[2] = "cutAllFromFirstDifferentElement";
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 21: {
                        objectArray = objectArray;
                        objectArray[2] = "firstDifferentElement";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 8, 9, 14, 18 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public static InsertHandler<LookupElement> createPrefixHandler(final String name2, final ObjectKind kind, final String prefix, final NamingService namingService2) {
        return new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    6.$$$reportNull$$$0(1);
                }
                int start2 = context.getStartOffset();
                int end = context.getTailOffset();
                context.getDocument().replaceString(start2, end, (CharSequence)(prefix + namingService2.catToScript(name2, kind, SqlPsiMiscUtil.settings(context.getFile()).getQuotesPriority())));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/completion/SqlInsertHandlers$6";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public static InsertHandler<LookupElement> getQuoteAndDotHandler(DasSymbol symbol, Project project, NamingService namingService2, boolean addDot, boolean isPlaceQuoted) {
        boolean mayOmitQuotes;
        String prefix;
        SqlPrefixedElement prefixed = symbol instanceof PsiNamedElement ? SqlCompletionUtil.getPrefixed((PsiNamedElement)symbol) : null;
        String string = prefix = prefixed == null ? null : prefixed.getNamePrefix();
        if (prefix != null) {
            return SqlInsertHandlers.createPrefixHandler(symbol.getName(), symbol.getKind(), prefix, namingService2);
        }
        SqlCodeStyleSettings settings = SqlPsiMiscUtil.settings(symbol, project);
        boolean bl = mayOmitQuotes = SqlCompletionUtil.hasPlainIdentifier(symbol) && settings.QUOTE_IDENTIFIER != 2;
        return isPlaceQuoted ? (addDot ? INSIDE_QUOT_DOT_INSERT_HANDLER : INSIDE_QUOT_INSERT_HANDLER) : (mayOmitQuotes ? (addDot ? DOT_INSERT_HANDLER : null) : (addDot ? QUOT_DOT_INSERT_HANDLER : QUOT_INSERT_HANDLER));
    }

    public static class TemplateSafeInsertHandler
    extends AddSpaceInsertHandler {
        public TemplateSafeInsertHandler(String ignoreOnChars, boolean triggerAutoPopup) {
            super(ignoreOnChars, triggerAutoPopup);
        }

        protected boolean shouldOverwriteExistingSpace(Editor editor2) {
            TemplateStateBase state = TemplateManagerUtilBase.getTemplateState((Editor)editor2);
            TextRange range = state instanceof TemplateState ? ((TemplateState)state).getCurrentVariableRange() : null;
            int offset = editor2.getCaretModel().getOffset();
            return range == null || offset != range.getEndOffset();
        }
    }

    public static class FunctionElementInsertHandler
    implements InsertHandler<LookupElement> {
        private final Dbms myDbms;
        private final boolean myUseSpaces;
        private final boolean myNoParams;
        @Nullable
        private final String myParameterList;
        private final BuiltinFunction myDefinition;
        private final BuiltinFunction.Prototype myPrototype;
        private static final String TRUE = "true";

        public FunctionElementInsertHandler(@NotNull Dbms dbms, boolean useSpaces, boolean noParams, @Nullable String parameterList, @Nullable BuiltinFunction definition2, @Nullable BuiltinFunction.Prototype prototype) {
            if (dbms == null) {
                FunctionElementInsertHandler.$$$reportNull$$$0(0);
            }
            this.myDbms = dbms;
            this.myUseSpaces = useSpaces;
            this.myNoParams = noParams;
            this.myParameterList = parameterList;
            this.myDefinition = definition2;
            this.myPrototype = prototype;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            DasSymbol symbol;
            if (context == null) {
                FunctionElementInsertHandler.$$$reportNull$$$0(1);
            }
            if (item == null) {
                FunctionElementInsertHandler.$$$reportNull$$$0(2);
            }
            if ((symbol = SqlCompletionUtil.getTargetSymbol(item)) != null && !SqlCompletionUtil.hasPlainIdentifier(symbol)) {
                QUOT_INSERT_HANDLER.handleInsert(context, item);
            }
            if (!FunctionElementInsertHandler.isInsertingInPgFunctionColumn(context, this.myDbms)) {
                FunctionElementInsertHandler.getInsertHandler(this.myUseSpaces, this.myNoParams, this.myParameterList).handleInsert(context, item);
            }
            if (this.myDefinition != null) {
                BuiltinFunction function2 = this.myDefinition;
                boolean analytic = (!TRUE.equals(function2.getDialectAttribute("aggregate")) || TRUE.equals(function2.getDialectAttribute("rank"))) && (TRUE.equals(function2.getDialectAttribute("analytic")) || this.myPrototype != null && TRUE.equals(this.myPrototype.getAttributes().get("analytic")));
                boolean withinGroup = TRUE.equals(function2.getDialectAttribute("within_group"));
                if (analytic) {
                    int offset = context.getEditor().getCaretModel().getOffset();
                    int insertionPlace = this.myNoParams ? offset : offset + 1;
                    PsiFile file = context.getFile();
                    PsiElement element2 = file.findElementAt(insertionPlace);
                    if (element2 instanceof PsiWhiteSpace) {
                        element2 = PsiTreeUtil.skipWhitespacesForward((PsiElement)element2);
                    }
                    if (element2 != null && "over".equalsIgnoreCase(element2.getText())) {
                        return;
                    }
                    if (withinGroup && element2 != null && "within".equalsIgnoreCase(element2.getText())) {
                        return;
                    }
                    SqlCodeStyleSettings settings = SqlCodeStyles.getSqlSettings((PsiFile)file);
                    Case keywordCase = settings.getKeywordCase();
                    String withinGroupString = withinGroup ? " within group ( order by )" : "";
                    Object fullString = withinGroupString + " over ()" + (element2 instanceof PsiErrorElement ? "," : "");
                    if (keywordCase == Case.UPPER) {
                        fullString = StringUtil.toUpperCase((String)fullString);
                    }
                    context.getDocument().insertString(insertionPlace, (CharSequence)fullString);
                    int newOffset = offset + withinGroupString.length() + " over (".length();
                    if (this.myNoParams) {
                        context.getEditor().getCaretModel().moveToOffset(newOffset);
                    }
                    context.commitDocument();
                    SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(newOffset), SqlQueryExpression.class);
                    if (PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)query, SqlWindowClauseImpl.class).size() > 0) {
                        context.getDocument().deleteString(newOffset - 1, newOffset + 1);
                    }
                }
            }
        }

        @NotNull
        private static InsertHandler<LookupElement> getInsertHandler(boolean useSpaces, boolean noParams, final @Nullable String parameterList) {
            if (useSpaces) {
                InsertHandler insertHandler = noParams ? DUMMY_HANDLER : AddSpaceInsertHandler.INSTANCE;
                if (insertHandler == null) {
                    FunctionElementInsertHandler.$$$reportNull$$$0(3);
                }
                return insertHandler;
            }
            if (noParams) {
                ParenthesesInsertHandler parenthesesInsertHandler = ParenthesesInsertHandler.NO_PARAMETERS;
                if (parenthesesInsertHandler == null) {
                    FunctionElementInsertHandler.$$$reportNull$$$0(4);
                }
                return parenthesesInsertHandler;
            }
            if (parameterList != null) {
                return new InsertHandler<LookupElement>(){

                    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                        if (context == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (item == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        Editor editor2 = context.getEditor();
                        CaretModel caretModel = editor2.getCaretModel();
                        int offset = caretModel.getOffset();
                        editor2.getDocument().insertString(offset, (CharSequence)parameterList);
                        caretModel.moveToOffset(offset + parameterList.length());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "context";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "item";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/sql/completion/SqlInsertHandlers$FunctionElementInsertHandler$1";
                        objectArray[2] = "handleInsert";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
            ParenthesesInsertHandler parenthesesInsertHandler = ParenthesesInsertHandler.WITH_PARAMETERS;
            if (parenthesesInsertHandler == null) {
                FunctionElementInsertHandler.$$$reportNull$$$0(5);
            }
            return parenthesesInsertHandler;
        }

        private static boolean isInsertingInPgFunctionColumn(@NotNull InsertionContext context, @NotNull Dbms dbms) {
            PsiReference ref2;
            if (context == null) {
                FunctionElementInsertHandler.$$$reportNull$$$0(6);
            }
            if (dbms == null) {
                FunctionElementInsertHandler.$$$reportNull$$$0(7);
            }
            return dbms.isPostgres() && SqlImplUtil.canResolveToPgFunctionColumn((ref2 = context.getFile().findReferenceAt(context.getStartOffset())) == null ? null : ref2.getElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/completion/SqlInsertHandlers$FunctionElementInsertHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/completion/SqlInsertHandlers$FunctionElementInsertHandler";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInsertHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleInsert";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isInsertingInPgFunctionColumn";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

