/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlValuesParameterInfoUtils;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlValuesParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<SqlExpressionList, SqlFunctionsUtil.ExpressionList, SqlExpression> {
    private static final Set<Class<?>> ourStopSearch = ContainerUtil.newHashSet((Object[])new Class[]{SqlStatement.class});
    private static final Set<Class<?>> ourAllowedParents = ContainerUtil.newHashSet((Object[])new Class[]{SqlParenthesizedExpression.class, SqlValuesExpression.class});

    public SqlExpressionList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        SqlExpressionList result2;
        Object[] res2;
        if (context == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((res2 = SqlValuesParameterInfoHandler.getLists(result2 = SqlValuesParameterInfoHandler.findExpressions((ParameterInfoContext)context))) != null) {
            context.setItemsToShow(res2);
        }
        return result2;
    }

    private static SqlFunctionsUtil.ExpressionList @Nullable [] getLists(@Nullable SqlExpressionList result2) {
        SqlDmlInstruction instruction2;
        if (result2 == null) {
            return null;
        }
        SqlValuesExpression values2 = (SqlValuesExpression)PsiTreeUtil.getParentOfType((PsiElement)result2, SqlValuesExpression.class, (boolean)true);
        SqlDmlInstruction sqlDmlInstruction = instruction2 = values2 == null ? null : (SqlDmlInstruction)ObjectUtils.tryCast((Object)values2.getParent(), SqlDmlInstruction.class);
        if (instruction2 != null) {
            return SqlFunctionsUtil.getInsertVariants(instruction2, result2);
        }
        SqlCreateStatement createStatement = (SqlCreateStatement)PsiTreeUtil.getParentOfType((PsiElement)result2, SqlCreateStatement.class, (boolean)true);
        return createStatement != null ? SqlFunctionsUtil.getCreateTable(createStatement, result2) : null;
    }

    public void showParameterInfo(@NotNull SqlExpressionList expression, @NotNull CreateParameterInfoContext context) {
        if (expression == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (context == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(2);
        }
        context.showHint((PsiElement)expression, expression.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public SqlExpressionList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(3);
        }
        return SqlValuesParameterInfoHandler.findExpressions((ParameterInfoContext)context);
    }

    public void updateParameterInfo(@NotNull SqlExpressionList element2, @NotNull UpdateParameterInfoContext context) {
        if (element2 == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(5);
        }
        int index2 = SqlValuesParameterInfoUtils.getCurrentParameterIndex(element2, context.getOffset());
        context.setCurrentParameter(index2);
    }

    public void updateUI(SqlFunctionsUtil.ExpressionList p2, @NotNull ParameterInfoUIContext context) {
        PsiElement element2;
        if (context == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (!(element2 = context.getParameterOwner()).isValid() || !p2.isValid()) {
            context.setUIComponentEnabled(false);
            return;
        }
        StringBuilder sb = new StringBuilder();
        int[] highlight = new int[]{-1, -1};
        p2.buildText(sb, context.getCurrentParameterIndex(), highlight);
        if (sb.length() == 0) {
            sb.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        }
        context.setupUIComponentPresentation(sb.toString(), highlight[0], highlight[1], false, false, false, context.getDefaultParameterColor());
    }

    public SqlExpression @NotNull [] getActualParameters(@NotNull SqlExpressionList o2) {
        if (o2 == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(7);
        }
        List list = o2.getExpressionList();
        SqlExpression[] sqlExpressionArray = list.toArray(new SqlExpression[0]);
        if (sqlExpressionArray == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(8);
        }
        return sqlExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        SqlTokenType sqlTokenType = SqlTokens.SQL_COMMA;
        if (sqlTokenType == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(9);
        }
        return sqlTokenType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        SqlTokenType sqlTokenType = SqlTokens.SQL_RIGHT_PAREN;
        if (sqlTokenType == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(10);
        }
        return sqlTokenType;
    }

    @NotNull
    public Set<Class<?>> getArgumentListAllowedParentClasses() {
        Set<Class<?>> set = ourAllowedParents;
        if (set == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    public Set<? extends Class<?>> getArgListStopSearchClasses() {
        Set<Class<?>> set = ourStopSearch;
        if (set == null) {
            SqlValuesParameterInfoHandler.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    public Class<SqlExpressionList> getArgumentListClass() {
        return SqlExpressionList.class;
    }

    @Nullable
    private static SqlExpressionList findExpressions(ParameterInfoContext context) {
        PsiFile file = context.getFile();
        if (!(file instanceof SqlFile)) {
            return null;
        }
        int offset = context.getOffset();
        PsiElement at = file.findElementAt(offset);
        return SqlValuesParameterInfoUtils.findExpressions(at);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlValuesParameterInfoHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlValuesParameterInfoHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

