/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.FileStructureFilter;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.SortableTreeElement;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeStructureUtil;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.PropertyOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElseClause;
import com.intellij.sql.psi.SqlElseIfClause;
import com.intellij.sql.psi.SqlExceptionClause;
import com.intellij.sql.psi.SqlExceptionWhenClause;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlThenClause;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.SqlWhenThenClause;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlSelectIntoClauseImpl;
import com.intellij.sql.psi.impl.SqlSelectIntoNewTableClauseImpl;
import com.intellij.sql.psi.impl.SqlTableElementListImpl;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlStructureViewBuilderProvider
implements PsiStructureViewFactory {
    private static final Condition<PsiElement> DDL_FILTER = Conditions.instanceOf((Class[])new Class[]{SqlDdlStatement.class, SqlDefinition.class});
    private static final Condition<PsiElement> DML_FILTER = Conditions.instanceOf(SqlDmlStatement.class);
    private static final Condition<PsiElement> SELECT_FILTER = Conditions.instanceOf(SqlSelectStatement.class);
    private static final Condition<PsiElement> OTHER_FILTER = Conditions.and((Condition)Conditions.instanceOf(SqlStatement.class), (Condition)Conditions.not((Condition)Conditions.or(DDL_FILTER, (Condition)Conditions.or(DML_FILTER, SELECT_FILTER))));
    private static final ClassFilter[] FILTERS = new ClassFilter[]{new ClassFilter(DDL_FILTER, "D", new ActionPresentationData(SqlBundle.message((String)"SqlStructureViewBuilderProvider.action.ddl.statements.text", (Object[])new Object[0]), "", DatabaseIcons.Table)), new ClassFilter(DML_FILTER, "M", new ActionPresentationData(SqlBundle.message((String)"SqlStructureViewBuilderProvider.action.dml.statements.text", (Object[])new Object[0]), "", DatabaseIcons.SqlDmlStatement)), new ClassFilter(SELECT_FILTER, "S", new ActionPresentationData(SqlBundle.message((String)"SqlStructureViewBuilderProvider.action.select.statements.text", (Object[])new Object[0]), "", DatabaseIcons.SqlSelectStatement)), new ClassFilter(OTHER_FILTER, "O", new ActionPresentationData(SqlBundle.message((String)"SqlStructureViewBuilderProvider.action.other.text", (Object[])new Object[0]), "", DatabaseIcons.SqlOtherStatement))};
    private static final Sorter SQL_ALPHA_SORTER = new Sorter(){

        @NotNull
        public Comparator getComparator() {
            Comparator comparator2 = Sorter.ALPHA_SORTER.getComparator();
            if (comparator2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return comparator2;
        }

        public boolean isVisible() {
            return true;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            ActionPresentation actionPresentation = Sorter.ALPHA_SORTER.getPresentation();
            if (actionPresentation == null) {
                1.$$$reportNull$$$0(1);
            }
            return actionPresentation;
        }

        @NotNull
        public String getName() {
            String string = "SQL_" + Sorter.getAlphaSorterId();
            if (string == null) {
                1.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/SqlStructureViewBuilderProvider$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };

    @Nullable
    public StructureViewBuilder getStructureViewBuilder(final @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            SqlStructureViewBuilderProvider.$$$reportNull$$$0(0);
        }
        if (!(psiFile instanceof SqlFile)) {
            return null;
        }
        if (SqlStructureViewBuilderProvider.noFiltersByDefault()) {
            PropertiesComponent properties2 = PropertiesComponent.getInstance();
            boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
            for (ClassFilter filter2 : JBIterable.of((Object[])FILTERS).take(testMode ? FILTERS.length : 1)) {
                String propertyName = TreeStructureUtil.getPropertyName((String)filter2.getPropertyName());
                if (properties2.isValueSet(propertyName)) continue;
                properties2.setValue(propertyName, "true");
            }
        }
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor2) {
                return new MyModel((SqlFile)psiFile, editor2);
            }

            public boolean isRootNodeShown() {
                return false;
            }
        };
    }

    public static boolean noFiltersByDefault() {
        PropertiesComponent properties2 = PropertiesComponent.getInstance();
        for (ClassFilter f : FILTERS) {
            String propertyName = TreeStructureUtil.getPropertyName((String)f.getPropertyName());
            if (!properties2.isValueSet(propertyName)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/sql/SqlStructureViewBuilderProvider", "getStructureViewBuilder"));
    }

    private static class ClassFilter
    implements FileStructureFilter,
    PropertyOwner {
        private final Condition<PsiElement> myFilter;
        private final Shortcut myShortCut;
        private final String myLetter;
        private final ActionPresentationData myPresentation;

        @NotNull
        public String getPropertyName() {
            String string = "SqlStructureView.filter" + this.myLetter;
            if (string == null) {
                ClassFilter.$$$reportNull$$$0(0);
            }
            return string;
        }

        ClassFilter(Condition<PsiElement> filter2, String shortCutLetter, ActionPresentationData presentation) {
            this.myFilter = filter2;
            this.myPresentation = presentation;
            this.myLetter = shortCutLetter;
            this.myShortCut = KeyboardShortcut.fromString((String)((ClientSystemInfo.isMac() ? "meta " : "control ") + shortCutLetter));
        }

        public boolean isVisible(TreeElement treeNode) {
            return !(treeNode instanceof MyElement) || !this.acceptsElement(((MyElement)treeNode).getElement());
        }

        protected boolean acceptsElement(PsiElement element2) {
            return this.myFilter.value((Object)element2);
        }

        public boolean isReverted() {
            return true;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            ActionPresentationData actionPresentationData = this.myPresentation;
            if (actionPresentationData == null) {
                ClassFilter.$$$reportNull$$$0(1);
            }
            return actionPresentationData;
        }

        @NotNull
        public String getName() {
            String string = this.myPresentation.getText();
            if (string == null) {
                ClassFilter.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getCheckBoxText() {
            String string = this.myPresentation.getText();
            if (string == null) {
                ClassFilter.$$$reportNull$$$0(3);
            }
            return string;
        }

        public Shortcut @NotNull [] getShortcut() {
            Shortcut[] shortcutArray = new Shortcut[]{this.myShortCut};
            if (shortcutArray == null) {
                ClassFilter.$$$reportNull$$$0(4);
            }
            return shortcutArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/SqlStructureViewBuilderProvider$ClassFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPropertyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCheckBoxText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortcut";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class TypeGrouper
    implements Grouper {
        private final ActionPresentationData myPresentation;

        TypeGrouper(ActionPresentationData presentation) {
            this.myPresentation = presentation;
        }

        @NotNull
        public Collection<Group> group(@NotNull AbstractTreeNode<?> parent2, @NotNull Collection<TreeElement> children2) {
            Object value2;
            if (parent2 == null) {
                TypeGrouper.$$$reportNull$$$0(0);
            }
            if (children2 == null) {
                TypeGrouper.$$$reportNull$$$0(1);
            }
            if (!((value2 = parent2.getValue()) instanceof MyElement) || !(((MyElement)((Object)value2)).getElement() instanceof PsiFile)) {
                List<Group> list = Collections.emptyList();
                if (list == null) {
                    TypeGrouper.$$$reportNull$$$0(2);
                }
                return list;
            }
            MultiMap map2 = new MultiMap();
            for (TreeElement child : children2) {
                map2.putValue((Object)((MyElement)child).myFilter, (Object)child);
            }
            ArrayList<Group> result2 = new ArrayList<Group>(map2.keySet().size());
            for (final ClassFilter filter2 : FILTERS) {
                final Collection elements2 = map2.get((Object)filter2);
                if (elements2.isEmpty()) continue;
                result2.add(new Group(){

                    @NotNull
                    public ItemPresentation getPresentation() {
                        return new PresentationData(filter2.getName(), "", filter2.getPresentation().getIcon(), null);
                    }

                    @NotNull
                    public Collection<TreeElement> getChildren() {
                        Collection collection2 = elements2;
                        if (collection2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return collection2;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$TypeGrouper$1", "getChildren"));
                    }
                });
            }
            ArrayList<Group> arrayList = result2;
            if (arrayList == null) {
                TypeGrouper.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            ActionPresentationData actionPresentationData = this.myPresentation;
            if (actionPresentationData == null) {
                TypeGrouper.$$$reportNull$$$0(4);
            }
            return actionPresentationData;
        }

        @NotNull
        public String getName() {
            String string = this.myPresentation.getText();
            if (string == null) {
                TypeGrouper.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/SqlStructureViewBuilderProvider$TypeGrouper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/SqlStructureViewBuilderProvider$TypeGrouper";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "group";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "group";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyElement
    extends PsiTreeElementBase<PsiElement>
    implements SortableTreeElement,
    LocationPresentation {
        private final ClassFilter myFilter;
        static final Function<PsiElement, StructureViewTreeElement> TO_ME = element2 -> new MyElement((PsiElement)element2);

        MyElement(PsiElement element2) {
            super(element2);
            ClassFilter filter2 = FILTERS[FILTERS.length - 1];
            for (ClassFilter f : FILTERS) {
                if (!f.acceptsElement(element2)) continue;
                filter2 = f;
                break;
            }
            this.myFilter = filter2;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            SqlQueryExpression qe;
            PsiElement element2 = this.getElement();
            if (element2 == null) {
                List<StructureViewTreeElement> list = Collections.emptyList();
                if (list == null) {
                    MyElement.$$$reportNull$$$0(0);
                }
                return list;
            }
            if (element2 instanceof SqlColumnDefinition || element2 instanceof SqlTableKeyDefinition) {
                List<StructureViewTreeElement> list = Collections.emptyList();
                if (list == null) {
                    MyElement.$$$reportNull$$$0(1);
                }
                return list;
            }
            if (element2 instanceof SqlSelectIntoNewTableClauseImpl) {
                List list = JBIterable.from(((SqlSelectIntoNewTableClauseImpl)element2).getColumns()).transform(TO_ME).toList();
                if (list == null) {
                    MyElement.$$$reportNull$$$0(2);
                }
                return list;
            }
            if (element2 instanceof SqlSelectStatement && (qe = ((SqlSelectStatement)element2).getQueryExpression()) instanceof SqlWithQueryExpression) {
                List list = JBIterable.of((Object[])new SqlElement[]{((SqlWithQueryExpression)qe).getWithClause(), ((SqlWithQueryExpression)qe).getExpression()}).transform(TO_ME).toList();
                if (list == null) {
                    MyElement.$$$reportNull$$$0(3);
                }
                return list;
            }
            List defs = MyElement.subDefinitions(element2).transform(TO_ME).toList();
            if (!defs.isEmpty() || element2.getNode() == null) {
                List list = defs;
                if (list == null) {
                    MyElement.$$$reportNull$$$0(4);
                }
                return list;
            }
            List list = this.subElements(element2).flatten(element1 -> {
                if (element1 instanceof SqlBlockStatementImpl && element1.getParent() instanceof SqlDefinition) {
                    return MyElement.subDefinitions((PsiElement)element1).append(this.subElements((PsiElement)element1));
                }
                return JBIterable.of((Object)element1).append(MyElement.subDefinitions((PsiElement)element1));
            }).transform(TO_ME).toList();
            if (list == null) {
                MyElement.$$$reportNull$$$0(5);
            }
            return list;
        }

        @NotNull
        protected JBIterable<SqlCompositeElement> subElements(PsiElement element2) {
            SqlStatement statement2;
            if (element2 instanceof SqlClause && !(element2 instanceof SqlExceptionClause) && ((statement2 = (SqlStatement)PsiTreeUtil.findChildOfType((PsiElement)element2, SqlStatement.class)) instanceof SqlBlockStatement || element2.getFirstChild() == statement2)) {
                JBIterable<SqlCompositeElement> jBIterable = this.subElements((PsiElement)statement2);
                if (jBIterable == null) {
                    MyElement.$$$reportNull$$$0(6);
                }
                return jBIterable;
            }
            JBIterable<SqlCompositeElement> extraElements = element2 instanceof SqlRoutineDefinition && SqlImplUtil.getSqlDialectSafe(element2).getDbms().isPostgres() ? this.subElements((PsiElement)((SqlRoutineDefinition)element2).getBody().first()) : JBIterable.empty();
            JBIterable jBIterable = SqlImplUtil.sqlCompositeElements(element2).append((Iterable)extraElements).filter(Conditions.notEqualTo((Object)element2)).filter(Conditions.instanceOf((Class[])new Class[]{SqlStatement.class, SqlDefinition.class, SqlTableElementListImpl.class, SqlWhenThenClause.class, SqlWhenClause.class, SqlExceptionClause.class, SqlExceptionWhenClause.class, SqlElseIfClause.class, SqlElseClause.class, SqlThenClause.class})).flatten(o2 -> o2 instanceof SqlTableElementListImpl ? SqlImplUtil.sqlCompositeElements((PsiElement)o2).filter(SqlDefinition.class) : JBIterable.of((Object)o2));
            if (jBIterable == null) {
                MyElement.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }

        private static JBIterable<SqlCompositeElement> subDefinitions(@Nullable PsiElement element2) {
            if (!(element2 instanceof SqlElement)) {
                return JBIterable.empty();
            }
            return SqlImplUtil.getSqlDialectSafe(element2).extractDefinitions((SqlElement)element2).filter(SqlCompositeElement.class);
        }

        @NotNull
        public String getAlphaSortKey() {
            String string = this.getPresentableText();
            if (string == null) {
                MyElement.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        public String getPresentableText() {
            PsiElement element2 = this.getElement();
            String string = SqlImplUtil.getPresentableName(element2, "");
            if (string == null) {
                MyElement.$$$reportNull$$$0(9);
            }
            return string;
        }

        public boolean isSearchInLocationString() {
            return true;
        }

        public String getLocationString() {
            PsiElement element2 = this.getElement();
            if (element2 == null) {
                return null;
            }
            return element2 instanceof DasTypedObject ? ((DasTypedObject)element2).getDasType().getSpecification() : null;
        }

        @Nullable
        public Icon getIcon(boolean unused) {
            PsiElement element2 = this.getElement();
            return element2 == null ? null : (element2 instanceof DasObject ? element2.getIcon(0) : this.myFilter.getPresentation().getIcon());
        }

        public String getLocationPrefix() {
            return " ";
        }

        public String getLocationSuffix() {
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/SqlStructureViewBuilderProvider$MyElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenBase";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subElements";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlphaSortKey";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class MyModel
    extends StructureViewModelBase
    implements StructureViewModel.ElementInfoProvider {
        protected MyModel(@NotNull SqlFile psiFile, @Nullable Editor editor2) {
            if (psiFile == null) {
                MyModel.$$$reportNull$$$0(0);
            }
            super((PsiFile)psiFile, editor2, (StructureViewTreeElement)new MyElement((PsiElement)psiFile));
            this.withSuitableClasses(new Class[]{SqlFile.class, SqlDefinition.class, SqlStatement.class, SqlSelectIntoClauseImpl.class});
        }

        public boolean isAlwaysShowsPlus(StructureViewTreeElement element2) {
            return false;
        }

        public boolean isAlwaysLeaf(StructureViewTreeElement element2) {
            Object e2 = element2.getValue();
            return e2 instanceof SqlTypedDefinition || e2 instanceof SqlTableKeyDefinition;
        }

        public ClassFilter @NotNull [] getFilters() {
            if (FILTERS == null) {
                MyModel.$$$reportNull$$$0(1);
            }
            return FILTERS;
        }

        public Grouper @NotNull [] getGroupers() {
            Grouper[] grouperArray = new Grouper[]{new TypeGrouper(new ActionPresentationData(SqlBundle.message((String)"SqlStructureViewBuilderProvider.action.group.by.type.text", (Object[])new Object[0]), "", DatabaseIcons.SqlGroupByType))};
            if (grouperArray == null) {
                MyModel.$$$reportNull$$$0(2);
            }
            return grouperArray;
        }

        public Object getCurrentEditorElement() {
            Object element2 = super.getCurrentEditorElement();
            if (element2 != null) {
                return element2;
            }
            Editor editor2 = this.getEditor();
            if (editor2 == null) {
                return null;
            }
            int offset = editor2.getCaretModel().getOffset();
            PsiFile file = this.getPsiFile();
            PsiElement at = file.getViewProvider().findElementAt(offset, file.getLanguage());
            if (at == null && offset > 0) {
                at = file.getViewProvider().findElementAt(offset - 1, file.getLanguage());
            }
            if (at == null) {
                return null;
            }
            Object prev = this.findAcceptableElement(PsiTreeUtil.getPrevSiblingOfType((PsiElement)PsiTreeUtil.prevVisibleLeaf((PsiElement)at), SqlStatement.class));
            if (prev != null) {
                return prev;
            }
            return this.findAcceptableElement(PsiTreeUtil.nextVisibleLeaf((PsiElement)at));
        }

        public Sorter @NotNull [] getSorters() {
            Sorter[] sorterArray = new Sorter[]{SQL_ALPHA_SORTER};
            if (sorterArray == null) {
                MyModel.$$$reportNull$$$0(3);
            }
            return sorterArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/SqlStructureViewBuilderProvider$MyModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/SqlStructureViewBuilderProvider$MyModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilters";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupers";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSorters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

