/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.script.QueryParametersProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlQueryParametersProvider
extends QueryParametersProvider<SqlFile> {
    @Override
    @Nullable
    public Map<String, PsiElement> getParameters(@NotNull SqlFile file) {
        SqlStatement statement2;
        if (file == null) {
            SqlQueryParametersProvider.$$$reportNull$$$0(0);
        }
        if ((statement2 = (SqlStatement)SqlImplUtil.sqlChildren((PsiElement)file).filter(SqlStatement.class).first()) == null) {
            return null;
        }
        LinkedHashMap<String, PsiElement> map2 = new LinkedHashMap<String, PsiElement>();
        for (SqlParameter o2 : SqlImplUtil.sqlTraverser((PsiElement)statement2).filter(SqlParameter.class)) {
            String realName;
            String name2 = o2.getName();
            String string = realName = StringUtil.isEmpty((String)name2) ? String.valueOf(map2.size() + 1) : name2;
            if (map2.containsKey(realName)) continue;
            map2.put(realName, (PsiElement)new Parameter(file, o2));
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/SqlQueryParametersProvider", "getParameters"));
    }

    private static class Parameter
    extends RenameableFakePsiElement {
        final SqlParameter usage;

        Parameter(SqlFile containingFile, SqlParameter usage) {
            super((PsiElement)containingFile);
            this.usage = usage;
        }

        @NotNull
        public String getName() {
            String string = this.usage.getName();
            if (string == null) {
                Parameter.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public TextRange getTextRange() {
            return this.usage.getTextRange();
        }

        @NotNull
        public PsiElement getNavigationElement() {
            SqlParameter sqlParameter = this.usage;
            if (sqlParameter == null) {
                Parameter.$$$reportNull$$$0(1);
            }
            return sqlParameter;
        }

        public boolean isValid() {
            if (!super.isValid()) {
                return false;
            }
            SqlFile file = (SqlFile)this.getContainingFile();
            Map<String, PsiElement> params2 = new SqlQueryParametersProvider().getParameters(file);
            return params2 != null && params2.containsValue((Object)this);
        }

        public String getTypeName() {
            return SqlBundle.message((String)"SqlQueryParametersProvider.query.parameter", (Object[])new Object[0]);
        }

        @Nullable
        public Icon getIcon() {
            return IconManager.getInstance().getPlatformIcon(PlatformIcons.Parameter);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || ((Object)((Object)this)).getClass() != o2.getClass()) {
                return false;
            }
            Parameter that = (Parameter)((Object)o2);
            return this.usage.equals(that.usage);
        }

        public int hashCode() {
            return this.usage.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/SqlQueryParametersProvider$Parameter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

