/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlNavigationUtils {
    private static final RecursionGuard<SqlDefinition> ourGuard = RecursionManager.createGuard((String)"findRelatedDbElements");

    @NotNull
    public static JBIterable<DbElement> findRelatedDbElements(@Nullable PsiElement o2, boolean strict) {
        if (o2 == null || !o2.isValid()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlNavigationUtils.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }
        if (o2 instanceof DbElement) {
            JBIterable jBIterable = JBIterable.of((Object)((DbElement)o2));
            if (jBIterable == null) {
                SqlNavigationUtils.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }
        JBIterable parents2 = strict ? JBIterable.of((Object)o2) : SyntaxTraverser.psiApi().parents((Object)o2);
        SqlReferenceExpression ref2 = (SqlReferenceExpression)parents2.filter(SqlReferenceExpression.class).first();
        DbDataSource dataSource2 = null;
        DbElement element2 = null;
        if (!strict) {
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)o2);
            dataSource2 = DbImplUtilCore.findDataSource(o2.getProject(), file);
            element2 = DbImplUtilCore.findElement(o2.getProject(), file);
        }
        JBIterable<DbElement> result1 = ref2 != null ? SqlNavigationUtils.findRelatedDbElements((PsiReference)ref2.getReference(), null) : JBIterable.empty();
        JBIterable result2 = parents2.filter(SqlDefinition.class).filter(SqlDefinition.class).flatMap(parentDef -> SqlNavigationUtils.findRelatedDbElements(null, parentDef));
        JBIterable jBIterable = result1.append((Iterable)result2).append((Object)element2).append((Object)dataSource2).unique();
        if (jBIterable == null) {
            SqlNavigationUtils.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DbElement> findRelatedDbElements(@Nullable PsiReference refAt, @Nullable SqlDefinition definition2) {
        if (!(refAt instanceof PsiPolyVariantReference) && definition2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlNavigationUtils.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        JBIterable result2 = (JBIterable)RecursionManager.doPreventingRecursion((Object)ObjectUtils.coalesce((Object)refAt, (Object)definition2), (boolean)false, () -> {
            if (refAt instanceof PsiPolyVariantReference) {
                return SqlNavigationUtils.findRelatedDbElementsImpl((PsiPolyVariantReference)refAt);
            }
            return SqlNavigationUtils.findRelatedDbElementsImpl(definition2);
        });
        JBIterable jBIterable = result2 != null ? result2 : JBIterable.empty();
        if (jBIterable == null) {
            SqlNavigationUtils.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DbElement> findRelatedDbElementsImpl(@NotNull PsiPolyVariantReference refAt) {
        if (refAt == null) {
            SqlNavigationUtils.$$$reportNull$$$0(5);
        }
        JBIterable jBIterable = JBIterable.of((Object[])refAt.multiResolve(false)).flatMap(rr -> {
            PsiElement element2 = rr.getElement();
            if (element2 instanceof DbElement) {
                return JBIterable.of((Object)element2);
            }
            if (!(element2 instanceof SqlDefinition)) {
                return JBIterable.empty();
            }
            return SqlNavigationUtils.findRelatedDbElementsImpl((SqlDefinition)element2);
        }).filter(DbElement.class);
        if (jBIterable == null) {
            SqlNavigationUtils.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DbElement> findRelatedDbElementsImpl(@NotNull SqlDefinition definition2) {
        JBIterable res2;
        if (definition2 == null) {
            SqlNavigationUtils.$$$reportNull$$$0(7);
        }
        JBIterable jBIterable = (res2 = (JBIterable)ourGuard.doPreventingRecursion((Object)definition2, false, () -> SqlNavigationUtils.findRelatedDbElementsUnsafe(definition2))) == null ? JBIterable.empty() : res2;
        if (jBIterable == null) {
            SqlNavigationUtils.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DbElement> findRelatedDbElementsUnsafe(@NotNull SqlDefinition definition2) {
        if (definition2 == null) {
            SqlNavigationUtils.$$$reportNull$$$0(9);
        }
        ObjectKind kind = definition2.getKind();
        SqlNameElement element2 = definition2.getNameElement();
        if (element2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlNavigationUtils.$$$reportNull$$$0(10);
            }
            return jBIterable;
        }
        SqlReferenceElementType refType = element2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element2).getReferenceElementType() : (kind == ObjectKind.COLUMN ? SqlCompositeElementTypes.SQL_COLUMN_REFERENCE : SqlCompositeElementTypes.SQL_REFERENCE);
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)element2);
        String refText = InjectedLanguageManager.getInstance((Project)definition2.getProject()).getUnescapedText((PsiElement)element2);
        SqlReferenceExpression newRef = SqlPsiElementFactory.createReferenceFromText(refText, dialect, refType, (PsiElement)element2);
        if (newRef == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlNavigationUtils.$$$reportNull$$$0(11);
            }
            return jBIterable;
        }
        for (PsiElement e2 : SyntaxTraverser.psiTraverser((PsiElement)newRef)) {
            SqlReferenceImpl.USE_SQL_DATA_SOURCE_MODEL.set((UserDataHolder)e2, (Object)true);
        }
        JBIterable result2 = JBIterable.of((Object[])newRef.multiResolve(false)).transform(rr -> rr.getElement()).filter(DbElement.class);
        if (result2.isNotEmpty()) {
            JBIterable jBIterable = result2;
            if (jBIterable == null) {
                SqlNavigationUtils.$$$reportNull$$$0(12);
            }
            return jBIterable;
        }
        DasObject parent2 = definition2.getDasParent();
        JBIterable parentDefinitions = parent2 instanceof SqlFileImpl.GroupImpl ? ((SqlFileImpl.GroupImpl)parent2).delegates() : JBIterable.of((Object)((SqlDefinition)ObjectUtils.tryCast((Object)parent2, SqlDefinition.class)));
        JBIterable jBIterable = parentDefinitions.flatten(parentDef -> SqlNavigationUtils.findRelatedDbElementsImpl(parentDef).flatMap(db2 -> {
            SqlReferenceExpression ref2 = SqlPsiElementFactory.createReferenceFromText(refText, dialect, refType, db2);
            return SqlNavigationUtils.findRelatedDbElementsImpl((PsiPolyVariantReference)Objects.requireNonNull(ref2).getReference());
        }));
        if (jBIterable == null) {
            SqlNavigationUtils.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 7, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlNavigationUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refAt";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelatedDbElements";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlNavigationUtils";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelatedDbElementsImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelatedDbElementsUnsafe";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findRelatedDbElementsImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findRelatedDbElementsUnsafe";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 7, 9 -> new IllegalArgumentException(string);
        };
    }
}

