/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.Dbms;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseTargetElementEvaluator;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlNavigationUtils;
import com.intellij.sql.actions.NavigationHelper;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class SqlGotoRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement psiElement) {
        RawDataSource rawDataSource;
        if (psiElement == null) {
            SqlGotoRelatedProvider.$$$reportNull$$$0(0);
        }
        if (psiElement instanceof DbDataSource && (rawDataSource = ((DbDataSource)psiElement).getDelegate()) instanceof SqlDataSource) {
            SqlDataSource sqlDataSource = (SqlDataSource)rawDataSource;
            PsiManager manager = psiElement.getManager();
            List list = JBIterable.from((Iterable)sqlDataSource.getRoots()).filterMap(f -> f.isDirectory() ? manager.findDirectory(f) : manager.findFile(f)).map(o2 -> new GotoRelatedItem((PsiElement)o2)).toList();
            if (list == null) {
                SqlGotoRelatedProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<? extends GotoRelatedItem> supersOrImpls = SqlGotoRelatedProvider.findSupersOrImpls(psiElement);
        if (!supersOrImpls.isEmpty()) {
            List<? extends GotoRelatedItem> list = supersOrImpls;
            if (list == null) {
                SqlGotoRelatedProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (psiElement instanceof DbElement) {
            List list = Collections.emptyList();
            if (list == null) {
                SqlGotoRelatedProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        DbElement first2 = (DbElement)SqlNavigationUtils.findRelatedDbElements(psiElement, false).first();
        if (first2 == null || !DbImplUtilCore.isInLocalDataSource(first2.getDataSource())) {
            List list = Collections.emptyList();
            if (list == null) {
                SqlGotoRelatedProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (first2 instanceof DasColumn) {
            final String[] columns2 = new String[]{first2.getName()};
            final DbElement table = Objects.requireNonNull(first2.getParent());
            List<1> list = Collections.singletonList(new GotoRelatedItem(first2){

                public void navigate() {
                    new OpenDataFileDescriptor(table.getProject(), table.getVirtualFile(), columns2, null).navigate(true);
                }
            });
            if (list == null) {
                SqlGotoRelatedProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (first2 instanceof DasTable) {
            List<GotoRelatedItem> list = Collections.singletonList(new GotoRelatedItem((PsiElement)first2));
            if (list == null) {
                SqlGotoRelatedProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            SqlGotoRelatedProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static List<? extends GotoRelatedItem> findSupersOrImpls(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            SqlGotoRelatedProvider.$$$reportNull$$$0(8);
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(psiElement);
        DasObject dasObject = psiElement instanceof DasObject ? (DasObject)psiElement : (DasObject)PsiTreeUtil.getParentOfType((PsiElement)psiElement, SqlDefinition.class);
        List<Object> list = dasObject != null ? SqlGotoRelatedProvider.findSupersOrImpls(dasObject, dialect.getDbms()) : Collections.emptyList();
        if (list == null) {
            SqlGotoRelatedProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private static List<? extends GotoRelatedItem> findSupersOrImpls(@NotNull DasObject dasObject, @NotNull Dbms dbms) {
        if (dasObject == null) {
            SqlGotoRelatedProvider.$$$reportNull$$$0(10);
        }
        if (dbms == null) {
            SqlGotoRelatedProvider.$$$reportNull$$$0(11);
        }
        NavigationHelper navHelper = NavigationHelper.EP.forDbms(dbms);
        Pair<String, JBIterable<? extends DasObject>> supers = navHelper.findSuperDefinitions(dasObject, false);
        Pair<String, JBIterable<? extends DasObject>> impls = navHelper.findDefinitions(dasObject, false);
        if (supers == null && impls == null) {
            List list = Collections.emptyList();
            if (list == null) {
                SqlGotoRelatedProvider.$$$reportNull$$$0(12);
            }
            return list;
        }
        JBIterable result2 = JBIterable.empty();
        if (supers != null) {
            result2 = result2.append((Iterable)supers.second);
        }
        if (impls != null) {
            result2 = result2.append((Iterable)impls.second);
        }
        List list = result2.filter(PsiElement.class).map(e2 -> new RelatedDefItem((PsiElement)e2)).toList();
        if (list == null) {
            SqlGotoRelatedProvider.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 9, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlGotoRelatedProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasObject";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlGotoRelatedProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findSupersOrImpls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findSupersOrImpls";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 9, 12, 13 -> new IllegalStateException(string);
        };
    }

    private static class RelatedDefItem
    extends GotoRelatedItem {
        RelatedDefItem(@NotNull PsiElement element2) {
            if (element2 == null) {
                RelatedDefItem.$$$reportNull$$$0(0);
            }
            super(element2);
        }

        public void navigate() {
            PsiElement psiElement = this.getElement();
            if (psiElement instanceof DbElement) {
                DbElement dbElement = (DbElement)psiElement;
                DatabaseTargetElementEvaluator.getGotoDeclarationTarget(dbElement).navigate(true);
                return;
            }
            super.navigate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlGotoRelatedProvider$RelatedDefItem", "<init>"));
        }
    }
}

