/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.schemaEditor.SchemaEditor;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseBatchIndicesEditor;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.models.BatchIndicesEditorModel;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DbBatchIndicesDialog
extends AbstractDbRefactoringDialog<DatabaseBatchIndicesEditor> {
    protected BatchIndicesEditorModel myBatchIndicesModel;

    protected DbBatchIndicesDialog(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(0);
        }
        super(context);
    }

    public static boolean canAddAnything(@NotNull DatabaseEditorContext context, @NotNull List<? extends DasColumn> columns2) {
        if (context == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(1);
        }
        if (columns2 == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(2);
        }
        if (columns2.isEmpty()) {
            return false;
        }
        for (DasColumn dasColumn : columns2) {
            DasTable table = dasColumn.getTable();
            if (table.getKind() == ObjectKind.TABLE) continue;
            return false;
        }
        return DbBatchIndicesDialog.getIndexCaps(context.getDbms(), false).canDoAnything();
    }

    public static boolean canModifyAnything(@NotNull DatabaseEditorContext context, @NotNull List<? extends DasIndex> indices) {
        if (context == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(3);
        }
        if (indices == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(4);
        }
        if (indices.isEmpty()) {
            return false;
        }
        return DbBatchIndicesDialog.getIndexCaps(context.getDbms(), true).canDoAnything();
    }

    @Override
    @NotNull
    @NlsContexts.DialogTitle
    protected String getTitle(boolean modify) {
        String string = modify ? DatabaseBundle.message("dialog.title.batch.modify.indices", new Object[0]) : DatabaseBundle.message("dialog.title.batch.add.indices", new Object[0]);
        if (string == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setIndices(@NotNull List<DeIndex> indices) {
        boolean edit;
        if (indices == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(6);
        }
        if (indices.isEmpty()) {
            throw new AssertionError((Object)"Invalid indices");
        }
        for (DeIndex index2 : indices) {
            if (index2.model != this.myModel) {
                throw new AssertionError((Object)"Invalid indices");
            }
        }
        this.myBatchIndicesModel = new BatchIndicesEditorModel(indices, this.myModel, this.myEditorModelsCache);
        boolean bl = edit = !indices.get(0).hasEdited();
        if (edit) {
            this.myBatchIndicesModel.setNameGenerator(BatchIndicesEditorModel.DEFAULT_NAME_GENERATOR);
            this.myBatchIndicesModel.setUniqueGenerator(BatchIndicesEditorModel.FALSE_UNIQUE_GENERATOR);
        } else {
            this.myBatchIndicesModel.setNameGenerator(BatchIndicesEditorModel.PREV_NAME_GENERATOR);
            this.myBatchIndicesModel.setUniqueGenerator(BatchIndicesEditorModel.PREV_UNIQUE_GENERATOR);
        }
        this.myBatchIndicesModel.commit();
        this.setEditor(new DatabaseBatchIndicesEditor(this.myState, this.myBatchIndicesModel, DbBatchIndicesDialog.getIndexCaps(this.getContext().getDbms(), edit)));
        if (edit) {
            ((DatabaseBatchIndicesEditor)this.myEditor).setUniqueRevertStateEnabled(false);
        } else {
            ((DatabaseBatchIndicesEditor)this.myEditor).setUniqueRevertStateEnabled(this.myBatchIndicesModel.isUnique() == ThreeState.UNSURE);
            ((DatabaseBatchIndicesEditor)this.myEditor).setHintText(DatabaseBundle.message("label.edit.to.override.existing.names", new Object[0]));
        }
    }

    @NotNull
    private static DatabaseEditorCapabilities.IndexEditorCaps getIndexCaps(@NotNull Dbms dbms, boolean existing) {
        if (dbms == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(7);
        }
        DatabaseEditorCapabilities.IndexEditorCaps indexEditorCaps = SchemaEditor.forDbms(dbms).getDbEditorCaps().getTableEditorCaps(true).getIndexCaps(existing);
        if (indexEditorCaps == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(8);
        }
        return indexEditorCaps;
    }

    @Override
    protected boolean isRefactoringValid() {
        return super.isRefactoringValid() && this.areIndicesNamesUnique();
    }

    private boolean areIndicesNamesUnique() {
        Set<String> names2 = DasUtil.newCaseAwareSet(DasUtil.isCaseSensitive(this.getContext().getCasingProvider().getCasing(ObjectKind.INDEX, null)));
        for (DeIndex index2 : this.myBatchIndicesModel.getIndices()) {
            if (names2.contains(index2.name)) {
                return false;
            }
            names2.add(index2.name);
        }
        return true;
    }

    @NotNull
    public List<DeIndex> createIndices(@NotNull List<? extends BasicTableColumn> columns2) {
        if (columns2 == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(9);
        }
        ArrayList<DeIndex> indices = new ArrayList<DeIndex>(columns2.size());
        for (BasicTableColumn basicTableColumn : columns2) {
            DeTable table = (DeTable)this.export(basicTableColumn.getTable(), true);
            DeIndex index2 = new DeIndex("", table, this.myModel);
            index2.items.add(new DeIndex.Item((DeColumn)this.export(basicTableColumn, false), DasIndex.Sorting.NONE));
            indices.add(index2);
            table.indices.add((Object)index2);
        }
        ArrayList<DeIndex> arrayList = indices;
        if (arrayList == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    public List<DeIndex> existingIndices(@NotNull List<? extends BasicIndex> indices) {
        if (indices == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(11);
        }
        ArrayList<DeIndex> deIndices = new ArrayList<DeIndex>(indices.size());
        for (BasicIndex basicIndex : indices) {
            this.checkObjectInContext(basicIndex);
            deIndices.add((DeIndex)this.export(basicIndex, true));
        }
        ArrayList<DeIndex> arrayList = deIndices;
        if (arrayList == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public static DbBatchIndicesDialog newBatchAddIndicesDialog(@NotNull DatabaseEditorContext context, @NotNull List<? extends BasicTableColumn> columns2) {
        if (context == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(13);
        }
        if (columns2 == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(14);
        }
        DbBatchIndicesDialog dialog = new DbBatchIndicesDialog(context);
        dialog.setIndices(dialog.createIndices(columns2));
        DbBatchIndicesDialog dbBatchIndicesDialog = dialog;
        if (dbBatchIndicesDialog == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(15);
        }
        return dbBatchIndicesDialog;
    }

    @NotNull
    public static DbBatchIndicesDialog newBatchModifyIndicesDialog(@NotNull DatabaseEditorContext context, @NotNull List<? extends BasicIndex> indices) {
        if (context == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(16);
        }
        if (indices == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(17);
        }
        DbBatchIndicesDialog dialog = new DbBatchIndicesDialog(context);
        dialog.setIndices(dialog.existingIndices(indices));
        dialog.setRefactoring(true);
        DbBatchIndicesDialog dbBatchIndicesDialog = dialog;
        if (dbBatchIndicesDialog == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(18);
        }
        return dbBatchIndicesDialog;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 10, 12, 15, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DbBatchIndicesDialog";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DbBatchIndicesDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexCaps";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndices";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "existingIndices";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "newBatchAddIndicesDialog";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "newBatchModifyIndicesDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canAddAnything";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canModifyAnything";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setIndices";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIndexCaps";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createIndices";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "existingIndices";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "newBatchAddIndicesDialog";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "newBatchModifyIndicesDialog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 10, 12, 15, 18 -> new IllegalStateException(string);
        };
    }
}

