/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.DatabaseNameComponent;
import com.intellij.database.dataSource.ui.DriverInstantiateComponent;
import com.intellij.database.view.ui.AdvancedPropertiesPanel;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverGeneralPanel;
import com.intellij.database.view.ui.DatabaseDriverOptionsPanel;
import com.intellij.database.view.ui.DriverClasspathPanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDriverConfigurable
extends AbstractDatabaseConfigurable<DatabaseDriverImpl> {
    private final DatabaseDriverImpl myDriver;
    private final DatabaseDriverImpl myTempDriver;
    private long myLastSaveStamp;
    private DriverInstantiateComponent myInstantiateComponent;
    private DatabaseNameComponent myNameComponent;
    private DatabaseDriverGeneralPanel myGeneralPanel;
    private DatabaseDriverOptionsPanel myOptionsPanel;
    private AdvancedPropertiesPanel myAdvancedPanel;
    private JBTabbedPane myTabbedPane;
    private JPanel myRootPanel;

    DatabaseDriverConfigurable(@NotNull Project project, @NotNull DatabaseDriverImpl driver2, @NotNull DatabaseConfigEditor editorController) {
        if (project == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(0);
        }
        if (driver2 == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(1);
        }
        if (editorController == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(2);
        }
        super(project, driver2);
        this.setController(editorController);
        this.myDriver = driver2;
        this.myTempDriver = driver2.copy(null, true);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNameComponent.getPreferredFocusedComponent();
    }

    @Nls
    public String getDisplayName() {
        return this.myNameComponent == null ? this.myTempDriver.getName() : this.myNameComponent.getNameValue();
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.tools.datasource.properties";
    }

    @Nullable
    public JComponent createComponent() {
        this.myRootPanel = new JPanel(new BorderLayout(0, 5));
        this.myInstantiateComponent = new DriverInstantiateComponent(this);
        this.myNameComponent = new DatabaseNameComponent(this, this.myController, false);
        this.myTabbedPane = new JBTabbedPane();
        this.myTabbedPane.setTabComponentInsets(null);
        this.myRootPanel.add((Component)this.myNameComponent.getComponent(), "North");
        this.myRootPanel.add((Component)this.myTabbedPane, "Center");
        this.myGeneralPanel = new DatabaseDriverGeneralPanel(this, this.myTempDriver);
        this.myOptionsPanel = new DatabaseDriverOptionsPanel(this);
        this.myAdvancedPanel = new AdvancedPropertiesPanel(this.myProject, this.myDriver.getDriverProperties(), this, this.myController);
        this.myTabbedPane.addTab(DatabaseBundle.message("database.driver.settings.general.tab", new Object[0]), (Component)this.myGeneralPanel.getComponent());
        this.myTabbedPane.addTab(DatabaseBundle.message("database.driver.settings.options.tab", new Object[0]), (Component)this.myOptionsPanel.getComponent());
        this.myTabbedPane.addTab(DatabaseBundle.message("database.driver.settings.advanced.tab", new Object[0]), (Component)this.myAdvancedPanel.getComponent());
        DataSourceConfigurable.initTabbedPane(this.myTabbedPane, this.myController);
        return this.myRootPanel;
    }

    @Override
    public void beforeShowNotify() {
        super.beforeShowNotify();
        this.myTabbedPane.setSelectedIndex(DataSourceConfigurable.getDefaultTabIndex(this.myTabbedPane, this.myController));
    }

    @Override
    @NotNull
    public DatabaseDriverImpl getTempTarget() {
        long curStamp = this.getModificationCount();
        if (curStamp != this.myLastSaveStamp) {
            this.myLastSaveStamp = curStamp;
            this.saveDriver(this.myTempDriver);
        }
        DatabaseDriverImpl databaseDriverImpl = this.myTempDriver;
        if (databaseDriverImpl == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(3);
        }
        return databaseDriverImpl;
    }

    @Override
    public boolean isTempTarget(@Nullable Object target2) {
        return target2 == this.myTempDriver;
    }

    @Override
    protected JComponent getComponent() {
        return this.myRootPanel;
    }

    @NotNull
    public DatabaseDriverImpl getTempDriver() {
        DatabaseDriverImpl databaseDriverImpl = this.getTempTarget();
        if (databaseDriverImpl == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(4);
        }
        return databaseDriverImpl;
    }

    private boolean isNewDriver() {
        return !DatabaseDriverManager.getInstance().getDrivers().contains(this.myDriver);
    }

    public void apply() throws ConfigurationException {
        this.saveDriver(this.myTempDriver);
        this.saveDriver(this.myDriver);
        DatabaseDriverManager.getInstance().updateDriver(this.myDriver);
    }

    private void saveDriver(DatabaseDriverImpl driver2) {
        if (this.myNameComponent != null) {
            this.myNameComponent.save(driver2);
        }
        if (this.myGeneralPanel != null) {
            this.myGeneralPanel.saveData(driver2);
        }
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.saveData(driver2);
        }
        if (this.myAdvancedPanel != null) {
            this.myAdvancedPanel.saveDriver(driver2);
        }
    }

    public void resetFromTemp() {
        this.bulkUpdate(() -> this.reset(this.myTempDriver));
    }

    @Override
    public void reset(@NotNull DatabaseDriverImpl driver2) {
        if (driver2 == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(5);
        }
        if (this.myNameComponent != null) {
            this.myNameComponent.reset(driver2, null);
        }
        if (this.myGeneralPanel != null) {
            this.myGeneralPanel.reset(driver2);
        }
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.reset(driver2);
        }
        if (this.myAdvancedPanel != null) {
            this.myAdvancedPanel.resetDriver(driver2);
        }
    }

    @Override
    public JComponent getCommonBar() {
        return this.myInstantiateComponent.getComponent();
    }

    public boolean isModified() {
        if (this.isNewDriver()) {
            return true;
        }
        return !this.getTempDriver().equalConfiguration(this.myDriver);
    }

    @NotNull
    public DatabaseDriverImpl getDriver() {
        DatabaseDriverImpl databaseDriverImpl = this.myDriver;
        if (databaseDriverImpl == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(6);
        }
        return databaseDriverImpl;
    }

    public void addNewUrlTemplate(@NotNull String template) {
        if (template == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(7);
        }
        if (this.myGeneralPanel != null && this.myTabbedPane != null) {
            this.myTabbedPane.setSelectedComponent((Component)this.myGeneralPanel.getComponent());
            this.myGeneralPanel.addNewUrlTemplate(template);
        }
    }

    public void focusDriverClassSelector() {
        if (this.myGeneralPanel != null) {
            this.myGeneralPanel.focusDriverClassSelector();
        }
    }

    public void focusKeepAliveField() {
        if (this.myOptionsPanel != null) {
            int index2 = DataSourceConfigurable.findTabIndex(this.myTabbedPane, this.myOptionsPanel.getComponent());
            if (index2 != -1) {
                this.myTabbedPane.setSelectedIndex(index2);
            }
            this.myOptionsPanel.focusKeepAliveField();
        }
    }

    @NotNull
    public JComponent selectAdvancedPanel() {
        int index2 = DataSourceConfigurable.findTabIndex(this.myTabbedPane, this.myAdvancedPanel.getComponent());
        if (index2 != -1) {
            this.myTabbedPane.setSelectedIndex(index2);
        }
        JPanel jPanel = this.myAdvancedPanel.getComponent();
        if (jPanel == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    @NotNull
    public DriverClasspathPanel getClassPathPanel() {
        DriverClasspathPanel driverClasspathPanel = this.myGeneralPanel.getDriverClassPathPanel();
        if (driverClasspathPanel == null) {
            DatabaseDriverConfigurable.$$$reportNull$$$0(9);
        }
        return driverClasspathPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorController";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DatabaseDriverConfigurable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DatabaseDriverConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempTarget";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDriver";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDriver";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "selectAdvancedPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPathPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addNewUrlTemplate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 8, 9 -> new IllegalStateException(string);
        };
    }
}

