/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.schemaEditor.DbEditorModality;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseConfigEditorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorConfigurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataSourceManagerDialog
extends SingleConfigurableEditor {
    DataSourceManagerDialog(@NotNull DbPsiFacade facade, @NotNull DatabaseConfigEditorImpl.DataSourceSettings settings) {
        if (facade == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(1);
        }
        super(facade.getProject(), (Configurable)new MyConfigurable(settings));
        this.setTitle(DatabaseBundle.message("dialog.title.data.sources.drivers", new Object[0]));
    }

    protected void init(@NotNull Configurable configurable) {
        if (configurable == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(2);
        }
        DbEditorModality.withDialogModality((DialogWrapper)this, () -> {
            super.init(configurable);
            return null;
        });
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(3);
        }
        return dialogStyle;
    }

    @NotNull
    public static List<DbDataSource> showDialog(@NotNull Project project, @Nullable Object selection2, @Nullable DatabaseCredentials credentials) {
        if (project == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(4);
        }
        return DataSourceManagerDialog.showDialog(DbPsiFacade.getInstance(project), selection2, credentials);
    }

    @NotNull
    public static List<DbDataSource> showDialog(@NotNull DbPsiFacade facade, @Nullable Object selection2, @Nullable DatabaseCredentials credentials) {
        if (facade == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(5);
        }
        return DataSourceManagerDialog.showDialog(facade, selection2, credentials, null);
    }

    @NotNull
    public static List<DbDataSource> showDialog(@NotNull DbPsiFacade facade, @Nullable Object selection2, @Nullable DatabaseCredentials credentials, @Nullable Consumer<? super DatabaseConfigEditor> setUp) {
        if (facade == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(6);
        }
        return DataSourceManagerDialog.showDialog(facade, selection2, credentials, setUp, null);
    }

    @NotNull
    public static List<DbDataSource> showDialog(@NotNull DbPsiFacade facade, @Nullable Object selection2, @Nullable DatabaseCredentials srcCredentials, @Nullable Consumer<? super DatabaseConfigEditor> setUp, @Nullable Runnable onFinish) {
        if (facade == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(7);
        }
        DatabaseCredentials credentials = DatabaseCredentialsUi.newUIInstance();
        DatabaseConfigEditorImpl.DataSourceSettings settings = new DatabaseConfigEditorImpl.DataSourceSettings(facade, credentials);
        JBIterable selectionIt = selection2 instanceof Iterable ? JBIterable.from((Iterable)((Iterable)selection2)) : JBIterable.of((Object)selection2);
        settings.selection = selectionIt.first();
        selectionIt.filter(DatabaseDriver.class).addAllTo(settings.newDrivers);
        selectionIt.filter(DasDataSource.class).filterMap(o2 -> DataSourceManagerDialog.dbDataSource(facade, o2)).filter(o2 -> !o2.isValid()).addAllTo(settings.newDataSources);
        HashSet<DbDataSource> existing = new HashSet<DbDataSource>(settings.facade.getDataSources());
        DataSourceManagerDialog dialog = new DataSourceManagerDialog(facade, settings);
        if (srcCredentials != null) {
            for (DbDataSource dataSource2 : settings.newDataSources) {
                LocalDataSource lds = DbImplUtilCore.getMaybeLocalDataSource(dataSource2);
                if (lds == null) continue;
                DatabaseAuthProvider.copyAllCredentials(lds, srcCredentials, lds, credentials);
            }
        }
        if (setUp != null) {
            DataSourceManagerDialog.runWhenDialogIsInitialized(dialog, () -> setUp.consume((Object)((MyConfigurable)dialog.getConfigurable()).getEditor()));
        }
        dialog.show();
        ArrayList<DbDataSource> result2 = new ArrayList<DbDataSource>();
        if (ModalityState.current() == ModalityState.nonModal()) {
            for (DbDataSource element2 : settings.facade.getDataSources()) {
                if (existing.contains(element2)) continue;
                result2.add(element2);
                if (!DbImplUtilCore.canConnectTo(element2)) continue;
                DatabaseEditorHelper.openConsoleFile(element2);
            }
            ((DbPsiFacadeImpl)facade).whenReady().onProcessed(x -> DatabaseView.select(facade.getProject(), result2, false, true).onProcessed(xx -> {
                DatabaseView view2 = DatabaseView.getDatabaseView(dialog.getProject());
                view2.showSchemaManagerGotIt((DbDataSource)ContainerUtil.getFirstItem((List)result2));
            }));
        }
        if (onFinish != null) {
            onFinish.run();
        }
        ArrayList<DbDataSource> arrayList = result2;
        if (arrayList == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static DbDataSource dbDataSource(@NotNull DbPsiFacade facade, DasDataSource o2) {
        if (facade == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(9);
        }
        if (o2 instanceof DbDataSource) {
            return (DbDataSource)o2;
        }
        return DataSourceManagerDialog.dbDataSource(facade, (RawDataSource)ObjectUtils.tryCast((Object)o2, RawDataSource.class));
    }

    @Nullable
    private static DbDataSource dbDataSource(@NotNull DbPsiFacade facade, RawDataSource o2) {
        if (facade == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(10);
        }
        if (o2 == null) {
            return null;
        }
        DataSourceManager<Class<?>> manager = DataSourceManager.byDataSource(facade.getProject(), o2.getClass());
        return manager == null ? null : ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(o2, manager);
    }

    private static void runWhenDialogIsInitialized(DataSourceManagerDialog dialog, final Runnable runnable) {
        final Condition expired = ignored -> dialog.isDisposed();
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getInstance((Project)dialog.getProject()).doWhenFocusSettlesDown(new ExpirableRunnable(){

            public boolean isExpired() {
                return expired.value(null);
            }

            public void run() {
                runnable.run();
            }
        }), expired), ModalityState.stateForComponent((Component)dialog.getContentPanel()), expired);
    }

    public static boolean showDialog(@NotNull DbPsiFacade facade, @NotNull DataSourceRegistry registry) {
        if (facade == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(11);
        }
        if (registry == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(12);
        }
        DataSourceStorage storage = DataSourceStorage.getProjectStorage(facade.getProject());
        DatabaseCredentials credentials = DatabaseCredentialsUi.newUIInstance();
        DatabaseConfigEditorImpl.DataSourceSettings settings = new DatabaseConfigEditorImpl.DataSourceSettings(facade, credentials);
        LocalDataSourceManager manager = LocalDataSourceManager.getInstance(facade.getProject());
        Map importedNames = JBIterable.from(storage.getDataSources()).filter(LocalDataSource.class).filter(LocalDataSource::isImported).toReverseMap(AbstractDataSource::getName);
        for (LocalDataSource o2 : registry.getDataSources()) {
            LocalDataSource existing = (LocalDataSource)importedNames.get(o2.getName());
            if (existing != null) continue;
            DataSourceManagerDialog.addDataSource(o2, settings, manager, facade);
        }
        DataSourceManagerDialog dialog = new DataSourceManagerDialog(facade, settings);
        DatabaseConfigEditorImpl editor2 = ((MyConfigurable)dialog.getConfigurable()).getEditor();
        for (LocalDataSource o3 : registry.getDataSources()) {
            DataSourceConfigurable configurable;
            DataSourceConfigUtil.copyCredentials(o3, registry.getCredentialsStore(), credentials);
            LocalDataSource existing = (LocalDataSource)importedNames.get(o3.getName());
            if (existing == null || (configurable = editor2.getConfigurable(existing, true, DataSourceConfigurable.class)) == null) continue;
            LocalDataSource temp = configurable.getTempDataSource();
            temp.setUrlSmart(o3.getUrl());
            configurable.resetFromTemp();
        }
        editor2.clearModifiedCache();
        boolean result2 = dialog.showAndGet();
        DataSourceConfigUtil.runRegistryCallbacks(facade.getProject(), registry);
        return result2;
    }

    private static void addDataSource(@NotNull LocalDataSource dataSource2, @NotNull DatabaseConfigEditorImpl.DataSourceSettings settings, @NotNull LocalDataSourceManager manager, @NotNull DbPsiFacade facade) {
        DatabaseDriver driver0;
        if (dataSource2 == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(14);
        }
        if (manager == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(15);
        }
        if (facade == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(16);
        }
        if ((driver0 = dataSource2.getDatabaseDriver()) == null) {
            String driverClass = dataSource2.getDriverClass();
            if (StringUtil.isEmpty((String)driverClass)) {
                return;
            }
            DatabaseDriver newDriver = null;
            for (DatabaseDriver driver2 : settings.newDrivers) {
                if (!driverClass.equals(driver2.getDriverClass())) continue;
                newDriver = driver2;
                break;
            }
            if (newDriver == null) {
                newDriver = DatabaseDriverManager.getInstance().createDriver(driverClass, driverClass, null);
                settings.newDrivers.add(newDriver);
            }
            dataSource2.setDatabaseDriver(newDriver);
        } else {
            JBIterable drivers = JBIterable.from(DatabaseDriverManager.getInstance().getDrivers()).filter(DatabaseDriver.class).append(settings.newDrivers);
            DatabaseDriver existingDriver = (DatabaseDriver)drivers.find(o2 -> ((DatabaseDriverImpl)o2).equalConfiguration((DatabaseDriverImpl)driver0));
            if (existingDriver != null) {
                dataSource2.setDatabaseDriver(existingDriver);
            } else {
                settings.newDrivers.add(driver0);
            }
        }
        DbDataSource element2 = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(dataSource2, manager);
        settings.newDataSources.add(element2);
        if (settings.newDataSources.size() == 1) {
            settings.selection = element2;
        }
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.execution.impl.EditConfigurationsDialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DataSourceManagerDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DataSourceManagerDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "showDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "dbDataSource";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addDataSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8 -> new IllegalStateException(string);
        };
    }

    static class MyConfigurable
    extends SettingsEditorConfigurable<DatabaseConfigEditorImpl.DataSourceSettings> {
        MyConfigurable(@NotNull DatabaseConfigEditorImpl.DataSourceSettings settings) {
            if (settings == null) {
                MyConfigurable.$$$reportNull$$$0(0);
            }
            super((SettingsEditor)new DatabaseConfigEditorImpl(settings), (Object)settings);
        }

        public String getDisplayName() {
            return DatabaseBundle.message("configurable.DataSourceManagerDialog.MyConfigurable.display.name", new Object[0]);
        }

        public String getHelpTopic() {
            String topic = this.getEditor().getHelpTopic();
            if (topic == null) {
                topic = "data.sources.and.drivers.dialog";
            }
            return topic;
        }

        @NotNull
        public DatabaseConfigEditorImpl getEditor() {
            DatabaseConfigEditorImpl databaseConfigEditorImpl = (DatabaseConfigEditorImpl)super.getEditor();
            if (databaseConfigEditorImpl == null) {
                MyConfigurable.$$$reportNull$$$0(1);
            }
            return databaseConfigEditorImpl;
        }

        public boolean isModified() {
            return this.getEditor().isAnyEditorModified();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.getEditor().getPreferredFocusedComponent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourceManagerDialog$MyConfigurable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourceManagerDialog$MyConfigurable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

