/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.DbModelRegistry;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseViewTreeCoreFun;
import com.intellij.database.view.structure.CollectionCache;
import com.intellij.database.view.structure.DvFun;
import com.intellij.database.view.structure.DvHostNode;
import com.intellij.database.view.structure.DvTreeAbstractLayer;
import com.intellij.database.view.structure.DvTreeModelLayer;
import com.intellij.database.view.structure.DvTreeStoreyLayer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 V2\u00020\u0001:\u0001VB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0014\u0010 \u001a\u00020\u001e2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00052\u0006\u0010%\u001a\u00020&H\u0002J\u001a\u0010'\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010(2\b\u0010%\u001a\u0004\u0018\u00010*H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020\u0015H\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0010\u00102\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019H\u0002J\u001c\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u00192\n\u0010!\u001a\u0006\u0012\u0002\b\u000305H\u0002J\u001a\u00106\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0\u00192\u0006\u00107\u001a\u00020.H\u0002J\u001c\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u00192\n\u0010!\u001a\u0006\u0012\u0002\b\u000305H\u0002J\u001c\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0\u00192\n\u0010!\u001a\u0006\u0012\u0002\b\u000305H\u0002J!\u0010:\u001a\u000f\u0012\u0006\b\u0001\u0012\u00020.0\u0019\u00a2\u0006\u0002\b;2\n\u0010!\u001a\u0006\u0012\u0002\b\u000305H\u0002J\u001c\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u00192\n\u0010!\u001a\u0006\u0012\u0002\b\u000305H\u0002J\u0015\u0010=\u001a\u00020\u00152\u0006\u0010>\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b?J\u0015\u0010@\u001a\u00020\u00152\u0006\u0010>\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\bAJ\u0015\u0010B\u001a\u00020\u00152\u0006\u0010>\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\bCJ\u001d\u0010D\u001a\u00020\u00152\u0006\u0010>\u001a\u00020\u00172\u0006\u0010E\u001a\u00020FH\u0010\u00a2\u0006\u0002\bGJ\u0012\u0010H\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0012\u0010I\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020.H\u0002J\u0014\u0010J\u001a\u00020\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u000305H\u0002J\u0010\u0010K\u001a\u00020L2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0014\u0010M\u001a\u00020L2\n\u0010!\u001a\u0006\u0012\u0002\b\u000305H\u0002J\u0010\u0010N\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019H\u0002J\u0015\u0010P\u001a\u00020\u00152\u0006\u0010Q\u001a\u00020RH\u0010\u00a2\u0006\u0002\bSJ\u000e\u0010T\u001a\u0004\u0018\u00010\u0005*\u00020UH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006W"}, d2={"Lcom/intellij/database/view/structure/DvTreeModelLayer;", "Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "()V", "dataSources", "Lcom/intellij/database/view/structure/CollectionCache;", "Lcom/intellij/database/view/DataSourceNode;", "knownViewOptionsCounter", "", "level", "", "getLevel", "()B", "project", "Lcom/intellij/openapi/project/Project;", "psiFacade", "Lcom/intellij/database/psi/DbPsiFacade;", "getPsiFacade", "()Lcom/intellij/database/psi/DbPsiFacade;", "psiFacade$delegate", "Lkotlin/Lazy;", "addDSN", "", "ds", "Lcom/intellij/database/model/RawDataSource;", "childrenOf", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/basic/BasicNode;", "node", "clearAll", "countAllChildrenOf", "", "countRealChildrenOf", "countRealChildrenOfFamily", "family", "Lcom/intellij/database/model/families/Family;", "getDSN", "getDataSourceNodeFor", "model", "Lcom/intellij/database/model/DasModel;", "getObjectFilterForRegularObjects", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/database/model/DasObject;", "Lcom/intellij/database/model/basic/BasicModel;", "getScope", "Lcom/intellij/database/util/TreePattern;", "host", "Lcom/intellij/database/model/basic/BasicElement;", "invalidateCaches", "isAlwaysLeaf", "", "isValid", "listDataSources", "listDatabases", "Lcom/intellij/database/model/families/HostFamily;", "listElementFamilies", "element", "listFamilyChildren", "listNamespacesToShow", "listRegularFamilyElements", "Lorg/jetbrains/annotations/NotNull;", "listSchemas", "onDataSourceAdded", "dataSource", "onDataSourceAdded$intellij_database_core_impl", "onDataSourceChanged", "onDataSourceChanged$intellij_database_core_impl", "onDataSourcePathChanged", "onDataSourcePathChanged$intellij_database_core_impl", "onDataSourceRemoved", "dbms", "Lcom/intellij/database/Dbms;", "onDataSourceRemoved$intellij_database_core_impl", "parentOf", "parentOfElement", "parentOfFamily", "presentableNameOf", "", "presentableNameOfFamily", "removeDSN", "retrieveAllDataSourceNodes", "setup", "base", "Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "setup$intellij_database_core_impl", "dataSourceNode", "Lcom/intellij/database/model/basic/BasicRoot;", "Companion", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvTreeModelLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeModelLayer.kt\ncom/intellij/database/view/structure/DvTreeModelLayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,285:1\n1#2:286\n288#3,2:287\n13#4:289\n*S KotlinDebug\n*F\n+ 1 DvTreeModelLayer.kt\ncom/intellij/database/view/structure/DvTreeModelLayer\n*L\n191#1:287,2\n275#1:289\n*E\n"})
public final class DvTreeModelLayer
extends DvTreeStoreyLayer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private Project project;
    @NotNull
    private final Lazy psiFacade$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DbPsiFacade>(this){
        final /* synthetic */ DvTreeModelLayer this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final DbPsiFacade invoke() {
            Project project = DvTreeModelLayer.access$getProject$p(this.this$0);
            if (project == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                project = null;
            }
            DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)dbPsiFacade), (String)"getInstance(...)");
            return dbPsiFacade;
        }
    }));
    private long knownViewOptionsCounter = -1L;
    @NotNull
    private final CollectionCache<DataSourceNode> dataSources = new CollectionCache((Function0)new Function0<Iterable<? extends DataSourceNode>>(this){
        final /* synthetic */ DvTreeModelLayer this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final Iterable<DataSourceNode> invoke() {
            return (Iterable)DvTreeModelLayer.access$retrieveAllDataSourceNodes(this.this$0);
        }
    });
    @NotNull
    private static final List<Class<?>> excluded = CollectionsKt.listOf(BasicArgument.class);
    @NotNull
    private static final List<Class<?>> alwaysLeafs;
    @NotNull
    private static final Logger logger;

    @Override
    public byte getLevel() {
        return 1;
    }

    private final DbPsiFacade getPsiFacade() {
        Lazy lazy = this.psiFacade$delegate;
        return (DbPsiFacade)((Object)lazy.getValue());
    }

    @Override
    public void setup$intellij_database_core_impl(@NotNull DvTreeAbstractLayer base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        super.setup$intellij_database_core_impl(base);
        this.project = base.getContext().project;
        this.knownViewOptionsCounter = this.getVo().getModificationCount();
    }

    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        BasicNode basicNode = node2;
        return basicNode instanceof BasicElement ? this.parentOfElement((BasicElement)node2) : (basicNode instanceof HostFamily ? this.parentOfFamily((HostFamily)node2) : (basicNode instanceof DataSourceNode ? this.getRoot() : (basicNode instanceof DvHostNode ? (BasicNode)((DvHostNode)node2).host : null)));
    }

    private final BasicNode parentOfElement(BasicElement node2) {
        return node2 instanceof BasicRoot ? this.getRoot() : (BasicNode)node2.getParentFamily();
    }

    private final DataSourceNode dataSourceNode(BasicRoot $this$dataSourceNode) {
        BasicModel model2;
        BasicModel basicModel = model2 = $this$dataSourceNode.getModel();
        return basicModel != null ? this.getDataSourceNodeFor(basicModel) : null;
    }

    private final BasicNode parentOfFamily(HostFamily<?> node2) {
        DataSourceNode dsn;
        BasicElement basicElement = node2.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
        BasicNode parent2 = basicElement;
        if (parent2 instanceof BasicRoot && (dsn = this.dataSourceNode((BasicRoot)parent2)) != null) {
            parent2 = dsn;
        }
        return parent2;
    }

    private final DataSourceNode getDataSourceNodeFor(DasModel model2) {
        DbDataSource dbDS = null;
        if (model2 instanceof BasicModel) {
            dbDS = this.getContext().getModelRegistry().findDbDataSource((BasicModel)model2);
        }
        if (dbDS == null) {
            Object v1;
            block3: {
                List<DbDataSource> list = this.getPsiFacade().getDataSources();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
                Iterable iterable = list;
                for (Object t : iterable) {
                    DbDataSource it2 = (DbDataSource)t;
                    boolean bl = false;
                    if (!(it2.getModel() == model2)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            dbDS = v1;
        }
        DbDataSource dbDataSource = dbDS;
        return dbDataSource != null ? DataSourceNode.Companion.node(dbDataSource) : null;
    }

    @Override
    @NotNull
    public JBIterable<? extends BasicNode> childrenOf(@NotNull BasicNode node2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        if (this.isAlwaysLeaf(node2)) {
            JBIterable<Family<?>> jBIterable = JBIterable.empty();
            object = jBIterable;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
        } else {
            BasicNode basicNode = node2;
            if (basicNode instanceof BasicElement) {
                object = this.listElementFamilies((BasicElement)node2);
            } else if (basicNode instanceof HostFamily) {
                object = this.listFamilyChildren((HostFamily)node2);
            } else if (basicNode instanceof DataSourceNode) {
                object = ((DataSourceNode)node2).getModelRoot();
                if (object == null || (object = object.getFamilies()) == null || (object = UtilKt.asJBIterable((Iterable)((Iterable)object))) == null) {
                    JBIterable jBIterable = JBIterable.empty();
                    object = jBIterable;
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
                }
            } else if (Intrinsics.areEqual((Object)basicNode, (Object)this.getRoot())) {
                object = this.listDataSources();
            } else {
                JBIterable jBIterable = JBIterable.empty();
                object = jBIterable;
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            }
        }
        return object;
    }

    private final JBIterable<DataSourceNode> listDataSources() {
        Collection<DataSourceNode> content = this.dataSources.content();
        JBIterable jBIterable = JBIterable.from((Iterable)content);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        return jBIterable;
    }

    private final JBIterable<Family<?>> listElementFamilies(BasicElement element2) {
        JBIterable jBIterable = UtilKt.asJBIterable((Iterable)element2.getFamilies()).filter(arg_0 -> DvTreeModelLayer.listElementFamilies$lambda$1((Function1)new Function1<Family<? extends BasicElement>, Boolean>(this){
            final /* synthetic */ DvTreeModelLayer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(Family<? extends BasicElement> f) {
                boolean bl;
                if (f instanceof HostFamily) {
                    Companion companion = DvTreeModelLayer.access$getCompanion$p();
                    BasicMetaObject<?> basicMetaObject = ((HostFamily)f).getMetaObject();
                    Intrinsics.checkNotNullExpressionValue(basicMetaObject, (String)"getMetaObject(...)");
                    if (!companion.kindOfAny(basicMetaObject, DvTreeModelLayer.access$getCompanion$p().getExcluded()) && !this.this$0.getVo().getHiddenKinds().contains(((HostFamily)f).getChildrenKind().code()) && (this.this$0.getVo().getShowEmptyGroups() || DbImplUtilCore.NAMESPACE_KINDS.contains(((HostFamily)f).getChildrenKind()) || ((HostFamily)f).isNotEmpty())) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    private final JBIterable<? extends BasicNode> listFamilyChildren(HostFamily<?> family) {
        Object object;
        if (family.isEmpty()) {
            JBIterable<? extends BasicNode> jBIterable = JBIterable.empty();
            object = jBIterable;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
        } else {
            ObjectKind objectKind = family.getChildrenKind();
            object = DbImplUtilCore.DATABASE_KINDS.contains(objectKind) ? this.listDatabases(family) : (DbImplUtilCore.SCHEMA_KINDS.contains(objectKind) ? this.listSchemas(family) : this.listRegularFamilyElements(family));
        }
        return object;
    }

    private final JBIterable<? extends BasicNode> listDatabases(HostFamily<?> family) {
        return this.listNamespacesToShow(family);
    }

    private final JBIterable<? extends BasicNode> listSchemas(HostFamily<?> family) {
        return this.listNamespacesToShow(family);
    }

    private final JBIterable<? extends BasicElement> listNamespacesToShow(HostFamily<?> family) {
        JBIterable jBIterable;
        BasicElement basicElement = family.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
        TreePattern scope = this.getScope(basicElement);
        if (scope == null) {
            JBIterable jBIterable2 = family.jbi();
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue(jBIterable2, (String)"jbi(...)");
        } else if (Intrinsics.areEqual((Object)scope, (Object)TreePattern.EMPTY)) {
            JBIterable jBIterable3 = JBIterable.empty();
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"empty(...)");
        } else {
            JBIterable jBIterable4 = family.jbi().filter(arg_0 -> DvTreeModelLayer.listNamespacesToShow$lambda$2((Function1)new Function1<BasicElement, Boolean>(scope){
                final /* synthetic */ TreePattern $scope;
                {
                    this.$scope = $scope;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(BasicElement it2) {
                    return DataSourceSchemaMapping.matches(this.$scope, it2);
                }
            }, arg_0));
            jBIterable = jBIterable4;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"filter(...)");
        }
        JBIterable namespaces2 = jBIterable;
        return namespaces2;
    }

    private final JBIterable<? extends BasicElement> listRegularFamilyElements(HostFamily<?> family) {
        JBIterable jBIterable = family.jbi();
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"jbi(...)");
        JBIterable children2 = jBIterable;
        Condition<DasObject> filter2 = this.getObjectFilterForRegularObjects(family.getModel());
        if (filter2 != null) {
            JBIterable jBIterable2 = children2.filter(arg_0 -> DvTreeModelLayer.listRegularFamilyElements$lambda$3((Function1)new Function1<DasObject, Boolean>(filter2){

                @NotNull
                public final Boolean invoke(DasObject p0) {
                    return ((Condition)this.receiver).value((Object)p0);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
            children2 = jBIterable2;
        }
        if (!this.getVo().getShowGeneratedObjects()) {
            JBIterable jBIterable3 = children2.filter(arg_0 -> DvTreeModelLayer.listRegularFamilyElements$lambda$4(listRegularFamilyElements.2.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"filter(...)");
            children2 = jBIterable3;
        }
        return children2;
    }

    private final Condition<DasObject> getObjectFilterForRegularObjects(BasicModel model2) {
        Condition<DasObject> condition2;
        if (model2 == null) {
            return null;
        }
        DbModelRegistry dbModelRegistry = this.getContext().getModelRegistry();
        BasicRoot basicRoot = model2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"getRoot(...)");
        RawDataSource rawDataSource = dbModelRegistry.findDataSource(basicRoot);
        if (rawDataSource == null) {
            return null;
        }
        RawDataSource ds = rawDataSource;
        try {
            condition2 = DbImplUtilCore.buildObjectFilter(ds);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return null;
        }
        Condition<DasObject> filter2 = condition2;
        return filter2;
    }

    private final TreePattern getScope(BasicElement host) {
        if (this.getVo().getShowAllNamespaces()) {
            return null;
        }
        DbDataSource dbDataSource = this.getContext().getModelRegistry().findDbDataSource(host);
        if (dbDataSource == null) {
            return null;
        }
        DbDataSource dbDataSource2 = dbDataSource;
        return DatabaseViewTreeCoreFun.getIntrospectionScope(dbDataSource2);
    }

    private final JBIterable<DataSourceNode> retrieveAllDataSourceNodes() {
        List<DbDataSource> list = this.getPsiFacade().getDataSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
        List<DbDataSource> dbDataSources = list;
        JBIterable jBIterable = JBIterable.from((Iterable)dbDataSources).map(arg_0 -> DvTreeModelLayer.retrieveAllDataSourceNodes$lambda$5(retrieveAllDataSourceNodes.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
        return jBIterable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        if (!(node2 instanceof BasicElement)) return false;
        BasicMetaObject<?> o2 = ((BasicElement)node2).getMetaObject();
        boolean bl = false;
        Intrinsics.checkNotNull(o2);
        if (Companion.kindOfAny(o2, alwaysLeafs)) return true;
        Intrinsics.checkNotNullExpressionValue(o2.children, (String)"children");
        if (((Object[])o2.children).length != 0) return false;
        return true;
    }

    @Override
    public void onDataSourceAdded$intellij_database_core_impl(@NotNull RawDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        if (Companion.getAlwaysInvalidateAll()) {
            this.invalidateCaches();
        } else {
            this.addDSN(dataSource2);
        }
    }

    @Override
    public void onDataSourceChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        if (Companion.getAlwaysInvalidateAll()) {
            this.invalidateCaches();
        }
    }

    @Override
    public void onDataSourcePathChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        if (Companion.getAlwaysInvalidateAll()) {
            this.invalidateCaches();
        }
    }

    @Override
    public void onDataSourceRemoved$intellij_database_core_impl(@NotNull RawDataSource dataSource2, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        if (Companion.getAlwaysInvalidateAll()) {
            this.invalidateCaches();
        } else {
            this.removeDSN(dataSource2);
        }
    }

    private final DataSourceNode getDSN(RawDataSource ds) {
        Object v1;
        block2: {
            List<DbDataSource> list = this.getPsiFacade().getDataSources();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DbDataSource d2 = (DbDataSource)element$iv;
                boolean bl = false;
                if (!(d2.getDelegate() == ds)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        DbDataSource dbDataSource = v1;
        if (dbDataSource == null) {
            return (DataSourceNode)((Object)Companion.logErrorReturnNull("Cannot find DbDataSource for RawDataSource (" + ds + ") in project " + this.getPsiFacade().getProject().getName()));
        }
        DbDataSource dbDS = dbDataSource;
        return DataSourceNode.Companion.node(dbDS);
    }

    private final void addDSN(RawDataSource ds) {
        DataSourceNode dsn = this.getDSN(ds);
        if (dsn != null) {
            this.dataSources.include(dsn);
        } else {
            logger.error("Cannot get DSN for RawDataSource " + ds);
        }
    }

    private final void removeDSN(RawDataSource ds) {
        this.dataSources.exclude((Function1<DataSourceNode, Boolean>)((Function1)new Function1<DataSourceNode, Boolean>(ds){
            final /* synthetic */ RawDataSource $ds;
            {
                this.$ds = $ds;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull DataSourceNode dsn) {
                Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
                return dsn.rawDataSource == this.$ds;
            }
        }));
    }

    @Override
    public int countAllChildrenOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        BasicNode basicNode = node2;
        return basicNode instanceof Family ? ((Family)node2).size() : (basicNode instanceof BasicElement ? ((BasicElement)node2).getFamilies().size() : CollectionsKt.count((Iterable)((Iterable)this.childrenOf(node2))));
    }

    @Override
    public int countRealChildrenOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        BasicNode basicNode = node2;
        return basicNode instanceof Family ? this.countRealChildrenOfFamily((Family)node2) : (basicNode instanceof BasicElement ? ((BasicElement)node2).getFamilies().size() : CollectionsKt.count((Iterable)((Iterable)this.childrenOf(node2))));
    }

    private final int countRealChildrenOfFamily(Family<?> family) {
        ObjectKind objectKind;
        return family instanceof HostFamily ? (Intrinsics.areEqual((Object)(objectKind = ((HostFamily)family).getChildrenKind()), (Object)ObjectKind.SCHEMA) ? this.listSchemas((HostFamily)family).size() : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.DATABASE) ? this.listDatabases((HostFamily)family).size() : family.size())) : family.size();
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        if (node2 instanceof HostFamily) {
            string = this.presentableNameOfFamily((HostFamily)node2);
        } else {
            String string2 = node2.getDisplayName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        }
        return string;
    }

    private final String presentableNameOfFamily(HostFamily<?> family) {
        BasicModel basicModel = family.getModel();
        if (basicModel == null) {
            return DvFun.getFamilyPresentableName(family);
        }
        BasicModel model2 = basicModel;
        ModelHelper helper = ModelFun.getHelper(model2);
        String customName = helper.getCustomName(family.getChildrenKind(), true);
        String string = customName;
        if (string == null) {
            string = DvFun.getFamilyPresentableName(family);
        }
        return string;
    }

    private final void invalidateCaches() {
        this.dataSources.invalidate();
    }

    @Override
    public void clearAll() {
        this.invalidateCaches();
    }

    @Override
    public boolean isValid(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return !(node2 instanceof BasicModElement) || !((BasicModElement)node2).isDropped();
    }

    private static final boolean listElementFamilies$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean listNamespacesToShow$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean listRegularFamilyElements$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean listRegularFamilyElements$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final DataSourceNode retrieveAllDataSourceNodes$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DataSourceNode)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Companion access$getCompanion$p() {
        return Companion;
    }

    public static final /* synthetic */ Project access$getProject$p(DvTreeModelLayer $this) {
        return $this.project;
    }

    public static final /* synthetic */ JBIterable access$retrieveAllDataSourceNodes(DvTreeModelLayer $this) {
        return $this.retrieveAllDataSourceNodes();
    }

    static {
        Object[] objectArray = new Class[]{BasicSequence.class, BasicSynonym.class, BasicRoutine.class};
        alwaysLeafs = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(DvTreeModelLayer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u00172\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/view/structure/DvTreeModelLayer$Companion;", "", "()V", "alwaysInvalidateAll", "", "getAlwaysInvalidateAll", "()Z", "alwaysLeafs", "", "Ljava/lang/Class;", "getAlwaysLeafs", "()Ljava/util/List;", "excluded", "getExcluded", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "logErrorReturnNull", "", "message", "", "kindOfAny", "Lcom/intellij/database/model/meta/BasicMetaObject;", "classes", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDvTreeModelLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeModelLayer.kt\ncom/intellij/database/view/structure/DvTreeModelLayer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n1747#2,3:286\n*S KotlinDebug\n*F\n+ 1 DvTreeModelLayer.kt\ncom/intellij/database/view/structure/DvTreeModelLayer$Companion\n*L\n270#1:286,3\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Class<?>> getExcluded() {
            return excluded;
        }

        @NotNull
        public final List<Class<?>> getAlwaysLeafs() {
            return alwaysLeafs;
        }

        public final boolean kindOfAny(@NotNull BasicMetaObject<?> $this$kindOfAny, @NotNull List<? extends Class<?>> classes) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter($this$kindOfAny, (String)"<this>");
                Intrinsics.checkNotNullParameter(classes, (String)"classes");
                Iterable $this$any$iv = classes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Class it2 = (Class)element$iv;
                        boolean bl2 = false;
                        if (!$this$kindOfAny.kindOf(it2)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean getAlwaysInvalidateAll() {
            return Registry.is((String)"database.view.layers.model.alwaysInvalidateAll");
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @Nullable
        public final Void logErrorReturnNull(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.getLogger().error(message2);
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

