/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.structure.DvHostNode;
import com.intellij.database.view.structure.DvTreeAbstractLayer;
import com.intellij.database.view.structure.DvTreeCacheLayer;
import com.intellij.database.view.structure.DvTreeInternalFunKt;
import com.intellij.database.view.structure.DvTreeLayer;
import com.intellij.database.view.structure.DvTreeStoreyLayer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0015\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0010\u00a2\u0006\u0002\b!J\u0015\u0010\"\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0010\u00a2\u0006\u0002\b#J)\u0010$\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010&H\u0010\u00a2\u0006\u0002\b(J\u0015\u0010)\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0010\u00a2\u0006\u0002\b*J\u001d\u0010+\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010,\u001a\u00020-H\u0010\u00a2\u0006\u0002\b.J\r\u0010/\u001a\u00020\u0014H\u0010\u00a2\u0006\u0002\b0J\u0012\u00101\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0012\u00102\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0015\u00105\u001a\u00020\u00142\u0006\u00106\u001a\u000207H\u0010\u00a2\u0006\u0002\b8J\u0010\u00109\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0010\u0010:\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J!\u0010;\u001a\u00020\u0004*\u00020\u00072\b\u0010<\u001a\u0004\u0018\u00010&2\b\u0010=\u001a\u0004\u0018\u00010&H\u0082\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/database/view/structure/DvTreeCacheLayer;", "Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "()V", "alwaysInvalidateAll", "", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/database/model/basic/BasicNode;", "Lcom/intellij/database/view/structure/DvTreeCacheLayer$NodeStuff;", "cacheEnabled", "knownModificationCount", "", "level", "", "getLevel", "()B", "skipDataSources", "specialCountCache", "", "checkOptionsModification", "", "childrenOf", "Lcom/intellij/util/containers/JBIterable;", "node", "clearAll", "clearCache", "countRealChildrenOf", "getStuff", "isAlwaysLeaf", "obtainStuff", "onDataSourceAdded", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "onDataSourceAdded$intellij_database_core_impl", "onDataSourceChanged", "onDataSourceChanged$intellij_database_core_impl", "onDataSourceModelReplaced", "oldModel", "Lcom/intellij/database/model/basic/BasicModel;", "newModel", "onDataSourceModelReplaced$intellij_database_core_impl", "onDataSourcePathChanged", "onDataSourcePathChanged$intellij_database_core_impl", "onDataSourceRemoved", "dbms", "Lcom/intellij/database/Dbms;", "onDataSourceRemoved$intellij_database_core_impl", "onViewOptionsChanged", "onViewOptionsChanged$intellij_database_core_impl", "parentOf", "peekStuff", "presentableNameOf", "", "setup", "base", "Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "setup$intellij_database_core_impl", "skip", "toCacheCountSpecially", "inModel", "model1", "model2", "NodeStuff", "intellij.database.core.impl"})
public final class DvTreeCacheLayer
extends DvTreeStoreyLayer {
    @NotNull
    private final Cache<BasicNode, NodeStuff> cache;
    @NotNull
    private final Cache<BasicNode, Integer> specialCountCache;
    private final boolean cacheEnabled;
    private final boolean alwaysInvalidateAll;
    private final boolean skipDataSources;
    private volatile long knownModificationCount;

    public DvTreeCacheLayer() {
        Cache cache2 = Caffeine.newBuilder().initialCapacity(256).expireAfterAccess(60L, TimeUnit.SECONDS).maximumSize(256L).weakKeys().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
        this.cache = cache2;
        Cache cache3 = Caffeine.newBuilder().initialCapacity(1024).weakKeys().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache3, (String)"build(...)");
        this.specialCountCache = cache3;
        this.cacheEnabled = Registry.is((String)"database.view.layers.cache.enable");
        this.alwaysInvalidateAll = Registry.is((String)"database.view.layers.cache.alwaysInvalidateAll");
        this.skipDataSources = Registry.is((String)"database.view.layers.cache.skipDataSources");
    }

    @Override
    public byte getLevel() {
        return 7;
    }

    @Override
    public void setup$intellij_database_core_impl(@NotNull DvTreeAbstractLayer base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        super.setup$intellij_database_core_impl(base);
        this.knownModificationCount = this.getVo().getModificationCount();
        this.clearCache();
    }

    private final NodeStuff getStuff(BasicNode node2) {
        this.checkOptionsModification();
        NodeStuff stuff2 = (NodeStuff)this.cache.get((Object)node2, arg_0 -> DvTreeCacheLayer.getStuff$lambda$0((Function1)new Function1<BasicNode, NodeStuff>((Object)this){

            @NotNull
            public final NodeStuff invoke(@NotNull BasicNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return DvTreeCacheLayer.access$obtainStuff((DvTreeCacheLayer)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNull((Object)stuff2);
        return stuff2;
    }

    private final NodeStuff peekStuff(BasicNode node2) {
        this.checkOptionsModification();
        NodeStuff stuff2 = DvTreeInternalFunKt.get(this.cache, node2);
        return stuff2;
    }

    private final NodeStuff obtainStuff(BasicNode node2) {
        List list;
        BasicNode parent2 = this.getBase().parentOf(node2);
        boolean alwaysLeaf = this.getBase().isAlwaysLeaf(node2);
        if (!alwaysLeaf) {
            List list2 = this.getBase().childrenOf(node2).toList();
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toList(...)");
        } else {
            list = CollectionsKt.emptyList();
        }
        List children2 = list;
        String presentableName = this.getBase().presentableNameOf(node2);
        return new NodeStuff(parent2, children2, alwaysLeaf, presentableName);
    }

    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return this.skip(node2) ? this.getBase().parentOf(node2) : this.getStuff(node2).getParent();
    }

    @Override
    @NotNull
    public JBIterable<? extends BasicNode> childrenOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return this.skip(node2) ? this.getBase().childrenOf(node2) : UtilKt.asJBIterable((Iterable)this.getStuff(node2).getChildren());
    }

    @Override
    public int countRealChildrenOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        if (this.skip(node2)) {
            return this.getBase().countRealChildrenOf(node2);
        }
        NodeStuff alreadyCachedStuff = this.peekStuff(node2);
        NodeStuff nodeStuff = alreadyCachedStuff;
        if (nodeStuff != null) {
            return ((Collection)nodeStuff.getChildren()).size();
        }
        if (this.toCacheCountSpecially(node2)) {
            Object object = this.specialCountCache.get((Object)node2, arg_0 -> DvTreeCacheLayer.countRealChildrenOf$lambda$1((Function1)new Function1<BasicNode, Integer>((Object)this.getBase()){

                @NotNull
                public final Integer invoke(@NotNull BasicNode p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((DvTreeLayer)this.receiver).countRealChildrenOf(p0);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return ((Number)object).intValue();
        }
        return this.getBase().countRealChildrenOf(node2);
    }

    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return this.skip(node2) ? this.getBase().isAlwaysLeaf(node2) : this.getStuff(node2).getAlwaysLeaf();
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        if (this.skip(node2)) {
            return this.getBase().presentableNameOf(node2);
        }
        NodeStuff cachedStuff = this.peekStuff(node2);
        if (cachedStuff != null) {
            return cachedStuff.getPresentableName();
        }
        return this.getBase().presentableNameOf(node2);
    }

    private final boolean skip(BasicNode node2) {
        return !this.cacheEnabled || this.skipDataSources && node2 instanceof DataSourceNode;
    }

    private final boolean toCacheCountSpecially(BasicNode node2) {
        return node2 instanceof DataSourceNode || node2 instanceof BasicNamespace || node2 instanceof HostFamily && ((HostFamily)node2).getHost() instanceof BasicSchema || node2 instanceof DvHostNode && ((DvHostNode)node2).host instanceof BasicSchema;
    }

    private final void checkOptionsModification() {
        long mc = this.getVo().getModificationCount();
        if (mc != this.knownModificationCount) {
            this.clearCache();
            this.knownModificationCount = mc;
        }
    }

    @Override
    public void onDataSourceAdded$intellij_database_core_impl(@NotNull RawDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        if (this.alwaysInvalidateAll) {
            this.clearCache();
            return;
        }
        DvTreeInternalFunKt.invalidateThat(this.cache, onDataSourceAdded.1.INSTANCE);
    }

    @Override
    public void onDataSourcePathChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        if (this.alwaysInvalidateAll) {
            this.clearCache();
            return;
        }
        DvTreeInternalFunKt.invalidateThat(this.cache, onDataSourcePathChanged.1.INSTANCE);
    }

    @Override
    public void onDataSourceModelReplaced$intellij_database_core_impl(@NotNull RawDataSource dataSource2, @Nullable BasicModel oldModel, @Nullable BasicModel newModel) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        if (this.alwaysInvalidateAll) {
            this.clearCache();
            return;
        }
        DvTreeInternalFunKt.invalidateThat(this.cache, (Function1)new Function1<BasicNode, Boolean>(dataSource2, this, oldModel, newModel){
            final /* synthetic */ RawDataSource $dataSource;
            final /* synthetic */ DvTreeCacheLayer this$0;
            final /* synthetic */ BasicModel $oldModel;
            final /* synthetic */ BasicModel $newModel;
            {
                this.$dataSource = $dataSource;
                this.this$0 = $receiver;
                this.$oldModel = $oldModel;
                this.$newModel = $newModel;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull BasicNode it2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                if (it2 instanceof DataSourceNode) {
                    bl = Intrinsics.areEqual((Object)((DataSourceNode)it2).rawDataSource, (Object)this.$dataSource);
                } else {
                    void model1$iv;
                    void $this$inModel$iv;
                    DvTreeCacheLayer dvTreeCacheLayer = this.this$0;
                    BasicNode basicNode = it2;
                    BasicModel basicModel = this.$oldModel;
                    BasicModel model2$iv = this.$newModel;
                    boolean $i$f$inModel = false;
                    BasicModel m$iv = $this$inModel$iv.getModel();
                    bl = Intrinsics.areEqual((Object)m$iv, (Object)model1$iv) || Intrinsics.areEqual((Object)m$iv, (Object)model2$iv);
                }
                return bl;
            }
        });
        DvTreeInternalFunKt.invalidateThat(this.specialCountCache, (Function1)new Function1<BasicNode, Boolean>(dataSource2, this, oldModel, newModel){
            final /* synthetic */ RawDataSource $dataSource;
            final /* synthetic */ DvTreeCacheLayer this$0;
            final /* synthetic */ BasicModel $oldModel;
            final /* synthetic */ BasicModel $newModel;
            {
                this.$dataSource = $dataSource;
                this.this$0 = $receiver;
                this.$oldModel = $oldModel;
                this.$newModel = $newModel;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull BasicNode it2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                if (it2 instanceof DataSourceNode) {
                    bl = Intrinsics.areEqual((Object)((DataSourceNode)it2).rawDataSource, (Object)this.$dataSource);
                } else {
                    void model1$iv;
                    void $this$inModel$iv;
                    DvTreeCacheLayer dvTreeCacheLayer = this.this$0;
                    BasicNode basicNode = it2;
                    BasicModel basicModel = this.$oldModel;
                    BasicModel model2$iv = this.$newModel;
                    boolean $i$f$inModel = false;
                    BasicModel m$iv = $this$inModel$iv.getModel();
                    bl = Intrinsics.areEqual((Object)m$iv, (Object)model1$iv) || Intrinsics.areEqual((Object)m$iv, (Object)model2$iv);
                }
                return bl;
            }
        });
    }

    private final boolean inModel(BasicNode $this$inModel, BasicModel model1, BasicModel model2) {
        boolean $i$f$inModel = false;
        BasicModel m = $this$inModel.getModel();
        return Intrinsics.areEqual((Object)m, (Object)model1) || Intrinsics.areEqual((Object)m, (Object)model2);
    }

    @Override
    public void onDataSourceChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource2) {
        BasicModel model2;
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        if (this.alwaysInvalidateAll) {
            this.clearCache();
            return;
        }
        DasModel dasModel = dataSource2.getModel();
        BasicModel basicModel = model2 = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
        if (model2 != null) {
            DvTreeInternalFunKt.invalidateThat(this.cache, (Function1)new Function1<BasicNode, Boolean>(dataSource2, model2){
                final /* synthetic */ RawDataSource $dataSource;
                final /* synthetic */ BasicModel $model;
                {
                    this.$dataSource = $dataSource;
                    this.$model = $model;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull BasicNode it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    return it2 instanceof DataSourceNode ? Intrinsics.areEqual((Object)((DataSourceNode)it2).rawDataSource, (Object)this.$dataSource) : Intrinsics.areEqual((Object)it2.getModel(), (Object)this.$model);
                }
            });
            DvTreeInternalFunKt.invalidateThat(this.specialCountCache, (Function1)new Function1<BasicNode, Boolean>(dataSource2, model2){
                final /* synthetic */ RawDataSource $dataSource;
                final /* synthetic */ BasicModel $model;
                {
                    this.$dataSource = $dataSource;
                    this.$model = $model;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull BasicNode it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    return it2 instanceof DataSourceNode ? Intrinsics.areEqual((Object)((DataSourceNode)it2).rawDataSource, (Object)this.$dataSource) : Intrinsics.areEqual((Object)it2.getModel(), (Object)this.$model);
                }
            });
        } else {
            DvTreeInternalFunKt.invalidateThat(this.cache, (Function1)new Function1<BasicNode, Boolean>(dataSource2){
                final /* synthetic */ RawDataSource $dataSource;
                {
                    this.$dataSource = $dataSource;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull BasicNode it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    return it2 instanceof DataSourceNode && Intrinsics.areEqual((Object)((DataSourceNode)it2).rawDataSource, (Object)this.$dataSource);
                }
            });
            DvTreeInternalFunKt.invalidateThat(this.specialCountCache, (Function1)new Function1<BasicNode, Boolean>(dataSource2){
                final /* synthetic */ RawDataSource $dataSource;
                {
                    this.$dataSource = $dataSource;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull BasicNode it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    return it2 instanceof DataSourceNode && Intrinsics.areEqual((Object)((DataSourceNode)it2).rawDataSource, (Object)this.$dataSource);
                }
            });
        }
    }

    @Override
    public void onDataSourceRemoved$intellij_database_core_impl(@NotNull RawDataSource dataSource2, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.clearCache();
    }

    @Override
    public void onViewOptionsChanged$intellij_database_core_impl() {
        this.clearCache();
    }

    private final void clearCache() {
        this.cache.invalidateAll();
        this.specialCountCache.invalidateAll();
    }

    @Override
    public void clearAll() {
        this.clearCache();
    }

    private static final NodeStuff getStuff$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (NodeStuff)$tmp0.invoke(p0);
    }

    private static final Integer countRealChildrenOf$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ NodeStuff access$obtainStuff(DvTreeCacheLayer $this, BasicNode node2) {
        return $this.obtainStuff(node2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/view/structure/DvTreeCacheLayer$NodeStuff;", "", "parent", "Lcom/intellij/database/model/basic/BasicNode;", "children", "", "alwaysLeaf", "", "presentableName", "", "(Lcom/intellij/database/model/basic/BasicNode;Ljava/util/List;ZLjava/lang/String;)V", "getAlwaysLeaf", "()Z", "getChildren", "()Ljava/util/List;", "getParent", "()Lcom/intellij/database/model/basic/BasicNode;", "getPresentableName", "()Ljava/lang/String;", "intellij.database.core.impl"})
    private static final class NodeStuff {
        @Nullable
        private final BasicNode parent;
        @NotNull
        private final List<BasicNode> children;
        private final boolean alwaysLeaf;
        @NotNull
        private final String presentableName;

        public NodeStuff(@Nullable BasicNode parent2, @NotNull List<? extends BasicNode> children2, boolean alwaysLeaf, @NotNull String presentableName) {
            Intrinsics.checkNotNullParameter(children2, (String)"children");
            Intrinsics.checkNotNullParameter((Object)presentableName, (String)"presentableName");
            this.parent = parent2;
            this.children = children2;
            this.alwaysLeaf = alwaysLeaf;
            this.presentableName = presentableName;
        }

        @Nullable
        public final BasicNode getParent() {
            return this.parent;
        }

        @NotNull
        public final List<BasicNode> getChildren() {
            return this.children;
        }

        public final boolean getAlwaysLeaf() {
            return this.alwaysLeaf;
        }

        @NotNull
        public final String getPresentableName() {
            return this.presentableName;
        }
    }
}

