/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001c*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001cB\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\tJ\u001a\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u0016J\u0013\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u001a\u001a\u00020\u0014J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0002R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/view/structure/CollectionCache;", "E", "", "gather", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "content", "Ljava/util/concurrent/atomic/AtomicReference;", "", "<set-?>", "", "populationsCount", "getPopulationsCount", "()I", "ready", "", "getReady", "()Z", "exclude", "", "predicate", "Lkotlin/Function1;", "element", "(Ljava/lang/Object;)V", "include", "invalidate", "populate", "Companion", "intellij.database.core.impl"})
public final class CollectionCache<E> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Iterable<E>> gather;
    @NotNull
    private final AtomicReference<Collection<E>> content;
    private transient int populationsCount;

    public CollectionCache(@NotNull Function0<? extends Iterable<? extends E>> gather) {
        Intrinsics.checkNotNullParameter(gather, (String)"gather");
        this.gather = gather;
        this.content = new AtomicReference<Object>(null);
    }

    public final int getPopulationsCount() {
        return this.populationsCount;
    }

    public final boolean getReady() {
        return this.content.get() != null;
    }

    @NotNull
    public final Collection<E> content() {
        Collection<E> theContent = this.content.get();
        if (theContent == null) {
            theContent = this.populate();
        }
        return theContent;
    }

    public final void include(E element2) {
        this.content.updateAndGet(arg_0 -> CollectionCache.include$lambda$0(element2, arg_0));
    }

    public final void exclude(E element2) {
        this.content.updateAndGet(arg_0 -> CollectionCache.exclude$lambda$1(element2, arg_0));
    }

    public final void exclude(@NotNull Function1<? super E, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        this.content.updateAndGet(arg_0 -> CollectionCache.exclude$lambda$2(predicate, arg_0));
    }

    public final void invalidate() {
        this.content.set(null);
    }

    private final Collection<E> populate() {
        List list = CollectionsKt.toList((Iterable)((Iterable)this.gather.invoke()));
        this.content.set(list);
        int n = this.populationsCount;
        this.populationsCount = n + 1;
        return list;
    }

    private static final Collection include$lambda$0(Object $element, Collection oldContent) {
        return Companion.includeElement(oldContent, $element);
    }

    private static final Collection exclude$lambda$1(Object $element, Collection oldContent) {
        return Companion.excludeElement(oldContent, $element);
    }

    private static final Collection exclude$lambda$2(Function1 $predicate, Collection oldContent) {
        Intrinsics.checkNotNullParameter((Object)$predicate, (String)"$predicate");
        return Companion.excludeElements(oldContent, $predicate);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u0004\"\u0004\b\u0001\u0010\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\bJ8\u0010\t\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u0004\"\u0004\b\u0001\u0010\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\f0\u000bJ1\u0010\r\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u0004\"\u0004\b\u0001\u0010\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/view/structure/CollectionCache$Companion;", "", "()V", "excludeElement", "", "E", "collection", "element", "(Ljava/util/Collection;Ljava/lang/Object;)Ljava/util/Collection;", "excludeElements", "predicate", "Lkotlin/Function1;", "", "includeElement", "intellij.database.core.impl"})
    private static final class Companion {
        private Companion() {
        }

        @Nullable
        public final <E> Collection<E> includeElement(@Nullable Collection<? extends E> collection2, E element2) {
            if (collection2 == null) {
                return null;
            }
            if (collection2.contains(element2)) {
                return collection2;
            }
            return collection2.isEmpty() ? (Collection)Collections.singleton(element2) : (Collection)CollectionsKt.plus(collection2, element2);
        }

        @Nullable
        public final <E> Collection<E> excludeElement(@Nullable Collection<? extends E> collection2, E element2) {
            if (collection2 == null || collection2.isEmpty()) {
                return collection2;
            }
            return collection2.contains(element2) ? (Collection)CollectionsKt.minus((Iterable)collection2, element2) : collection2;
        }

        @Nullable
        public final <E> Collection<E> excludeElements(@Nullable Collection<? extends E> collection2, @NotNull Function1<? super E, Boolean> predicate) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            if (collection2 == null || collection2.isEmpty()) {
                return collection2;
            }
            Set elementsToExclude = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection2), predicate));
            if (elementsToExclude.isEmpty()) {
                return collection2;
            }
            List result2 = CollectionsKt.minus((Iterable)collection2, (Iterable)elementsToExclude);
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

