/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShutSplitter
extends Splitter {
    @Nls
    private final String myText;
    private final String myKey;
    private boolean myShut;
    private float myOldProportion;
    private final JComponent mySecondWrapper;
    private JComponent mySecond;
    private JComponent mySecondFocus;
    private JComponent myLeadComp;
    private JComponent myTrailComp;

    public ShutSplitter(@Nls @NotNull String text2, @Nullable String key2, float defProportion) {
        if (text2 == null) {
            ShutSplitter.$$$reportNull$$$0(0);
        }
        super(true);
        this.myOldProportion = 0.7f;
        this.mySecondWrapper = new JPanel(new BorderLayout());
        this.myText = text2;
        this.myKey = key2;
        this.setDividerPositionStrategy(Splitter.DividerPositionStrategy.DISTRIBUTE);
        this.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_FIRST_MIN_SIZE);
        this.setHonorComponentsMinimumSize(true);
        this.setHonorComponentsPreferredSize(false);
        this.setUseViewportViewSizes(true);
        this.getDivider().updateData();
        this.loadState(defProportion);
        super.setSecondComponent(this.mySecondWrapper);
    }

    public void setSecondComponent(@Nullable JComponent component2) {
        this.mySecondWrapper.removeAll();
        this.mySecond = component2;
        if (component2 != null && !this.myShut) {
            this.mySecondWrapper.add((Component)component2, "Center");
        }
    }

    @NotNull
    private String getProportionKey() {
        String string = this.myKey + ".proportion";
        if (string == null) {
            ShutSplitter.$$$reportNull$$$0(1);
        }
        return string;
    }

    private void loadState(float defProportion) {
        boolean shut;
        float prop = this.myKey == null ? defProportion : PropertiesComponent.getInstance().getFloat(this.getProportionKey(), defProportion);
        boolean bl = shut = prop < 0.0f;
        if (shut) {
            prop = -prop;
        }
        this.setProportion(prop);
        this.myOldProportion = prop;
        this.setShut(shut);
    }

    private void saveState() {
        if (this.myKey == null) {
            return;
        }
        PropertiesComponent.getInstance().setValue(this.getProportionKey(), (float)(this.myShut ? -1 : 1) * this.myOldProportion, 0.7f);
    }

    protected Divider createDivider() {
        return new MyDividerImpl();
    }

    public MyDividerImpl getDivider() {
        return (MyDividerImpl)((Object)super.getDivider());
    }

    public int getDividerWidth() {
        return this.getDivider().getPreferredSize().height + JBUIScale.scale((int)10);
    }

    public void setShut(boolean shut) {
        if (this.myShut == shut) {
            return;
        }
        this.myShut = shut;
        this.getDivider().updateData();
        this.setProportion(shut ? 1.0f : this.myOldProportion);
        this.setResizeEnabled(!shut);
        this.mySecondWrapper.setMinimumSize(shut ? new Dimension(0, 0) : null);
        if (this.mySecond != null) {
            if (!this.myShut) {
                this.mySecondWrapper.add((Component)this.mySecond, "Center");
                this.getDivider().mySeparator.setLabelFor((Component)this.mySecondFocus);
            } else {
                this.mySecondWrapper.remove(this.mySecond);
                this.getDivider().mySeparator.setLabelFor(null);
            }
        }
    }

    public void setLeadWidget(@Nullable JComponent comp) {
        if (this.myLeadComp != null) {
            this.getDivider().myLeadPlaceholder.remove(this.myLeadComp);
        }
        this.myLeadComp = comp;
        if (this.myLeadComp != null) {
            this.getDivider().myLeadPlaceholder.add((Component)this.myLeadComp, "Center");
        }
    }

    public void setTrailWidget(@Nullable JComponent comp) {
        if (this.myTrailComp != null) {
            this.getDivider().myTrailPlaceholder.remove(this.myTrailComp);
        }
        this.myTrailComp = comp;
        if (this.myTrailComp != null) {
            this.getDivider().myTrailPlaceholder.add((Component)this.myTrailComp, "Center");
        }
    }

    public void setProportion(float proportion) {
        super.setProportion(proportion);
        if (!this.myShut) {
            this.myOldProportion = proportion;
        }
        this.saveState();
    }

    public void setTitleLabelFor(JComponent component2) {
        this.mySecondFocus = component2;
        if (!this.myShut) {
            this.getDivider().myIcon.setLabelFor((Component)component2);
        }
    }

    public boolean isShut() {
        return this.myShut;
    }

    public void setDividerToolTipText(@NlsContexts.Tooltip String tooltip) {
        this.getDivider().setToolTipText(tooltip);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/ShutSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/ShutSplitter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProportionKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private class MyDividerImpl
    extends Splitter.DividerImpl {
        private TitledSeparator mySeparator;
        private JBLabel myIcon;
        private JComponent myLeadPlaceholder;
        private JComponent myTrailPlaceholder;

        private MyDividerImpl() {
            super((Splitter)ShutSplitter.this);
        }

        public void setOrientation(boolean isVerticalSplit) {
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.myLeadPlaceholder = new JPanel(new BorderLayout());
            this.myTrailPlaceholder = new JPanel(new BorderLayout());
            if (ShutSplitter.this.myLeadComp != null) {
                this.myLeadPlaceholder.add((Component)ShutSplitter.this.myLeadComp, "Center");
            }
            if (ShutSplitter.this.myTrailComp != null) {
                this.myTrailPlaceholder.add((Component)ShutSplitter.this.myTrailComp, "Center");
            }
            this.myIcon = new JBLabel(this.getIcon());
            this.myLeadPlaceholder.add((Component)this.myIcon, "West");
            this.add(this.myLeadPlaceholder, "West");
            this.add(Box.createVerticalStrut(JBUIScale.scale((int)5)), "North");
            this.myIcon.setFont(UIUtil.getTitledBorderFont());
            this.myIcon.setText(UIUtil.replaceMnemonicAmpersand((String)ShutSplitter.this.myText));
            this.mySeparator = new TitledSeparator();
            this.add((Component)this.mySeparator, "Center");
            this.add(this.myTrailPlaceholder, "East");
            this.mySeparator.getLabel().setCursor(Cursor.getPredefinedCursor(12));
            this.setInnerCursor(ShutSplitter.this.isVertical() ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(10));
            this.revalidate();
            this.repaint();
        }

        private void setInnerCursor(Cursor cursor2) {
            this.mySeparator.setCursor(cursor2);
            this.myIcon.setCursor(cursor2);
        }

        public void updateData() {
            this.myIcon.setIcon(this.getIcon());
            this.myIcon.setText(UIUtil.replaceMnemonicAmpersand((String)ShutSplitter.this.myText));
            ShutSplitter.this.getDivider().mySeparator.revalidate();
            ShutSplitter.this.getDivider().mySeparator.repaint();
        }

        protected void processMouseEvent(MouseEvent e2) {
            if (e2.getID() == 500) {
                if (e2.getClickCount() == 2) {
                    return;
                }
                if (!(e2.getClickCount() != 1 || !SwingUtilities.isLeftMouseButton(e2) || e2.isAltDown() || e2.isControlDown() || e2.isMetaDown() || e2.isShiftDown())) {
                    ShutSplitter.this.setShut(!ShutSplitter.this.myShut);
                }
            }
            super.processMouseEvent(e2);
        }

        public void setResizeEnabled(boolean resizeEnabled) {
            super.setResizeEnabled(resizeEnabled);
            if (!resizeEnabled) {
                this.setInnerCursor(Cursor.getPredefinedCursor(12));
            }
        }

        private Icon getIcon() {
            return ShutSplitter.this.myShut ? AllIcons.General.ArrowUp : AllIcons.General.ArrowDown;
        }
    }
}

