/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlPreviewBase {
    private final JPanel myPanel;
    protected EditorTextField myPreview;
    protected DatabaseEditorContext myPreviousContext;
    private Runnable myListener;
    private DocumentListener myWrappedListener;

    public DdlPreviewBase(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            DdlPreviewBase.$$$reportNull$$$0(0);
        }
        this.myPanel = new JPanel(new BorderLayout());
        this.myPreviousContext = context;
        this.updatePreview(context);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DdlPreviewBase.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myPreview.getFocusTarget();
        if (jComponent == null) {
            DdlPreviewBase.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    public void addDocumentListener(@NotNull Runnable listener2, @NotNull Disposable parent2) {
        if (listener2 == null) {
            DdlPreviewBase.$$$reportNull$$$0(3);
        }
        if (parent2 == null) {
            DdlPreviewBase.$$$reportNull$$$0(4);
        }
        assert (this.myListener == null);
        this.myListener = listener2;
        this.myWrappedListener = DdlPreviewBase.wrapListener(this.myListener);
        this.myPreview.addDocumentListener(this.myWrappedListener);
        Disposer.register((Disposable)parent2, () -> this.myPreview.removeDocumentListener(this.myWrappedListener));
    }

    @NotNull
    private static DocumentListener wrapListener(final @NotNull Runnable listener2) {
        if (listener2 == null) {
            DdlPreviewBase.$$$reportNull$$$0(5);
        }
        return new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                listener2.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/view/editors/DdlPreviewBase$1", "documentChanged"));
            }
        };
    }

    public void updatePreview(@NotNull String statement2, @Nullable DatabaseEditorContext context) {
        if (statement2 == null) {
            DdlPreviewBase.$$$reportNull$$$0(6);
        }
        if (context != null && context != this.myPreviousContext) {
            this.updatePreview(context);
            this.myPreviousContext = context;
        }
        this.myPreview.setText(statement2);
        this.scrollToBeginning();
    }

    private void updatePreview(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            DdlPreviewBase.$$$reportNull$$$0(7);
        }
        if (this.myPreview != null && this.myWrappedListener != null) {
            this.myPreview.removeDocumentListener(this.myWrappedListener);
        }
        this.myPreview = DatabaseDialogsHelper.createLanguageEditorArea(context, context.getSearchPath(), "");
        if (this.myListener != null) {
            this.myPreview.addDocumentListener(this.myWrappedListener);
            this.myListener.run();
        }
        this.myPreview.setPreferredSize((Dimension)JBUI.size((int)120, (int)120));
        this.myPanel.removeAll();
        this.myPanel.add((Component)this.myPreview);
    }

    protected void scrollToBeginning() {
        Editor editor2 = this.myPreview.getEditor();
        if (editor2 != null) {
            editor2.getScrollingModel().scrollVertically(0);
            editor2.getCaretModel().moveToOffset(0);
        }
    }

    @NotNull
    public String getPreviewText() {
        String string = this.myPreview.getText();
        if (string == null) {
            DdlPreviewBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DdlPreviewBase";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DdlPreviewBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviewText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrapListener";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 8 -> new IllegalStateException(string);
        };
    }
}

