/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DdlPreviewBase;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.EditorTextField;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlPreview
extends DdlPreviewBase {
    public static final Condition<DeObject> LIGHT_EXPORTED = object -> object.lightExported;

    @NotNull
    public static JBIterable<ObjectAction> basicTraversal(@NotNull DeModel model2) {
        if (model2 == null) {
            DdlPreview.$$$reportNull$$$0(0);
        }
        JBIterable jBIterable = ((JBTreeTraverser)model2.traverser().expandAndSkip(LIGHT_EXPORTED)).bfsTraversal().filter(DeObject.class).transform(object -> new ObjectAction(object.hasEdited() ? ObjectAction.Action.ALTER : ObjectAction.Action.CREATE, (DeObject)object));
        if (jBIterable == null) {
            DdlPreview.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    public DdlPreview(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            DdlPreview.$$$reportNull$$$0(2);
        }
        super(context);
    }

    public boolean updatePreview(@Nullable ModelTraverser traverser2) {
        return this.updatePreview(traverser2, null);
    }

    public boolean updatePreview(@Nullable ModelTraverser traverser2, @Nullable DatabaseEditorContext context) {
        if (traverser2 != null) {
            ScriptingResult res2 = traverser2.generate();
            this.updatePreview(res2.getScriptText(), context);
            for (CompositeText.Fragment f : res2.getScript().getFragments()) {
                if (f.getError() == null) continue;
                return false;
            }
            return true;
        }
        this.myPreview.setText("-- No editor");
        this.scrollToBeginning();
        return false;
    }

    @NotNull
    public EditorTextField getTextField() {
        EditorTextField editorTextField2 = this.myPreview;
        if (editorTextField2 == null) {
            DdlPreview.$$$reportNull$$$0(3);
        }
        return editorTextField2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DdlPreview";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DdlPreview";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "basicTraversal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "basicTraversal";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    public static class ModelTraverser {
        public final DeModel model;

        public ModelTraverser(DeModel model2) {
            this.model = model2;
        }

        @NotNull
        public ScriptingResult generate() {
            return new ScriptingResult(){

                @Override
                public String @NotNull [] getScriptStatementsTexts() {
                    String[] stringArray = new String[]{this.getScriptText()};
                    if (stringArray == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return stringArray;
                }

                @Override
                @NotNull
                public List<CompositeText> getScriptStatements() {
                    List<CompositeText> list = List.of(this.getScript());
                    if (list == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return list;
                }

                @Override
                @NotNull
                public String getScriptText() {
                    return "-- fail";
                }

                @Override
                @NotNull
                public CompositeText getScript() {
                    return new SimpleCompositeText((CharSequence)this.getScriptText(), CompositeText.Kind.COMMENT);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/database/view/editors/DdlPreview$ModelTraverser$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getScriptStatementsTexts";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getScriptStatements";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }

        @NotNull
        public JBIterable<ObjectAction> traverse() {
            JBIterable<ObjectAction> jBIterable = DdlPreview.basicTraversal(this.model);
            if (jBIterable == null) {
                ModelTraverser.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }

        public void setOptions(@NotNull ScriptingOptions options2) {
            if (options2 == null) {
                ModelTraverser.$$$reportNull$$$0(1);
            }
        }

        @Nullable
        public ScriptingTask getTask() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DdlPreview$ModelTraverser";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "traverse";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DdlPreview$ModelTraverser";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setOptions";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class ObjectAction {
        public final Action action;
        public final DeObject object;

        public ObjectAction(Action action, DeObject object) {
            this.action = action;
            this.object = object;
        }

        public static enum Action {
            CREATE,
            ALTER,
            DROP;

        }
    }
}

