/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseObjectRefEditor;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import icons.DatabaseIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableRefEditor {
    private final DeModel myModel;
    private final DeObject myContextNamespace;
    @Nullable
    private final BasicModel myTargetModel;
    private final DatabaseObjectRefEditor<Object> myDelegate;
    private DeTable myStubCache;

    public DatabaseTableRefEditor(@NotNull DeModel model2, @Nullable DeObject contextNamespace, @NotNull DatabaseEditorContext context) {
        if (model2 == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(1);
        }
        this.myModel = model2;
        this.myContextNamespace = contextNamespace;
        this.myTargetModel = context.getModel();
        this.myDelegate = new DatabaseObjectRefEditor<Object>(context){

            @Override
            protected Icon getIcon(@NotNull Object item) {
                if (item == null) {
                    1.$$$reportNull$$$0(0);
                }
                return DatabaseIcons.Table;
            }

            @Override
            protected boolean allowQualification() {
                return true;
            }

            @Override
            @NotNull
            public List<String> getQName(@NotNull Object table) {
                if (table == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (table instanceof BasicTable) {
                    String sc2 = DasUtil.getSchema((BasicTable)table);
                    if (DatabaseTableRefEditor.this.myContextNamespace != null && !DatabaseTableRefEditor.this.myModel.getExportHelper().getContext().getNamingService().unquoteIdentifier(DatabaseTableRefEditor.this.myContextNamespace.name).equals(sc2)) {
                        List<String> list = Arrays.asList(sc2, ((BasicTable)table).getName());
                        if (list == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return list;
                    }
                }
                List<String> list = super.getQName(table);
                if (list == null) {
                    1.$$$reportNull$$$0(3);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "table";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableRefEditor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableRefEditor$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getQName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getIcon";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getQName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        };
        JBIterable objects2 = JBIterable.empty();
        objects2 = this.myTargetModel == null ? JBIterable.empty() : objects2.append((Iterable)this.myTargetModel.traverser().filter(BasicTable.class).filter(DasUtil.byKind(ObjectKind.TABLE))).append((Iterable)this.myModel.traverser().filter(DeTable.class).filter(o2 -> o2.getEditedBasic() == null || !o2.getEditedBasic().getName().equals(o2.name)));
        this.myDelegate.setItems((JBIterable<Object>)objects2);
    }

    @NotNull
    public EditorTextField getEditor() {
        EditorTextField editorTextField2 = this.myDelegate.getEditor();
        if (editorTextField2 == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(2);
        }
        return editorTextField2;
    }

    @NotNull
    public String getName() {
        String string = this.myDelegate.getName();
        if (string == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public DeTable getObject() {
        Object object = this.myDelegate.getObject();
        if (object == null) {
            return null;
        }
        if (object instanceof DeTable) {
            return (DeTable)object;
        }
        BasicTable res2 = (BasicTable)object;
        return (DeTable)this.myModel.getExportHelper().exportDeep(this.myTargetModel, res2, true);
    }

    public void setObject(@Nullable DeTable obj2) {
        if (obj2 == null) {
            this.myDelegate.setObject((String)null);
        } else if (this.getObjectOrStub((DeNamespace)ObjectUtils.tryCast((Object)obj2.parent, DeNamespace.class)) != obj2) {
            if (this.myContextNamespace == null || obj2.parent == this.myContextNamespace || obj2.parent == null) {
                this.myDelegate.setObject(obj2.name);
            } else {
                this.myDelegate.setObject(Arrays.asList(obj2.parent.name, obj2.name));
            }
        }
    }

    @NotNull
    public DeTable getObjectOrStub(@Nullable DeNamespace parent2) {
        DeTable res2 = this.getObject();
        if (res2 == null) {
            List<String> qname = this.myDelegate.getQName();
            if (this.myStubCache == null || !DatabaseTableRefEditor.matches(this.myStubCache, qname, qname.size() - 1)) {
                this.myStubCache = DatabaseTableRefEditor.createStub(qname, parent2, this.myModel);
            }
            res2 = this.myStubCache;
        }
        DeTable deTable = res2;
        if (deTable == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(4);
        }
        return deTable;
    }

    private static boolean matches(DeObject obj2, List<String> qname, int i2) {
        if (i2 < 0) {
            return true;
        }
        if (obj2 == null) {
            return false;
        }
        if (!obj2.name.equals(qname.get(i2))) {
            return false;
        }
        return DatabaseTableRefEditor.matches(obj2.getParent(), qname, i2 - 1);
    }

    @NotNull
    public static DeTable createStub(@NotNull List<String> qname, @Nullable DeNamespace parent2, @NotNull DeModel model2) {
        if (qname == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(5);
        }
        if (model2 == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(6);
        }
        parent2 = DatabaseTableRefEditor.getStubParent(qname, parent2, model2);
        DeTable deTable = EditorModelUtil.setStub(new DeTable(qname.get(qname.size() - 1), parent2, model2));
        if (deTable == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(7);
        }
        return deTable;
    }

    private static DeNamespace getStubParent(List<String> qname, DeNamespace parent2, DeModel model2) {
        if (qname.size() < 2 || parent2 != null && parent2.name.equals(qname.get(qname.size() - 2))) {
            return parent2;
        }
        List<String> sc2 = qname.subList(0, qname.size() - 1);
        DeNamespace first2 = (DeNamespace)((JBTreeTraverser)model2.traverser().expand(o2 -> o2 instanceof DeNamespace)).filter(DeNamespace.class).filter(n -> DatabaseTableRefEditor.matches(n, sc2, sc2.size() - 1)).first();
        return first2 == null ? EditorModelUtil.setStub(new DeNamespace(qname.get(qname.size() - 1), ObjectKind.SCHEMA, model2)) : first2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableRefEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qname";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableRefEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectOrStub";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 7 -> new IllegalStateException(string);
        };
    }
}

