/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseObjectRefEditor<Das> {
    private final EditorTextField myEditor;
    private final DatabaseEditorContext myContext;
    private JBIterable<? extends Das> myItems;

    public DatabaseObjectRefEditor(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            DatabaseObjectRefEditor.$$$reportNull$$$0(0);
        }
        this.myItems = JBIterable.empty();
        this.myContext = context;
        this.myEditor = new TextFieldWithAutoCompletion(this.myContext.getProject(), (TextFieldWithAutoCompletionListProvider)new MyCompletionProvider(), false, "");
        this.myEditor.addSettingsProvider(editor2 -> {
            editor2.setHighlighter((EditorHighlighter)new EmptyEditorHighlighter(editor2.getColorsScheme(), HighlighterColors.TEXT));
            this.updateAdditionalHighlighting((Editor)editor2);
        });
    }

    public void setItems(@NotNull JBIterable<? extends Das> items2) {
        if (items2 == null) {
            DatabaseObjectRefEditor.$$$reportNull$$$0(1);
        }
        this.myItems = items2;
    }

    @NotNull
    public EditorTextField getEditor() {
        EditorTextField editorTextField2 = this.myEditor;
        if (editorTextField2 == null) {
            DatabaseObjectRefEditor.$$$reportNull$$$0(2);
        }
        return editorTextField2;
    }

    @NotNull
    public List<String> getQName(@NotNull Das das) {
        if (das == null) {
            DatabaseObjectRefEditor.$$$reportNull$$$0(3);
        }
        List<String> list = Collections.singletonList(DatabaseObjectRefEditor.getName(das));
        if (list == null) {
            DatabaseObjectRefEditor.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<String> getQName() {
        ParserDefinition definition2;
        String text2 = this.myEditor.getText();
        ParserDefinition parserDefinition = definition2 = this.allowQualification() && text2.contains(".") ? (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)this.myContext.getSqlDialect()) : null;
        if (definition2 == null) {
            List<String> list = Collections.singletonList(this.unquote(text2));
            if (list == null) {
                DatabaseObjectRefEditor.$$$reportNull$$$0(5);
            }
            return list;
        }
        Lexer lexer = definition2.createLexer(this.myContext.getProject());
        lexer.start((CharSequence)text2);
        ArrayList<String> parts = new ArrayList<String>();
        while (lexer.getTokenType() != null) {
            if (lexer.getTokenType() != SqlCommonTokens.SQL_PERIOD) {
                parts.add(this.unquote(lexer.getTokenText()));
            }
            lexer.advance();
        }
        List<String> list = parts.isEmpty() ? Collections.singletonList(this.unquote(text2)) : parts;
        if (list == null) {
            DatabaseObjectRefEditor.$$$reportNull$$$0(6);
        }
        return list;
    }

    private String unquote(String n) {
        return this.myContext.getNamingService().unquoteIdentifier(n);
    }

    @NotNull
    public String getName() {
        String string = this.getQName().get(0);
        if (string == null) {
            DatabaseObjectRefEditor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public Das getObject() {
        return this.getObject(this.myItems);
    }

    @Nullable
    protected Das getObject(JBIterable<? extends Das> items2) {
        List<String> qname = this.getQName();
        CasingProvider provider = this.myContext.getCasingProvider();
        return (Das)items2.map(o2 -> o2).filter(o2 -> this.matchesAsWritten(o2, qname, provider)).append((Iterable)items2.filter(o2 -> DatabaseObjectRefEditor.matches(o2, qname, qname.size() - 1, provider, -1))).first();
    }

    private boolean matchesAsWritten(Das item, List<String> qname, CasingProvider provider) {
        return DatabaseObjectRefEditor.matches(item, qname, qname.size() - 1, provider, this.getQName(item).size());
    }

    private static boolean matches(Object item, List<String> qname, int i2, CasingProvider provider, int depth) {
        if (depth == 0) {
            return i2 < 0;
        }
        if (i2 < 0) {
            return false;
        }
        if (item == null) {
            return false;
        }
        return DatabaseObjectRefEditor.matches(item, qname.get(i2), provider) && DatabaseObjectRefEditor.matches(DatabaseObjectRefEditor.getParent(item), qname, i2 - 1, provider, depth - 1);
    }

    private static boolean matches(Object item, String name2, CasingProvider provider) {
        return item instanceof DeObject ? DbRenamePsiElementProcessor.nameEqual((DeObject)item, name2, provider) : DasUtil.nameEqual((DasObject)item, name2, provider);
    }

    @Nullable
    protected Icon getIcon(@NotNull Das item) {
        if (item == null) {
            DatabaseObjectRefEditor.$$$reportNull$$$0(8);
        }
        return null;
    }

    protected boolean allowQualification() {
        return false;
    }

    @NotNull
    protected static String getName(@Nullable Object item) {
        String string = item == null ? "" : (item instanceof DeObject ? ((DeObject)item).getName() : ((DasObject)item).getName());
        if (string == null) {
            DatabaseObjectRefEditor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    protected static Object getParent(@NotNull Object item) {
        if (item == null) {
            DatabaseObjectRefEditor.$$$reportNull$$$0(10);
        }
        return item instanceof DeObject ? ((DeObject)item).getParent() : ((DasObject)item).getDasParent();
    }

    public void setObject(@Nullable Das das) {
        this.setObject(das == null ? null : this.getQName(das));
    }

    public void setObject(@Nullable String objName) {
        this.setObject(objName == null ? null : Collections.singletonList(objName));
    }

    public void setObject(@Nullable List<String> objName) {
        List<Object> nn;
        List<Object> list = nn = objName == null ? Collections.emptyList() : objName;
        if (!this.allowQualification() && nn.size() > 1) {
            nn = nn.subList(0, 1);
        }
        if (!nn.equals(this.getQName())) {
            this.myEditor.setText(this.getText(nn));
        }
        this.updateAdditionalHighlighting(this.myEditor.getEditor());
    }

    @NotNull
    protected String getText(@NotNull List<String> nn) {
        if (nn == null) {
            DatabaseObjectRefEditor.$$$reportNull$$$0(11);
        }
        String string = StringUtil.join(nn, n -> this.myContext.getNamingService().catToScript((String)n, null), (String)".");
        if (string == null) {
            DatabaseObjectRefEditor.$$$reportNull$$$0(12);
        }
        return string;
    }

    protected void updateAdditionalHighlighting(@Nullable Editor editor2) {
        if (editor2 == null) {
            return;
        }
        editor2.getMarkupModel().removeAllHighlighters();
        if (this.getObject() == null) {
            editor2.getMarkupModel().addRangeHighlighter(CodeInsightColors.WARNINGS_ATTRIBUTES, 0, this.myEditor.getText().length(), 3000, HighlighterTargetArea.EXACT_RANGE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 7, 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseObjectRefEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "das";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseObjectRefEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQName";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setItems";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 7, 9, 12 -> new IllegalStateException(string);
        };
    }

    private class MyCompletionProvider
    extends TextFieldWithAutoCompletionListProvider<Das> {
        MyCompletionProvider() {
            super(Collections.emptyList());
        }

        public boolean isDumbAware() {
            return true;
        }

        @Nullable
        protected Icon getIcon(@NotNull Das item) {
            if (item == null) {
                MyCompletionProvider.$$$reportNull$$$0(0);
            }
            return DatabaseObjectRefEditor.this.getIcon(item);
        }

        @NotNull
        protected String getLookupString(@NotNull Das item) {
            if (item == null) {
                MyCompletionProvider.$$$reportNull$$$0(1);
            }
            String string = DatabaseObjectRefEditor.this.getText(DatabaseObjectRefEditor.this.getQName(item));
            if (string == null) {
                MyCompletionProvider.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public LookupElementBuilder createLookupBuilder(@NotNull Das item) {
            if (item == null) {
                MyCompletionProvider.$$$reportNull$$$0(3);
            }
            LookupElementBuilder lookupElementBuilder = super.createLookupBuilder(item).withLookupString(StringUtil.join(DatabaseObjectRefEditor.this.getQName(item), (String)"."));
            if (lookupElementBuilder == null) {
                MyCompletionProvider.$$$reportNull$$$0(4);
            }
            return lookupElementBuilder;
        }

        @Nullable
        protected String getTypeText(@NotNull Das item) {
            if (item == null) {
                MyCompletionProvider.$$$reportNull$$$0(5);
            }
            return DatabaseObjectRefEditor.getName(DatabaseObjectRefEditor.getParent(item));
        }

        public int compare(Das item1, Das item2) {
            return StringUtil.naturalCompare((String)DatabaseObjectRefEditor.getName(item1), (String)DatabaseObjectRefEditor.getName(item2));
        }

        @Nullable
        public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                MyCompletionProvider.$$$reportNull$$$0(6);
            }
            return new CamelHumpMatcher(prefix, false);
        }

        @NotNull
        public Collection<Das> getItems(String prefix, boolean cached, CompletionParameters parameters2) {
            if (cached) {
                List list = Collections.emptyList();
                if (list == null) {
                    MyCompletionProvider.$$$reportNull$$$0(7);
                }
                return list;
            }
            PrefixMatcher matcher = this.createPrefixMatcher(prefix);
            JBIterable items2 = DatabaseObjectRefEditor.this.myItems;
            if (matcher != null) {
                items2 = items2.filter(de -> matcher.prefixMatches(StringUtil.join(DatabaseObjectRefEditor.this.getQName(de), (String)".")));
            }
            ArrayList res2 = ContainerUtil.newArrayList(items2);
            res2.sort((o1, o2) -> StringUtil.naturalCompare((String)DatabaseObjectRefEditor.getName(o1), (String)DatabaseObjectRefEditor.getName(o2)));
            ArrayList arrayList = res2;
            if (arrayList == null) {
                MyCompletionProvider.$$$reportNull$$$0(8);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseObjectRefEditor$MyCompletionProvider";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseObjectRefEditor$MyCompletionProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLookupBuilder";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 8: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createLookupBuilder";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeText";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createPrefixMatcher";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4, 7, 8 -> new IllegalStateException(string);
            };
        }
    }
}

