/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.DynamicBundle;
import com.intellij.database.model.DasIndex;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.view.editors.DataGridEditorUtil;
import com.intellij.database.view.editors.DatabaseColumnRefEditor;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseIndexEditor;
import com.intellij.database.view.editors.EmbComboBox;
import com.intellij.database.view.models.IndexEditorModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DatabaseIndexColumnEditor
implements DataGridEditorUtil.EmbeddableEditor {
    private final DatabaseIndexEditor myIndexEditor;
    private final DatabaseEditorCapabilities.IndexColumnEditorCaps myCaps;
    private JPanel myPanel;
    private EditorTextField myColumnEditorComponent;
    private JComboBox<DasIndex.Sorting> mySorting;
    private final DatabaseColumnRefEditor myColumnEditor;

    public DatabaseIndexColumnEditor(@NotNull DatabaseIndexEditor indexEditor, @NotNull DatabaseEditorCapabilities.IndexColumnEditorCaps caps) {
        if (indexEditor == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(0);
        }
        if (caps == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(1);
        }
        this.myIndexEditor = indexEditor;
        this.myCaps = caps;
        this.myColumnEditor = new DatabaseColumnRefEditor(this.myIndexEditor.getContext()){

            @Override
            @NotNull
            protected String getText(@NotNull List<String> nn) {
                if (nn == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (nn.size() == 1 && ContainerUtil.find(DatabaseIndexColumnEditor.this.myIndexEditor.getTable().columns, c2 -> c2.name.equals(nn.get(0))) == null) {
                    String string = nn.get(0);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = super.getText(nn);
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Override
            protected void updateAdditionalHighlighting(@Nullable Editor editor2) {
                if (editor2 != null) {
                    editor2.getMarkupModel().removeAllHighlighters();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nn";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/editors/DatabaseIndexColumnEditor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/editors/DatabaseIndexColumnEditor$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getText";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
        this.$$$setupUI$$$();
        this.myColumnEditorComponent.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e2) {
                if (e2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!DatabaseIndexColumnEditor.this.myIndexEditor.myUpdating) {
                    ArrayList<DeIndex.Item> items2 = new ArrayList<DeIndex.Item>(DatabaseIndexColumnEditor.this.getIndexModel().getItems());
                    int index2 = DatabaseIndexColumnEditor.this.myIndexEditor.getIndex(DatabaseIndexColumnEditor.this);
                    DeColumn item = DatabaseIndexColumnEditor.this.getColumn();
                    items2.set(index2, new DeIndex.Item(item, ((DeIndex.Item)items2.get((int)index2)).sorting));
                    DatabaseIndexColumnEditor.this.getIndexModel().setItems(items2);
                    DatabaseIndexColumnEditor.this.getIndexModel().commit();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/editors/DatabaseIndexColumnEditor$2", "documentChanged"));
            }
        });
        this.mySorting.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (!DatabaseIndexColumnEditor.this.myIndexEditor.myUpdating) {
                    ArrayList<DeIndex.Item> items2 = new ArrayList<DeIndex.Item>(DatabaseIndexColumnEditor.this.getIndexModel().getItems());
                    int index2 = DatabaseIndexColumnEditor.this.myIndexEditor.getIndex(DatabaseIndexColumnEditor.this);
                    items2.set(index2, new DeIndex.Item(((DeIndex.Item)items2.get((int)index2)).column, (DasIndex.Sorting)((Object)e2.getItem())));
                    DatabaseIndexColumnEditor.this.getIndexModel().setItems(items2);
                    DatabaseIndexColumnEditor.this.getIndexModel().commit();
                }
            }
        });
        this.mySorting.setEnabled(this.myCaps.getSorting().isAvailable());
    }

    @NotNull
    public IndexEditorModel getIndexModel() {
        IndexEditorModel indexEditorModel = this.myIndexEditor.getIndexModel();
        if (indexEditorModel == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(2);
        }
        return indexEditorModel;
    }

    @NotNull
    public DeIndex.Item getItem() {
        DeIndex.Item item = this.myIndexEditor.getIndex().items.get(this.myIndexEditor.getIndex(this));
        if (item == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(3);
        }
        return item;
    }

    @NotNull
    public Iterable<Pair<String, TextAttributesKey>> getRowText() {
        String sorting = this.getSorting();
        DeColumn column2 = this.getColumn();
        Iterable<Pair<String, TextAttributesKey>> iterable = new DatabaseEditorUtil.ColoredFragmentsBuilder().append(column2.isInTable() ? this.myIndexEditor.getObjectName(column2) : column2.name).append((sorting.isEmpty() ? "" : " ") + sorting).build();
        if (iterable == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(4);
        }
        return iterable;
    }

    public boolean isObjectValid() {
        return true;
    }

    @NotNull
    public String getSorting() {
        Object item = this.mySorting.getSelectedItem();
        if (item == DasIndex.Sorting.ASCENDING) {
            return "ASC";
        }
        if (item == DasIndex.Sorting.DESCENDING) {
            return "DESC";
        }
        return "";
    }

    public boolean canDoAnything() {
        return true;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myColumnEditorComponent.getFocusTarget();
        if (jComponent == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    @NotNull
    public JComponent[] getFocusableComponents() {
        JComponent[] jComponentArray = new JComponent[]{this.myColumnEditorComponent.getFocusTarget(), this.mySorting};
        if (jComponentArray == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(7);
        }
        return jComponentArray;
    }

    @NotNull
    public DeColumn getColumn() {
        DeColumn deColumn = this.myColumnEditor.getObjectOrStub(this.myIndexEditor.getTable());
        if (deColumn == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(8);
        }
        return deColumn;
    }

    public void updateFromModel(int idx) {
        DeIndex.Item item = this.getIndexModel().getItems().get(idx);
        this.myColumnEditor.setTable(this.myIndexEditor.getTable());
        this.myColumnEditor.setObject(item.column == null ? null : item.column.name);
        this.mySorting.setSelectedItem((Object)item.sorting);
    }

    @TestOnly
    @NotNull
    public EditorTextField getColumnEditor() {
        EditorTextField editorTextField2 = this.myColumnEditorComponent;
        if (editorTextField2 == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(9);
        }
        return editorTextField2;
    }

    @TestOnly
    @NotNull
    public JComboBox getSortingEditor() {
        JComboBox<DasIndex.Sorting> jComboBox = this.mySorting;
        if (jComboBox == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(10);
        }
        return jComboBox;
    }

    private void createUIComponents() {
        this.myColumnEditorComponent = this.myColumnEditor.getEditor();
        this.mySorting = new EmbComboBox<DasIndex.Sorting>(new DefaultComboBoxModel<DasIndex.Sorting>(DasIndex.Sorting.values()));
        this.mySorting.setRenderer(EmbComboBox.ENUM_RENDERER);
    }

    @NotNull
    public DatabaseIndexEditor getIndexEditor() {
        DatabaseIndexEditor databaseIndexEditor = this.myIndexEditor;
        if (databaseIndexEditor == null) {
            DatabaseIndexColumnEditor.$$$reportNull$$$0(11);
        }
        return databaseIndexEditor;
    }

    public DatabaseEditorCapabilities.IndexColumnEditorCaps getCaps() {
        return this.myCaps;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseIndexColumnEditor.class).getString("DatabaseIndexColumnEditor.label.name"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField2 = this.myColumnEditorComponent;
        jPanel.add((Component)editorTextField2, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseIndexColumnEditor.class).getString("DatabaseIndexColumnEditor.label.sorting"));
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox<DasIndex.Sorting> jComboBox = this.mySorting;
        jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseIndexColumnEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseIndexColumnEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusableComponents";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumn";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnEditor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortingEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

