/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicMixinForeignKey;
import com.intellij.database.model.basic.BasicModConstraint;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseEditorCapabilities {
    @NotNull
    public static DbEditorCaps createFor(@NotNull Dbms dbms) {
        if (dbms == null) {
            DatabaseEditorCapabilities.$$$reportNull$$$0(0);
        }
        CapsHelper helper = new CapsHelper(dbms);
        BasicMetaObject schema2 = (BasicMetaObject)((BasicMetaModel)helper.model.getMetaModel()).findMetaObjects(ObjectKind.SCHEMA).first();
        assert (schema2 != null);
        BasicMetaObject<?> database = schema2.getParent();
        ScriptingCapabilities dbCaps = helper.caps(database);
        ScriptingCapabilities scCaps = helper.caps(schema2);
        Couple<TableEditorCaps> table = DatabaseEditorCapabilities.tableCapsFor(helper, BasicMetaUtils.findChild(schema2, ObjectKind.TABLE));
        return new DbEditorCaps(new ObjectEditorCaps(DatabaseEditorCapabilities.supported(dbCaps, (Function<ScriptingCapabilities, ScriptingCapabilities.VersionedCapability<Boolean>>)((Function)ScriptingCapabilities::getCreate)), DatabaseEditorCapabilities.supported(dbCaps, (Function<ScriptingCapabilities, ScriptingCapabilities.VersionedCapability<Boolean>>)((Function)ScriptingCapabilities::getComment))), new ObjectEditorCaps(DatabaseEditorCapabilities.supported(dbCaps, (Function<ScriptingCapabilities, ScriptingCapabilities.VersionedCapability<Boolean>>)((Function)ScriptingCapabilities::getRename)), DatabaseEditorCapabilities.supported(dbCaps, (Function<ScriptingCapabilities, ScriptingCapabilities.VersionedCapability<Boolean>>)((Function)ScriptingCapabilities::getAlterComment))), new ObjectEditorCaps(DatabaseEditorCapabilities.supported(scCaps, (Function<ScriptingCapabilities, ScriptingCapabilities.VersionedCapability<Boolean>>)((Function)ScriptingCapabilities::getCreate)), DatabaseEditorCapabilities.supported(scCaps, (Function<ScriptingCapabilities, ScriptingCapabilities.VersionedCapability<Boolean>>)((Function)ScriptingCapabilities::getComment))), new ObjectEditorCaps(DatabaseEditorCapabilities.supported(scCaps, (Function<ScriptingCapabilities, ScriptingCapabilities.VersionedCapability<Boolean>>)((Function)ScriptingCapabilities::getRename)), DatabaseEditorCapabilities.supported(scCaps, (Function<ScriptingCapabilities, ScriptingCapabilities.VersionedCapability<Boolean>>)((Function)ScriptingCapabilities::getAlterComment))), (TableEditorCaps)table.first, (TableEditorCaps)table.second);
    }

    private static Couple<TableEditorCaps> tableCapsFor(@NotNull CapsHelper helper, @Nullable BasicMetaObject<?> table) {
        if (helper == null) {
            DatabaseEditorCapabilities.$$$reportNull$$$0(1);
        }
        ScriptingCapabilities caps = helper.caps(table);
        BasicMetaObject idxMeta = BasicMetaUtils.findChild(table, ObjectKind.INDEX);
        BasicMetaObject keyMeta = BasicMetaUtils.findChild(table, ObjectKind.KEY);
        ScriptingCapabilities idxCaps = helper.caps(idxMeta);
        BasicModKey kk = (BasicModKey)helper.get(keyMeta);
        if (kk != null) {
            kk.setPrimary(false);
        }
        ScriptingCapabilities keyCaps = helper.caps(keyMeta);
        if (kk != null) {
            kk.setPrimary(true);
        }
        ScriptingCapabilities pkCaps = helper.caps(keyMeta);
        ScriptingCapabilities fkCaps = helper.caps(BasicMetaUtils.findChild(table, ObjectKind.FOREIGN_KEY));
        BasicMetaObject<BasicModElement> columnMeta = BasicMetaUtils.findChild(table, ObjectKind.COLUMN);
        ScriptingCapabilities colCaps = helper.caps(columnMeta);
        BasicMetaId autoIncId = DatabaseEditorCapabilities.getAutoIncId(columnMeta);
        ColumnEditorCaps newCol = new ColumnEditorCaps(DatabaseEditorCapabilities.canCreateWith(colCaps, BasicModNamedElement.NAME), DatabaseEditorCapabilities.canCreateWith(colCaps, BasicModNamedElement.COMMENT), DatabaseEditorCapabilities.canCreateWith(colCaps, BasicModTypedElement.STORED_TYPE), DatabaseEditorCapabilities.canCreateWith(colCaps, autoIncId), DatabaseEditorCapabilities.canCreateWith(colCaps, BasicModTypedElement.DEFAULT_EXPRESSION), DatabaseEditorCapabilities.canCreateWith(colCaps, BasicModTypedElement.NOT_NULL));
        ColumnEditorCaps col = new ColumnEditorCaps(DatabaseEditorCapabilities.canAlter(colCaps, BasicModNamedElement.NAME), DatabaseEditorCapabilities.canAlter(colCaps, BasicModNamedElement.COMMENT), DatabaseEditorCapabilities.canAlter(colCaps, BasicModTypedElement.STORED_TYPE), DatabaseEditorCapabilities.canAlter(colCaps, autoIncId), DatabaseEditorCapabilities.canAlter(colCaps, BasicModTypedElement.DEFAULT_EXPRESSION), DatabaseEditorCapabilities.canAlter(colCaps, BasicModTypedElement.NOT_NULL));
        KeyEditorCaps newKey = new KeyEditorCaps(DatabaseEditorCapabilities.canCreateWith(keyCaps, BasicModNamedElement.NAME), DatabaseEditorCapabilities.canCreateWith(keyCaps, BasicModNamedElement.COMMENT), new TableKeyColumnEditorCaps());
        KeyEditorCaps key2 = new KeyEditorCaps(DatabaseEditorCapabilities.canAlter(keyCaps, BasicModNamedElement.NAME), DatabaseEditorCapabilities.canAlter(keyCaps, BasicModNamedElement.COMMENT), new TableKeyColumnEditorCaps());
        IndexEditorCaps newIdx = new IndexEditorCaps(DatabaseEditorCapabilities.canCreateWith(idxCaps, BasicModNamedElement.NAME), DatabaseEditorCapabilities.canCreateWith(idxCaps, BasicModNamedElement.COMMENT), DatabaseEditorCapabilities.canCreateWith(idxCaps, BasicModIndex.UNIQUE), new IndexColumnEditorCaps(DatabaseEditorCapabilities.canCreateWith(idxCaps, BasicModIndex.REVERSE_COL_NAMES)));
        IndexEditorCaps idx = new IndexEditorCaps(DatabaseEditorCapabilities.canAlter(idxCaps, BasicModNamedElement.NAME), DatabaseEditorCapabilities.canAlter(idxCaps, BasicModNamedElement.COMMENT), DatabaseEditorCapabilities.recreatable(idxCaps), new IndexColumnEditorCaps(DatabaseEditorCapabilities.recreatable(idxCaps)));
        boolean sqlite = helper.dialect.getDbms().isSqlite();
        ValuesCapability<DasForeignKey.Deferrability> deferrability = DatabaseEditorCapabilities.getDeferrability(fkCaps);
        ValuesCapability<DasForeignKey.RuleAction> updateRule = DatabaseEditorCapabilities.getRuleAction(fkCaps, BasicModForeignKey.ON_UPDATE);
        ValuesCapability<DasForeignKey.RuleAction> deleteRule = DatabaseEditorCapabilities.getRuleAction(fkCaps, BasicModForeignKey.ON_DELETE);
        ForeignKeyEditorCaps newFk = new ForeignKeyEditorCaps(sqlite ? Capability.AVAILABLE : DatabaseEditorCapabilities.canCreateWith(fkCaps, BasicModNamedElement.NAME), DatabaseEditorCapabilities.canCreateWith(fkCaps, BasicModNamedElement.COMMENT), deferrability, updateRule, deleteRule);
        ForeignKeyEditorCaps fk = new ForeignKeyEditorCaps(DatabaseEditorCapabilities.canAlter(fkCaps, BasicModNamedElement.NAME), DatabaseEditorCapabilities.canAlter(fkCaps, BasicModNamedElement.COMMENT), !sqlite && !DatabaseEditorCapabilities.isRecreatable(fkCaps) ? ValuesCapability.unsupported(DasForeignKey.Deferrability.class) : deferrability, !sqlite && !DatabaseEditorCapabilities.isRecreatable(fkCaps) ? ValuesCapability.unsupported(DasForeignKey.RuleAction.class) : updateRule, !sqlite && !DatabaseEditorCapabilities.isRecreatable(fkCaps) ? ValuesCapability.unsupported(DasForeignKey.RuleAction.class) : deleteRule);
        Grants.Controller<?, ?> grantCtl = ModelFacade.forDbms(helper.model.getDbms()).getModelHelper().getGrantController();
        return Couple.of((Object)new TableEditorCaps(DatabaseEditorCapabilities.canCreateWith(caps, BasicModNamedElement.NAME), DatabaseEditorCapabilities.canCreateWith(caps, BasicModNamedElement.COMMENT), ListCapability.get(colCaps != null, true, DatabaseEditorCapabilities.canCreate(colCaps), true), ListCapability.get(idxCaps != null, false, DatabaseEditorCapabilities.canCreate(idxCaps), true), ListCapability.get(fkCaps != null, false, sqlite || DatabaseEditorCapabilities.canCreate(fkCaps), true), ListCapability.get(pkCaps != null, false, DatabaseEditorCapabilities.canCreate(pkCaps), true), ListCapability.get(keyCaps != null, false, DatabaseEditorCapabilities.canCreate(keyCaps), true), ListCapability.unsupported(), newCol, newCol, newKey, newKey, newIdx, newIdx, newFk, newFk, Capability.supported(grantCtl != null)), (Object)new TableEditorCaps(DatabaseEditorCapabilities.canAlter(caps, BasicModNamedElement.NAME), DatabaseEditorCapabilities.canAlter(caps, BasicModNamedElement.COMMENT), ListCapability.get(colCaps != null, DatabaseEditorCapabilities.can(colCaps, (Function<ScriptingCapabilities, ScriptingCapabilities.VersionedCapability<Boolean>>)((Function)ScriptingCapabilities::getAlterOrder)), DatabaseEditorCapabilities.canCreate(colCaps), sqlite || DatabaseEditorCapabilities.canDrop(colCaps)), ListCapability.get(idxCaps != null, false, DatabaseEditorCapabilities.canCreate(idxCaps), sqlite || DatabaseEditorCapabilities.canDrop(idxCaps)), ListCapability.get(fkCaps != null, false, sqlite || DatabaseEditorCapabilities.canCreate(fkCaps), sqlite || DatabaseEditorCapabilities.canDrop(fkCaps)), ListCapability.get(pkCaps != null, false, DatabaseEditorCapabilities.canCreate(pkCaps), sqlite || DatabaseEditorCapabilities.canDrop(pkCaps)), ListCapability.get(keyCaps != null, false, DatabaseEditorCapabilities.canCreate(keyCaps), sqlite || DatabaseEditorCapabilities.canDrop(keyCaps)), ListCapability.unsupported(), newCol, col, newKey, key2, newIdx, idx, newFk, fk, Capability.supported(grantCtl != null)));
    }

    private static BasicMetaId getAutoIncId(BasicMetaObject<BasicModElement> columnMeta) {
        if (columnMeta != null) {
            BasicMetaProperty<BasicModElement, Serializable> prop = columnMeta.getObjectProperty(BasicModTableColumn.SEQUENCE_IDENTITY);
            if (prop != null && !prop.isAbstract()) {
                return BasicModTableColumn.SEQUENCE_IDENTITY;
            }
            prop = columnMeta.getObjectProperty(BasicModTableColumn.AUTO_INC);
            if (prop != null && !prop.isAbstract()) {
                return BasicModTableColumn.AUTO_INC;
            }
            BasicMetaProperty seqRef = (BasicMetaProperty)columnMeta.getAllProperties().filterMap(BasicMetaReference::asRef).find(r -> !r.isAbstract() && r.getReferenceDesc().targets.length != 0 && r.getReferenceDesc().targets[0].kindOf(BasicSequence.class));
            if (seqRef != null) {
                return seqRef.id;
            }
        }
        return BasicModTableColumn.SEQUENCE_IDENTITY;
    }

    @NotNull
    private static ValuesCapability<DasForeignKey.Deferrability> getDeferrability(ScriptingCapabilities fkCaps) {
        if (fkCaps == null) {
            ValuesCapability<DasForeignKey.Deferrability> valuesCapability = ValuesCapability.unsupported(DasForeignKey.Deferrability.class);
            if (valuesCapability == null) {
                DatabaseEditorCapabilities.$$$reportNull$$$0(2);
            }
            return valuesCapability;
        }
        boolean deferrable = DatabaseEditorCapabilities.can(fkCaps.canCreateWith(BasicModConstraint.DEFERRABLE));
        boolean initial = DatabaseEditorCapabilities.can(fkCaps.canCreateWith(BasicModConstraint.INITIALLY_DEFERRED));
        if (!deferrable || !initial) {
            ValuesCapability<DasForeignKey.Deferrability> valuesCapability = ValuesCapability.unsupported(DasForeignKey.Deferrability.class);
            if (valuesCapability == null) {
                DatabaseEditorCapabilities.$$$reportNull$$$0(3);
            }
            return valuesCapability;
        }
        ValuesCapability<DasForeignKey.Deferrability> valuesCapability = ValuesCapability.supported(true, DasForeignKey.Deferrability.values());
        if (valuesCapability == null) {
            DatabaseEditorCapabilities.$$$reportNull$$$0(4);
        }
        return valuesCapability;
    }

    @NotNull
    private static ValuesCapability<DasForeignKey.RuleAction> getRuleAction(ScriptingCapabilities fkCaps, BasicMetaPropertyId<CascadeRule> prop) {
        if (fkCaps == null || !DatabaseEditorCapabilities.can(fkCaps.canCreateWith(prop))) {
            ValuesCapability<DasForeignKey.RuleAction> valuesCapability = ValuesCapability.unsupported(DasForeignKey.RuleAction.class);
            if (valuesCapability == null) {
                DatabaseEditorCapabilities.$$$reportNull$$$0(5);
            }
            return valuesCapability;
        }
        List values2 = ContainerUtil.map(fkCaps.supportedValues(prop), BasicMixinForeignKey::getAction);
        ValuesCapability<DasForeignKey.RuleAction> valuesCapability = ValuesCapability.supported(true, values2.toArray(new DasForeignKey.RuleAction[0]));
        if (valuesCapability == null) {
            DatabaseEditorCapabilities.$$$reportNull$$$0(6);
        }
        return valuesCapability;
    }

    private static boolean canCreate(ScriptingCapabilities caps) {
        return DatabaseEditorCapabilities.can(caps, (Function<ScriptingCapabilities, ScriptingCapabilities.VersionedCapability<Boolean>>)((Function)ScriptingCapabilities::getCreate));
    }

    private static Capability canCreateWith(ScriptingCapabilities caps, BasicMetaId id) {
        return Capability.supported(caps != null && DatabaseEditorCapabilities.can(caps.canCreateWith(id)));
    }

    private static Capability canAlter(ScriptingCapabilities caps, BasicMetaId id) {
        return Capability.supported(caps != null && DatabaseEditorCapabilities.can(caps.canAlter(id)));
    }

    private static boolean canDrop(ScriptingCapabilities caps) {
        return DatabaseEditorCapabilities.can(caps, (Function<ScriptingCapabilities, ScriptingCapabilities.VersionedCapability<Boolean>>)((Function)ScriptingCapabilities::getDrop));
    }

    private static Capability supported(@Nullable ScriptingCapabilities caps, @NotNull Function<ScriptingCapabilities, ScriptingCapabilities.VersionedCapability<Boolean>> field) {
        if (field == null) {
            DatabaseEditorCapabilities.$$$reportNull$$$0(7);
        }
        return Capability.supported(DatabaseEditorCapabilities.can(caps, field));
    }

    private static Capability recreatable(@Nullable ScriptingCapabilities caps) {
        return Capability.supported(DatabaseEditorCapabilities.isRecreatable(caps));
    }

    private static boolean isRecreatable(@Nullable ScriptingCapabilities caps) {
        return caps != null && DatabaseEditorCapabilities.can(caps.getCreate()) && DatabaseEditorCapabilities.can(caps.getDrop());
    }

    private static boolean can(@Nullable ScriptingCapabilities caps, @NotNull Function<ScriptingCapabilities, ScriptingCapabilities.VersionedCapability<Boolean>> field) {
        if (field == null) {
            DatabaseEditorCapabilities.$$$reportNull$$$0(8);
        }
        return caps != null && DatabaseEditorCapabilities.can((ScriptingCapabilities.VersionedCapability)field.fun((Object)caps));
    }

    private static boolean can(@NotNull ScriptingCapabilities.VersionedCapability<Boolean> cap) {
        if (cap == null) {
            DatabaseEditorCapabilities.$$$reportNull$$$0(9);
        }
        return cap.get(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeferrability";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuleAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tableCapsFor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "supported";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "can";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    private static final class CapsHelper {
        public final DatabaseDialectEx dialect;
        public final BasicModModel model;
        public final Map<BasicMetaObject<?>, BasicModElement> cache;
        public final ScriptGenerator generator;

        private CapsHelper(@NotNull Dbms dbms) {
            if (dbms == null) {
                CapsHelper.$$$reportNull$$$0(0);
            }
            this.cache = new HashMap();
            this.dialect = DbImplUtilCore.getDatabaseDialect(dbms);
            this.model = new ModelFactory(BlackHoleTextStorage.INSTANCE).createModel(dbms);
            this.generator = (ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms);
        }

        @Nullable
        private ScriptingCapabilities caps(@Nullable BasicMetaObject<?> meta) {
            BasicModElement element2 = meta == null ? null : this.get(meta);
            return element2 == null ? null : this.generator.capabilities(element2);
        }

        private BasicModElement get(@Nullable BasicMetaObject<?> meta) {
            if (meta == null) {
                return null;
            }
            if (meta.kind == ObjectKind.ROOT) {
                return (BasicModElement)((Object)this.model.getRoot());
            }
            if (this.cache.containsKey(meta)) {
                return this.cache.get(meta);
            }
            BasicModElement parent2 = this.get(Objects.requireNonNull(meta.getParent()));
            Family family = parent2.familyOf(meta.kind);
            BasicModElement res2 = family == null ? null : (BasicModElement)family.createNewOne();
            this.cache.put(meta, res2);
            return res2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbms", "com/intellij/database/view/editors/DatabaseEditorCapabilities$CapsHelper", "<init>"));
        }
    }

    public static class DbEditorCaps {
        private final ObjectEditorCaps myNewDatabaseEditorCaps;
        private final ObjectEditorCaps myExistingDatabaseEditorCaps;
        private final ObjectEditorCaps myNewSchemaEditorCaps;
        private final ObjectEditorCaps myExistingSchemaEditorCaps;
        private final TableEditorCaps myNewTableEditorCaps;
        private final TableEditorCaps myExistingTableEditorCaps;

        public DbEditorCaps(@NotNull ObjectEditorCaps newDatabaseEditorCaps, @NotNull ObjectEditorCaps existingDatabaseEditorCaps, @NotNull ObjectEditorCaps newSchemaEditorCaps, @NotNull ObjectEditorCaps existingSchemaEditorCaps, @NotNull TableEditorCaps newTableEditorCaps, @NotNull TableEditorCaps existingTableEditorCaps) {
            if (newDatabaseEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(0);
            }
            if (existingDatabaseEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(1);
            }
            if (newSchemaEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(2);
            }
            if (existingSchemaEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(3);
            }
            if (newTableEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(4);
            }
            if (existingTableEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(5);
            }
            this.myNewDatabaseEditorCaps = newDatabaseEditorCaps;
            this.myExistingDatabaseEditorCaps = existingDatabaseEditorCaps;
            this.myNewSchemaEditorCaps = newSchemaEditorCaps;
            this.myExistingSchemaEditorCaps = existingSchemaEditorCaps;
            this.myNewTableEditorCaps = newTableEditorCaps;
            this.myExistingTableEditorCaps = existingTableEditorCaps;
        }

        @NotNull
        public ObjectEditorCaps getDatabaseEditorCaps(boolean existing) {
            ObjectEditorCaps objectEditorCaps = existing ? this.myExistingDatabaseEditorCaps : this.myNewDatabaseEditorCaps;
            if (objectEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(6);
            }
            return objectEditorCaps;
        }

        @NotNull
        public ObjectEditorCaps getSchemaEditorCaps(boolean existing) {
            ObjectEditorCaps objectEditorCaps = existing ? this.myExistingSchemaEditorCaps : this.myNewSchemaEditorCaps;
            if (objectEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(7);
            }
            return objectEditorCaps;
        }

        @NotNull
        public TableEditorCaps getTableEditorCaps(boolean existing) {
            TableEditorCaps tableEditorCaps = existing ? this.myExistingTableEditorCaps : this.myNewTableEditorCaps;
            if (tableEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(8);
            }
            return tableEditorCaps;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newDatabaseEditorCaps";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingDatabaseEditorCaps";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newSchemaEditorCaps";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingSchemaEditorCaps";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newTableEditorCaps";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingTableEditorCaps";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$DbEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$DbEditorCaps";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDatabaseEditorCaps";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSchemaEditorCaps";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    public static class ObjectEditorCaps {
        private final Capability myRename;
        private final Capability myComment;

        public ObjectEditorCaps(@NotNull Capability rename, @NotNull Capability comment) {
            if (rename == null) {
                ObjectEditorCaps.$$$reportNull$$$0(0);
            }
            if (comment == null) {
                ObjectEditorCaps.$$$reportNull$$$0(1);
            }
            this.myRename = rename;
            this.myComment = comment;
        }

        @NotNull
        public Capability getRename() {
            Capability capability = this.myRename;
            if (capability == null) {
                ObjectEditorCaps.$$$reportNull$$$0(2);
            }
            return capability;
        }

        @NotNull
        public Capability getComment() {
            Capability capability = this.myComment;
            if (capability == null) {
                ObjectEditorCaps.$$$reportNull$$$0(3);
            }
            return capability;
        }

        public boolean canDoAnything() {
            return this.getRename().isAvailable() || this.getComment().isAvailable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rename";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$ObjectEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$ObjectEditorCaps";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRename";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static enum Capability {
        UNSUPPORTED,
        UNAVAILABLE,
        AVAILABLE;


        public boolean isAvailable() {
            return this == AVAILABLE;
        }

        public boolean isSupported() {
            return this != UNSUPPORTED;
        }

        public <T> T convert(T unsup, T unavail, T avail) {
            return this == UNSUPPORTED ? unsup : (this == UNAVAILABLE ? unavail : avail);
        }

        @NotNull
        public static Capability from(boolean supported, boolean avail) {
            Capability capability = !supported ? UNSUPPORTED : (avail ? AVAILABLE : UNAVAILABLE);
            if (capability == null) {
                Capability.$$$reportNull$$$0(0);
            }
            return capability;
        }

        @NotNull
        public static Capability available(boolean avail) {
            Capability capability = avail ? AVAILABLE : UNAVAILABLE;
            if (capability == null) {
                Capability.$$$reportNull$$$0(1);
            }
            return capability;
        }

        @NotNull
        public static Capability supported(boolean sup) {
            Capability capability = sup ? AVAILABLE : UNSUPPORTED;
            if (capability == null) {
                Capability.$$$reportNull$$$0(2);
            }
            return capability;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$Capability";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "from";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "available";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "supported";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class TableEditorCaps
    extends ObjectEditorCaps {
        private final ListCapability myColumns;
        private final ListCapability myIndices;
        private final ListCapability myForeignKeys;
        private final ListCapability myPrimaryKey;
        private final ListCapability myAltKeys;
        private final ListCapability myConstraints;
        private final ColumnEditorCaps myNewColumnCaps;
        private final ColumnEditorCaps myExistingColumnCaps;
        private final KeyEditorCaps myNewKeyCaps;
        private final KeyEditorCaps myExistingKeyCaps;
        private final IndexEditorCaps myNewIndexCaps;
        private final IndexEditorCaps myExistingIndexCaps;
        private final ForeignKeyEditorCaps myNewForeignKeyCaps;
        private final ForeignKeyEditorCaps myExistingForeignKeyCaps;
        private final Capability myGrants;

        public TableEditorCaps(@NotNull Capability rename, @NotNull Capability comment, @NotNull ListCapability columns2, @NotNull ListCapability indices, @NotNull ListCapability foreignKeys2, @NotNull ListCapability primaryKey, @NotNull ListCapability altKeys, @NotNull ListCapability constraints, @NotNull ColumnEditorCaps newColumnCaps, @NotNull ColumnEditorCaps existingColumnCaps, @NotNull KeyEditorCaps newKeyCaps, @NotNull KeyEditorCaps existingKeyCaps, @NotNull IndexEditorCaps newIndexCaps, @NotNull IndexEditorCaps existingIndexCaps, @NotNull ForeignKeyEditorCaps newForeignKeyCaps, @NotNull ForeignKeyEditorCaps existingForeignKeyCaps, @NotNull Capability grants) {
            if (rename == null) {
                TableEditorCaps.$$$reportNull$$$0(0);
            }
            if (comment == null) {
                TableEditorCaps.$$$reportNull$$$0(1);
            }
            if (columns2 == null) {
                TableEditorCaps.$$$reportNull$$$0(2);
            }
            if (indices == null) {
                TableEditorCaps.$$$reportNull$$$0(3);
            }
            if (foreignKeys2 == null) {
                TableEditorCaps.$$$reportNull$$$0(4);
            }
            if (primaryKey == null) {
                TableEditorCaps.$$$reportNull$$$0(5);
            }
            if (altKeys == null) {
                TableEditorCaps.$$$reportNull$$$0(6);
            }
            if (constraints == null) {
                TableEditorCaps.$$$reportNull$$$0(7);
            }
            if (newColumnCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(8);
            }
            if (existingColumnCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(9);
            }
            if (newKeyCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(10);
            }
            if (existingKeyCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(11);
            }
            if (newIndexCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(12);
            }
            if (existingIndexCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(13);
            }
            if (newForeignKeyCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(14);
            }
            if (existingForeignKeyCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(15);
            }
            if (grants == null) {
                TableEditorCaps.$$$reportNull$$$0(16);
            }
            super(rename, comment);
            this.myPrimaryKey = primaryKey;
            this.myColumns = columns2;
            this.myIndices = indices;
            this.myForeignKeys = foreignKeys2;
            this.myAltKeys = altKeys;
            this.myConstraints = constraints;
            this.myNewColumnCaps = newColumnCaps;
            this.myExistingColumnCaps = existingColumnCaps;
            this.myNewKeyCaps = newKeyCaps;
            this.myExistingKeyCaps = existingKeyCaps;
            this.myNewIndexCaps = newIndexCaps;
            this.myExistingIndexCaps = existingIndexCaps;
            this.myNewForeignKeyCaps = newForeignKeyCaps;
            this.myExistingForeignKeyCaps = existingForeignKeyCaps;
            this.myGrants = grants;
        }

        @NotNull
        public Capability getGrants() {
            Capability capability = this.myGrants;
            if (capability == null) {
                TableEditorCaps.$$$reportNull$$$0(17);
            }
            return capability;
        }

        @NotNull
        public ListCapability getPrimaryKey() {
            ListCapability listCapability = this.myPrimaryKey;
            if (listCapability == null) {
                TableEditorCaps.$$$reportNull$$$0(18);
            }
            return listCapability;
        }

        @NotNull
        public ListCapability getColumns() {
            ListCapability listCapability = this.myColumns;
            if (listCapability == null) {
                TableEditorCaps.$$$reportNull$$$0(19);
            }
            return listCapability;
        }

        @NotNull
        public ListCapability getAltKeys() {
            ListCapability listCapability = this.myAltKeys;
            if (listCapability == null) {
                TableEditorCaps.$$$reportNull$$$0(20);
            }
            return listCapability;
        }

        @NotNull
        public ListCapability getIndices() {
            ListCapability listCapability = this.myIndices;
            if (listCapability == null) {
                TableEditorCaps.$$$reportNull$$$0(21);
            }
            return listCapability;
        }

        @NotNull
        public ListCapability getForeignKeys() {
            ListCapability listCapability = this.myForeignKeys;
            if (listCapability == null) {
                TableEditorCaps.$$$reportNull$$$0(22);
            }
            return listCapability;
        }

        @NotNull
        public ListCapability getConstraints() {
            ListCapability listCapability = this.myConstraints;
            if (listCapability == null) {
                TableEditorCaps.$$$reportNull$$$0(23);
            }
            return listCapability;
        }

        @NotNull
        public ColumnEditorCaps getColumnCaps(boolean existing) {
            ColumnEditorCaps columnEditorCaps = existing ? this.myExistingColumnCaps : this.myNewColumnCaps;
            if (columnEditorCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(24);
            }
            return columnEditorCaps;
        }

        @NotNull
        public IndexEditorCaps getIndexCaps(boolean existing) {
            IndexEditorCaps indexEditorCaps = existing ? this.myExistingIndexCaps : this.myNewIndexCaps;
            if (indexEditorCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(25);
            }
            return indexEditorCaps;
        }

        @NotNull
        public ForeignKeyEditorCaps getForeignKeyCaps(boolean existing) {
            ForeignKeyEditorCaps foreignKeyEditorCaps = existing ? this.myExistingForeignKeyCaps : this.myNewForeignKeyCaps;
            if (foreignKeyEditorCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(26);
            }
            return foreignKeyEditorCaps;
        }

        @NotNull
        public KeyEditorCaps getKeyCaps(boolean existing) {
            KeyEditorCaps keyEditorCaps = existing ? this.myExistingKeyCaps : this.myNewKeyCaps;
            if (keyEditorCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(27);
            }
            return keyEditorCaps;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getPrimaryKey().canDoAnything() || this.getColumns().canDoAnything() || this.getIndices().canDoAnything() || this.getForeignKeys().canDoAnything() || this.getConstraints().canDoAnything() || this.getColumnCaps(true).canDoAnything() || this.getColumnCaps(false).canDoAnything() || this.getIndexCaps(true).canDoAnything() || this.getIndexCaps(false).canDoAnything() || this.getForeignKeyCaps(true).canDoAnything() || this.getForeignKeyCaps(false).canDoAnything();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rename";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indices";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foreignKeys";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primaryKey";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "altKeys";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constraints";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newColumnCaps";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingColumnCaps";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newKeyCaps";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingKeyCaps";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newIndexCaps";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingIndexCaps";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newForeignKeyCaps";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingForeignKeyCaps";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grants";
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGrants";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrimaryKey";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumns";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAltKeys";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndices";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getForeignKeys";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConstraints";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnCaps";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndexCaps";
                    break;
                }
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getForeignKeyCaps";
                    break;
                }
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27 -> new IllegalStateException(string);
            };
        }
    }

    public static class ColumnEditorCaps
    extends ObjectEditorCaps {
        private final Capability myDataType;
        private final Capability myAutoInc;
        private final Capability myDefault;
        private final Capability myNotNull;

        public ColumnEditorCaps(@NotNull Capability rename, @NotNull Capability comment, @NotNull Capability dataType, @NotNull Capability autoInc, @NotNull Capability aDefault, @NotNull Capability notNull) {
            if (rename == null) {
                ColumnEditorCaps.$$$reportNull$$$0(0);
            }
            if (comment == null) {
                ColumnEditorCaps.$$$reportNull$$$0(1);
            }
            if (dataType == null) {
                ColumnEditorCaps.$$$reportNull$$$0(2);
            }
            if (autoInc == null) {
                ColumnEditorCaps.$$$reportNull$$$0(3);
            }
            if (aDefault == null) {
                ColumnEditorCaps.$$$reportNull$$$0(4);
            }
            if (notNull == null) {
                ColumnEditorCaps.$$$reportNull$$$0(5);
            }
            super(rename, comment);
            this.myDataType = dataType;
            this.myAutoInc = autoInc;
            this.myDefault = aDefault;
            this.myNotNull = notNull;
        }

        @NotNull
        public Capability getAutoInc() {
            Capability capability = this.myAutoInc;
            if (capability == null) {
                ColumnEditorCaps.$$$reportNull$$$0(6);
            }
            return capability;
        }

        @NotNull
        public Capability getDefault() {
            Capability capability = this.myDefault;
            if (capability == null) {
                ColumnEditorCaps.$$$reportNull$$$0(7);
            }
            return capability;
        }

        @NotNull
        public Capability getNotNull() {
            Capability capability = this.myNotNull;
            if (capability == null) {
                ColumnEditorCaps.$$$reportNull$$$0(8);
            }
            return capability;
        }

        @NotNull
        public Capability getDataType() {
            Capability capability = this.myDataType;
            if (capability == null) {
                ColumnEditorCaps.$$$reportNull$$$0(9);
            }
            return capability;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getAutoInc().isAvailable() || this.getDefault().isAvailable() || this.getNotNull().isAvailable() || this.getDataType().isAvailable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rename";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "autoInc";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aDefault";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notNull";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$ColumnEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$ColumnEditorCaps";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAutoInc";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotNull";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 8, 9 -> new IllegalStateException(string);
            };
        }
    }

    public static class KeyEditorCaps
    extends ObjectEditorCaps {
        private final TableKeyColumnEditorCaps myColumnEditorCaps;

        public KeyEditorCaps(@NotNull Capability rename, @NotNull Capability comment, @NotNull TableKeyColumnEditorCaps caps) {
            if (rename == null) {
                KeyEditorCaps.$$$reportNull$$$0(0);
            }
            if (comment == null) {
                KeyEditorCaps.$$$reportNull$$$0(1);
            }
            if (caps == null) {
                KeyEditorCaps.$$$reportNull$$$0(2);
            }
            super(rename, comment);
            this.myColumnEditorCaps = caps;
        }

        @NotNull
        public TableKeyColumnEditorCaps getColumnEditorCaps() {
            TableKeyColumnEditorCaps tableKeyColumnEditorCaps = this.myColumnEditorCaps;
            if (tableKeyColumnEditorCaps == null) {
                KeyEditorCaps.$$$reportNull$$$0(3);
            }
            return tableKeyColumnEditorCaps;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rename";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caps";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$KeyEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$KeyEditorCaps";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class TableKeyColumnEditorCaps {
    }

    public static class IndexEditorCaps
    extends ObjectEditorCaps {
        private final Capability myUnique;
        private final IndexColumnEditorCaps myColumnEditorCaps;

        public IndexEditorCaps(@NotNull Capability rename, @NotNull Capability comment, @NotNull Capability unique, @NotNull IndexColumnEditorCaps caps) {
            if (rename == null) {
                IndexEditorCaps.$$$reportNull$$$0(0);
            }
            if (comment == null) {
                IndexEditorCaps.$$$reportNull$$$0(1);
            }
            if (unique == null) {
                IndexEditorCaps.$$$reportNull$$$0(2);
            }
            if (caps == null) {
                IndexEditorCaps.$$$reportNull$$$0(3);
            }
            super(rename, comment);
            this.myUnique = unique;
            this.myColumnEditorCaps = caps;
        }

        @NotNull
        public Capability getUnique() {
            Capability capability = this.myUnique;
            if (capability == null) {
                IndexEditorCaps.$$$reportNull$$$0(4);
            }
            return capability;
        }

        @NotNull
        public IndexColumnEditorCaps getColumnEditorCaps() {
            IndexColumnEditorCaps indexColumnEditorCaps = this.myColumnEditorCaps;
            if (indexColumnEditorCaps == null) {
                IndexEditorCaps.$$$reportNull$$$0(5);
            }
            return indexColumnEditorCaps;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getUnique().isAvailable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rename";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unique";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caps";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$IndexEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$IndexEditorCaps";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnique";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class IndexColumnEditorCaps {
        private final Capability mySorting;

        public IndexColumnEditorCaps(@NotNull Capability sorting) {
            if (sorting == null) {
                IndexColumnEditorCaps.$$$reportNull$$$0(0);
            }
            this.mySorting = sorting;
        }

        @NotNull
        public Capability getSorting() {
            Capability capability = this.mySorting;
            if (capability == null) {
                IndexColumnEditorCaps.$$$reportNull$$$0(1);
            }
            return capability;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sorting";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$IndexColumnEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$IndexColumnEditorCaps";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSorting";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static final class ValuesCapability<T> {
        private final Capability myCapability;
        private final T[] myValues;

        public static <T> ValuesCapability<T> unsupported(@NotNull Class<T> clazz) {
            if (clazz == null) {
                ValuesCapability.$$$reportNull$$$0(0);
            }
            return new ValuesCapability<Object>(Capability.UNSUPPORTED, (Object[])Array.newInstance(clazz, 0));
        }

        public static <T> ValuesCapability<T> supported(boolean avail, T ... values2) {
            if (values2 == null) {
                ValuesCapability.$$$reportNull$$$0(1);
            }
            return new ValuesCapability<T>(Capability.available(avail), values2);
        }

        private ValuesCapability(Capability capability, T[] values2) {
            this.myCapability = capability;
            this.myValues = values2;
        }

        public boolean isAvailable() {
            return this.myCapability.isAvailable();
        }

        public boolean isSupported() {
            return this.myCapability.isSupported();
        }

        public T[] values() {
            return this.myValues;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$ValuesCapability";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unsupported";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "supported";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ForeignKeyEditorCaps
    extends ObjectEditorCaps {
        private final ValuesCapability<DasForeignKey.Deferrability> myDeferrability;
        private final ValuesCapability<DasForeignKey.RuleAction> myUpdateRule;
        private final ValuesCapability<DasForeignKey.RuleAction> myDeleteRule;

        public ForeignKeyEditorCaps(@NotNull Capability rename, @NotNull Capability comment, @NotNull ValuesCapability<DasForeignKey.Deferrability> deferrability, @NotNull ValuesCapability<DasForeignKey.RuleAction> updateRule, @NotNull ValuesCapability<DasForeignKey.RuleAction> deleteRule) {
            if (rename == null) {
                ForeignKeyEditorCaps.$$$reportNull$$$0(0);
            }
            if (comment == null) {
                ForeignKeyEditorCaps.$$$reportNull$$$0(1);
            }
            if (deferrability == null) {
                ForeignKeyEditorCaps.$$$reportNull$$$0(2);
            }
            if (updateRule == null) {
                ForeignKeyEditorCaps.$$$reportNull$$$0(3);
            }
            if (deleteRule == null) {
                ForeignKeyEditorCaps.$$$reportNull$$$0(4);
            }
            super(rename, comment);
            this.myDeferrability = deferrability;
            this.myUpdateRule = updateRule;
            this.myDeleteRule = deleteRule;
        }

        @NotNull
        public ValuesCapability<DasForeignKey.RuleAction> getUpdateRule() {
            ValuesCapability<DasForeignKey.RuleAction> valuesCapability = this.myUpdateRule;
            if (valuesCapability == null) {
                ForeignKeyEditorCaps.$$$reportNull$$$0(5);
            }
            return valuesCapability;
        }

        @NotNull
        public ValuesCapability<DasForeignKey.RuleAction> getDeleteRule() {
            ValuesCapability<DasForeignKey.RuleAction> valuesCapability = this.myDeleteRule;
            if (valuesCapability == null) {
                ForeignKeyEditorCaps.$$$reportNull$$$0(6);
            }
            return valuesCapability;
        }

        @NotNull
        public ValuesCapability<DasForeignKey.Deferrability> getDeferrability() {
            ValuesCapability<DasForeignKey.Deferrability> valuesCapability = this.myDeferrability;
            if (valuesCapability == null) {
                ForeignKeyEditorCaps.$$$reportNull$$$0(7);
            }
            return valuesCapability;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getUpdateRule().isAvailable() || this.getDeleteRule().isAvailable() || this.getDeferrability().isAvailable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rename";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deferrability";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updateRule";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deleteRule";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$ForeignKeyEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$ForeignKeyEditorCaps";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUpdateRule";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeleteRule";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeferrability";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    public static final class ListCapability {
        private static final int REORDERABLE = 1;
        private static final int ADDABLE = 2;
        private static final int REMOVABLE = 4;
        private static final int UNSUPPORTED = 8;
        private static final ListCapability[] INSTANCES = new ListCapability[9];
        private final int myFlags;

        public static ListCapability unsupported() {
            return INSTANCES[8];
        }

        public static ListCapability supported(boolean reorder, boolean add, boolean remove2) {
            return INSTANCES[(reorder ? 1 : 0) + (add ? 2 : 0) + (remove2 ? 4 : 0)];
        }

        public static ListCapability get(boolean supported, boolean reorder, boolean add, boolean remove2) {
            return supported ? ListCapability.supported(reorder, add, remove2) : ListCapability.unsupported();
        }

        public boolean canDoAnything() {
            return this.canAdd() || this.canRemove() || this.canReorder();
        }

        public boolean isSupported() {
            return this.myFlags != 8;
        }

        public boolean canSupersede(boolean addedMy, boolean addedAny) {
            return addedAny && !addedMy ? this.canReadd() : this.canChange(addedMy);
        }

        public boolean canReadd() {
            return this.canRemove() && this.canAdd();
        }

        public boolean canChange(boolean added) {
            return added ? this.canRemove() : this.canAdd();
        }

        public boolean canAdd() {
            return (this.myFlags & 2) != 0;
        }

        public boolean canRemove() {
            return (this.myFlags & 4) != 0;
        }

        public boolean canReorder() {
            return (this.myFlags & 1) != 0;
        }

        private ListCapability(int flags) {
            this.myFlags = flags;
        }

        static {
            for (int i2 = 0; i2 < INSTANCES.length; ++i2) {
                ListCapability.INSTANCES[i2] = new ListCapability(i2);
            }
        }
    }

    public static class TableKeyEditorCaps
    extends KeyEditorCaps {
        private final TableEditorCaps myTableCaps;
        private final boolean myTableHasPk;
        private final boolean myIsPk;

        public TableKeyEditorCaps(@NotNull TableEditorCaps tableCaps, @NotNull KeyEditorCaps caps, boolean tableHasPk, boolean isPk) {
            if (tableCaps == null) {
                TableKeyEditorCaps.$$$reportNull$$$0(0);
            }
            if (caps == null) {
                TableKeyEditorCaps.$$$reportNull$$$0(1);
            }
            super(caps.getRename(), caps.getComment(), caps.getColumnEditorCaps());
            this.myTableCaps = tableCaps;
            this.myTableHasPk = tableHasPk;
            this.myIsPk = isPk;
        }

        @NotNull
        public Capability getPrimaryKey() {
            Capability capability = Capability.from(this.myTableCaps.getPrimaryKey().isSupported(), this.myTableCaps.getPrimaryKey().canSupersede(this.myIsPk, this.myTableHasPk));
            if (capability == null) {
                TableKeyEditorCaps.$$$reportNull$$$0(2);
            }
            return capability;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getPrimaryKey().isAvailable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableCaps";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caps";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableKeyEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableKeyEditorCaps";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrimaryKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class TableColumnEditorCaps
    extends ColumnEditorCaps {
        private final TableEditorCaps myTableCaps;
        private final boolean myTableHasPk;
        private final boolean myIsPk;
        private final boolean myIsUnique;

        public TableColumnEditorCaps(@NotNull TableEditorCaps tableCaps, @NotNull ColumnEditorCaps columnCaps, boolean tableHasPk, boolean isPk, boolean isUnique) {
            if (tableCaps == null) {
                TableColumnEditorCaps.$$$reportNull$$$0(0);
            }
            if (columnCaps == null) {
                TableColumnEditorCaps.$$$reportNull$$$0(1);
            }
            super(columnCaps.getRename(), columnCaps.getComment(), columnCaps.getDataType(), columnCaps.getAutoInc(), columnCaps.getDefault(), columnCaps.getNotNull());
            this.myTableCaps = tableCaps;
            this.myTableHasPk = tableHasPk;
            this.myIsPk = isPk;
            this.myIsUnique = isUnique;
        }

        @NotNull
        public Capability getPrimaryKey() {
            Capability capability = Capability.from(this.myTableCaps.getPrimaryKey().isSupported(), this.myTableCaps.getPrimaryKey().canSupersede(this.myIsPk, this.myTableHasPk));
            if (capability == null) {
                TableColumnEditorCaps.$$$reportNull$$$0(2);
            }
            return capability;
        }

        @NotNull
        public Capability getUnique() {
            boolean isSupported = this.myTableCaps.getIndices().isSupported() && this.myTableCaps.myNewIndexCaps.getUnique().isSupported();
            Capability capability = Capability.from(isSupported, this.myTableCaps.getIndices().canChange(this.myIsUnique));
            if (capability == null) {
                TableColumnEditorCaps.$$$reportNull$$$0(3);
            }
            return capability;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getPrimaryKey().isAvailable() || this.getUnique().isAvailable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableCaps";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnCaps";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableColumnEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableColumnEditorCaps";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrimaryKey";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnique";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

