/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.ThreeStateCheckBox;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseEditorBase
implements Disposable {
    protected boolean myUpdating;
    private final DatabaseEditorState myState;

    public DatabaseEditorBase(@NotNull DatabaseEditorState state) {
        if (state == null) {
            DatabaseEditorBase.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myState.context;
        if (databaseEditorContext == null) {
            DatabaseEditorBase.$$$reportNull$$$0(1);
        }
        return databaseEditorContext;
    }

    public Project getProject() {
        return this.getContext().getProject();
    }

    @NotNull
    public abstract EditorModelBase getModel();

    protected void updateFromModel() {
        this.myUpdating = true;
        try {
            this.updateFromModelImpl();
        }
        finally {
            this.myUpdating = false;
        }
    }

    protected void markInvalid() {
        this.myState.markInvalid(this);
    }

    protected void markValid() {
        this.myState.markValid(this);
    }

    public boolean areEditorsValid() {
        return this.myState.areAllEditorsValid();
    }

    protected abstract void updateFromModelImpl();

    protected static void setValue(@NotNull EditorTextField field, @NotNull String value2) {
        if (field == null) {
            DatabaseEditorBase.$$$reportNull$$$0(2);
        }
        if (value2 == null) {
            DatabaseEditorBase.$$$reportNull$$$0(3);
        }
        if (!value2.equals(field.getText())) {
            field.setText(value2);
        }
    }

    protected static void setValue(@NotNull JCheckBox field, boolean value2) {
        if (field == null) {
            DatabaseEditorBase.$$$reportNull$$$0(4);
        }
        if (value2 != field.isSelected()) {
            field.setSelected(value2);
        }
    }

    protected static void setValue(@NotNull ThreeStateCheckBox field, ThreeState value2) {
        ThreeStateCheckBox.State state;
        if (field == null) {
            DatabaseEditorBase.$$$reportNull$$$0(5);
        }
        ThreeStateCheckBox.State state2 = value2 == ThreeState.YES ? ThreeStateCheckBox.State.SELECTED : (state = value2 == ThreeState.NO ? ThreeStateCheckBox.State.NOT_SELECTED : ThreeStateCheckBox.State.DONT_CARE);
        if (state != field.getState()) {
            field.setState(state);
        }
    }

    protected static void setValue(@NotNull JTextField field, @NotNull String value2) {
        if (field == null) {
            DatabaseEditorBase.$$$reportNull$$$0(6);
        }
        if (value2 == null) {
            DatabaseEditorBase.$$$reportNull$$$0(7);
        }
        if (!value2.equals(field.getText())) {
            field.setText(value2);
        }
    }

    @NotNull
    public abstract JComponent getComponent();

    @NotNull
    public abstract JComponent getPreferredFocusedComponent();

    public void dispose() {
        this.markValid();
    }

    @NotNull
    public String getObjectName(@Nullable DeObject ref2) {
        String string = ref2 == null ? "" : this.getContext().getNamingService().catToScript(ref2.name, ref2.getKind());
        if (string == null) {
            DatabaseEditorBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    public DatabaseEditorState getState() {
        return this.myState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorBase";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8 -> new IllegalStateException(string);
        };
    }
}

