/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.BasicModelRegistry;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbModelRegistry;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LinkedDataSourceHelper;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.DvTreeNodeDecoration;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiLevelIntrospectableArea;
import com.intellij.database.model.basic.BasicMultiLevelObject;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.families.FamilyWithId;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.model.properties.Level;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.view.AsyncCachedValue;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.DbNodeDescriptorHelper;
import com.intellij.database.view.structure.DvDsGroup;
import com.intellij.database.view.structure.DvErsatzFamilyNode;
import com.intellij.database.view.structure.DvHostNode;
import com.intellij.database.view.structure.DvTreeImplantingLayer;
import com.intellij.database.view.structure.DvTreeLayoutLayer;
import com.intellij.database.view.structure.DvTreeStructure;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbNodeDescriptor {
    public static final SimpleTextAttributes INACTIVE_LINK_ATTRS = SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES.derive(SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES.getStyle() | 0x200, null, null, null);
    public static final SimpleTextAttributes ACTIVE_LINK_ATTRS = INACTIVE_LINK_ATTRS.derive(INACTIVE_LINK_ATTRS.getStyle() | 0x400, UIUtil.getLabelForeground(), null, null);
    static final int nodeNameLimit = 80;
    static final String spaceDelimiter = "\u2002";

    public static void updatePresentation(@NotNull PresentationData presentation, @NotNull BasicNode node2, @NotNull Project project, @NotNull DvViewOptions viewOptions, @NotNull DvTreeStructure treeStructure2, @Nullable TreePath pathUnderMouse, boolean showCount, boolean appendNamespaceChooserLink) {
        BasicElement element2;
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(0);
        }
        if (node2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(2);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(3);
        }
        if (treeStructure2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(4);
        }
        presentation.clear();
        if (project.isDisposed()) {
            return;
        }
        MiniContext mc = new MiniContext();
        @Nullable BasicModel model2 = node2.getModel();
        @NotNull Dbms dbms = model2 != null ? model2.getDbms() : Dbms.UNKNOWN;
        DescriptionService descriptionService = ModelFacade.forDbms(dbms).getDescriptionService();
        @Nullable RawDataSource dataSource2 = DbNodeDescriptorHelper.getDataSourceForTopNode(node2);
        Icon nodeIcon = DbNodeDescriptorHelper.getNodeIcon(project, node2);
        presentation.setIcon(nodeIcon);
        DvTreeNodeDecoration decoration = descriptionService.getNodeDecoration(node2);
        String nodeText = DbNodeDescriptorHelper.getNodePrimaryText(node2, treeStructure2);
        DbNodeDescriptor.setNodePrimaryText(presentation, project, viewOptions, node2, nodeText, decoration, dataSource2);
        DbNodeDescriptor.decorateNode(presentation, node2, decoration, viewOptions);
        if (node2 instanceof DataSourceNode) {
            DataSourceNode dsn = (DataSourceNode)node2;
            DbNodeDescriptor.updatePresentationForDataSource(presentation, dsn, project, mc, viewOptions, pathUnderMouse, appendNamespaceChooserLink);
            if (viewOptions.getWithIntrospectionLevels()) {
                DbNodeDescriptorHelper.addLevelIcon(presentation, dsn);
            }
        } else if (node2 instanceof BasicMultiLevelIntrospectableArea) {
            BasicMultiLevelIntrospectableArea area = (BasicMultiLevelIntrospectableArea)node2;
            if (viewOptions.getWithIntrospectionLevels()) {
                DbNodeDescriptorHelper.addLevelIcon(presentation, area, dataSource2);
            }
        } else if (node2 instanceof BasicMultiLevelObject) {
            BasicMultiLevelObject mlObject = (BasicMultiLevelObject)node2;
            if (viewOptions.getWithDetailLevels() && mlObject.getMaxDetailsLevel().level > Level.L1.level) {
                DbNodeDescriptorHelper.addDetailsLevelIcon(presentation, mlObject.getEffectiveDetailsLevel());
            }
        } else if (node2 instanceof DvTreeLayoutLayer.EmptyScopeLeaf) {
            DvTreeLayoutLayer.EmptyScopeLeaf leaf = (DvTreeLayoutLayer.EmptyScopeLeaf)node2;
            DbNodeDescriptor.updatePresentationForEmptyScopeLeaf(presentation, leaf, mc, pathUnderMouse);
        } else if (node2 instanceof DvTreeImplantingLayer.ImplantedNode) {
            DvTreeImplantingLayer.ImplantedNode implantedNode = (DvTreeImplantingLayer.ImplantedNode)node2;
            implantedNode.updatePresentation(project, presentation, treeStructure2, viewOptions);
        }
        if (node2 instanceof BasicNamespaceOwner && appendNamespaceChooserLink) {
            boolean activate = pathUnderMouse != null && node2 == pathUnderMouse.getLastPathComponent();
            DbNodeDescriptor.appendNamespaceChooserLinkWithCounters(presentation, (BasicNamespaceOwner)node2, project, mc, activate);
        }
        if (showCount && !mc.countShown) {
            DbNodeDescriptor.showCount(presentation, node2, treeStructure2, mc, viewOptions);
        }
        if (node2 instanceof BasicElement) {
            element2 = (BasicElement)node2;
            LinkedDataSourceHelper helper = LinkedDataSourceHelper.of(dbms);
            if (helper != null && element2.getKind() == helper.getLinkedDataSourceKind() && DbNodeDescriptor.updateLinkObjectPresentation(presentation, element2, treeStructure2)) {
                return;
            }
        }
        if (node2 instanceof BasicElement) {
            element2 = (BasicElement)node2;
            DbNodeDescriptor.updatePresentationAdditions(presentation, element2, project, descriptionService, viewOptions);
        }
    }

    private static void decorateNode(@NotNull PresentationData presentation, @NotNull BasicNode node2, @NotNull DvTreeNodeDecoration decoration, @NotNull DvViewOptions viewOptions) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(5);
        }
        if (node2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(6);
        }
        if (decoration == null) {
            DbNodeDescriptor.$$$reportNull$$$0(7);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(8);
        }
        if (decoration.additions != null && !viewOptions.getWithCommentsNotDetails()) {
            for (String addition : decoration.additions) {
                presentation.addText(addition, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
            }
        }
    }

    private static boolean updateLinkObjectPresentation(@NotNull PresentationData presentation, @NotNull BasicElement element2, @NotNull DvTreeStructure treeStructure2) {
        RawDataSource ds;
        LocalDataSource dsLocal;
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(9);
        }
        if (element2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(10);
        }
        if (treeStructure2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(11);
        }
        if ((dsLocal = DbImplUtilCore.getMaybeLocalDataSource(ds = treeStructure2.getContext().getModelRegistry().findDataSource(element2))) == null) {
            return false;
        }
        ObjectPath path = ObjectPaths.of(element2);
        String linkedId = dsLocal.getLinkedDataSourceIds().get(path);
        Project project = treeStructure2.getContext().project;
        DbDataSource dsLinked = DbPsiFacade.getInstance(project).findDataSource(linkedId);
        if (dsLinked == null) {
            return false;
        }
        presentation.addText(DbPresentation.arrow() + " " + dsLinked.getName(), DbPresentation.BOLD_INFO_ATTRS);
        return true;
    }

    private static void updatePresentationAdditions(@NotNull PresentationData presentation, @NotNull BasicElement element2, @NotNull Project project, @NotNull DescriptionService descriptionService, @NotNull DvViewOptions viewOptions) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(12);
        }
        if (element2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(13);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(14);
        }
        if (descriptionService == null) {
            DbNodeDescriptor.$$$reportNull$$$0(15);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(16);
        }
        DbNodeDescriptor.updatePresentationAdditions(project, presentation, element2, descriptionService, viewOptions);
    }

    public static void updatePresentationAdditions(@NotNull Project project, @NotNull PresentationData presentation, @NotNull BasicElement element2, @NotNull DescriptionService descriptionService, @NotNull DvViewOptions viewOptions) {
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(17);
        }
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(18);
        }
        if (element2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(19);
        }
        if (descriptionService == null) {
            DbNodeDescriptor.$$$reportNull$$$0(20);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(21);
        }
        String comment = DbNodeDescriptor.adjustCommentString(element2.getComment());
        boolean commentsMode = viewOptions.getWithCommentsNotDetails();
        boolean hasComment = StringUtil.isNotEmpty((String)comment);
        if (!commentsMode || !hasComment) {
            descriptionService.updatePresentation(project, element2, viewOptions, presentation);
        } else {
            DbNodeDescriptor.addSpaceDelimiter(presentation);
            presentation.addText(comment, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
        if (hasComment) {
            DbNodeDescriptor.addTooltip(presentation, true, "<pre>" + StringUtil.escapeXmlEntities((String)comment) + "</pre>");
        }
    }

    public static void updatePresentationForDataSource(@NotNull PresentationData presentation, @NotNull DataSourceNode dsn, @NotNull Project project, @NotNull MiniContext mc, @NotNull DvViewOptions viewOptions, @Nullable TreePath pathUnderMouse, boolean appendNamespaceChooserLink) {
        boolean activate;
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(22);
        }
        if (dsn == null) {
            DbNodeDescriptor.$$$reportNull$$$0(23);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(24);
        }
        if (mc == null) {
            DbNodeDescriptor.$$$reportNull$$$0(25);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(26);
        }
        if (project.isDisposed()) {
            return;
        }
        DbDataSource ds = dsn.dbDataSource;
        boolean commentsMode = viewOptions.getWithCommentsNotDetails();
        String comment = DbNodeDescriptor.adjustCommentString(ds.getComment());
        boolean bl = activate = pathUnderMouse != null && dsn == pathUnderMouse.getLastPathComponent();
        if (appendNamespaceChooserLink) {
            DbNodeDescriptor.appendNamespaceChooserLinkWithCounters(presentation, dsn, mc, activate);
        }
        if (StringUtil.isNotEmpty((String)comment)) {
            DbNodeDescriptor.addTooltip(presentation, true, "<pre>" + StringUtil.escapeXmlEntities((String)comment) + "</pre>");
            if (commentsMode) {
                DbNodeDescriptor.addSpaceDelimiter(presentation);
                presentation.addText(comment, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
            }
        }
    }

    private static void setNodePrimaryText(@NotNull PresentationData presentation, @NotNull Project project, @NotNull DvViewOptions viewOptions, @NotNull BasicNode node2, @NotNull @Nls String nodeText, @NotNull DvTreeNodeDecoration decoration, @Nullable RawDataSource dataSource2) {
        String theText;
        BasicMinorObject minorObj;
        BasicModel model2;
        Dbms dbms;
        DescriptionService service;
        String schemaName;
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(27);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(28);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(29);
        }
        if (node2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(30);
        }
        if (nodeText == null) {
            DbNodeDescriptor.$$$reportNull$$$0(31);
        }
        if (decoration == null) {
            DbNodeDescriptor.$$$reportNull$$$0(32);
        }
        if (node2 instanceof BasicMinorObject && (schemaName = (service = ModelFacade.forDbms(dbms = (model2 = (minorObj = (BasicMinorObject)node2).getModel()) != null ? model2.getDbms() : Dbms.UNKNOWN).getDescriptionService()).getMinorObjectSchemaName(minorObj)) != null) {
            String schemaString = "(" + schemaName + ".)\u2009";
            presentation.addText(schemaString, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        String string = theText = StringUtil.isEmpty((String)nodeText) ? DbPresentation.UNNAMED : nodeText;
        if (theText.length() > 80) {
            theText = StringUtil.shortenTextWithEllipsis((String)theText, (int)80, (int)10, (boolean)true);
        }
        presentation.setPresentableText(theText);
        SimpleTextAttributes style = DbNodeDescriptor.handleStatuses(project, presentation, node2, dataSource2, decoration, viewOptions);
        if (node2 instanceof DvDsGroup) {
            if (DbNodeDescriptorHelper.getBoldDataSources()) {
                style = new SimpleTextAttributes(1, (Color)JBColor.GRAY);
            }
        } else if (node2 instanceof DataSourceNode) {
            if (DbNodeDescriptorHelper.getBoldDataSources()) {
                SimpleTextAttributes bold = new SimpleTextAttributes(1, style.getFgColor());
                style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)bold);
            }
        } else if (node2 instanceof DasObject) {
            style = DbNodeDescriptor.handleModified(project, (DasObject)((Object)node2), style);
        }
        presentation.addText(theText, style);
        DbNodeDescriptor.addSpaceDelimiter(presentation);
    }

    public static void updatePresentationForEmptyScopeLeaf(@NotNull PresentationData presentation, @NotNull DvTreeLayoutLayer.EmptyScopeLeaf leaf, @NotNull MiniContext mc, @Nullable TreePath pathUnderMouse) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(33);
        }
        if (leaf == null) {
            DbNodeDescriptor.$$$reportNull$$$0(34);
        }
        if (mc == null) {
            DbNodeDescriptor.$$$reportNull$$$0(35);
        }
        ObjectKind leafKind = leaf.getLeafKind();
        DbNodeDescriptor.updatePresentationForEmptyScopeLeaf(presentation, leaf, leafKind, mc, pathUnderMouse);
    }

    private static void updatePresentationForEmptyScopeLeaf(@NotNull PresentationData presentation, @NotNull Object leaf, @NotNull ObjectKind leafKind, @NotNull MiniContext mc, @Nullable TreePath pathUnderMouse) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(36);
        }
        if (leaf == null) {
            DbNodeDescriptor.$$$reportNull$$$0(37);
        }
        if (leafKind == null) {
            DbNodeDescriptor.$$$reportNull$$$0(38);
        }
        if (mc == null) {
            DbNodeDescriptor.$$$reportNull$$$0(39);
        }
        presentation.clear();
        presentation.addText(DatabaseBundle.message("label.no.schemas.selected", leafKind.getPluralPresentableName()), SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
        presentation.addText("  ", SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
        boolean activate = pathUnderMouse != null && leaf == pathUnderMouse.getLastPathComponent();
        DbNodeDescriptor.appendNamespaceChooserLinkWithoutCounters(presentation, mc, activate);
    }

    private static SimpleTextAttributes handleModified(Project project, DasObject element2, SimpleTextAttributes style) {
        BasicSourceAware sa = (BasicSourceAware)ObjectUtils.tryCast((Object)element2, BasicSourceAware.class);
        DbDataSource dataSource2 = sa == null ? null : ((DbModelRegistry)project.getService(DbModelRegistry.class)).findDbDataSource(sa);
        VirtualFile file = dataSource2 == null ? null : DbSrcUtils.findDbSrcFile(dataSource2, sa, false);
        FileStatus status = file == null ? null : DbSrcChangesTracker.getFileStatuses().getStatus(file).getStatus();
        return status == null ? style : style.derive(-1, status.getColor(), null, null);
    }

    @NotNull
    public static String adjustCommentString(@Nullable String comment) {
        String string = comment == null ? "" : StringUtil.shortenTextWithEllipsis((String)comment, (int)2000, (int)0, (boolean)true);
        if (string == null) {
            DbNodeDescriptor.$$$reportNull$$$0(40);
        }
        return string;
    }

    private static void appendNamespaceChooserLinkWithCounters(@NotNull PresentationData presentation, @NotNull BasicNamespaceOwner namespaceOwner, @NotNull Project project, @NotNull MiniContext mc, boolean activate) {
        Couple<Integer> counters;
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(41);
        }
        if (namespaceOwner == null) {
            DbNodeDescriptor.$$$reportNull$$$0(42);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(43);
        }
        if (mc == null) {
            DbNodeDescriptor.$$$reportNull$$$0(44);
        }
        if ((counters = DbNodeDescriptor.countNamespaces(namespaceOwner, project)) == null) {
            return;
        }
        DbNodeDescriptor.appendNamespaceChooserLinkWithCounters(presentation, counters, mc, activate);
    }

    private static void appendNamespaceChooserLinkWithCounters(@NotNull PresentationData presentation, @NotNull DataSourceNode dsn, @NotNull MiniContext mc, boolean activate) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(45);
        }
        if (dsn == null) {
            DbNodeDescriptor.$$$reportNull$$$0(46);
        }
        if (mc == null) {
            DbNodeDescriptor.$$$reportNull$$$0(47);
        }
        BasicRoot root2 = dsn.getModelRoot();
        LocalDataSource ds = dsn.getLocalDataSource();
        if (root2 == null || ds == null) {
            return;
        }
        Couple<Integer> counters = DbNodeDescriptor.countNamespaces((BasicNamespaceOwner)root2, ds);
        DbNodeDescriptor.appendNamespaceChooserLinkWithCounters(presentation, counters, mc, activate);
    }

    private static void appendNamespaceChooserLinkWithCounters(@NotNull PresentationData presentation, @NotNull Couple<Integer> counters, @NotNull MiniContext mc, boolean activate) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(48);
        }
        if (counters == null) {
            DbNodeDescriptor.$$$reportNull$$$0(49);
        }
        if (mc == null) {
            DbNodeDescriptor.$$$reportNull$$$0(50);
        }
        int enabled = (Integer)counters.first;
        int total = (Integer)counters.second;
        String text2 = enabled == 0 && total == 0 ? "  ...  " : (enabled != total ? " " + DatabaseBundle.message("namespace.fraction", enabled, total) + " " : " " + enabled + " ");
        DbNodeDescriptor.appendNamespaceChooserLink(presentation, activate, text2);
        mc.countShown = true;
    }

    private static void appendNamespaceChooserLinkWithoutCounters(PresentationData presentation, @NotNull MiniContext mc, boolean activate) {
        if (mc == null) {
            DbNodeDescriptor.$$$reportNull$$$0(51);
        }
        DbNodeDescriptor.appendNamespaceChooserLink(presentation, activate, "  ...  ");
        mc.countShown = true;
    }

    private static void appendNamespaceChooserLink(PresentationData presentation, boolean activate, @NlsContexts.Label String text2) {
        presentation.addText(text2, activate ? ACTIVE_LINK_ATTRS : INACTIVE_LINK_ATTRS);
    }

    @Nullable
    private static Couple<Integer> countNamespaces(@NotNull BasicNamespaceOwner namespaceOwner, @NotNull Project project) {
        if (namespaceOwner == null) {
            DbNodeDescriptor.$$$reportNull$$$0(52);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(53);
        }
        BasicModelRegistry registry = BasicModelRegistry.instance();
        BasicModel model2 = namespaceOwner.getModel();
        if (model2 == null) {
            return null;
        }
        LocalDataSource ds = registry.getLocalDataSource(model2);
        if (ds == null) {
            return null;
        }
        return DbNodeDescriptor.countNamespaces(namespaceOwner, ds);
    }

    @NotNull
    private static Couple<Integer> countNamespaces(@NotNull BasicNamespaceOwner namespaceOwner, @NotNull LocalDataSource dataSource2) {
        if (namespaceOwner == null) {
            DbNodeDescriptor.$$$reportNull$$$0(54);
        }
        if (dataSource2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(55);
        }
        TreePattern scope = dataSource2.getIntrospectionScope();
        Couple<Integer> couple = TreePatternUtils.countNamespaces(namespaceOwner, scope);
        if (couple == null) {
            DbNodeDescriptor.$$$reportNull$$$0(56);
        }
        return couple;
    }

    public static void addSpaceDelimiter(PresentationData presentation) {
        presentation.addText(spaceDelimiter, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    private static SimpleTextAttributes handleStatuses(@NotNull Project project, @NotNull PresentationData presentation, @NotNull BasicNode node2, @Nullable RawDataSource dataSource2, @NotNull DvTreeNodeDecoration decoration, @NotNull DvViewOptions viewOptions) {
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(57);
        }
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(58);
        }
        if (node2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(59);
        }
        if (decoration == null) {
            DbNodeDescriptor.$$$reportNull$$$0(60);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(61);
        }
        if (node2 instanceof BasicElement) {
            BasicElement element2 = (BasicElement)node2;
            return DbNodeDescriptor.handleStatusesOfElement(element2, dataSource2, decoration, viewOptions);
        }
        if (node2 instanceof DataSourceNode) {
            DataSourceNode dsn = (DataSourceNode)node2;
            return DbNodeDescriptor.handleStatusesOfDataSource(project, presentation, dsn, decoration);
        }
        return SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    private static SimpleTextAttributes handleStatusesOfDataSource(@NotNull Project project, @NotNull PresentationData presentation, @NotNull DataSourceNode dsn, @NotNull DvTreeNodeDecoration decoration) {
        boolean hasModel;
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(62);
        }
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(63);
        }
        if (dsn == null) {
            DbNodeDescriptor.$$$reportNull$$$0(64);
        }
        if (decoration == null) {
            DbNodeDescriptor.$$$reportNull$$$0(65);
        }
        boolean hasErrors = false;
        boolean hasWarnings = false;
        LocalDataSource lds = dsn.getLocalDataSource();
        BasicModel model2 = dsn.getModel();
        boolean bl = hasModel = model2 != null && model2.getRoot().hasChildren();
        if (hasModel) {
            Set<DataSourceProblem> problems = DataSourceProblemCache.getDataSourceProblems(dsn.dbDataSource);
            for (DataSourceProblem problem : problems) {
                switch (problem.getLevel()) {
                    case WARNING: {
                        hasWarnings = true;
                        break;
                    }
                    case ERROR: {
                        hasErrors = true;
                    }
                }
            }
        }
        boolean connected = lds != null && DbImplUtil.isConnected(project, lds);
        int connectionCount = connected ? DbImplUtil.getActiveConnectionCount(lds) : -1;
        int usageCount = DbImplUtilCore.countUsagesAsLinkedDataSource(project, dsn.rawDataSource.getUniqueId());
        SimpleTextAttributes style = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (decoration.dimmed) {
            style = SimpleTextAttributes.GRAY_ATTRIBUTES;
        }
        if (lds != null && !connected && !DbImplUtilCore.hasDriverFiles(lds)) {
            hasWarnings = true;
            DbNodeDescriptor.addTooltip(presentation, false, DatabaseBundle.message("tooltip.database.driver.files.not.found.open.properties.to.download", new Object[0]));
        }
        if (hasErrors || hasWarnings) {
            SimpleTextAttributes waved = new SimpleTextAttributes(8, null, (Color)(hasErrors ? JBColor.RED : JBColor.ORANGE));
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)waved);
        }
        if (connectionCount >= 0) {
            String message2 = DatabaseBundle.message("tooltip.choice.connection.connections", connectionCount, connectionCount == 1 ? 0 : 1);
            DbNodeDescriptor.addTooltip(presentation, false, message2);
        }
        if (usageCount > 0) {
            DbNodeDescriptor.addTooltip(presentation, false, DbImplUtilCore.usageAsLinkedDSMessage(usageCount));
        }
        return style;
    }

    /*
     * Unable to fully structure code
     */
    private static SimpleTextAttributes handleStatusesOfElement(@NotNull BasicElement element, @Nullable RawDataSource dataSource, @NotNull DvTreeNodeDecoration decoration, @NotNull DvViewOptions viewOptions) {
        if (element == null) {
            DbNodeDescriptor.$$$reportNull$$$0(66);
        }
        if (decoration == null) {
            DbNodeDescriptor.$$$reportNull$$$0(67);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(68);
        }
        invalid = element instanceof BasicSourceAware != false && (sa = (BasicSourceAware)element).isInvalid() != false;
        style = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (!(element instanceof BasicNamespace)) ** GOTO lbl-1000
        namespace = (BasicNamespace)element;
        if (viewOptions.getShowAllNamespaces() && !DbNodeDescriptorHelper.isInIntrospectionScope(namespace, dataSource)) {
            style = DbPresentationCore.INFO_ATTRS;
        } else if (decoration.dimmed) {
            style = SimpleTextAttributes.GRAY_ATTRIBUTES;
        } else if (DbPresentation.isUnnamed(element)) {
            style = DbPresentationCore.INFO_ATTRS;
        }
        if (invalid) {
            waved = new SimpleTextAttributes(8, null, (Color)JBColor.RED);
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)waved);
        }
        return style;
    }

    private static void showCount(@NotNull PresentationData presentation, @NotNull BasicNode node2, @NotNull DvTreeStructure treeStructure2, @NotNull MiniContext mc, @NotNull DvViewOptions viewOptions) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(69);
        }
        if (node2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(70);
        }
        if (treeStructure2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(71);
        }
        if (mc == null) {
            DbNodeDescriptor.$$$reportNull$$$0(72);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(73);
        }
        int n = DbNodeDescriptorHelper.countShowChildrenNum(node2, treeStructure2, viewOptions);
        DbNodeDescriptor.showCount(presentation, mc, n);
    }

    public static void showCount(@NotNull PresentationData presentation, @Nullable MiniContext mc, int count) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(74);
        }
        if (count > 0) {
            @NlsSafe String countStr = Integer.toString(count);
            DbNodeDescriptor.showCount(presentation, countStr);
            if (mc != null) {
                mc.countShown = true;
            }
        }
    }

    private static void showCount(@NotNull PresentationData presentation, @NotNull @NlsSafe String countStr) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(75);
        }
        if (countStr == null) {
            DbNodeDescriptor.$$$reportNull$$$0(76);
        }
        presentation.addText(countStr, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
    }

    private static void addTooltip(PresentationData presentation, boolean before2, @NlsContexts.Tooltip String tooltip) {
        Object result2;
        String cur = presentation.getTooltip();
        if (StringUtil.isEmpty((String)cur)) {
            result2 = tooltip;
        } else {
            String separator = "<p><p>";
            result2 = before2 ? tooltip + separator + cur : cur + separator + tooltip;
        }
        presentation.setTooltip((String)(((String)result2).startsWith("<html>") ? result2 : "<html>" + (String)result2));
    }

    @Nullable
    public static Object getDataSlow(@NonNls @NotNull String dataId, @NotNull Project project, @NotNull Supplier<?> nodeGetter) {
        if (dataId == null) {
            DbNodeDescriptor.$$$reportNull$$$0(77);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(78);
        }
        if (nodeGetter == null) {
            DbNodeDescriptor.$$$reportNull$$$0(79);
        }
        if (VcsDataKeys.VIRTUAL_FILES.is(dataId)) {
            return DbNodeDescriptor.getVirtualFiles(DbNodeDescriptor.asDbElement(project, nodeGetter.get()));
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return DbNodeDescriptor.getNavigatable(project, nodeGetter.get());
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            Object node2 = nodeGetter.get();
            DbElement db2 = DbNodeDescriptor.asDbElement(project, node2);
            return db2 != null ? db2 : ObjectUtils.tryCast(node2, PsiElement.class);
        }
        return null;
    }

    @Nullable
    private static Navigatable getNavigatable(@NotNull Project project, @Nullable Object node2) {
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(80);
        }
        if (node2 == null) {
            return null;
        }
        DbElement db2 = DbNodeDescriptor.asDbElement(project, node2);
        if (db2 != null) {
            return DbNavigationUtils.createFromTreeNavigatable(db2);
        }
        DbModelRegistry modelRegistry2 = (DbModelRegistry)project.getService(DbModelRegistry.class);
        if (node2 instanceof HostFamily) {
            return DbNodeDescriptor.createFamilyNavigatable(modelRegistry2, (HostFamily)node2);
        }
        if (node2 instanceof DvErsatzFamilyNode) {
            return DbNodeDescriptor.createFamilyNavigatable(modelRegistry2, (DvErsatzFamilyNode)node2);
        }
        return (Navigatable)ObjectUtils.tryCast((Object)node2, Navigatable.class);
    }

    @Nullable
    private static List<VirtualFile> getVirtualFiles(@Nullable DbElement e2) {
        LocalDataSource lds;
        SqlDataSource sqlDs2;
        SqlDataSource sqlDataSource = sqlDs2 = e2 == null ? null : DbImplUtilCore.getMaybeSqlDataSource(e2.getDataSource());
        if (sqlDs2 != null) {
            return DbNodeDescriptor.getFilesForSqlDataSource(e2, sqlDs2);
        }
        LocalDataSource localDataSource = lds = e2 == null ? null : DbImplUtilCore.getMaybeLocalDataSource(e2.getDataSource());
        if (lds != null) {
            return DbNodeDescriptor.getFilesForLocalDataSource(e2, lds);
        }
        return null;
    }

    @Nullable
    private static List<VirtualFile> getFilesForLocalDataSource(@NotNull DbElement e2, @NotNull LocalDataSource ds) {
        if (e2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(81);
        }
        if (ds == null) {
            DbNodeDescriptor.$$$reportNull$$$0(82);
        }
        String filePath = DbSrcUtils.getPath(e2.getProject(), ds, e2, ds.getModel(), DbSrcFileSystemCore.ItemType.SRC);
        VirtualFile file = DbSrcFileSystem.getInstance().findFileByPath(filePath);
        if (file == null) {
            filePath = DbSrcUtils.getPath(e2.getProject(), ds, e2, ds.getModel(), null);
            file = DbSrcFileSystem.getInstance().findFileByPath(filePath);
        }
        return file == null ? null : Collections.singletonList(file);
    }

    @Nullable
    private static List<VirtualFile> getFilesForSqlDataSource(@NotNull DbElement e2, @NotNull SqlDataSource sqlDs2) {
        if (e2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(83);
        }
        if (sqlDs2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(84);
        }
        if (e2 instanceof DbDataSource) {
            return sqlDs2.getRoots();
        }
        DasObject object = sqlDs2.fromModel((DasObject)e2.getDelegate());
        PsiElement element2 = (PsiElement)ObjectUtils.tryCast((Object)object, PsiElement.class);
        PsiFile f = element2 == null ? null : element2.getContainingFile();
        VirtualFile file = f == null ? null : f.getViewProvider().getVirtualFile();
        return file == null ? null : Collections.singletonList(file);
    }

    @Nullable
    private static DbElement asDbElement(@NotNull Project project, @Nullable Object node2) {
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(85);
        }
        if (node2 == null) {
            return null;
        }
        if (node2 instanceof DbElement) {
            return (DbElement)node2;
        }
        if (node2 instanceof DataSourceNode) {
            return ((DataSourceNode)node2).dbDataSource;
        }
        DbModelRegistry modelRegistry2 = (DbModelRegistry)project.getService(DbModelRegistry.class);
        if (node2 instanceof BasicElement) {
            return modelRegistry2.findDbElement((BasicElement)node2);
        }
        if (node2 instanceof DasObject) {
            DbDataSource ds = modelRegistry2.findDbDataSource((DasObject)node2);
            return ds == null ? null : ds.findElement((DasObject)node2);
        }
        return null;
    }

    @Nullable
    private static NavigationItem createFamilyNavigatable(DbModelRegistry modelRegistry2, FamilyWithId bn) {
        DvHostNode hn = (DvHostNode)ObjectUtils.tryCast((Object)bn, DvHostNode.class);
        DbElement host = hn == null ? null : modelRegistry2.findDbElement((BasicElement)hn.host);
        return host == null ? null : DbNavigationUtils.createFromTreeFamilyNavigatable(host, bn.getFamilyId().getFakeKind());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 40, 56 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: 
            case 6: 
            case 30: 
            case 59: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 14: 
            case 17: 
            case 24: 
            case 28: 
            case 43: 
            case 53: 
            case 57: 
            case 62: 
            case 78: 
            case 80: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 8: 
            case 16: 
            case 21: 
            case 26: 
            case 29: 
            case 61: 
            case 68: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewOptions";
                break;
            }
            case 4: 
            case 11: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStructure";
                break;
            }
            case 7: 
            case 32: 
            case 60: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoration";
                break;
            }
            case 10: 
            case 13: 
            case 19: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionService";
                break;
            }
            case 23: 
            case 46: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dsn";
                break;
            }
            case 25: 
            case 35: 
            case 39: 
            case 44: 
            case 47: 
            case 50: 
            case 51: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mc";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeText";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafKind";
                break;
            }
            case 40: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DbNodeDescriptor";
                break;
            }
            case 42: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceOwner";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "counters";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "countStr";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeGetter";
                break;
            }
            case 81: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlDs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DbNodeDescriptor";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustCommentString";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "countNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "decorateNode";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateLinkObjectPresentation";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentationAdditions";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentationForDataSource";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setNodePrimaryText";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentationForEmptyScopeLeaf";
                break;
            }
            case 40: 
            case 56: {
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "appendNamespaceChooserLinkWithCounters";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "appendNamespaceChooserLinkWithoutCounters";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "countNamespaces";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "handleStatuses";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "handleStatusesOfDataSource";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "handleStatusesOfElement";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "showCount";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getDataSlow";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getFilesForLocalDataSource";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getFilesForSqlDataSource";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "asDbElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 40, 56 -> new IllegalStateException(string);
        };
    }

    private static class MiniContext {
        boolean countShown = false;

        private MiniContext() {
        }
    }

    @Service(value={Service.Level.PROJECT})
    public static final class DataSourceProblemCache
    implements Disposable {
        private final Project myProject;
        private final ExecutorService myExecutor;
        private final Map<DbDataSource, AsyncCachedValue<Set<DataSourceProblem>>> myCache;

        public DataSourceProblemCache(@NotNull Project project) {
            if (project == null) {
                DataSourceProblemCache.$$$reportNull$$$0(0);
            }
            this.myExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"DataSourceProblemCache", (int)1);
            this.myCache = ConcurrentFactoryMap.createWeakMap(ds -> new AsyncCachedValue(Collections.emptySet()));
            this.myProject = project;
            this.myProject.getMessageBus().connect((Disposable)this).subscribe(DbPsiFacade.TOPIC, (Object)new DbPsiFacade.Listener(){

                @Override
                public void onChanged(@Nullable DbDataSource source) {
                    if (source == null) {
                        for (AsyncCachedValue<Set<DataSourceProblem>> value2 : myCache.values()) {
                            value2.invalidate();
                        }
                    } else {
                        myCache.get(source).invalidate();
                    }
                }
            });
        }

        public void dispose() {
            this.myExecutor.shutdownNow();
        }

        private static Set<DataSourceProblem> getDataSourceProblems(@NotNull DbDataSource dataSource2) {
            if (dataSource2 == null) {
                DataSourceProblemCache.$$$reportNull$$$0(1);
            }
            return ((DataSourceProblemCache)dataSource2.getProject().getService(DataSourceProblemCache.class)).getProblems(dataSource2);
        }

        private Set<DataSourceProblem> getProblems(@NotNull DbDataSource dataSource2) {
            if (dataSource2 == null) {
                DataSourceProblemCache.$$$reportNull$$$0(2);
            }
            RawDataSource rawDs = dataSource2.getDelegate();
            return this.myCache.get(dataSource2).getValue(() -> this.getProblemsAsync(rawDs));
        }

        @NotNull
        private CompletableFuture<Set<DataSourceProblem>> getProblemsAsync(@NotNull RawDataSource dataSource2) {
            if (dataSource2 == null) {
                DataSourceProblemCache.$$$reportNull$$$0(3);
            }
            CompletableFuture<Set<DataSourceProblem>> res2 = CompletableFuture.supplyAsync(() -> DatabaseConfigValidator.getProblems(this.myProject, dataSource2, null), this.myExecutor);
            res2.whenComplete((r, th) -> {
                if (r != null) {
                    DatabaseView.getDatabaseView(this.myProject).repaint();
                }
            });
            CompletableFuture<Set<DataSourceProblem>> completableFuture = res2;
            if (completableFuture == null) {
                DataSourceProblemCache.$$$reportNull$$$0(4);
            }
            return completableFuture;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DbNodeDescriptor$DataSourceProblemCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DbNodeDescriptor$DataSourceProblemCache";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProblemsAsync";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataSourceProblems";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getProblems";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getProblemsAsync";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

