/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u001b\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0007\u00a2\u0006\u0002\b\u0013J\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tJ\u0006\u0010\u0016\u001a\u00020\u000eJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0001J\u0006\u0010\u001c\u001a\u00020\u0018J\u0006\u0010\u001d\u001a\u00020\u0018R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/view/DatabaseTreeContext;", "", "project", "Lcom/intellij/openapi/project/Project;", "refresher", "Ljava/lang/Runnable;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Runnable;)V", "cutDataSourcesIds", "Ljava/util/concurrent/atomic/AtomicReference;", "", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "assignCutDataSources", "", "dataSources", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "dataSourceIds", "assignCutDataSourcesIds", "clearCut", "getCutDataSourcesIds", "invokeRefresh", "isDataSourceCut", "", "dataSource", "isNodeCut", "node", "isSomeDataSourceCut", "isSomethingCut", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseTreeContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseTreeContext.kt\ncom/intellij/database/view/DatabaseTreeContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1549#2:75\n1620#2,3:76\n*S KotlinDebug\n*F\n+ 1 DatabaseTreeContext.kt\ncom/intellij/database/view/DatabaseTreeContext\n*L\n21#1:75\n21#1:76,3\n*E\n"})
public final class DatabaseTreeContext {
    @NotNull
    private final Project project;
    @NotNull
    private final Runnable refresher;
    @NotNull
    private volatile AtomicReference<Set<String>> cutDataSourcesIds;

    public DatabaseTreeContext(@NotNull Project project, @NotNull Runnable refresher) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)refresher, (String)"refresher");
        this.project = project;
        this.refresher = refresher;
        this.cutDataSourcesIds = new AtomicReference<Object>(null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    public final void assignCutDataSources(@NotNull Iterable<? extends LocalDataSource> dataSources2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(dataSources2, (String)"dataSources");
        Iterable<? extends LocalDataSource> iterable = dataSources2;
        DatabaseTreeContext databaseTreeContext = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            LocalDataSource localDataSource = (LocalDataSource)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String string = it2.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
            collection2.add(string);
        }
        databaseTreeContext.assignCutDataSourcesIds((List)destination$iv$iv);
    }

    @JvmName(name="assignCutDataSourcesIds")
    public final void assignCutDataSourcesIds(@NotNull Iterable<String> dataSourceIds) {
        Intrinsics.checkNotNullParameter(dataSourceIds, (String)"dataSourceIds");
        Set set = CollectionsKt.toSet(dataSourceIds);
        if (set.isEmpty()) {
            Set was = this.cutDataSourcesIds.getAndSet(null);
            if (was != null) {
                this.invokeRefresh();
            }
        } else {
            this.cutDataSourcesIds.set(set);
            this.invokeRefresh();
        }
    }

    public final boolean isSomethingCut() {
        return this.isSomeDataSourceCut();
    }

    public final boolean isSomeDataSourceCut() {
        return this.cutDataSourcesIds.get() != null;
    }

    public final boolean isNodeCut(@NotNull Object node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Object o2 = node2 instanceof DbElement ? DbImplUtil.unwrap((DasObject)node2) : node2;
        if (o2 == null) {
            return false;
        }
        return o2 instanceof LocalDataSource ? this.isDataSourceCut((LocalDataSource)o2) : false;
    }

    private final boolean isDataSourceCut(LocalDataSource dataSource2) {
        Set<String> set = this.cutDataSourcesIds.get();
        return set != null && set.contains(dataSource2.getUniqueId());
    }

    @Nullable
    public final Set<String> getCutDataSourcesIds() {
        return this.cutDataSourcesIds.get();
    }

    public final void clearCut() {
        this.assignCutDataSourcesIds(SetsKt.emptySet());
    }

    public final void invokeRefresh() {
        this.refresher.run();
    }
}

