/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.InterruptibleDatabaseConnectionKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.AbstractDatabaseModifier;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseRefactoringHandler
extends AbstractDatabaseModifier {
    @NotNull
    private final RefactoringExecutor myRefactoringExecutor;

    public DatabaseRefactoringHandler(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable SearchPath searchPath) {
        if (project == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(1);
        }
        super(project, dataSource2, searchPath, DGDepartment.REFACTORING, DatabaseBundle.message("progress.title.updating.database", new Object[0]));
        this.myRefactoringExecutor = new RefactoringExecutor(project, dataSource2);
    }

    @NotNull
    public DatabaseRefactoringHandler setStatement(@NotNull String statement2) {
        if (statement2 == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(2);
        }
        this.myRefactoringExecutor.setStatement(statement2);
        DatabaseRefactoringHandler databaseRefactoringHandler = this;
        if (databaseRefactoringHandler == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(3);
        }
        return databaseRefactoringHandler;
    }

    @NotNull
    public String getStatement() {
        String string = this.myRefactoringExecutor.getStatement();
        if (string == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    protected AbstractDatabaseModifier.QueryExecutor getExecutor() {
        RefactoringExecutor refactoringExecutor = this.myRefactoringExecutor;
        if (refactoringExecutor == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(5);
        }
        return refactoringExecutor;
    }

    private static int executeQueries(@NotNull Project project, @NotNull DatabaseConnection connection2, @Nullable SearchPath path, @NotNull List<String> queries, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(6);
        }
        if (connection2 == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(7);
        }
        if (queries == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(9);
        }
        int totalCount = queries.size();
        int count = 0;
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        Consumer<String> errorChecker = DatabaseRefactoringHandler.createErrorChecker(project, connection2, path);
        try (ReusableSmartStatement<String> statement2 = SmartStatements.poweredBy(connection2).simple().reuse();){
            for (String query : queries) {
                if (StringUtil.isEmptyOrSpaces((String)query)) {
                    ++count;
                    continue;
                }
                indicator.checkCanceled();
                try {
                    statement2.barren().execute(query, StandardExecutionMode.UPDATE);
                    indicator.setFraction((double)(++count) / (double)totalCount);
                    errorChecker.accept(query);
                }
                catch (Exception e2) {
                    int n = count;
                    if (statement2 != null) {
                        statement2.close();
                    }
                    return n;
                }
            }
        }
        indicator.setIndeterminate(true);
        return count;
    }

    @NotNull
    private static Consumer<String> createErrorChecker(@NotNull Project project, @NotNull DatabaseConnection connection2, @Nullable SearchPath path) {
        JdbcConsole.RawErrorsObtainer errorsObtainer;
        if (project == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(10);
        }
        if (connection2 == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(11);
        }
        if ((errorsObtainer = (JdbcConsole.RawErrorsObtainer)ObjectUtils.tryCast((Object)JdbcConsole.createAdvancedErrorsObtainer(project, connection2.getConnectionPoint().getDataSource()), JdbcConsole.RawErrorsObtainer.class)) == null) {
            Consumer<String> consumer2 = q2 -> {};
            if (consumer2 == null) {
                DatabaseRefactoringHandler.$$$reportNull$$$0(12);
            }
            return consumer2;
        }
        AdvancedAuditService service = connection2.getAuditService();
        Consumer<String> consumer3 = q2 -> errorsObtainer.obtainErrors((String)q2, connection2, path, th -> service.warning((Throwable)th));
        if (consumer3 == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(13);
        }
        return consumer3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseRefactoringHandler";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queries";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseRefactoringHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setStatement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeQueries";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createErrorChecker";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 12, 13 -> new IllegalStateException(string);
        };
    }

    private static class RefactoringExecutor
    implements AbstractDatabaseModifier.QueryExecutor {
        @NotNull
        private String myStatement;
        private final Project myProject;
        @NotNull
        private final LocalDataSource myDataSource;

        RefactoringExecutor(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
            if (project == null) {
                RefactoringExecutor.$$$reportNull$$$0(0);
            }
            if (dataSource2 == null) {
                RefactoringExecutor.$$$reportNull$$$0(1);
            }
            this.myStatement = "";
            this.myProject = project;
            this.myDataSource = dataSource2;
        }

        public void setStatement(@NotNull String statement2) {
            if (statement2 == null) {
                RefactoringExecutor.$$$reportNull$$$0(2);
            }
            this.myStatement = statement2;
        }

        @NotNull
        public String getStatement() {
            String string = this.myStatement;
            if (string == null) {
                RefactoringExecutor.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public AsyncTask<Boolean> execute(@NotNull ProgressIndicator indicator, @NotNull DatabaseSessionManager.Facade facade, @NotNull ErrorHandler errorHandler) {
            if (indicator == null) {
                RefactoringExecutor.$$$reportNull$$$0(4);
            }
            if (facade == null) {
                RefactoringExecutor.$$$reportNull$$$0(5);
            }
            if (errorHandler == null) {
                RefactoringExecutor.$$$reportNull$$$0(6);
            }
            return AsyncTask.frame(DatabaseBundle.message("progress.title.execute", new Object[0])).computeAsync(null, () -> facade.runAsync(connection2 -> {
                Ref res2 = Ref.create();
                InterruptibleDatabaseConnectionKt.withCancelling(connection2, indicator, (Function0<Unit>)((Function0)() -> {
                    indicator.setText(DatabaseBundle.message("progress.text.updating.database", new Object[0]));
                    res2.set((Object)this.execute(indicator, (DatabaseConnection)connection2, facade.getPath()));
                    return null;
                }));
                return Boolean.TRUE.equals(res2.get());
            }));
        }

        public boolean execute(@NotNull ProgressIndicator indicator, @NotNull DatabaseConnection connection2, @Nullable SearchPath path) {
            List<String> queries;
            if (indicator == null) {
                RefactoringExecutor.$$$reportNull$$$0(7);
            }
            if (connection2 == null) {
                RefactoringExecutor.$$$reportNull$$$0(8);
            }
            return (queries = DbSqlUtilCore.getQueries(this.myStatement, this.myProject, DbSqlUtilCore.getLanguage(this.myDataSource))).size() == DatabaseRefactoringHandler.executeQueries(this.myProject, connection2, path, queries, indicator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseRefactoringHandler$RefactoringExecutor";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facade";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorHandler";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseRefactoringHandler$RefactoringExecutor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setStatement";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

