/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.structure.DvTreeStructure;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.JBIterable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0017J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017J\u0014\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0017J\u0010\u0010!\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\"\u001a\u00020\u0017J\u0010\u0010#\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001b\u001a\u00020\u0001R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/intellij/database/view/DatabaseNavBarService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "dv", "Lcom/intellij/database/view/DatabaseView;", "getDv", "()Lcom/intellij/database/view/DatabaseView;", "dv$delegate", "Lkotlin/Lazy;", "treeStructure", "Lcom/intellij/database/view/structure/DvTreeStructure;", "getTreeStructure", "()Lcom/intellij/database/view/structure/DvTreeStructure;", "treeStructure$delegate", "wrappingService", "Lcom/intellij/database/view/DatabaseNodeWrappingService;", "getWrappingService", "()Lcom/intellij/database/view/DatabaseNodeWrappingService;", "wrappingService$delegate", "getChildren", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/psi/PsiElement;", "wrapper", "getLeafElement", "getNodeChildren", "node", "Lcom/intellij/database/model/basic/BasicNode;", "getNodeDisplayText", "", "getNodeParent", "getParent", "unwrap", "w", "wrap", "Companion", "intellij.database.impl"})
public final class DatabaseNavBarService {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy dv$delegate;
    @NotNull
    private final Lazy treeStructure$delegate;
    @NotNull
    private final Lazy wrappingService$delegate;
    @Deprecated
    public static final int nameTextLimit = 40;

    public DatabaseNavBarService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.dv$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DatabaseView>(this){
            final /* synthetic */ DatabaseNavBarService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final DatabaseView invoke() {
                return DatabaseView.getDatabaseView(DatabaseNavBarService.access$getProject$p(this.this$0));
            }
        }));
        this.treeStructure$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DvTreeStructureService>(this){
            final /* synthetic */ DatabaseNavBarService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DvTreeStructureService invoke() {
                ComponentManager $this$service$iv = (ComponentManager)DatabaseNavBarService.access$getProject$p(this.this$0);
                boolean $i$f$service = false;
                Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                return (DvTreeStructureService)object;
            }
        }));
        this.wrappingService$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DatabaseNodeWrappingService>(this){
            final /* synthetic */ DatabaseNavBarService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DatabaseNodeWrappingService invoke() {
                ComponentManager $this$service$iv = (ComponentManager)DatabaseNavBarService.access$getProject$p(this.this$0);
                boolean $i$f$service = false;
                Class<DatabaseNodeWrappingService> serviceClass$iv = DatabaseNodeWrappingService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                return (DatabaseNodeWrappingService)object;
            }
        }));
    }

    private final DatabaseView getDv() {
        Lazy lazy = this.dv$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (DatabaseView)object;
    }

    private final DvTreeStructure getTreeStructure() {
        Lazy lazy = this.treeStructure$delegate;
        return (DvTreeStructure)lazy.getValue();
    }

    private final DatabaseNodeWrappingService getWrappingService() {
        Lazy lazy = this.wrappingService$delegate;
        return (DatabaseNodeWrappingService)lazy.getValue();
    }

    @Nullable
    public final PsiElement getLeafElement() {
        JBIterable<BasicNode> jBIterable = this.getDv().getSelectedNodes();
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getSelectedNodes(...)");
        JBIterable<BasicNode> selectedNodes2 = jBIterable;
        BasicNode basicNode = (BasicNode)selectedNodes2.single();
        if (basicNode == null) {
            return null;
        }
        BasicNode selectedNode = basicNode;
        return this.wrap(selectedNode);
    }

    @Nullable
    public final PsiElement getParent(@NotNull PsiElement wrapper) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        BasicNode basicNode = this.unwrap(wrapper);
        if (basicNode == null) {
            return null;
        }
        BasicNode node2 = basicNode;
        Object object = this.getNodeParent(node2);
        if (object == null) {
            return null;
        }
        Object parent2 = object;
        PsiElement parentWrapper = this.wrap(parent2);
        return parentWrapper;
    }

    @NotNull
    public final JBIterable<PsiElement> getChildren(@NotNull PsiElement wrapper) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        BasicNode basicNode = this.unwrap(wrapper);
        if (basicNode == null) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        BasicNode node2 = basicNode;
        JBIterable jBIterable = this.getNodeChildren(node2).filterMap(arg_0 -> DatabaseNavBarService.getChildren$lambda$0((Function1)new Function1<Object, PsiElement>((Object)this){

            @Nullable
            public final PsiElement invoke(@NotNull Object p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((DatabaseNavBarService)this.receiver).wrap(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
        return jBIterable;
    }

    private final Object getNodeParent(BasicNode node2) {
        return this.getTreeStructure().parentOf(node2);
    }

    private final JBIterable<?> getNodeChildren(BasicNode node2) {
        return this.getTreeStructure().childrenOf(node2);
    }

    @Nullable
    public final PsiElement wrap(@NotNull Object node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Object object = node2;
        return object instanceof BasicNode ? this.getWrappingService().wrap((BasicNode)node2) : (object instanceof PsiElement ? (PsiElement)node2 : null);
    }

    @Nullable
    public final BasicNode unwrap(@NotNull PsiElement w) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        return this.getWrappingService().unwrap(w);
    }

    @Nls
    @NotNull
    public final String getNodeDisplayText(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        String text2 = this.getTreeStructure().presentableNameOf(node2);
        if (text2.length() > 40) {
            String string = StringUtil.shortenTextWithEllipsis((String)text2, (int)40, (int)10, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
            text2 = string;
        }
        return text2;
    }

    private static final PsiElement getChildren$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PsiElement)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(DatabaseNavBarService $this) {
        return $this.project;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/view/DatabaseNavBarService$Companion;", "", "()V", "nameTextLimit", "", "intellij.database.impl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

