/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\"\u001a\u00020\fH\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0006\u0010%\u001a\u00020\u0010J\b\u0010&\u001a\u00020\fH\u0016R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001c8GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001d\u0010\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u00020!8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/database/view/DataSourceNode;", "Lcom/intellij/database/model/basic/BasicNode;", "dbDataSource", "Lcom/intellij/database/psi/DbDataSource;", "(Lcom/intellij/database/psi/DbDataSource;)V", "getDbDataSource$annotations", "()V", "dbms", "Lcom/intellij/database/Dbms;", "getDbms", "()Lcom/intellij/database/Dbms;", "groupName", "", "getGroupName", "()Ljava/lang/String;", "levelAutoSelectable", "", "getLevelAutoSelectable", "()Z", "localDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "getLocalDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "modelRoot", "Lcom/intellij/database/model/basic/BasicRoot;", "getModelRoot", "()Lcom/intellij/database/model/basic/BasicRoot;", "project", "Lcom/intellij/openapi/project/Project;", "getProject$annotations", "getProject", "()Lcom/intellij/openapi/project/Project;", "rawDataSource", "Lcom/intellij/database/model/RawDataSource;", "getDisplayName", "getModel", "Lcom/intellij/database/model/basic/BasicModel;", "isIntrospectable", "toString", "Companion", "intellij.database.core.impl"})
public final class DataSourceNode
implements BasicNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final RawDataSource rawDataSource;
    @JvmField
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public final DbDataSource dbDataSource;
    @NotNull
    private static final Key<DataSourceNode> DATA_SOURCE_NODE;
    @NotNull
    private static final Object syncObject;

    @Deprecated(message="Use rawDataSource instead", replaceWith=@ReplaceWith(expression="rawDataSource", imports={}))
    public static /* synthetic */ void getDbDataSource$annotations() {
    }

    @Deprecated(message="Pass a project instance separately", replaceWith=@ReplaceWith(expression="project", imports={}))
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public final Project getProject() {
        Project project = this.dbDataSource.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    @Deprecated(message="Pass a project instance separately", replaceWith=@ReplaceWith(expression="project", imports={}))
    public static /* synthetic */ void getProject$annotations() {
    }

    @NotNull
    public final Dbms getDbms() {
        Dbms dbms = this.rawDataSource.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        return dbms;
    }

    @Nullable
    public final BasicRoot getModelRoot() {
        BasicModel basicModel = this.getModel();
        return basicModel != null ? basicModel.getRoot() : null;
    }

    @Nullable
    public final String getGroupName() {
        return this.rawDataSource.getGroupName();
    }

    @Nullable
    public final LocalDataSource getLocalDataSource() {
        RawDataSource rawDataSource = this.rawDataSource;
        return rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
    }

    public DataSourceNode(@NotNull DbDataSource dbDataSource) {
        Intrinsics.checkNotNullParameter((Object)dbDataSource, (String)"dbDataSource");
        RawDataSource rawDataSource = dbDataSource.getDelegateDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)rawDataSource, (String)"getDelegateDataSource(...)");
        this.rawDataSource = rawDataSource;
        this.dbDataSource = dbDataSource;
    }

    @Override
    @Nullable
    public BasicModel getModel() {
        DasModel dasModel = this.rawDataSource.getModel();
        return dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.rawDataSource.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public String toString() {
        return this.rawDataSource.getName() + ": DSN";
    }

    public final boolean isIntrospectable() {
        DasModel dasModel = this.rawDataSource.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)dasModel, (String)"getModel(...)");
        DasModel model2 = dasModel;
        if (model2 instanceof BasicModel) {
            return true;
        }
        return Intrinsics.areEqual((Object)model2.getMetaModel(), (Object)MetaModel.EMPTY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getLevelAutoSelectable() {
        if (!(this.rawDataSource instanceof LocalDataSource)) return false;
        Dbms dbms = ((LocalDataSource)this.rawDataSource).getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        if (!DBIntrospectorFeatures.supportsMultilevelIntrospection(dbms)) return false;
        return true;
    }

    @JvmStatic
    @NotNull
    public static final DataSourceNode node(@NotNull DbDataSource $this$node) {
        return Companion.node($this$node);
    }

    static {
        Key key2 = Key.create((String)"DATA_SOURCE_NODE");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        DATA_SOURCE_NODE = key2;
        syncObject = new Object();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\n\u001a\u00020\u0005*\u00020\u000bH\u0007R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u0016\u0010\u0007\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/database/view/DataSourceNode$Companion;", "", "()V", "DATA_SOURCE_NODE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/database/view/DataSourceNode;", "getDATA_SOURCE_NODE$annotations", "syncObject", "Ljava/lang/Object;", "getSyncObject$annotations", "node", "Lcom/intellij/database/psi/DbDataSource;", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getDATA_SOURCE_NODE$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getSyncObject$annotations() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final DataSourceNode node(@NotNull DbDataSource $this$node) {
            Intrinsics.checkNotNullParameter((Object)$this$node, (String)"<this>");
            Object attachedNode = null;
            attachedNode = $this$node.getUserData(DATA_SOURCE_NODE);
            if (attachedNode == null) {
                Object object = syncObject;
                synchronized (object) {
                    boolean bl = false;
                    attachedNode = $this$node.getUserData(DATA_SOURCE_NODE);
                    if (attachedNode == null) {
                        attachedNode = new DataSourceNode($this$node);
                        $this$node.putUserData(DATA_SOURCE_NODE, attachedNode);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            return (DataSourceNode)attachedNode;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

