/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CommentQueryGenerator {
    private final Project myProject;
    private final BasicModel myModel;
    private final BasicNamedElement myElement;
    private final BasicModModel myTargetModel;
    private final BasicModNamedElement myTargetElement;
    private final ScriptGenerator myScriptGenerator;
    private final List<ElementDelta<?>> myCorrespondence;
    private BasicNamespace myCurrentNamespace;
    private ScriptingOptions myOptions;

    public CommentQueryGenerator(@NotNull Project project, @NotNull BasicModel model2, @NotNull BasicNamedElement element2) {
        if (project == null) {
            CommentQueryGenerator.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            CommentQueryGenerator.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            CommentQueryGenerator.$$$reportNull$$$0(2);
        }
        this.myOptions = DefaultScriptingOptions.INSTANCE;
        this.myProject = project;
        this.myModel = model2;
        this.myElement = element2;
        this.myTargetModel = new ModelFactory(new MemoryTextStorage()).createModel(((BasicMetaModel)model2.getMetaModel()).dbms);
        this.myCorrespondence = new ArrayList();
        this.myTargetElement = (BasicModNamedElement)ModelLightCopier.copy(this.myTargetModel, element2, true);
        BasicElement e1 = this.myElement;
        for (BasicElement e2 = this.myTargetElement; e1 != null && e2 != null; e1 = e1.getParent(), e2 = e2.getParent()) {
            if (e1.getKind() == ObjectKind.ROOT) continue;
            this.myCorrespondence.add(ElementDelta.create(e1, e2));
        }
        this.myScriptGenerator = ScriptGenerators.INSTANCE.byModel(model2);
    }

    public void setOptions(ScriptingOptions options2) {
        this.myOptions = options2;
    }

    public ScriptingOptions getOptions() {
        return this.myOptions;
    }

    @NotNull
    public ScriptingResult generate(@Nullable String newComment, @Nullable Version ver) {
        this.myTargetModel.modify(BasicModRoot.class, r -> this.myTargetElement.setComment(newComment));
        ScriptingResult scriptingResult = this.myScriptGenerator.makeScript(this.myProject, this.createTask(ver));
        if (scriptingResult == null) {
            CommentQueryGenerator.$$$reportNull$$$0(3);
        }
        return scriptingResult;
    }

    public static boolean canComment(@NotNull BasicModel model2, @NotNull BasicNamedElement element2) {
        if (model2 == null) {
            CommentQueryGenerator.$$$reportNull$$$0(4);
        }
        if (element2 == null) {
            CommentQueryGenerator.$$$reportNull$$$0(5);
        }
        return CommentQueryGenerator.canComment(model2, element2, model2.getRoot().getServerVersion());
    }

    public static boolean canComment(@NotNull BasicModel model2, @NotNull BasicNamedElement element2, @Nullable Version ver) {
        if (model2 == null) {
            CommentQueryGenerator.$$$reportNull$$$0(6);
        }
        if (element2 == null) {
            CommentQueryGenerator.$$$reportNull$$$0(7);
        }
        return CommentQueryGenerator.getCapabilities(model2, element2).getAlterComment().get(ver);
    }

    public boolean isRenamed() {
        return !this.myTargetElement.getName().equals(this.myElement.getName());
    }

    @NotNull
    public ScriptingResult generate(@Nullable String newComment) {
        ScriptingResult scriptingResult = this.generate(newComment, this.myModel.getRoot().getServerVersion());
        if (scriptingResult == null) {
            CommentQueryGenerator.$$$reportNull$$$0(8);
        }
        return scriptingResult;
    }

    @NotNull
    public static ScriptingCapabilities getCapabilities(@NotNull BasicModel model2, @NotNull BasicElement element2) {
        if (model2 == null) {
            CommentQueryGenerator.$$$reportNull$$$0(9);
        }
        if (element2 == null) {
            CommentQueryGenerator.$$$reportNull$$$0(10);
        }
        ScriptingCapabilities scriptingCapabilities = ScriptGenerators.INSTANCE.byModel(model2).capabilities(element2);
        if (scriptingCapabilities == null) {
            CommentQueryGenerator.$$$reportNull$$$0(11);
        }
        return scriptingCapabilities;
    }

    @TestOnly
    @NotNull
    public BasicNamedElement getTargetElement() {
        BasicModNamedElement basicModNamedElement = this.myTargetElement;
        if (basicModNamedElement == null) {
            CommentQueryGenerator.$$$reportNull$$$0(12);
        }
        return basicModNamedElement;
    }

    @NotNull
    public ScriptingAlterTask createTask(@Nullable Version ver) {
        ScriptingAlterTaskBuilder builder = new ScriptingAlterTaskBuilder(this.myModel, this.myTargetModel);
        builder.setCorrespondence(this.myCorrespondence);
        builder.setCurrentNamespace(this.myCurrentNamespace);
        builder.setOptions(this.myOptions);
        if (ver != null) {
            builder.setVersion(ver);
        }
        ScriptingAlterTask scriptingAlterTask = builder.build();
        if (scriptingAlterTask == null) {
            CommentQueryGenerator.$$$reportNull$$$0(13);
        }
        return scriptingAlterTask;
    }

    @Nullable
    public BasicElement getCurrentNamespace() {
        return this.myCurrentNamespace;
    }

    public void setCurrentNamespace(@Nullable BasicNamespace currentNamespace) {
        assert (currentNamespace == null || this.myModel.contains(currentNamespace));
        this.myCurrentNamespace = currentNamespace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/CommentQueryGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/CommentQueryGenerator";
                break;
            }
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapabilities";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetElement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canComment";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCapabilities";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

