/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.util.Version;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/util/VersionRange;", "", "fromVersion", "Lcom/intellij/database/util/Version;", "untilVersion", "(Lcom/intellij/database/util/Version;Lcom/intellij/database/util/Version;)V", "getFromVersion", "()Lcom/intellij/database/util/Version;", "getUntilVersion", "component1", "component2", "contains", "", "version", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "intellij.database"})
public final class VersionRange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Version fromVersion;
    @NotNull
    private final Version untilVersion;

    public VersionRange(@NotNull Version fromVersion, @NotNull Version untilVersion) {
        Intrinsics.checkNotNullParameter((Object)fromVersion, (String)"fromVersion");
        Intrinsics.checkNotNullParameter((Object)untilVersion, (String)"untilVersion");
        this.fromVersion = fromVersion;
        this.untilVersion = untilVersion;
    }

    @NotNull
    public final Version getFromVersion() {
        return this.fromVersion;
    }

    @NotNull
    public final Version getUntilVersion() {
        return this.untilVersion;
    }

    public final boolean contains(@NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return this.fromVersion.compareTo(version) <= 0 && (version.compareTo(this.untilVersion) < 0 || this.untilVersion.isOrGreater(Version.INFINITY));
    }

    @NotNull
    public final Version component1() {
        return this.fromVersion;
    }

    @NotNull
    public final Version component2() {
        return this.untilVersion;
    }

    @NotNull
    public final VersionRange copy(@NotNull Version fromVersion, @NotNull Version untilVersion) {
        Intrinsics.checkNotNullParameter((Object)fromVersion, (String)"fromVersion");
        Intrinsics.checkNotNullParameter((Object)untilVersion, (String)"untilVersion");
        return new VersionRange(fromVersion, untilVersion);
    }

    public static /* synthetic */ VersionRange copy$default(VersionRange versionRange, Version version, Version version2, int n, Object object) {
        if ((n & 1) != 0) {
            version = versionRange.fromVersion;
        }
        if ((n & 2) != 0) {
            version2 = versionRange.untilVersion;
        }
        return versionRange.copy(version, version2);
    }

    @NotNull
    public String toString() {
        return "VersionRange(fromVersion=" + this.fromVersion + ", untilVersion=" + this.untilVersion + ")";
    }

    public int hashCode() {
        int result2 = this.fromVersion.hashCode();
        result2 = result2 * 31 + this.untilVersion.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VersionRange)) {
            return false;
        }
        VersionRange versionRange = (VersionRange)other;
        if (!Intrinsics.areEqual((Object)this.fromVersion, (Object)versionRange.fromVersion)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.untilVersion, (Object)versionRange.untilVersion);
    }

    @JvmStatic
    @NotNull
    public static final VersionRange after(@NotNull Version version) {
        return Companion.after(version);
    }

    @JvmStatic
    @NotNull
    public static final VersionRange before(@NotNull Version version) {
        return Companion.before(version);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/util/VersionRange$Companion;", "", "()V", "after", "Lcom/intellij/database/util/VersionRange;", "version", "Lcom/intellij/database/util/Version;", "before", "intellij.database"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final VersionRange after(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Version version2 = Version.INFINITY;
            Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"INFINITY");
            return new VersionRange(version, version2);
        }

        @JvmStatic
        @NotNull
        public final VersionRange before(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Version version2 = Version.NEG_INFINITY;
            Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"NEG_INFINITY");
            return new VersionRange(version2, version);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

