/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.Casing;
import com.intellij.database.util.SmartPredicate;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TreePatternNode {
    public static final Comparator<TreePatternNode> BY_FIRST = (n12, n22) -> Comparing.compare((Comparable)((ObjectName)ArrayUtil.getFirstElement((Object[])n12.naming.names)), (Comparable)((ObjectName)ArrayUtil.getFirstElement((Object[])n22.naming.names)));
    public static final Group[] NO_GROUPS = new Group[0];
    public final BaseNaming naming;
    public final Group @NotNull [] groups;

    public TreePatternNode(@NotNull BaseNaming naming, Group @NotNull [] groups2) {
        if (naming == null) {
            TreePatternNode.$$$reportNull$$$0(0);
        }
        if (groups2 == null) {
            TreePatternNode.$$$reportNull$$$0(1);
        }
        this.naming = naming;
        this.groups = groups2;
        assert (TreePatternUtils.isValid(this));
    }

    public String toString() {
        return TreePatternUtils.print(new StringBuilder(), this, 0).toString();
    }

    @Nullable
    public Group getGroup(@Nullable ObjectKind kind) {
        if (kind != null) {
            for (Group group2 : this.groups) {
                if (group2.kind != kind) continue;
                return group2;
            }
        }
        return null;
    }

    public boolean matchedChildren(@Nullable ObjectName name2, @NotNull Casing casing, @NotNull ObjectKind kind, @NotNull Collection<TreePatternNode> matched) {
        Group group2;
        if (casing == null) {
            TreePatternNode.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            TreePatternNode.$$$reportNull$$$0(3);
        }
        if (matched == null) {
            TreePatternNode.$$$reportNull$$$0(4);
        }
        return (group2 = this.getGroup(kind)) != null && group2.matchedChildren(name2, casing, matched);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        TreePatternNode node2 = (TreePatternNode)o2;
        if (!this.naming.equals(node2.naming)) {
            return false;
        }
        return Arrays.equals(this.groups, node2.groups);
    }

    public int hashCode() {
        int result2 = this.naming.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.groups);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "naming";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matched";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/util/TreePatternNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "matchedChildren";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class BaseNaming {
        public final ObjectName[] names;

        public BaseNaming(ObjectName @NotNull [] names2) {
            if (names2 == null) {
                BaseNaming.$$$reportNull$$$0(0);
            }
            this.names = names2;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            return Arrays.equals(this.names, ((BaseNaming)o2).names);
        }

        public int hashCode() {
            return Arrays.hashCode(this.names);
        }

        public abstract boolean matches(@Nullable ObjectName var1, @Nullable(value="exact match") @Nullable(value="exact match") Casing var2);

        public ObjectName find(@NotNull ObjectName name2, @Nullable(value="exact match") @Nullable(value="exact match") Casing casing) {
            if (name2 == null) {
                BaseNaming.$$$reportNull$$$0(1);
            }
            for (ObjectName n : this.names) {
                if (!(casing == null ? name2.equals(n) : name2.equals(n, casing))) continue;
                return n;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/util/TreePatternNode$BaseNaming";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "find";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Group {
        public static final Comparator<Group> BY_KIND = (g1, g2) -> Comparing.compare((Comparable)g1.kind, (Comparable)g2.kind);
        public final ObjectKind kind;
        public final TreePatternNode @Nullable [] children;
        private Integer myHashCode;

        public Group(@NotNull ObjectKind kind, TreePatternNode @Nullable [] children2) {
            if (kind == null) {
                Group.$$$reportNull$$$0(0);
            }
            this(kind, children2, true);
        }

        protected Group(@NotNull ObjectKind kind, TreePatternNode @Nullable [] children2, boolean validate2) {
            if (kind == null) {
                Group.$$$reportNull$$$0(1);
            }
            this.kind = kind;
            this.children = children2;
        }

        public String toString() {
            return TreePatternUtils.print(new StringBuilder(), this, 0).toString();
        }

        public boolean matchedChildren(@Nullable ObjectName name2, @Nullable(value="exact match") @Nullable(value="exact match") Casing casing, @Nullable Collection<TreePatternNode> matched) {
            boolean m = false;
            if (this.children != null) {
                for (TreePatternNode child : this.children) {
                    if (!child.naming.matches(name2, casing)) continue;
                    if (matched != null) {
                        matched.add(child);
                    }
                    m = true;
                }
            }
            return m;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Group group2 = (Group)o2;
            if (group2.hashCode() != this.hashCode()) {
                return false;
            }
            if (!this.kind.equals(group2.kind)) {
                return false;
            }
            return Arrays.equals(this.children, group2.children);
        }

        public int hashCode() {
            if (this.myHashCode != null) {
                return this.myHashCode;
            }
            int result2 = this.kind.hashCode();
            result2 = 31 * result2 + Arrays.hashCode(this.children);
            this.myHashCode = result2;
            return this.myHashCode;
        }

        public int size() {
            return this.children == null ? 0 : this.children.length;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/util/TreePatternNode$Group", "<init>"));
        }
    }

    public static abstract class PatternWrapper
    implements Comparable<PatternWrapper> {
        public static PatternWrapper create(@NotNull String pattern2) {
            if (pattern2 == null) {
                PatternWrapper.$$$reportNull$$$0(0);
            }
            try {
                return new PatternWrapperOk(Pattern.compile(pattern2, 2));
            }
            catch (PatternSyntaxException e2) {
                return new PatternWrapperFailed(pattern2, StringUtil.notNullize((String)e2.getMessage()));
            }
        }

        @Override
        public int compareTo(@NotNull PatternWrapper wrapper) {
            if (wrapper == null) {
                PatternWrapper.$$$reportNull$$$0(1);
            }
            return Comparing.compare((Comparable)((Object)this.getText()), (Comparable)((Object)wrapper.getText()));
        }

        @NlsSafe
        public abstract String getText();

        @Nls
        @Nullable
        public abstract String getError();

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof PatternWrapper)) {
                return false;
            }
            return Objects.equals(this.getText(), ((PatternWrapper)o2).getText());
        }

        public int hashCode() {
            return Objects.hash(this.getText());
        }

        public abstract boolean matches(@NotNull ObjectName var1);

        public static Predicate<PatternWrapper> evaluator(@NotNull ObjectName name2) {
            if (name2 == null) {
                PatternWrapper.$$$reportNull$$$0(2);
            }
            return p2 -> p2.matches(name2);
        }

        public static boolean evaluate(@NotNull SmartPredicate<PatternWrapper> pattern2, @NotNull ObjectName name2) {
            if (pattern2 == null) {
                PatternWrapper.$$$reportNull$$$0(3);
            }
            if (name2 == null) {
                PatternWrapper.$$$reportNull$$$0(4);
            }
            return pattern2.evaluate(PatternWrapper.evaluator(name2));
        }

        public String toString() {
            return this.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapper";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/util/TreePatternNode$PatternWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluator";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class PatternWrapperOk
        extends PatternWrapper {
            private final Pattern myPattern;

            private PatternWrapperOk(@NotNull Pattern p2) {
                if (p2 == null) {
                    PatternWrapperOk.$$$reportNull$$$0(0);
                }
                this.myPattern = p2;
            }

            @Override
            @NlsSafe
            public String getText() {
                return this.myPattern.pattern();
            }

            @Override
            @Nullable
            public String getError() {
                return null;
            }

            @Override
            public boolean matches(@NotNull ObjectName name2) {
                if (name2 == null) {
                    PatternWrapperOk.$$$reportNull$$$0(1);
                }
                return this.myPattern.matcher(name2.name).matches();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "p";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/util/TreePatternNode$PatternWrapper$PatternWrapperOk";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "matches";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class PatternWrapperFailed
        extends PatternWrapper {
            private final String myPattern;
            @NlsSafe
            private final String myError;

            private PatternWrapperFailed(@NotNull String p2, @NotNull String e2) {
                if (p2 == null) {
                    PatternWrapperFailed.$$$reportNull$$$0(0);
                }
                if (e2 == null) {
                    PatternWrapperFailed.$$$reportNull$$$0(1);
                }
                this.myPattern = p2;
                this.myError = e2;
            }

            @Override
            @NlsSafe
            public String getText() {
                return this.myPattern;
            }

            @Override
            @Nullable
            public String getError() {
                return this.myError;
            }

            @Override
            public boolean matches(@NotNull ObjectName name2) {
                if (name2 == null) {
                    PatternWrapperFailed.$$$reportNull$$$0(2);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "p";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/util/TreePatternNode$PatternWrapper$PatternWrapperFailed";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "matches";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class NegativeNaming
    extends BaseNaming {
        public static final NegativeNaming WILDCARD = new NegativeNaming(SmartPredicate.all(), ObjectName.EMPTY_ARRAY);
        public final SmartPredicate<PatternWrapper> pattern;

        public NegativeNaming(@NotNull SmartPredicate<PatternWrapper> pattern2, ObjectName ... antiNames) {
            if (pattern2 == null) {
                NegativeNaming.$$$reportNull$$$0(0);
            }
            if (antiNames == null) {
                NegativeNaming.$$$reportNull$$$0(1);
            }
            super(antiNames);
            this.pattern = pattern2;
            if (pattern2.isNone()) {
                throw new AssertionError((Object)"Empty naming");
            }
        }

        @Nullable
        public static SmartPredicate<PatternWrapper> getPattern(@Nullable BaseNaming naming) {
            return naming instanceof NegativeNaming ? ((NegativeNaming)naming).pattern : null;
        }

        protected boolean matchesPattern(@NotNull ObjectName name2) {
            if (name2 == null) {
                NegativeNaming.$$$reportNull$$$0(2);
            }
            return PatternWrapper.evaluate(this.pattern, name2);
        }

        @Override
        public boolean matches(@Nullable ObjectName name2, @Nullable(value="exact match") @Nullable(value="exact match") Casing casing) {
            return name2 == null || this.find(name2, casing) == null && this.matchesPattern(name2);
        }

        public String toString() {
            String names2 = this.names.length == 0 ? "*" : "*, -" + StringUtil.join((Object[])this.names, n -> n.name.length() == 0 ? "()" : n.toString(), (String)", -");
            return names2 + (String)(this.pattern.isAll() ? "" : " {" + this.pattern + "}");
        }

        @Override
        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof NegativeNaming)) {
                return false;
            }
            return super.equals(o2) && this.pattern.equals(((NegativeNaming)o2).pattern);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.pattern);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "antiNames";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/util/TreePatternNode$NegativeNaming";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchesPattern";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PositiveNaming
    extends BaseNaming {
        public static final PositiveNaming DUMMY = new PositiveNaming(ObjectName.quoted(""));

        public PositiveNaming(ObjectName ... names2) {
            if (names2 == null) {
                PositiveNaming.$$$reportNull$$$0(0);
            }
            super(names2);
            assert (names2.length != 0) : "Empty positive naming";
        }

        @Override
        public boolean matches(@Nullable ObjectName name2, @Nullable(value="exact match") @Nullable(value="exact match") Casing casing) {
            return name2 == null || this.find(name2, casing) != null;
        }

        public ObjectName @NotNull [] getNames() {
            if (this.names == null) {
                PositiveNaming.$$$reportNull$$$0(1);
            }
            return this.names;
        }

        public String toString() {
            return StringUtil.join((Object[])this.names, n -> n.name.length() == 0 ? "()" : n.toString(), (String)", ");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/TreePatternNode$PositiveNaming";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/TreePatternNode$PositiveNaming";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

