/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPathTrie;
import com.intellij.openapi.util.Ref;
import com.intellij.util.NotNullizer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ObjectPathTrieImpl<V>
implements ObjectPathTrie<V> {
    private final MapFactory myMapFactory;
    private final Node<V> myRoot;

    public ObjectPathTrieImpl(@NotNull MapFactory mapFactory) {
        if (mapFactory == null) {
            ObjectPathTrieImpl.$$$reportNull$$$0(0);
        }
        this.myMapFactory = mapFactory;
        this.myRoot = new Node(null, this.myMapFactory.create());
    }

    @Override
    public void clear() {
        this.myRoot.remove(null, true, null);
    }

    @Override
    @NotNull
    public List<? extends V> clearAndCollectValues() {
        List list = this.removeCascadeAndCollectValuesImpl(null).toList();
        if (list == null) {
            ObjectPathTrieImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public V put(@NotNull ObjectPath path, V value2) {
        if (path == null) {
            ObjectPathTrieImpl.$$$reportNull$$$0(2);
        }
        Node<V> node2 = this.myRoot.findOrCreate(path, this.myMapFactory);
        return node2.setValue(value2);
    }

    @Override
    public V putIfAbsent(@NotNull ObjectPath path, V value2) {
        if (path == null) {
            ObjectPathTrieImpl.$$$reportNull$$$0(3);
        }
        Node<V> node2 = this.myRoot.findOrCreate(path, this.myMapFactory);
        if (node2.myValue != null) {
            return node2.getValue();
        }
        return node2.setValue(value2);
    }

    @Override
    public V get(@NotNull ObjectPath path) {
        Node<V> node2;
        if (path == null) {
            ObjectPathTrieImpl.$$$reportNull$$$0(4);
        }
        return (node2 = this.myRoot.findNodeOrParent(path)) != null && node2.getDepth() == path.getSize() ? (V)node2.getValue() : null;
    }

    @Override
    public V remove(@NotNull ObjectPath path) {
        if (path == null) {
            ObjectPathTrieImpl.$$$reportNull$$$0(5);
        }
        Ref prev = Ref.create();
        this.myRoot.remove(path, false, n -> {
            prev.set(n.getValue());
            return true;
        });
        return (V)prev.get();
    }

    @Override
    public boolean remove(@NotNull ObjectPath path, V value2) {
        if (path == null) {
            ObjectPathTrieImpl.$$$reportNull$$$0(6);
        }
        return this.myRoot.remove(path, false, n -> Node.NN.notNullize(value2).equals(n.myValue));
    }

    @Override
    public boolean removeCascade(@NotNull ObjectPath path) {
        if (path == null) {
            ObjectPathTrieImpl.$$$reportNull$$$0(7);
        }
        return this.myRoot.remove(path, true, null);
    }

    @Override
    @NotNull
    public List<? extends V> removeCascadeAndCollectValues(@NotNull ObjectPath path) {
        if (path == null) {
            ObjectPathTrieImpl.$$$reportNull$$$0(8);
        }
        List list = this.removeCascadeAndCollectValuesImpl(path).toList();
        if (list == null) {
            ObjectPathTrieImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    JBIterable<V> removeCascadeAndCollectValuesImpl(@Nullable ObjectPath path) {
        Ref res2 = Ref.create();
        this.myRoot.remove(path, true, n -> {
            res2.set((Object)JBIterable.of(n.getValue()).append((Iterable)((JBTreeTraverser)JBTreeTraverser.from(o2 -> o2.myChildren.values()).withRoots(new ArrayList(n.myChildren.values()))).traverse().map(Node::getValue)).filterNotNull());
            return true;
        });
        JBIterable jBIterable = res2.isNull() ? JBIterable.empty() : (JBIterable)res2.get();
        if (jBIterable == null) {
            ObjectPathTrieImpl.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    @Override
    public boolean contains(@NotNull ObjectPath path) {
        Node<V> node2;
        if (path == null) {
            ObjectPathTrieImpl.$$$reportNull$$$0(11);
        }
        return (node2 = this.myRoot.findNodeOrParent(path)) != null && node2.getDepth() == path.getSize() && node2.myValue != null;
    }

    @Override
    @NotNull
    public Iterable<ObjectPath> getChildren(@Nullable ObjectPath path) {
        ObjectPath child;
        Node<V> node2 = this.myRoot.findNodeOrParent(path);
        if (node2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                ObjectPathTrieImpl.$$$reportNull$$$0(12);
            }
            return jBIterable;
        }
        if (node2.myKey == path) {
            Set<ObjectPath> set = node2.myChildren.keySet();
            if (set == null) {
                ObjectPathTrieImpl.$$$reportNull$$$0(13);
            }
            return set;
        }
        if (path == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                ObjectPathTrieImpl.$$$reportNull$$$0(14);
            }
            return jBIterable;
        }
        ObjectPath nextStep = path.getParentAtDepth(node2.getDepth() + 1);
        Node nextNode = node2.myChildren.get(nextStep);
        ObjectPath objectPath = child = nextNode == null || nextNode.myKey == null ? null : nextNode.myKey.getParentAtDepth(path.getSize() + 1);
        if (child == null || child.parent != path) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                ObjectPathTrieImpl.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object)child);
        if (jBIterable == null) {
            ObjectPathTrieImpl.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @TestOnly
    public JBTreeTraverser<Map.Entry<@Nullable ObjectPath, V>> traverseNodes() {
        return ((JBTreeTraverser)JBTreeTraverser.from(Node::sortedChildren).withRoot(this.myRoot)).map(e2 -> e2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 9, 10, 12, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapFactory";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/ObjectPathTrieImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/ObjectPathTrieImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "clearAndCollectValues";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "removeCascadeAndCollectValues";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "removeCascadeAndCollectValuesImpl";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeCascade";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeCascadeAndCollectValues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 9, 10, 12, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }

    static interface MapFactory {
        public <K, V> Map<K, V> create();
    }

    static class Node<V>
    implements Map.Entry<ObjectPath, V> {
        private static final NotNullizer NN = new NotNullizer("ObjectPathTrie.Node.null");
        private final Map<ObjectPath, Node<V>> myChildren;
        @Nullable
        private final ObjectPath myKey;
        @Nullable
        private V myValue;

        private Node(@Nullable ObjectPath key2, @NotNull Map<ObjectPath, Node<V>> children2) {
            if (children2 == null) {
                Node.$$$reportNull$$$0(0);
            }
            this.myKey = key2;
            this.myChildren = children2;
        }

        @Override
        @Nullable
        public ObjectPath getKey() {
            return this.myKey;
        }

        @Override
        public V setValue(@Nullable V value2) {
            V prev = this.getValue();
            this.myValue = NN.notNullize(value2);
            return prev;
        }

        @Override
        @Nullable
        public V getValue() {
            return (V)(this.myValue == null ? null : NN.nullize(this.myValue));
        }

        @Nullable
        private Node<V> findNodeOrParent(@Nullable ObjectPath path) {
            int depth;
            int searchDepth = Node.getDepth(path);
            if (searchDepth < (depth = this.getDepth())) {
                return null;
            }
            if (searchDepth == depth) {
                return this.myKey == path ? this : null;
            }
            if (path == null) {
                return null;
            }
            ObjectPath nextStep = path.getParentAtDepth(depth + 1);
            if (nextStep == null || nextStep.parent != this.myKey) {
                return null;
            }
            Node<V> child = this.myChildren.get(nextStep);
            Node<V> result2 = child == null ? null : child.findNodeOrParent(path);
            return result2 == null ? this : result2;
        }

        private int getDepth() {
            return Node.getDepth(this.myKey);
        }

        private static int getDepth(@Nullable ObjectPath key2) {
            return key2 == null ? 0 : key2.getSize();
        }

        @NotNull
        private Node<V> findOrCreate(@NotNull ObjectPath path, @NotNull MapFactory mapFactory) {
            if (path == null) {
                Node.$$$reportNull$$$0(1);
            }
            if (mapFactory == null) {
                Node.$$$reportNull$$$0(2);
            }
            int depth = this.getDepth();
            if (path.getSize() == depth) {
                Node node2 = this;
                if (node2 == null) {
                    Node.$$$reportNull$$$0(3);
                }
                return node2;
            }
            ObjectPath nextStep = path.getParentAtDepth(depth + 1);
            Node<V> nextNode = this.myChildren.get(nextStep);
            if (nextNode == null) {
                Node<V> node3 = new Node<V>(path, mapFactory.create());
                this.myChildren.put(nextStep, node3);
                Node<V> node4 = node3;
                if (node4 == null) {
                    Node.$$$reportNull$$$0(4);
                }
                return node4;
            }
            ObjectPath nextNodeKey = nextNode.myKey;
            assert (nextNodeKey != null);
            ObjectPath split = nextNodeKey.getCommonAncestor(path);
            assert (split != null);
            if (split == nextNodeKey) {
                return nextNode.findOrCreate(path, mapFactory);
            }
            Node<V> splitNode = new Node<V>(split, mapFactory.create());
            splitNode.myChildren.put(nextNodeKey.getParentAtDepth(split.getSize() + 1), nextNode);
            this.myChildren.put(nextStep, splitNode);
            return splitNode.findOrCreate(path, mapFactory);
        }

        private boolean remove(@Nullable ObjectPath path, boolean recursive, @Nullable Predicate<Node<V>> finalPredicate) {
            boolean result2;
            Node<V> nextNode;
            int depth = this.getDepth();
            if (Node.getDepth(path) == depth) {
                if (finalPredicate != null && !finalPredicate.test(this)) {
                    return false;
                }
                this.myValue = null;
                if (recursive) {
                    this.myChildren.clear();
                }
                return true;
            }
            ObjectPath nextStep = path == null ? null : path.getParentAtDepth(depth + 1);
            Node<V> node2 = nextNode = nextStep == null ? null : this.myChildren.get(nextStep);
            if (nextNode == null) {
                return false;
            }
            ObjectPath nextNodeKey = nextNode.myKey;
            assert (nextNodeKey != null);
            boolean bl = nextNodeKey.isAncestorOf(path, false) ? nextNode.remove(path, recursive, finalPredicate) : (result2 = recursive && nextNode.remove(nextNodeKey, true, finalPredicate));
            if (result2 && nextNode.myValue == null) {
                if (nextNode.myChildren.isEmpty()) {
                    this.myChildren.remove(nextStep);
                } else if (nextNode.myChildren.size() == 1) {
                    this.myChildren.put(nextStep, nextNode.myChildren.values().iterator().next());
                }
            }
            return result2;
        }

        @TestOnly
        public JBIterable<Node<V>> sortedChildren() {
            return JBIterable.from(this.myChildren.entrySet()).sort(Comparator.comparing(e2 -> ((ObjectPath)e2.getKey()).kind).thenComparing(e2 -> ((ObjectPath)e2.getKey()).name)).map(Map.Entry::getValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapFactory";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/ObjectPathTrieImpl$Node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/ObjectPathTrieImpl$Node";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findOrCreate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findOrCreate";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

