/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.google.common.collect.Sets;
import com.intellij.concurrency.ThreadContext;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorageCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.HookUpHelper;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.database.extractors.TextInfo;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.JdbcInjection;
import com.intellij.database.remote.jdbc.RemoteClob;
import com.intellij.database.remote.jdbc.RemoteCloseable;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteResultSetMetaData;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.JdbcInjectable;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.database.util.VirtualFileDataSourceProvider;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.structure.DvFamilyId;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DbImplUtilCore {
    public static final Map<String, ObjectKind> FILTER_BY_NAME = Map.ofEntries(Map.entry("table", ObjectKind.TABLE), Map.entry("vtable", ObjectKind.VIRTUAL_TABLE), Map.entry("ftable", ObjectKind.FOREIGN_TABLE), Map.entry("view", ObjectKind.VIEW), Map.entry("mview", ObjectKind.MAT_VIEW), Map.entry("routine", ObjectKind.ROUTINE), Map.entry("aggregate", ObjectKind.AGGREGATE), Map.entry("package", ObjectKind.PACKAGE), Map.entry("sequence", ObjectKind.SEQUENCE), Map.entry("synonym", ObjectKind.SYNONYM), Map.entry("operator", ObjectKind.OPERATOR), Map.entry("collation", ObjectKind.COLLATION), Map.entry("role", ObjectKind.ROLE), Map.entry("user", ObjectKind.USER), Map.entry("fdw", ObjectKind.FOREIGN_DATA_WRAPPER), Map.entry("event", ObjectKind.SCHEDULED_EVENT));
    public static final ThrowableConvertor<RemoteResultSet, List<String>, Exception> RS_AS_STRING_LIST = rs -> {
        ArrayList<String> res2 = new ArrayList<String>();
        while (rs.next()) {
            res2.add(rs.getString(1));
        }
        return res2;
    };
    public static final String PREFER_IPV4 = "java.net.preferIPv4Stack";
    public static final DbmsExtension<JdbcHelper> JDBC_HELPER_EP = new DbmsExtension("com.intellij.database.jdbcHelper");
    public static final int UNLIMITED_PAGE_SIZE = -1;
    public static final String DEFAULT_PAGE_SIZE_MONGO_PROP = "database.mongodb.page.size";
    public static final int DEFAULT_PAGE_SIZE_MONGO = 20;
    public static final String DEFAULT_LIMIT_PAGE_SIZE_MONGO_PROP = "database.mongodb.page.size.limit";
    public static final boolean DEFAULT_LIMIT_PAGE_SIZE_MONGO = true;
    public static final Set<ObjectKind> SCHEMA_KINDS = Set.of(ObjectKind.SCHEMA, ObjectKind.EXTERNAL_SCHEMA);
    public static final Set<ObjectKind> DATABASE_KINDS = Set.of(ObjectKind.DATABASE, ObjectKind.EXTERNAL_DATABASE);
    public static final Set<ObjectKind> NAMESPACE_KINDS = Sets.union(DATABASE_KINDS, SCHEMA_KINDS);
    protected static final Logger LOG = Logger.getInstance(DbImplUtilCore.class);

    protected DbImplUtilCore() {
    }

    public static boolean isNamespace(@Nullable ObjectKind kind) {
        if (kind == null) {
            return false;
        }
        return NAMESPACE_KINDS.contains(kind);
    }

    public static boolean isDatabase(@Nullable ObjectKind kind) {
        if (kind == null) {
            return false;
        }
        return DATABASE_KINDS.contains(kind);
    }

    public static boolean isSchema(@NotNull DasObject object) {
        if (object == null) {
            DbImplUtilCore.$$$reportNull$$$0(0);
        }
        return DbImplUtilCore.isSchema(object.getKind());
    }

    public static boolean isSchema(@Nullable ObjectKind kind) {
        if (kind == null) {
            return false;
        }
        return SCHEMA_KINDS.contains(kind);
    }

    public static boolean isExternalNamespace(@Nullable ObjectKind kind) {
        return kind == ObjectKind.EXTERNAL_DATABASE || kind == ObjectKind.EXTERNAL_SCHEMA;
    }

    public static boolean isTypeKind(@Nullable ObjectKind kind) {
        return kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.COLLECTION_TYPE || kind == ObjectKind.ALIAS_TYPE || kind == ObjectKind.TABLE_TYPE;
    }

    public static boolean isDataTable(@Nullable DasTable info2) {
        if (info2 == null) {
            return false;
        }
        return DbImplUtilCore.isDataTable(info2.getKind());
    }

    public static boolean isDataTable(@Nullable ObjectKind kind) {
        return ArrayUtil.contains((Object)kind, (Object[])new ObjectKind[]{ObjectKind.TABLE, ObjectKind.FOREIGN_TABLE, ObjectKind.VIRTUAL_TABLE, ObjectKind.VIEW, ObjectKind.MAT_VIEW, DvFamilyId.VIRTUAL_VIEW.getFakeKind(), ObjectKind.STRING, ObjectKind.LIST, ObjectKind.SET, ObjectKind.SORTED_SET, ObjectKind.HASH_TABLE, ObjectKind.STREAM, ObjectKind.JSON_DOCUMENT, ObjectKind.COLLECTION, ObjectKind.DYNAMIC_TABLE});
    }

    @NotNull
    public static BasicMetaModel<?> getMetaModel(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(1);
        }
        BasicMetaModel<?> basicMetaModel = ModelFacade.forDbms(dbms).getMetaModel();
        if (basicMetaModel == null) {
            DbImplUtilCore.$$$reportNull$$$0(2);
        }
        return basicMetaModel;
    }

    @Nullable
    public static BasicMetaObject<?> getMetaObject(@Nullable DasObject object) {
        BasicObjectNode unw = (BasicObjectNode)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(object), BasicObjectNode.class);
        return unw == null ? null : unw.getMetaObject();
    }

    @Nullable
    public static DasNamespace getSearchPathObject(@NotNull DatabaseDialectEx dialect, @Nullable DasObject dasObject) {
        if (dialect == null) {
            DbImplUtilCore.$$$reportNull$$$0(3);
        }
        if (dialect.getDbms().isSqlite()) {
            return (DasNamespace)ObjectUtils.tryCast((Object)DasUtil.getSchemaObject(dasObject), DasNamespace.class);
        }
        ObjectKind kind = dialect.getSearchPathObjectKind();
        List path = kind == null ? null : (List)DbImplUtilCore.getMetaModel(dialect.getDbms()).getPathsToRoot(kind).first();
        List pathsToRoot = path == null ? Collections.singletonList(kind) : path;
        return kind == null ? null : (DasNamespace)DasUtil.dasParents(dasObject).filter(DasNamespace.class).find(o2 -> pathsToRoot.contains(o2.getKind()));
    }

    @Nullable
    public static SearchPath getSearchPath(@NotNull DbDataSource dataSource2, @Nullable DasObject dasObject) {
        if (dataSource2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(4);
        }
        DatabaseDialectEx dialect = DbImplUtilCore.getDatabaseDialect(dataSource2);
        DasNamespace namespace = DbImplUtilCore.getSearchPathObject(dialect, dasObject);
        return ObjectPaths.searchPathOf(namespace);
    }

    @Nullable
    public static DbDataSource getDbDataSource(@NotNull Project project, @NotNull DasDataSource database) {
        if (project == null) {
            DbImplUtilCore.$$$reportNull$$$0(5);
        }
        if (database == null) {
            DbImplUtilCore.$$$reportNull$$$0(6);
        }
        return database instanceof DbDataSource ? (DbDataSource)database : DbPsiFacade.getInstance(project).findDataSource(database.getUniqueId());
    }

    public static CascadeRule asCascadeRule(DasForeignKey.RuleAction ac) {
        if (ac == DasForeignKey.RuleAction.CASCADE) {
            return CascadeRule.cascade;
        }
        if (ac == DasForeignKey.RuleAction.NO_ACTION) {
            return CascadeRule.no_action;
        }
        if (ac == DasForeignKey.RuleAction.RESTRICT) {
            return CascadeRule.restrict;
        }
        if (ac == DasForeignKey.RuleAction.SET_DEFAULT) {
            return CascadeRule.set_default;
        }
        if (ac == DasForeignKey.RuleAction.SET_NULL) {
            return CascadeRule.set_null;
        }
        return CascadeRule.no_action;
    }

    @Nullable
    public static Object prepareValue(@NotNull Dbms family, @Nullable Object value2, @NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
        if (family == null) {
            DbImplUtilCore.$$$reportNull$$$0(7);
        }
        if (formatsCache == null) {
            DbImplUtilCore.$$$reportNull$$$0(8);
        }
        if (formatterCreator == null) {
            DbImplUtilCore.$$$reportNull$$$0(9);
        }
        return value2 == null || value2 == ReservedCellValue.NULL ? null : (value2 instanceof JdbcInjectable ? ((JdbcInjectable)value2).injection(family, formatsCache, formatterCreator) : (value2 instanceof ImageInfo ? (JdbcInjection)((ImageInfo)value2).bytes : (value2 instanceof TextInfo ? (JdbcInjection)((TextInfo)value2).bytes : (value2 instanceof BitString ? (JdbcInjection)((BitString)value2).getBytes() : (value2 instanceof Date ? DbImplUtilCore.prepareDate((Date)value2) : value2)))));
    }

    @NotNull
    private static Object prepareDate(@NotNull Date value2) {
        if (value2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(10);
        }
        return value2 instanceof Timestamp || value2 instanceof Time ? value2 : new JdbcInjection.DateInjection(JdbcNativeUtil.createSqlDate((Date)value2));
    }

    public static <T extends BasicModElement> ModFamily<T> familyOf(@Nullable BasicModElement element2, @NotNull ObjectKind kind) {
        if (kind == null) {
            DbImplUtilCore.$$$reportNull$$$0(11);
        }
        Family res2 = element2 == null ? null : element2.familyOf(kind);
        return res2 != null ? res2 : null;
    }

    public static void resolveKey(@NotNull BasicModForeignKey fkey, @NotNull List<String> refColNames) {
        BasicMetaField<?> colsField;
        BasicTable table;
        if (fkey == null) {
            DbImplUtilCore.$$$reportNull$$$0(12);
        }
        if (refColNames == null) {
            DbImplUtilCore.$$$reportNull$$$0(13);
        }
        if (!refColNames.isEmpty() && (table = fkey.getRefTable()) != null) {
            for (BasicKey key2 : JBIterable.from(table.familyOf(ObjectKind.KEY)).filter(BasicKey.class)) {
                if (!refColNames.equals(key2.getColNames())) continue;
                fkey.setRefKeyRef(BasicNameReference.create(key2));
                return;
            }
        }
        if ((colsField = fkey.getMetaObject().getField(BasicModForeignKey.REF_COL_NAMES)) == null || colsField.isAbstract()) {
            return;
        }
        fkey.setRefKeyRef(null);
    }

    public static DasNamespace getSearchPathObjectForSwitch(@NotNull DbDataSource dataSource2, @Nullable DasObject dasObject) {
        if (dataSource2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(14);
        }
        return DbImplUtilCore.getSearchPathObjectForSwitch(DbImplUtilCore.getMaybeLocalDataSource(dataSource2), DbImplUtilCore.getDatabaseDialect(dataSource2), dasObject);
    }

    public static DasNamespace getSearchPathObjectForSwitch(@NotNull DasDataSource dataSource2, @Nullable DasObject dasObject) {
        if (dataSource2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(15);
        }
        return DbImplUtilCore.getSearchPathObjectForSwitch(DbImplUtilCore.getMaybeLocalDataSource(dataSource2), DbImplUtilCore.getDatabaseDialect(dataSource2.getDbms()), dasObject);
    }

    public static DasNamespace getSearchPathObjectForSwitch(@Nullable LocalDataSource dataSource2, @NotNull DatabaseDialectEx dialect, @Nullable DasObject dasObject) {
        SchemaControl control;
        if (dialect == null) {
            DbImplUtilCore.$$$reportNull$$$0(16);
        }
        if (dasObject == null) {
            return null;
        }
        SchemaControl schemaControl = control = dataSource2 == null ? SchemaControl.AUTOMATIC : dataSource2.getSchemaControl();
        if (control != SchemaControl.AUTOMATIC) {
            if (!dialect.getDbms().isPostgres()) {
                return null;
            }
            DasNamespace object = DbImplUtilCore.getSearchPathObject(dialect, dasObject);
            if (dasObject.getKind() == ObjectKind.DATABASE) {
                return (DasNamespace)ObjectUtils.tryCast((Object)dasObject, DasNamespace.class);
            }
            if (object == null || object.getKind() != ObjectKind.SCHEMA) {
                return object;
            }
            return (DasNamespace)ObjectUtils.tryCast((Object)object.getDasParent(), DasNamespace.class);
        }
        return DbImplUtilCore.getSearchPathObject(dialect, dasObject);
    }

    public static DasNamespace getSearchPathObjectForSwitch(@Nullable DbElement element2) {
        return element2 == null ? null : DbImplUtilCore.getSearchPathObjectForSwitch(element2.getDataSource(), (DasObject)element2);
    }

    @Nullable
    public static ObjectPath getSearchPathObject(@NotNull Dbms dbms, @Nullable ObjectPath objectPath) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(17);
        }
        if (objectPath == null) {
            return null;
        }
        if (dbms.isSqlite()) {
            return objectPath.findParent(ObjectKind.SCHEMA, false);
        }
        ObjectKind kind = DbImplUtilCore.getDatabaseDialect(dbms).getSearchPathObjectKind();
        List<ObjectKind> path = kind == null ? null : (List<ObjectKind>)DbImplUtilCore.getMetaModel(dbms).getPathsToRoot(kind).first();
        List<ObjectKind> pathsToRoot = path == null ? Collections.singletonList(kind) : path;
        return kind == null ? null : (ObjectPath)JBIterable.generate((Object)objectPath, p2 -> p2.parent).find(o2 -> pathsToRoot.contains(o2.kind));
    }

    @Nullable
    public static DasNamespace getSearchPathObject(@Nullable DbElement element2) {
        return element2 == null ? null : DbImplUtilCore.getSearchPathObject(DbImplUtilCore.getDatabaseDialect(element2), element2);
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull DbElement element2) {
        if (element2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(18);
        }
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)element2.getDataSource().getDatabaseDialect();
        if (databaseDialectEx == null) {
            DbImplUtilCore.$$$reportNull$$$0(19);
        }
        return databaseDialectEx;
    }

    @NotNull
    public static Dbms getDbms(@Nullable DasObject obj2) {
        if (obj2 instanceof PsiElement) {
            return DbImplUtilCore.getDbms((PsiElement)obj2);
        }
        if (obj2 instanceof BasicElement) {
            Dbms dbms = ((BasicElement)obj2).getMetaObject().getDbms();
            if (dbms == null) {
                DbImplUtilCore.$$$reportNull$$$0(20);
            }
            return dbms;
        }
        Dbms dbms = Dbms.UNKNOWN;
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(21);
        }
        return dbms;
    }

    @NotNull
    public static Dbms getDbms(@Nullable PsiElement e2) {
        if (e2 instanceof DbElement) {
            return DbImplUtilCore.getDbms((DbElement)e2);
        }
        SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect(e2);
        Dbms dbms = dialect == null ? Dbms.UNKNOWN : dialect.getDbms();
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(22);
        }
        return dbms;
    }

    @NotNull
    public static Dbms getDbms(@Nullable DbElement element2) {
        Dbms dbms = element2 == null ? Dbms.UNKNOWN : element2.getDataSource().getDbms();
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(23);
        }
        return dbms;
    }

    public static Condition<DasObject> buildFilter(DasDataSource ds) {
        LocalDataSource source = DbImplUtilCore.getMaybeLocalDataSource(ds);
        if (source != null) {
            try {
                Condition<DasObject> c2 = DbImplUtilCore.buildObjectFilter(source);
                if (c2 == null) {
                    return null;
                }
                return o2 -> o2 instanceof DasNamespace || c2.value(o2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static Condition<DasObject> buildObjectFilter(@NotNull RawDataSource ds) throws PatternSyntaxException {
        if (ds == null) {
            DbImplUtilCore.$$$reportNull$$$0(24);
        }
        String filterText = ds instanceof LocalDataSource ? ((LocalDataSource)ds).getObjectPattern() : null;
        return DbImplUtilCore.buildObjectFilter(filterText);
    }

    @Nullable
    public static Condition<DasObject> buildObjectFilter(@Nullable String filterText) throws PatternSyntaxException {
        if (StringUtil.isEmptyOrSpaces((String)filterText)) {
            return null;
        }
        HashMap<ObjectKind, Couple> builders = new HashMap<ObjectKind, Couple>();
        for (Object s2 : StringUtil.split((String)filterText, (String)"||")) {
            StringBuilder target2;
            ObjectKind kind;
            String string = ((String)s2).trim();
            if (string.length() == 0) continue;
            int idx = string.indexOf(58);
            boolean exclude = string.charAt(idx + 1) == '-';
            String patternText = string.substring(idx + (exclude ? 2 : 1));
            if (idx < 0 || idx == string.length() - 1) {
                kind = ObjectKind.NONE;
            } else {
                String k = string.substring(0, idx);
                kind = FILTER_BY_NAME.getOrDefault(k, ObjectKind.NONE);
                if (kind == ObjectKind.NONE) {
                    exclude = false;
                    patternText = string;
                }
            }
            Couple item = (Couple)builders.get(kind);
            if (item == null) {
                item = Couple.of((Object)new StringBuilder(), (Object)new StringBuilder());
                builders.put(kind, item);
            }
            StringBuilder stringBuilder = target2 = exclude ? (StringBuilder)item.second : (StringBuilder)item.first;
            if (target2.length() != 0) {
                target2.append("|");
            }
            target2.append(patternText);
        }
        HashMap<ObjectKind, Condition> map2 = new HashMap<ObjectKind, Condition>();
        for (Map.Entry entry : builders.entrySet()) {
            Couple v2 = (Couple)entry.getValue();
            map2.put((ObjectKind)entry.getKey(), Conditions.and((Condition)((Condition)ObjectUtils.notNull(DbImplUtilCore.makeCondition((CharSequence)v2.first), (Object)Conditions.alwaysTrue())), (Condition)Conditions.not((Condition)((Condition)ObjectUtils.notNull(DbImplUtilCore.makeCondition((CharSequence)v2.second), (Object)Conditions.alwaysFalse())))));
        }
        Map.Entry item = (Map.Entry)ContainerUtil.getFirstItem(map2.entrySet());
        if (map2.size() == 1 && item != null && item.getKey() == ObjectKind.NONE) {
            return Conditions.compose(DasUtil.TO_NAME, (Condition)((Condition)item.getValue()));
        }
        return object -> {
            Condition c2 = object == null ? null : (Condition)map2.get(object.getKind());
            return c2 == null || c2.value((Object)object.getName());
        };
    }

    @Nullable
    public static Condition<String> makeCondition(CharSequence regex) {
        if (StringUtil.isEmpty((CharSequence)regex)) {
            return null;
        }
        Pattern p2 = Pattern.compile(regex.toString(), 2);
        return s2 -> s2 == null || p2.matcher((CharSequence)s2).matches();
    }

    public static boolean isExpandable(@NotNull DasObject obj2, @Nullable TreePattern scope) {
        DasObject unw;
        if (obj2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(25);
        }
        return (unw = (DasObject)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(obj2), DasObject.class)) == null || unw instanceof BasicNamespace && ((BasicNamespace)unw).isSubstituted() || DataSourceSchemaMapping.isIntrospected(scope, unw);
    }

    @Contract(value="null -> null")
    public static Object unwrap(@Nullable DasObject object) {
        Object tmp = object;
        while (tmp != null) {
            if (!(tmp instanceof DbElement)) {
                return tmp;
            }
            tmp = ((DbElement)tmp).getDelegate();
        }
        return object;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@Nullable Dbms dbms) {
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.chooseNotNull((Object)DbImplUtilCore.guessDatabaseDialect(dbms), (Object)DatabaseDialects.getGenericDialect());
        if (databaseDialectEx == null) {
            DbImplUtilCore.$$$reportNull$$$0(26);
        }
        return databaseDialectEx;
    }

    @Nullable
    public static DatabaseDialectEx guessDatabaseDialect(@Nullable RawConnectionConfig connectionInfo) {
        Dbms dbms = DbImplUtilCore.guessDbms(connectionInfo);
        return DbImplUtilCore.guessDatabaseDialect(dbms);
    }

    @NotNull
    public static CasingProvider getCasingProvider(@Nullable DasObject obj2) {
        if (obj2 instanceof DbElement) {
            return DbImplUtilCore.getCasingProvider(DbImplUtilCore.getMaybeBasicElement(obj2));
        }
        if (obj2 instanceof PsiElement) {
            CasingProvider casingProvider = (CasingProvider)ObjectUtils.notNull((Object)((CasingProvider)DbSqlUtilCore.getSqlDialect((PsiElement)obj2)), (Object)DasUtil.NO_CASING_PROVIDER);
            if (casingProvider == null) {
                DbImplUtilCore.$$$reportNull$$$0(27);
            }
            return casingProvider;
        }
        if (obj2 instanceof BasicElement) {
            CasingProvider casingProvider = (CasingProvider)ObjectUtils.notNull((Object)BasicMixinElement.getCasingProvider((BasicElement)obj2), (Object)DasUtil.NO_CASING_PROVIDER);
            if (casingProvider == null) {
                DbImplUtilCore.$$$reportNull$$$0(28);
            }
            return casingProvider;
        }
        CasingProvider casingProvider = DasUtil.NO_CASING_PROVIDER;
        if (casingProvider == null) {
            DbImplUtilCore.$$$reportNull$$$0(29);
        }
        return casingProvider;
    }

    @Nullable
    protected static DatabaseDialectEx guessDatabaseDialect(@Nullable Dbms dbms) {
        return dbms == Dbms.UNKNOWN || dbms == null ? null : DatabaseDialects.findByDbms(dbms);
    }

    @Nullable
    public static DbDataSource getForcedDataSource(@Nullable PsiFile psiFile) {
        DbDataSource res2;
        VirtualFile originalFile;
        if (psiFile == null) {
            return null;
        }
        Project project = psiFile.getProject();
        VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
        while (virtualFile instanceof LightVirtualFile && (originalFile = ((LightVirtualFile)virtualFile).getOriginalFile()) != null) {
            virtualFile = originalFile;
        }
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
        }
        if ((res2 = DbImplUtilCore.getForcedDataSource(project, virtualFile)) != null) {
            return res2;
        }
        res2 = (DbDataSource)DatabaseDataKeysCore.DATA_SOURCE_KEY.get((UserDataHolder)psiFile);
        if (res2 == null && ApplicationManager.getApplication().isUnitTestMode()) {
            return (DbDataSource)DatabaseDataKeysCore.DATA_SOURCE_KEY.get((UserDataHolder)virtualFile);
        }
        return res2 != null && res2.isValid() ? res2 : null;
    }

    @Nullable
    public static DbDataSource getForcedDataSource(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            DbImplUtilCore.$$$reportNull$$$0(30);
        }
        if (virtualFile == null) {
            return null;
        }
        DbDataSource element2 = VirtualFileDataSourceProvider.findDataSource(project, virtualFile);
        return element2 != null && element2.isValid() ? element2 : null;
    }

    public static void performSrcOperation(@Nullable Project project, @Nullable DasModel model2, @NotNull ModalityState modality, boolean asyncRefresh, @NotNull Runnable runnable) {
        BasicModModel basicModel;
        DbSrcModelStorageCore storage;
        if (modality == null) {
            DbImplUtilCore.$$$reportNull$$$0(31);
        }
        if (runnable == null) {
            DbImplUtilCore.$$$reportNull$$$0(32);
        }
        DbSrcModelStorageCore dbSrcModelStorageCore = storage = (basicModel = (BasicModModel)ObjectUtils.tryCast((Object)model2, BasicModModel.class)) == null ? null : (DbSrcModelStorageCore)ObjectUtils.tryCast((Object)basicModel.getTextStorage(), DbSrcModelStorageCore.class);
        if (storage == null) {
            runnable.run();
        } else {
            try (GuardedRef<?> ignored = storage.startWriteSession(project, basicModel, modality, asyncRefresh, true);){
                runnable.run();
            }
        }
    }

    @Nullable
    public static String getCustomTypeShortDescription(@Nullable Object delegate) {
        JBIterable names2;
        if (delegate instanceof DasTypedObject) {
            DataType type2 = ((DasTypedObject)delegate).getDasType().toDataType();
            if (type2 != DataType.UNKNOWN) {
                return DbPresentationCore.arrow() + " " + type2;
            }
        } else if (delegate instanceof DasTable && !(names2 = DasUtil.getColumns((DasTable)delegate).transform(DasUtil.TO_NAME)).isEmpty()) {
            return "(" + StringUtil.join((Iterable)names2, (String)", ") + ")";
        }
        return null;
    }

    @NotNull
    public static Dbms guessDbms(@Nullable RawConnectionConfig connectionInfo) {
        Dbms dbms = connectionInfo instanceof DasDataSource ? ((DasDataSource)((Object)connectionInfo)).getDbms() : Dbms.forConnection(connectionInfo);
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(33);
        }
        return dbms;
    }

    public static boolean isRoutine(@NotNull ObjectKind kind) {
        if (kind == null) {
            DbImplUtilCore.$$$reportNull$$$0(34);
        }
        return kind == ObjectKind.ROUTINE || kind == ObjectKind.AGGREGATE;
    }

    public static int getPageSize(@Nullable Dbms dbms) {
        dbms = dbms == null ? Dbms.UNKNOWN : dbms;
        return DbImplUtilCore.isLimitDefaultPageSize(dbms) ? DbImplUtilCore.getDefaultPageSize(dbms) : -1;
    }

    public static int getDefaultPageSize(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(35);
        }
        return dbms.isMongo() ? PropertiesComponent.getInstance().getInt(DEFAULT_PAGE_SIZE_MONGO_PROP, 20) : DatabaseSettings.getSettings().getPageSize();
    }

    public static boolean isLimitDefaultPageSize(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(36);
        }
        return dbms.isMongo() ? PropertiesComponent.getInstance().getBoolean(DEFAULT_LIMIT_PAGE_SIZE_MONGO_PROP, true) : DatabaseSettings.getSettings().isLimitPageSize();
    }

    @Nullable
    public static Project getAnyProject() {
        return (Project)ContainerUtil.find((Object[])ProjectManager.getInstance().getOpenProjects(), p2 -> !p2.isDefault());
    }

    public static boolean isZonedTimeColumn(@NotNull ColumnDescriptor column2, @NotNull Dbms dbms) {
        if (column2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(37);
        }
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(38);
        }
        return DbImplUtilCore.getJdbcHelper(dbms).isZonedTimeColumn(column2.getTypeName(), column2.getType());
    }

    public static boolean isZonedTimestampColumn(@NotNull ColumnDescriptor column2, @NotNull Dbms dbms) {
        if (column2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(39);
        }
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(40);
        }
        return DbImplUtilCore.getJdbcHelper(dbms).isZonedTimestampColumn(column2.getTypeName(), column2.getType());
    }

    public static void closeSafe(@Nullable AutoCloseable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public static Dbms getDbms(@Nullable DatabaseDriver o2) {
        if (o2 == null) {
            Dbms dbms = Dbms.UNKNOWN;
            if (dbms == null) {
                DbImplUtilCore.$$$reportNull$$$0(41);
            }
            return dbms;
        }
        if (o2.getForcedDbms() != null) {
            Dbms dbms = o2.getForcedDbms();
            if (dbms == null) {
                DbImplUtilCore.$$$reportNull$$$0(42);
            }
            return dbms;
        }
        if (o2.isPredefined()) {
            Dbms dbms = Dbms.fromString(o2.getId());
            if (dbms == Dbms.DB2) {
                SqlLanguageDialect dialect;
                String dialectId = o2.getSqlDialect();
                SqlLanguageDialect sqlLanguageDialect = dialect = dialectId == null ? null : SqlDialects.findDialectById(dialectId);
                if (dialect != null && dialect.getDbms().isDb2()) {
                    Dbms dbms2 = dialect.getDbms();
                    if (dbms2 == null) {
                        DbImplUtilCore.$$$reportNull$$$0(43);
                    }
                    return dbms2;
                }
            }
            Dbms dbms3 = dbms;
            if (dbms3 == null) {
                DbImplUtilCore.$$$reportNull$$$0(44);
            }
            return dbms3;
        }
        Dbms dbms = Dbms.fromString(o2.getDriverClass());
        if (dbms == Dbms.UNKNOWN || o2.getSqlDialect() == null) {
            Dbms dbms4 = dbms;
            if (dbms4 == null) {
                DbImplUtilCore.$$$reportNull$$$0(45);
            }
            return dbms4;
        }
        SqlLanguageDialect detectedDialect = DbSqlUtilCore.getSqlDialect(dbms);
        if (SqlDialects.isGenericDialect(detectedDialect)) {
            Dbms dbms5 = dbms;
            if (dbms5 == null) {
                DbImplUtilCore.$$$reportNull$$$0(46);
            }
            return dbms5;
        }
        SqlLanguageDialect dialect = SqlDialects.findDialectById(o2.getSqlDialect());
        Dbms dbms6 = dialect == null || SqlDialects.isGenericDialect(dialect) || dialect == detectedDialect && dbms != Dbms.DB2 ? dbms : dialect.getDbms();
        if (dbms6 == null) {
            DbImplUtilCore.$$$reportNull$$$0(47);
        }
        return dbms6;
    }

    public static String concatStringResults(DatabaseConnectionCore connection2, Dbms dbms, String query, int forcedColumn, ConcatenationProps props) throws SQLException {
        return DbImplUtilCore.concatStringResults(connection2, dbms, query, forcedColumn, new StringBuilder(), props).toString().trim();
    }

    public static StringBuilder concatStringResults(DatabaseConnectionCore connection2, Dbms dbms, int forcedColumn, String query, StringBuilder sb, ConcatenationProps props) throws SQLException {
        return DbImplUtilCore.concatStringResults(connection2, dbms, query, forcedColumn, sb, props);
    }

    public static StringBuilder concatStringResults(DatabaseConnectionCore connection2, Dbms dbms, String query, int forcedColumn, StringBuilder sb, ConcatenationProps props) throws SQLException {
        SmartStatementFactoryService.getInstance().poweredBy(connection2).simple().noisy().execute(query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.allResults((ThrowableConsumer<RemoteResultSet, Exception>)((ThrowableConsumer)rs -> DbImplUtilCore.concatStringResults(rs, dbms, forcedColumn, sb, props))));
        return sb;
    }

    private static void concatStringResults(RemoteResultSet rs, Dbms dbms, int forcedColumn, StringBuilder sb, ConcatenationProps props) throws Exception {
        int trimmedLen;
        DataConsumer.Column[] columns2 = JdbcEngineUtils.getColumnDescriptors(rs);
        int columnCount = columns2.length;
        int start2 = sb.length();
        while (rs.next()) {
            if (start2 != sb.length()) {
                sb.append(props.rowSep);
            }
            int rowStart = sb.length();
            for (int i2 = forcedColumn > 0 ? forcedColumn : 1; i2 <= (forcedColumn > 0 ? forcedColumn : columnCount); ++i2) {
                CharSequence s2 = DbImplUtilCore.extractString(rs.getObject(i2));
                if (s2 == null) continue;
                if (props.lTrim) {
                    s2 = StringUtil.trimLeading((CharSequence)s2);
                }
                if (props.rTrim) {
                    s2 = StringUtil.trimTrailing((CharSequence)s2);
                }
                if (rowStart != sb.length()) {
                    sb.append(props.colSep);
                }
                sb.append(s2);
            }
        }
        for (trimmedLen = sb.length(); trimmedLen != 0 && sb.charAt(trimmedLen - 1) == ' '; --trimmedLen) {
        }
        sb.setLength(trimmedLen);
    }

    @Nullable
    private static CharSequence extractString(@Nullable Object object) throws SQLException {
        if (object instanceof CharSequence) {
            return (CharSequence)object;
        }
        if (object instanceof RemoteClob) {
            RemoteClob clob = (RemoteClob)object;
            try {
                return clob.getSubString(1L, (int)clob.length());
            }
            catch (RemoteException re) {
                ExceptionUtil.rethrow((Throwable)RemoteUtil.unwrap((Throwable)re));
            }
        } else if (object instanceof Clob) {
            Clob clob = (Clob)object;
            return clob.getSubString(1L, (int)clob.length());
        }
        return null;
    }

    public static String escapeStr(String value2) {
        return StringUtil.notNullize((String)value2).replace("'", "''");
    }

    @Nullable
    public static Version getDatabaseVersion(@Nullable DasDataSource dataSource2) {
        return dataSource2 == null ? null : dataSource2.getVersion();
    }

    @Nullable
    public static DasNamespace getTopSingleNamespace(@Nullable DasObject object) {
        ObjectKind kind;
        ObjectKind objectKind = kind = object == null ? null : object.getKind();
        if (kind != ObjectKind.ROOT && kind != ObjectKind.DATABASE) {
            return (DasNamespace)DasUtil.dasParents(object).filter(DasNamespace.class).first();
        }
        JBIterable ns = ((JBTreeTraverser)((JBTreeTraverser)DasUtil.dasTraverser().withRoot((Object)object)).expand(Conditions.compose(DasUtil.TO_KIND, k -> k == ObjectKind.ROOT || k == ObjectKind.DATABASE))).traverse();
        DasObject result2 = (DasObject)ns.filter(DasUtil.byKind(ObjectKind.SCHEMA)).single();
        if (result2 == null) {
            result2 = (DasObject)ns.filter(DasUtil.byKind(ObjectKind.DATABASE)).single();
        }
        return result2 instanceof DasNamespace ? (DasNamespace)result2 : null;
    }

    @NotNull
    public static JBTreeTraverser<DasObject> traverseVisibleObjects(@NotNull DasDataSource ds) {
        if (ds == null) {
            DbImplUtilCore.$$$reportNull$$$0(48);
        }
        TreePattern scope = DbImplUtilCore.getIntrospectionScope(ds);
        JBTreeTraverser traverser2 = (JBTreeTraverser)DasUtil.dasTraverser().withRoots(ds.getModel().getModelRoots());
        JBTreeTraverser jBTreeTraverser = DbImplUtilCore.traverseVisibleObjects(traverser2, scope);
        if (jBTreeTraverser == null) {
            DbImplUtilCore.$$$reportNull$$$0(49);
        }
        return jBTreeTraverser;
    }

    public static <T extends DasObject> JBTreeTraverser<T> traverseVisibleObjects(@NotNull JBTreeTraverser<T> traverser2, @Nullable TreePattern scope) {
        if (traverser2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(50);
        }
        return scope == null ? traverser2 : (JBTreeTraverser)traverser2.expandAndFilter(o2 -> DataSourceSchemaMapping.isIntrospected(scope, o2));
    }

    @NotNull
    public static JBIterable<BasicNamespace> getNamespaces(DasDataSource lds, TreePattern scope) {
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)DbImplUtilCore.traverseVisibleObjects((JBTreeTraverser)DasUtil.dasTraverser().withRoots(lds.getModel().getModelRoots()), scope).forceIgnore(o2 -> !(o2 instanceof BasicNamespace))).expand(o2 -> o2 instanceof BasicNamespace)).traverse(TreeTraversal.LEAVES_DFS).filter(BasicNamespace.class).collect();
        if (jBIterable == null) {
            DbImplUtilCore.$$$reportNull$$$0(51);
        }
        return jBIterable;
    }

    public static <T> T executeAndGetResult(DatabaseConnectionCore connection2, String query, ThrowableConvertor<RemoteResultSet, T, Exception> result2) throws SQLException {
        return SmartStatementFactoryService.getInstance().poweredBy(connection2).simple().noisy().execute(query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.throwableResultsTransformer(result2));
    }

    public static long getRowCount(@NotNull DatabaseConnectionCore connection2, @NotNull String query) throws SQLException {
        if (connection2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(52);
        }
        if (query == null) {
            DbImplUtilCore.$$$reportNull$$$0(53);
        }
        ExecutionEnvironmentHelper helper = ExecutionEnvironmentHelper.EP.forDbms(connection2.getDbms());
        Long result2 = (Long)DbImplUtilCore.executeAndGetResult(connection2, query, helper::getRowCount);
        if (result2 == null) {
            throw new AssertionError((Object)"Incorrect count query!");
        }
        return result2;
    }

    public static boolean hasUniqueIndex(@NotNull DasTable table) {
        if (table == null) {
            DbImplUtilCore.$$$reportNull$$$0(54);
        }
        return table.getDasChildren(ObjectKind.INDEX).filter(idx -> idx instanceof DasIndex && ((DasIndex)idx).isUnique()).isNotEmpty();
    }

    public static <T> T escapeSql(T value2, boolean needsEscaping, @NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(55);
        }
        return (T)DbImplUtilCore.getJdbcHelper(dbms).escapeSqlRegex(value2, needsEscaping);
    }

    @Nullable
    public static DatabaseDriver guessDatabaseDriver(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(56);
        }
        return dbms == Dbms.UNKNOWN ? null : (DatabaseDriver)JBIterable.from(DatabaseDriverManager.getInstance().getDrivers()).filter(o2 -> DbImplUtilCore.getDbms(o2) == dbms).sort((o1, o2) -> o1.isPredefined() ? (o2.isPredefined() ? 0 : -1) : (o2.isPredefined() ? 1 : 0)).first();
    }

    @Nullable
    public static DatabaseDriver guessDatabaseDriver(@NotNull RawConnectionConfig info2) {
        if (info2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(57);
        }
        return DbImplUtilCore.guessDatabaseDriver(DatabaseDriverManager.getInstance().getDrivers(), info2);
    }

    @Nullable
    public static DatabaseDriver guessDatabaseDriver(@NotNull Collection<? extends DatabaseDriver> allDrivers, @NotNull RawConnectionConfig info2) {
        if (allDrivers == null) {
            DbImplUtilCore.$$$reportNull$$$0(58);
        }
        if (info2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(59);
        }
        SmartList matchedDrivers = new SmartList();
        if (info2.getDriverClass() == null) {
            matchedDrivers.addAll(allDrivers);
        } else {
            for (DatabaseDriver databaseDriver : allDrivers) {
                if (!Objects.equals(info2.getDriverClass(), databaseDriver.getDriverClass())) continue;
                matchedDrivers.add(databaseDriver);
            }
        }
        if (matchedDrivers.isEmpty()) {
            return null;
        }
        if (matchedDrivers.size() == 1) {
            return (DatabaseDriver)matchedDrivers.get(0);
        }
        Dbms dbms = info2 instanceof LocalDataSource ? ((LocalDataSource)info2).getDbms() : null;
        return DbImplUtilCore.guessDatabaseDriverByUrl((List<DatabaseDriver>)matchedDrivers, info2.getUrl(), dbms);
    }

    @Nullable
    public static DatabaseDriver guessDatabaseDriverByUrl(List<DatabaseDriver> allDrivers, @Nullable String url, @Nullable Dbms dbms) {
        String urlString = StringUtil.notNullize((String)url);
        ArrayList<DatabaseDriver> filteredDrivers = new ArrayList<DatabaseDriver>(allDrivers.size());
        for (DatabaseDriver driver2 : allDrivers) {
            if (!driver2.matchesUrl(urlString) && (!urlString.isEmpty() || dbms == null || DbImplUtilCore.getDbms(driver2) != dbms)) continue;
            filteredDrivers.add(driver2);
        }
        if (filteredDrivers.isEmpty()) {
            return allDrivers.get(0);
        }
        if (filteredDrivers.size() == 1) {
            return (DatabaseDriver)filteredDrivers.get(0);
        }
        return DbImplUtilCore.disambiguate(urlString, (JBIterable<DatabaseDriver>)JBIterable.from(filteredDrivers));
    }

    @Nullable
    public static DatabaseDriver disambiguate(@NotNull String url, @NotNull JBIterable<DatabaseDriver> drivers) {
        if (url == null) {
            DbImplUtilCore.$$$reportNull$$$0(60);
        }
        if (drivers == null) {
            DbImplUtilCore.$$$reportNull$$$0(61);
        }
        if (StringUtil.containsIgnoreCase((String)url, (String)"database.windows.net")) {
            return (DatabaseDriver)drivers.filter(d2 -> DbImplUtilCore.likelyAzureDriver(d2)).append(drivers).first();
        }
        if (StringUtil.containsIgnoreCase((String)url, (String)"redshift.amazonaws.com")) {
            return (DatabaseDriver)drivers.filter(d2 -> DbImplUtilCore.likelyRedshiftDriver(d2)).append(drivers).first();
        }
        return (DatabaseDriver)drivers.filter(d2 -> !DbImplUtilCore.likelyAzureDriver(d2) && !DbImplUtilCore.likelyRedshiftDriver(d2) && !DbImplUtilCore.likelyGreenplumDriver(d2) && !DbImplUtilCore.likelyCockroachDriver(d2)).append(drivers).first();
    }

    private static boolean likelyCockroachDriver(DatabaseDriver driver2) {
        return DbImplUtilCore.getDbms(driver2) == Dbms.COCKROACH;
    }

    private static boolean likelyRedshiftDriver(DatabaseDriver driver2) {
        return DbImplUtilCore.getDbms(driver2) == Dbms.REDSHIFT;
    }

    private static boolean likelyGreenplumDriver(DatabaseDriver driver2) {
        return DbImplUtilCore.getDbms(driver2) == Dbms.GREENPLUM;
    }

    private static boolean likelyAzureDriver(DatabaseDriver driver2) {
        return DbImplUtilCore.getDbms(driver2) == Dbms.AZURE || StringUtil.containsIgnoreCase((String)driver2.getName(), (String)"azure");
    }

    @NotNull
    public static LocalDataSource getLocalDataSource(@Nullable DbDataSource info2) {
        return DbImplUtilCore.getLocalDataSource((DasDataSource)info2);
    }

    @NotNull
    public static LocalDataSource getLocalDataSource(@Nullable DasDataSource info2) {
        RawDataSource dataSource2 = DbImplUtilCore.unwrapDS(info2);
        if (dataSource2 instanceof LocalDataSource) {
            LocalDataSource localDataSource = (LocalDataSource)dataSource2;
            if (localDataSource == null) {
                DbImplUtilCore.$$$reportNull$$$0(62);
            }
            return localDataSource;
        }
        throw new AssertionError(info2);
    }

    public static Map<String, Object> resultRowAsMap(DatabaseConnectionCore connection2, String query) throws SQLException {
        return SmartStatementFactoryService.getInstance().poweredBy(connection2).simple().noisy().execute(query, StandardResultsProcessors.throwableResultsTransformer(rs -> {
            if (!rs.next()) {
                return Collections.emptyMap();
            }
            try {
                LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>();
                RemoteResultSetMetaData metaData = rs.getMetaData();
                int count = metaData.getColumnCount();
                for (int i2 = 1; i2 <= count; ++i2) {
                    result2.put(metaData.getColumnName(i2), rs.getObject(i2));
                }
                return result2;
            }
            catch (Exception exception) {
                return Collections.emptyMap();
            }
        }, Collections.emptyMap()));
    }

    public static Map<String, Object> resultRowAsMap(DatabaseConnectionCore connection2, String query, String ... columnSelection) throws SQLException {
        Map<String, Object> res2 = DbImplUtilCore.resultRowAsMap(connection2, query);
        if (columnSelection.length > 0 && !res2.isEmpty()) {
            assert (columnSelection.length % 2 == 0);
            LinkedHashMap<String, Object> map2 = new LinkedHashMap<String, Object>();
            for (int i2 = 0; i2 < columnSelection.length; i2 += 2) {
                Object o2 = res2.get(columnSelection[i2]);
                if (o2 == null) continue;
                map2.put(columnSelection[i2 + 1], o2);
            }
            return map2;
        }
        return res2;
    }

    private static String getNameQuotingAware(@NotNull DasObject object, @NotNull NamingService namingService2) {
        if (object == null) {
            DbImplUtilCore.$$$reportNull$$$0(63);
        }
        if (namingService2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(64);
        }
        String name2 = object.getName();
        return object.isQuoted() ? namingService2.enquote(name2, object.getKind()) : name2;
    }

    @NotNull
    @NonNls
    public static String renderRoutineHeader(@NotNull DasRoutine routine2, @NotNull Dbms dbms) {
        if (routine2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(65);
        }
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(66);
        }
        StringBuilder builder = new StringBuilder();
        NamingService namingService2 = NamingServices.getNamingService(dbms);
        builder.append((Object)routine2.getRoutineKind());
        builder.append(" ");
        builder.append(DbImplUtilCore.getNameQuotingAware(routine2, namingService2));
        builder.append("(");
        for (DasArgument dasArgument : routine2.getArguments()) {
            builder.append(StringUtil.defaultIfEmpty((String)DbImplUtilCore.getNameQuotingAware(dasArgument, namingService2), (String)"?"));
            builder.append(" ");
            builder.append(StringUtil.notNullize((String)dasArgument.getDasType().getSpecification()));
        }
        builder.append(")");
        DasArgument returnArgument2 = routine2.getReturnArgument();
        if (returnArgument2 != null) {
            builder.append(" ");
            builder.append(dbms.isOracle() || dbms.isVertica() ? "return" : "returns");
            builder.append(" ");
            builder.append(StringUtil.notNullize((String)returnArgument2.getDasType().getSpecification()));
        }
        String string = builder.toString();
        if (string == null) {
            DbImplUtilCore.$$$reportNull$$$0(67);
        }
        return string;
    }

    public static boolean writeVFSAttributeSafe(@NotNull VirtualFile file, @NotNull FileAttribute attribute, @Nullable String value2) {
        if (file == null) {
            DbImplUtilCore.$$$reportNull$$$0(68);
        }
        if (attribute == null) {
            DbImplUtilCore.$$$reportNull$$$0(69);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return false;
        }
        try {
            return DbImplUtilCore.writeVFSAttribute(file, attribute, value2);
        }
        catch (IOException ex) {
            LOG.warn((Throwable)ex);
            return false;
        }
    }

    @Nullable
    public static String readVFSAttributeSafe(@NotNull VirtualFile file, @NotNull FileAttribute attribute) {
        if (file == null) {
            DbImplUtilCore.$$$reportNull$$$0(70);
        }
        if (attribute == null) {
            DbImplUtilCore.$$$reportNull$$$0(71);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return null;
        }
        try {
            return DbImplUtilCore.readVFSAttribute(file, attribute);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static boolean writeVFSAttribute(@NotNull VirtualFile fileOrDir, @NotNull FileAttribute attribute, @Nullable String value2) throws IOException {
        String oldValue;
        if (fileOrDir == null) {
            DbImplUtilCore.$$$reportNull$$$0(72);
        }
        if (attribute == null) {
            DbImplUtilCore.$$$reportNull$$$0(73);
        }
        if (Objects.equals(oldValue = DbImplUtilCore.readVFSAttribute(fileOrDir, attribute), value2)) {
            return false;
        }
        try (AttributeOutputStream oStream = attribute.writeFileAttribute(fileOrDir);){
            oStream.writeEnumeratedString(value2);
        }
        return true;
    }

    @Nullable
    public static String readVFSAttribute(VirtualFile fileOrDir, FileAttribute attribute) throws IOException {
        try (AttributeInputStream iStream = attribute.readFileAttribute(fileOrDir);){
            if (iStream != null) {
                String string = StringUtil.nullize((String)iStream.readEnumeratedString());
                return string;
            }
        }
        return null;
    }

    @Nullable
    public static LocalDataSource getMaybeLocalDataSource(@Nullable DasDataSource info2) {
        RawDataSource dataSource2 = DbImplUtilCore.unwrapDS(info2);
        return dataSource2 instanceof LocalDataSource ? (LocalDataSource)dataSource2 : null;
    }

    @Nullable
    public static SqlDataSource getMaybeSqlDataSource(@Nullable DasDataSource info2) {
        RawDataSource dataSource2 = DbImplUtilCore.unwrapDS(info2);
        return dataSource2 instanceof SqlDataSource ? (SqlDataSource)dataSource2 : null;
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static RawDataSource unwrapDS(@Nullable DasDataSource database) {
        if (database == null || database instanceof RawDataSource) {
            return (RawDataSource)database;
        }
        if (database instanceof DbDataSource) {
            return ((DbDataSource)database).getDelegate();
        }
        throw new AssertionError(database);
    }

    @Nullable
    public static TreePattern getIntrospectionScope(@Nullable DasDataSource info2) {
        LocalDataSource ds = DbImplUtilCore.getMaybeLocalDataSource(info2);
        return ds == null ? null : ds.getIntrospectionScope();
    }

    @Nullable
    public static BasicElement getMaybeBasicElement(@Nullable DasObject o2) {
        Object delegate = DbImplUtilCore.unwrap(o2);
        if (delegate instanceof DasDataSource) {
            BasicModel model2 = (BasicModel)ObjectUtils.tryCast((Object)((DasDataSource)delegate).getModel(), BasicModel.class);
            return model2 == null ? null : model2.getRoot();
        }
        return delegate instanceof BasicElement ? (BasicElement)delegate : null;
    }

    @NotNull
    public static JdbcHelper getJdbcHelper(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(74);
        }
        JdbcHelper jdbcHelper = JDBC_HELPER_EP.forDbms(dbms);
        if (jdbcHelper == null) {
            DbImplUtilCore.$$$reportNull$$$0(75);
        }
        return jdbcHelper;
    }

    public static DdlBuilder createBuilderForExec(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            DbImplUtilCore.$$$reportNull$$$0(76);
        }
        return new DdlBuilder().withDialect(dialect).qualifyReferences(true).quoteIdentifiers(true);
    }

    public static DdlBuilder createBuilderForUIExec(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(77);
        }
        return DbImplUtilCore.createBuilderForUIExec(dbms, null);
    }

    public static DdlBuilder createBuilderForUIExec(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            DbImplUtilCore.$$$reportNull$$$0(78);
        }
        return DbImplUtilCore.createBuilderForUIExec(dialect, null);
    }

    public static DdlBuilder createBuilderForUIExec(@NotNull Dbms dbms, @Nullable DasObject object) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(79);
        }
        DatabaseDialectEx dialect = DbImplUtilCore.getDatabaseDialect(dbms);
        return DbImplUtilCore.createBuilderForUIExec(dialect, object);
    }

    public static boolean omitSchemaQualifier() {
        return Registry.is((String)"database.query.generation.omit.schema.qualifier", (boolean)false);
    }

    public static DdlBuilder createBuilderForUIExec(@NotNull DatabaseDialectEx dialect, @Nullable DasObject object) {
        if (dialect == null) {
            DbImplUtilCore.$$$reportNull$$$0(80);
        }
        DdlBuilder builder = DbImplUtilCore.createBuilderForExec(dialect).qualifyReferences(!DbImplUtilCore.omitSchemaQualifier()).quoteIdentifiers(false);
        DbElement element2 = DbImplUtilCore.getDbElement(object);
        return element2 != null ? builder.withCasingFor(element2) : builder;
    }

    @Nullable
    private static DbElement getDbElement(@Nullable DasObject object) {
        return DasUtil.getParentOfClass(object, DbDataSource.class, false);
    }

    @Nullable
    public static RemoteCloseable setStatementParameter(@NotNull RemotePreparedStatement statement2, @NotNull JdbcColumnDescriptor column2, @Nullable Object value2, @NotNull Dbms dbms, boolean needsEscaping, int idx, @NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) throws Exception {
        if (statement2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(81);
        }
        if (column2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(82);
        }
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(83);
        }
        if (formatsCache == null) {
            DbImplUtilCore.$$$reportNull$$$0(84);
        }
        if (formatterCreator == null) {
            DbImplUtilCore.$$$reportNull$$$0(85);
        }
        ColumnInfo info2 = new ColumnInfo(column2.getJavaClassName(), column2.getTypeName(), column2.getType(), idx);
        return statement2.setObject(DbImplUtilCore.prepareValue(dbms, value2, formatsCache, formatterCreator), info2, needsEscaping, idx);
    }

    @NotNull
    public static ModelHelper getModelHelper(@NotNull BasicElement element2) {
        if (element2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(86);
        }
        return DbImplUtilCore.getModelHelper(DbImplUtilCore.getDbms(element2));
    }

    @NotNull
    public static ModelHelper getModelHelper(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(87);
        }
        ModelHelper modelHelper = ModelFacade.forDbms(dbms).getModelHelper();
        if (modelHelper == null) {
            DbImplUtilCore.$$$reportNull$$$0(88);
        }
        return modelHelper;
    }

    @Nullable
    public static DbDataSource findDataSource(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DbImplUtilCore.$$$reportNull$$$0(89);
        }
        if (DbSrcUtilsCore.isDbSrcFile(file)) {
            return DbPsiFacade.getInstance(project).findDataSource(DbSrcUtilsCore.getDataSource(file));
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            DatabaseElementVirtualFileImpl dbFile = (DatabaseElementVirtualFileImpl)file;
            return dbFile.findDataSource(project);
        }
        return null;
    }

    @TestOnly
    public static boolean isEditableTable(@NotNull Dbms dbms, @Nullable ObjectKind kind) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(90);
        }
        return DmlHelper.Companion.getEP().forDbms(dbms).isEditableTable(kind);
    }

    @TestOnly
    public static boolean isFilterApplicable(@NotNull Dbms dbms, @Nullable ObjectKind kind) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(91);
        }
        return HookUpHelper.Companion.getEP().forDbms(dbms).isFilterApplicable(kind);
    }

    @TestOnly
    public static boolean isSortingApplicable(@NotNull Dbms dbms, @Nullable ObjectKind kind) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(92);
        }
        return HookUpHelper.Companion.getEP().forDbms(dbms).isSortingApplicable(kind);
    }

    @NotNull
    public static MetaModel getMetaModel(@NotNull DbElement element2) {
        if (element2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(93);
        }
        DbDataSource dataSource2 = element2.getDataSource();
        return DbImplUtilCore.getMetaModel(dataSource2);
    }

    @NotNull
    public static MetaModel getMetaModel(@NotNull DbDataSource dataSource2) {
        if (dataSource2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(94);
        }
        return DbImplUtilCore.getMetaModel((DasDataSource)dataSource2);
    }

    @NotNull
    public static MetaModel getMetaModel(@NotNull DasDataSource dataSource2) {
        BaseModel model2;
        if (dataSource2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(95);
        }
        if ((model2 = (BaseModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BaseModel.class)) != null) {
            MetaModel metaModel = model2.getMetaModel();
            if (metaModel == null) {
                DbImplUtilCore.$$$reportNull$$$0(96);
            }
            return metaModel;
        }
        return DbImplUtilCore.getMetaModel(dataSource2.getDbms());
    }

    public static boolean isInLocalDataSource(@Nullable DbElement element2) {
        return DbImplUtilCore.getLocalDataSource(element2) != null;
    }

    @Nullable
    public static LocalDataSource getLocalDataSource(@Nullable DbElement element2) {
        RawDataSource ds = element2 == null ? null : element2.getDataSource().getDelegate();
        return (LocalDataSource)ObjectUtils.tryCast((Object)ds, LocalDataSource.class);
    }

    public static boolean canConnectTo(@Nullable DbElement element2) {
        RawDataSource ds = element2 == null ? null : element2.getDataSource().getDelegate();
        return ds instanceof LocalDataSource && DbImplUtilCore.canConnectTo((LocalDataSource)ds);
    }

    public static boolean isDdlElement(@Nullable DbElement element2) {
        return element2 != null && DbImplUtilCore.getMaybeSqlDataSource(element2.getDataSource()) != null;
    }

    public static boolean hasDriverFiles(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(97);
        }
        return dataSource2.hasDriverFiles();
    }

    public static boolean canConnectTo(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(98);
        }
        if (StringUtil.isEmptyOrSpaces((String)dataSource2.getUrl())) {
            return false;
        }
        if (!DbImplUtilCore.hasDriverFiles(dataSource2)) {
            return false;
        }
        String driverClass = dataSource2.getDriverClass();
        return !StringUtil.isEmptyOrSpaces((String)driverClass);
    }

    @NotNull
    public static Dbms getDbms(@NotNull BasicElement element2) {
        BasicModel model2;
        if (element2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(99);
        }
        Dbms dbms = (model2 = element2.getModel()) == null ? element2.getMetaObject().getModel().dbms : model2.getDbms();
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(100);
        }
        return dbms;
    }

    @Nullable
    public static DbElement findElement(@NotNull Project project, @Nullable DasDataSource dataSource2, @Nullable DasObject object) {
        if (project == null) {
            DbImplUtilCore.$$$reportNull$$$0(101);
        }
        if (dataSource2 == null || object == null) {
            return null;
        }
        DbDataSource dbDataSource = dataSource2 instanceof DbDataSource ? (DbDataSource)dataSource2 : DbPsiFacade.getInstance(project).findDataSource(dataSource2.getUniqueId());
        return DbImplUtilCore.findElement(dbDataSource, object);
    }

    @Nullable
    public static DbElement findElement(@Nullable DbDataSource dataSource2, @Nullable DasObject object) {
        if (dataSource2 == null || object == null) {
            return null;
        }
        return dataSource2.findElement(object);
    }

    @Nullable
    public static DbElement findElement(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DbImplUtilCore.$$$reportNull$$$0(102);
        }
        if (DbSrcUtilsCore.isDbSrcFile(file)) {
            return DbSrcUtilsCore.findDbElement(project, file.getPath(), DbElement.class);
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            return ((DatabaseElementVirtualFileImpl)file).findElement(project);
        }
        return null;
    }

    public static int countUsagesAsLinkedDataSource(@NotNull Project project, @NotNull String dataSourceUniqueId) {
        if (project == null) {
            DbImplUtilCore.$$$reportNull$$$0(103);
        }
        if (dataSourceUniqueId == null) {
            DbImplUtilCore.$$$reportNull$$$0(104);
        }
        int count = 0;
        DataSourceManager<Class<LocalDataSource>> manager = DataSourceManager.byDataSource(project, LocalDataSource.class);
        if (manager != null) {
            for (LocalDataSource localDataSource : manager.getDataSources()) {
                if (!localDataSource.getLinkedDataSourceIds().containsValue(dataSourceUniqueId)) continue;
                ++count;
            }
        }
        return count;
    }

    public static String usageAsLinkedDSMessage(int count) {
        return DatabaseBundle.message("tooltip.choice.usage.usages", count, count == 1 ? 0 : 1);
    }

    public static boolean supportsTableSampling(@Nullable DasObject table, @NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(105);
        }
        return table != null && dbms.is(Dbms.BIGQUERY) && table.getKind() == ObjectKind.TABLE;
    }

    public static <T> Class<T> classOf(T o2) {
        return o2.getClass();
    }

    public static <K, V> V putOrRemove(Map<K, V> m, K k, @Nullable V v2) {
        if (v2 == null) {
            return m.remove(k);
        }
        return m.put(k, v2);
    }

    public static <T> boolean equals(@NotNull Iterable<T> a, @NotNull Iterable<T> b2, @NotNull PairFunction<? super T, ? super T, Boolean> eq) {
        if (a == null) {
            DbImplUtilCore.$$$reportNull$$$0(106);
        }
        if (b2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(107);
        }
        if (eq == null) {
            DbImplUtilCore.$$$reportNull$$$0(108);
        }
        if (a instanceof Collection && b2 instanceof Collection && ((Collection)a).size() != ((Collection)b2).size()) {
            return false;
        }
        Iterator<T> ait = a.iterator();
        Iterator<T> bit = b2.iterator();
        while (ait.hasNext() && bit.hasNext()) {
            if (((Boolean)eq.fun(ait.next(), bit.next())).booleanValue()) continue;
            return false;
        }
        return !ait.hasNext() && !bit.hasNext();
    }

    @TestOnly
    public static <R> R computeOnPooledThreadSync(@NotNull Computable<R> computable) {
        if (computable == null) {
            DbImplUtilCore.$$$reportNull$$$0(109);
        }
        Ref res2 = Ref.create();
        DbImplUtilCore.invokeOnPooledThreadSync(() -> res2.set(computable.compute()));
        return (R)res2.get();
    }

    @TestOnly
    public static void invokeOnPooledThreadSync(@NotNull Runnable runnable) {
        if (runnable == null) {
            DbImplUtilCore.$$$reportNull$$$0(110);
        }
        SecondaryLoop loop = Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
        Ref th = Ref.create();
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        ProgressIndicator finalIndicator = indicator == null ? new EmptyProgressIndicator() : indicator;
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(() -> {
            try {
                runnable.run();
            }
            catch (Throwable e2) {
                th.set((Object)e2);
            }
            finally {
                DbImplUtilCore.invokeLater(() -> loop.exit());
            }
        }, finalIndicator));
        try (AccessToken ignored = ThreadContext.resetThreadContext();){
            loop.enter();
        }
        if (!th.isNull()) {
            ExceptionUtil.rethrow((Throwable)((Throwable)th.get()));
        }
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            DbImplUtilCore.$$$reportNull$$$0(111);
        }
        UIUtil.invokeLaterIfNeeded((Runnable)runnable);
    }

    public static void invokeLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            DbImplUtilCore.$$$reportNull$$$0(112);
        }
        SwingUtilities.invokeLater(runnable);
    }

    public static boolean switchSchemaThroughJdbcImpl(@Nullable ObjectPath path, @NotNull DatabaseConnectionCore connection2) throws SQLException {
        if (connection2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(113);
        }
        if (path == null) {
            return false;
        }
        ObjectPath schema2 = path.findParent(ObjectKind.SCHEMA, false);
        ObjectPath database = path.findParent(ObjectKind.DATABASE, false);
        if (schema2 == null && database == null) {
            return false;
        }
        boolean swap2 = connection2.getConnectionPoint().getDataSource().getInfo().isJdbcCatalogIsSchema();
        ObjectPath jdbcDb = swap2 ? schema2 : database;
        ObjectPath jdbcSc = !swap2 ? schema2 : database;
        JdbcNativeUtil.performRemote(() -> {
            if (jdbcDb != null) {
                connection2.getRemoteConnection().setCatalog(jdbcDb.name);
            }
            if (jdbcSc != null) {
                connection2.getRemoteConnection().setSchema(jdbcSc.name);
            }
        });
        return true;
    }

    @Nullable
    public static ObjectPath getSchemaThroughJdbcImpl(@NotNull DatabaseConnectionCore connection2) {
        if (connection2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(114);
        }
        RemoteConnection remoteConnection = connection2.getRemoteConnection();
        String catalog = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteConnection)remoteConnection).getCatalog());
        String schema2 = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteConnection)remoteConnection).getSchema());
        if (schema2 == null && catalog == null) {
            return null;
        }
        if (connection2.getConnectionPoint().getDataSource().getInfo().isJdbcCatalogIsSchema()) {
            String tmp = catalog;
            catalog = schema2;
            schema2 = tmp;
        }
        ObjectPath dbPath = ObjectPath.create(StringUtil.notNullize((String)catalog), ObjectKind.DATABASE);
        if (schema2 == null) {
            return dbPath;
        }
        return dbPath.append(schema2, ObjectKind.SCHEMA);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 19, 20, 21, 22, 23, 26, 27, 28, 29, 33, 41, 42, 43, 44, 45, 46, 47, 49, 51, 62, 67, 75, 88, 96, 100 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: 
            case 17: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 55: 
            case 56: 
            case 66: 
            case 74: 
            case 77: 
            case 79: 
            case 83: 
            case 87: 
            case 90: 
            case 91: 
            case 92: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 2: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 62: 
            case 67: 
            case 75: 
            case 88: 
            case 96: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbImplUtilCore";
                break;
            }
            case 3: 
            case 16: 
            case 76: 
            case 78: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 94: 
            case 95: 
            case 97: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 5: 
            case 30: 
            case 89: 
            case 101: 
            case 102: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 8: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatsCache";
                break;
            }
            case 9: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatterCreator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fkey";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refColNames";
                break;
            }
            case 18: 
            case 86: 
            case 93: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 32: 
            case 110: 
            case 111: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 37: 
            case 39: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traverser";
                break;
            }
            case 52: 
            case 113: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDrivers";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drivers";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namingService";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 69: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceUniqueId";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eq";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbImplUtilCore";
                break;
            }
            case 2: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 19: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasingProvider";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "guessDbms";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "traverseVisibleObjects";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaces";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalDataSource";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "renderRoutineHeader";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdbcHelper";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSchema";
                break;
            }
            case 1: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getMetaModel";
                break;
            }
            case 2: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 62: 
            case 67: 
            case 75: 
            case 88: 
            case 96: 
            case 100: {
                break;
            }
            case 3: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPathObject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDbDataSource";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prepareValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareDate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "familyOf";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveKey";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPathObjectForSwitch";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "buildObjectFilter";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isExpandable";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getForcedDataSource";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "performSrcOperation";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isRoutine";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPageSize";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isLimitDefaultPageSize";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isZonedTimeColumn";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isZonedTimestampColumn";
                break;
            }
            case 48: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "traverseVisibleObjects";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getRowCount";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "hasUniqueIndex";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "escapeSql";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "guessDatabaseDriver";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "disambiguate";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getNameQuotingAware";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "renderRoutineHeader";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "writeVFSAttributeSafe";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "readVFSAttributeSafe";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "writeVFSAttribute";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getJdbcHelper";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderForExec";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderForUIExec";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "setStatementParameter";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getModelHelper";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "findDataSource";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "isEditableTable";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "isFilterApplicable";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "isSortingApplicable";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "hasDriverFiles";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "canConnectTo";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getDbms";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "countUsagesAsLinkedDataSource";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "supportsTableSampling";
                break;
            }
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "computeOnPooledThreadSync";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnPooledThreadSync";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "switchSchemaThroughJdbcImpl";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaThroughJdbcImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 19, 20, 21, 22, 23, 26, 27, 28, 29, 33, 41, 42, 43, 44, 45, 46, 47, 49, 51, 62, 67, 75, 88, 96, 100 -> new IllegalStateException(string);
        };
    }

    public static class ConcatenationProps {
        public String rowSep;
        public String colSep;
        public boolean lTrim;
        public boolean rTrim;
        public static final ConcatenationProps LINES = new ConcatenationProps("\n", " ", false, false);
        public static final ConcatenationProps TIGHT = new ConcatenationProps("", "", false, false);
        public static final ConcatenationProps NO_CONCAT = LINES;

        public ConcatenationProps(String rowSep, String colSep, boolean lTrim, boolean rTrim) {
            this.rowSep = rowSep;
            this.colSep = colSep;
            this.lTrim = lTrim;
            this.rTrim = rTrim;
        }

        public String toString() {
            return "ConcatenationProps{rowSep='" + this.rowSep + "', colSep='" + this.colSep + "', lTrim=" + this.lTrim + ", rTrim=" + this.rTrim + "}";
        }
    }

    public static abstract class HashingStrategyUnique<T>
    extends JBIterable.SCond<T>
    implements Hash.Strategy<T> {
        private Set<T> myVisited;

        public boolean value(T t) {
            if (this.myVisited == null) {
                this.myVisited = new ObjectOpenCustomHashSet((Hash.Strategy)this);
            }
            return this.myVisited.add(t);
        }
    }

    public static enum StringLiteralDecorator {
        CONTAINS("%", "%", true),
        STARTS_WITH(null, "%", true),
        ENDS_WITH("%", null, true),
        MATCHES(null, null, true),
        PLAIN(null, null, false);

        private final String myPrefix;
        private final String mySuffix;
        private final boolean myEscapeSqlRegexSymbols;

        private StringLiteralDecorator(String prefix, String suffix2, boolean escapeSqlRegexSymbols) {
            this.myPrefix = prefix;
            this.mySuffix = suffix2;
            this.myEscapeSqlRegexSymbols = escapeSqlRegexSymbols;
        }

        @NotNull
        public String decorate(@NotNull String text2, @NotNull Dbms dbms) {
            if (text2 == null) {
                StringLiteralDecorator.$$$reportNull$$$0(0);
            }
            if (dbms == null) {
                StringLiteralDecorator.$$$reportNull$$$0(1);
            }
            String string = this.decorate(text2, dbms, false);
            if (string == null) {
                StringLiteralDecorator.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String decorate(@NotNull String text2, @NotNull Dbms dbms, boolean multiline) {
            if (text2 == null) {
                StringLiteralDecorator.$$$reportNull$$$0(3);
            }
            if (dbms == null) {
                StringLiteralDecorator.$$$reportNull$$$0(4);
            }
            String string = this.decorate(text2, dbms, multiline, null);
            if (string == null) {
                StringLiteralDecorator.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String decorate(@NotNull String text2, @NotNull Dbms dbms, boolean multiline, @Nullable JdbcHelper helper) {
            if (text2 == null) {
                StringLiteralDecorator.$$$reportNull$$$0(6);
            }
            if (dbms == null) {
                StringLiteralDecorator.$$$reportNull$$$0(7);
            }
            String string = DbSqlUtilCore.toStringLiteral(text2, dbms, this.myEscapeSqlRegexSymbols, this.myPrefix, this.mySuffix, multiline, helper != null ? helper : DbImplUtilCore.getJdbcHelper(dbms));
            if (string == null) {
                StringLiteralDecorator.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/DbImplUtilCore$StringLiteralDecorator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/DbImplUtilCore$StringLiteralDecorator";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decorate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "decorate";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5, 8 -> new IllegalStateException(string);
            };
        }
    }
}

