/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicPaths {
    @Contract(value="!null->!null")
    public static ObjectPath of(@Nullable BasicElement o2) {
        return BasicPaths.of(o2, null);
    }

    @Contract(value="!null->!null")
    public static ObjectPath of(@Nullable BasicObjectNode o2) {
        if (o2 == null) {
            return null;
        }
        BasicObjectNode parent2 = o2.getParent();
        if (parent2 != null && parent2.getMetaObject().kind == ObjectKind.ROOT) {
            parent2 = null;
        }
        return BasicPaths.append(o2.extractObject(), null, BasicPaths.of(parent2));
    }

    @Contract(value="!null,_->!null")
    public static ObjectPath of(@Nullable BasicElement o2, @Nullable CasingProvider normalizer) {
        if (o2 == null) {
            return null;
        }
        BasicElement parent2 = o2.getParent();
        if (parent2 != null && parent2.getKind() == ObjectKind.ROOT) {
            parent2 = null;
        }
        return BasicPaths.append(o2, normalizer, BasicPaths.of(parent2, normalizer));
    }

    @NotNull
    public static ObjectPath append(@NotNull BasicElement o2, @Nullable ObjectPath parentPath) {
        if (o2 == null) {
            BasicPaths.$$$reportNull$$$0(0);
        }
        return BasicPaths.append(o2, null, parentPath);
    }

    @NotNull
    public static ObjectPath append(@NotNull BasicElement o2, @Nullable CasingProvider normalizer, @Nullable ObjectPath parentPath) {
        if (o2 == null) {
            BasicPaths.$$$reportNull$$$0(1);
        }
        return BasicPaths.append(o2, o2.getName(), normalizer, parentPath);
    }

    @NotNull
    public static ObjectPath append(@NotNull BasicElement o2, @NotNull String name2, @Nullable CasingProvider normalizer, @Nullable ObjectPath parentPath) {
        if (o2 == null) {
            BasicPaths.$$$reportNull$$$0(2);
        }
        if (name2 == null) {
            BasicPaths.$$$reportNull$$$0(3);
        }
        return BasicPaths.createNormalized(o2, name2, BasicPaths.isQuoted(o2), BasicPaths.getIdentity(o2), parentPath, normalizer);
    }

    @NotNull
    public static ObjectPath createNormalized(@NotNull DasObject o2, boolean quoted, @Nullable String identity, @Nullable ObjectPath parentPath, @Nullable CasingProvider normalizer) {
        if (o2 == null) {
            BasicPaths.$$$reportNull$$$0(4);
        }
        return BasicPaths.createNormalized(o2, o2.getName(), quoted, identity, parentPath, normalizer);
    }

    @NotNull
    public static ObjectPath createNormalized(@NotNull DasObject o2, @NotNull String name2, boolean quoted, @Nullable String identity, @Nullable ObjectPath parentPath, @Nullable CasingProvider normalizer) {
        if (o2 == null) {
            BasicPaths.$$$reportNull$$$0(5);
        }
        if (name2 == null) {
            BasicPaths.$$$reportNull$$$0(6);
        }
        ObjectKind kind = o2.getKind();
        if (normalizer != null) {
            Casing casing = normalizer.getCasing(kind, o2);
            Case q2 = casing.choose(!quoted);
            name2 = q2.apply(name2);
            if (!(quoted || q2 == Case.MIXED && casing.quoted != Case.MIXED)) {
                quoted = true;
            }
        }
        ObjectPath objectPath = ObjectPath.create(name2, kind, quoted, identity, parentPath);
        if (objectPath == null) {
            BasicPaths.$$$reportNull$$$0(7);
        }
        return objectPath;
    }

    public static boolean isQuoted(@NotNull BasicElement o2) {
        if (o2 == null) {
            BasicPaths.$$$reportNull$$$0(8);
        }
        return !(o2 instanceof BasicNamedElement) || ((BasicNamedElement)o2).isNameQuoted() || !((BasicNamedElement)o2).isNameScripted();
    }

    @Nullable
    public static String getIdentity(@NotNull BasicElement obj2) {
        if (obj2 == null) {
            BasicPaths.$$$reportNull$$$0(9);
        }
        return BasicPaths.getIdentity(obj2, false, true);
    }

    @Nullable
    public static String getIdentity(@NotNull BasicElement obj2, boolean normalize, boolean withSurrogates) {
        if (obj2 == null) {
            BasicPaths.$$$reportNull$$$0(10);
        }
        return StringUtil.nullize((String)obj2.identity(withSurrogates, true, normalize));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/BasicPaths";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/BasicPaths";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createNormalized";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNormalized";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isQuoted";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIdentity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

