/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.SqlUiService;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.ErrorHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncPromiseKt;
import org.jetbrains.concurrency.Promise;

public final class AsyncUtil {
    private static final Key<Boolean> ASYNC_FRIENDLY = Key.create((String)"ASYNC_FRIENDLY");

    public static Executor transactionExecutor(@NotNull Disposable d2, @NotNull ModalityState modality, boolean later) {
        if (d2 == null) {
            AsyncUtil.$$$reportNull$$$0(0);
        }
        if (modality == null) {
            AsyncUtil.$$$reportNull$$$0(1);
        }
        AppUIExecutor executor = (AppUIExecutor)AppUIExecutor.onWriteThread((ModalityState)modality).expireWith(d2);
        if (later) {
            executor = executor.later();
        }
        return arg_0 -> ((AppUIExecutor)executor).submit(arg_0);
    }

    public static Executor transactionExecutor(@NotNull Disposable d2) {
        if (d2 == null) {
            AsyncUtil.$$$reportNull$$$0(2);
        }
        return AsyncUtil.transactionExecutor(d2, ModalityState.defaultModalityState(), false);
    }

    @Nullable
    public static ProgressIndicator getAsyncFriendlyIndicator() {
        return AsyncUtil.getIfAsyncFriendly(ProgressManager.getInstance().getProgressIndicator());
    }

    @Nullable
    public static ProgressIndicator getIfAsyncFriendly(ProgressIndicator indicator) {
        if (AsyncUtil.isAsyncFriendly(indicator)) {
            if (indicator == null || indicator.isRunning()) {
                return indicator;
            }
            return null;
        }
        return null;
    }

    @Contract(value="!null->!null")
    public static Throwable unwrap(@Nullable Throwable e2) {
        Throwable first2 = (Throwable)AsyncUtil.traverse(e2).skipWhile(o2 -> o2.getCause() != null && (o2 instanceof CompletionException || o2 instanceof ExecutionException || o2 instanceof com.intellij.execution.ExecutionException && o2.getCause() instanceof ProcessCanceledException || o2 instanceof SQLException && (o2.getCause().getClass() == RuntimeException.class || o2.getCause().getClass() == SQLException.class) || o2.getClass() == RuntimeException.class)).first();
        return first2 instanceof CancellationException ? new ProcessCanceledException() : first2;
    }

    @NotNull
    public static @NotNull JBIterable<@NotNull Throwable> traverse(@Nullable Throwable e2) {
        JBIterable jBIterable = JBIterable.generate((Object)e2, Throwable::getCause);
        if (jBIterable == null) {
            AsyncUtil.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    public static boolean isAsyncFriendly(@Nullable ProgressIndicator indicator) {
        return indicator == null || indicator instanceof EmptyProgressIndicator || indicator instanceof EmptyProgressIndicatorEx || indicator instanceof SqlUiService.DummyProgressIndicator || indicator instanceof UserDataHolder && ASYNC_FRIENDLY.get((UserDataHolder)indicator) == Boolean.TRUE;
    }

    public static <T extends ProgressIndicator> T markAsyncFriendly(@Nullable T indicator, boolean friendly) {
        if (indicator instanceof UserDataHolder) {
            ASYNC_FRIENDLY.set((UserDataHolder)indicator, (Object)(friendly ? Boolean.TRUE : null));
        }
        return indicator;
    }

    public static <T> CompletionStage<T> supplyAsync(@NotNull Supplier<? extends CompletionStage<T>> s2, @NotNull Executor e2) {
        if (s2 == null) {
            AsyncUtil.$$$reportNull$$$0(4);
        }
        if (e2 == null) {
            AsyncUtil.$$$reportNull$$$0(5);
        }
        return AsyncUtil.thenComposeAsync(CompletableFuture.completedFuture(null), x -> (CompletionStage)s2.get(), e2);
    }

    public static <U, T> CompletionStage<T> thenComposeAsync(@NotNull CompletionStage<? extends U> s2, @NotNull Function<? super U, ? extends CompletionStage<T>> f, @NotNull Executor e2) {
        if (s2 == null) {
            AsyncUtil.$$$reportNull$$$0(6);
        }
        if (f == null) {
            AsyncUtil.$$$reportNull$$$0(7);
        }
        if (e2 == null) {
            AsyncUtil.$$$reportNull$$$0(8);
        }
        CompletableFuture result2 = new CompletableFuture();
        AsyncUtil.processWhenComplete(s2, result2, r -> e2.execute(() -> {
            try {
                AsyncUtil.processWhenComplete((CompletionStage)f.apply((Object)r), result2, result2::complete);
            }
            catch (Throwable th) {
                result2.completeExceptionally(th);
            }
        }));
        return result2;
    }

    private static <T> void processWhenComplete(@NotNull CompletionStage<T> what, @NotNull CompletableFuture<?> where2, @NotNull Consumer<? super T> cons) {
        if (what == null) {
            AsyncUtil.$$$reportNull$$$0(9);
        }
        if (where2 == null) {
            AsyncUtil.$$$reportNull$$$0(10);
        }
        if (cons == null) {
            AsyncUtil.$$$reportNull$$$0(11);
        }
        AsyncUtil.handleWhenComplete(what, where2, (r, th) -> {
            if (th != null) {
                where2.completeExceptionally((Throwable)th);
            } else {
                cons.consume(r);
            }
        });
    }

    private static <T> void handleWhenComplete(@NotNull CompletionStage<T> what, @NotNull CompletableFuture<?> where2, @NotNull BiConsumer<? super T, ? super Throwable> cons) {
        if (what == null) {
            AsyncUtil.$$$reportNull$$$0(12);
        }
        if (where2 == null) {
            AsyncUtil.$$$reportNull$$$0(13);
        }
        if (cons == null) {
            AsyncUtil.$$$reportNull$$$0(14);
        }
        try {
            what.whenComplete((r, th) -> {
                try {
                    cons.accept((Object)r, (Throwable)th);
                }
                catch (Throwable ex) {
                    where2.completeExceptionally(ex);
                }
            });
        }
        catch (Throwable ex) {
            where2.completeExceptionally(ex);
        }
    }

    public static <T> T underProgress(@NotNull Supplier<T> r, @Nullable ProgressIndicator indicator) {
        if (r == null) {
            AsyncUtil.$$$reportNull$$$0(15);
        }
        Ref res2 = Ref.create();
        AsyncUtil.underProgress(() -> res2.set(r.get()), indicator);
        return (T)res2.get();
    }

    public static void underProgress(@NotNull Runnable r, @Nullable ProgressIndicator indicator) {
        if (r == null) {
            AsyncUtil.$$$reportNull$$$0(16);
        }
        ProgressManager.getInstance().executeProcessUnderProgress(r, indicator);
    }

    public static void finish(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            AsyncUtil.$$$reportNull$$$0(17);
        }
        indicator.stop();
        if (indicator instanceof ProgressIndicatorEx) {
            ((ProgressIndicatorEx)indicator).processFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T withAsyncFriendly(@Nullable ProgressIndicator indicator, @NotNull ThrowableComputable<T, E> computable) throws E {
        boolean wasFriendly;
        if (computable == null) {
            AsyncUtil.$$$reportNull$$$0(18);
        }
        if (!(wasFriendly = AsyncUtil.isAsyncFriendly(indicator))) {
            AsyncUtil.markAsyncFriendly(indicator, true);
        }
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            if (!wasFriendly) {
                AsyncUtil.markAsyncFriendly(indicator, false);
            }
        }
    }

    @RequiresEdt
    public static ProgressIndicatorEx createBackgroundIndicator(@Nullable Project project, @NotNull @NlsContexts.ProgressTitle String name2) {
        if (name2 == null) {
            AsyncUtil.$$$reportNull$$$0(19);
        }
        ThreadingAssertions.assertEventDispatchThread();
        return AsyncUtil.createBackgroundIndicator(project, name2, true);
    }

    @RequiresEdt
    public static ProgressIndicatorEx createBackgroundIndicator(@Nullable Project project, @NotNull @NlsContexts.ProgressTitle String name2, boolean cancellable) {
        if (name2 == null) {
            AsyncUtil.$$$reportNull$$$0(20);
        }
        ThreadingAssertions.assertEventDispatchThread();
        return AsyncUtil.markAsyncFriendly(SqlUiService.getInstance().createBackgroundableIndicator(project, name2, cancellable), true);
    }

    public static <T> CompletableFuture<T> cancelled() {
        CompletableFuture res2 = new CompletableFuture();
        res2.cancel(false);
        return res2;
    }

    public static <T> CompletableFuture<T> exceptional(@NotNull Throwable th) {
        if (th == null) {
            AsyncUtil.$$$reportNull$$$0(21);
        }
        CompletableFuture res2 = new CompletableFuture();
        res2.completeExceptionally(th);
        return res2;
    }

    public static <T> void transfer(@NotNull CompletionStage<T> from, @NotNull CompletableFuture<T> to) {
        if (from == null) {
            AsyncUtil.$$$reportNull$$$0(22);
        }
        if (to == null) {
            AsyncUtil.$$$reportNull$$$0(23);
        }
        from.handle((r, th) -> th == null ? to.complete(r) : to.completeExceptionally((Throwable)th));
    }

    @Contract(value="_->fail")
    public static void rethrow(@NotNull Throwable e2) {
        if (e2 == null) {
            AsyncUtil.$$$reportNull$$$0(24);
        }
        if (AsyncUtil.isCancellation(e2)) {
            ProcessCanceledException r = new ProcessCanceledException();
            r.addSuppressed(AsyncUtil.unwrap(e2));
            throw r;
        }
        ExceptionUtil.rethrow((Throwable)e2);
    }

    public static boolean isCancellation(@Nullable Throwable e2) {
        return AsyncUtil.traverse(e2).find(o2 -> o2 instanceof ProcessCanceledException && o2.getCause() == null || o2 instanceof CancellationException) != null;
    }

    public static void addUnhandledError(@NotNull ErrorHandler errorHandler, @Nullable Throwable e2, @Nullable LocalDataSource dataSource2) {
        if (errorHandler == null) {
            AsyncUtil.$$$reportNull$$$0(25);
        }
        if (e2 == null || AsyncUtil.isCancellation(e2)) {
            return;
        }
        Throwable unwrapped = AsyncUtil.unwrap(e2);
        errorHandler.add(JdbcEngineUtils.getErrorInfo(unwrapped, dataSource2), true);
    }

    public static <T> Promise<T> runAsync(@NotNull Supplier<? extends Promise<T>> s2, @NotNull Executor e2) {
        if (s2 == null) {
            AsyncUtil.$$$reportNull$$$0(26);
        }
        if (e2 == null) {
            AsyncUtil.$$$reportNull$$$0(27);
        }
        AsyncPromise res2 = new AsyncPromise();
        e2.execute(() -> AsyncPromiseKt.catchError((AsyncPromise)res2, () -> AsyncUtil.lambda$runAsync$9((Supplier)s2, res2)));
        return res2;
    }

    public static Executor getPoolExecutor() {
        return arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0);
    }

    public static Executor getEdtExecutor() {
        return r -> ModalityUiUtil.invokeLaterIfNeeded((ModalityState)AsyncTask.getCurrentModality(), (Runnable)r);
    }

    public static Executor getEdtExecutor(ModalityState modalityState) {
        return r -> ModalityUiUtil.invokeLaterIfNeeded((ModalityState)modalityState, (Runnable)r);
    }

    public static Executor getEdtLaterExecutor() {
        return r -> ApplicationManager.getApplication().invokeLater(r, AsyncTask.getCurrentModality());
    }

    public static Executor getEdtLaterExecutor(ModalityState modalityState) {
        return r -> ApplicationManager.getApplication().invokeLater(r, modalityState);
    }

    public static Executor getNonEdtExecutor() {
        return command2 -> {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                ApplicationManager.getApplication().executeOnPooledThread(command2);
            } else {
                command2.run();
            }
        };
    }

    private static /* synthetic */ Object lambda$runAsync$9(Supplier s2, AsyncPromise res2) {
        ((Promise)s2.get()).processed((Promise)res2);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/AsyncUtil";
                break;
            }
            case 4: 
            case 6: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: 
            case 8: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cons";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "th";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/AsyncUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "traverse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "transactionExecutor";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "supplyAsync";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "thenComposeAsync";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processWhenComplete";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "handleWhenComplete";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "underProgress";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "finish";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "withAsyncFriendly";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createBackgroundIndicator";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "exceptional";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "transfer";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "rethrow";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addUnhandledError";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "runAsync";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static class EmptyProgressIndicatorEx
    extends ProgressIndicatorBase {
    }
}

