/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.types;

import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasBuiltinTypeWithLength;
import com.intellij.database.types.DasBuiltinTypeWithLengthUnits;
import com.intellij.database.types.DasSimpleBuiltinTypeClass;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeInternerKt;
import com.intellij.database.types.DasTypeUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB'\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0013\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0002H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\r\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/types/DasBuiltinTypeWithLengthUnitsImpl;", "Lcom/intellij/database/types/DasBuiltinTypeWithLengthUnits;", "Lcom/intellij/database/types/DasSimpleBuiltinTypeClass;", "typeClass", "length", "", "unit", "Lcom/intellij/database/model/LengthUnit;", "isExplicitUnit", "", "(Lcom/intellij/database/types/DasSimpleBuiltinTypeClass;ILcom/intellij/database/model/LengthUnit;Z)V", "copy", "Lcom/intellij/database/types/DasBuiltinTypeWithLength;", "equals", "other", "", "getDescription", "", "getLength", "getTypeClass", "getUnit", "hashCode", "toDataType", "Lcom/intellij/database/model/DataType;", "Lorg/jetbrains/annotations/NotNull;", "withTypeClass", "newTypeClass", "Companion", "intellij.database.core.impl"})
public final class DasBuiltinTypeWithLengthUnitsImpl
implements DasBuiltinTypeWithLengthUnits<DasSimpleBuiltinTypeClass> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DasSimpleBuiltinTypeClass typeClass;
    private final int length;
    @NotNull
    private final LengthUnit unit;
    private final boolean isExplicitUnit;

    private DasBuiltinTypeWithLengthUnitsImpl(DasSimpleBuiltinTypeClass typeClass, int length, LengthUnit unit, boolean isExplicitUnit) {
        this.typeClass = typeClass;
        this.length = length;
        this.unit = unit;
        this.isExplicitUnit = isExplicitUnit;
    }

    @Override
    @NotNull
    public DasSimpleBuiltinTypeClass getTypeClass() {
        return this.typeClass;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    @NotNull
    public LengthUnit getUnit() {
        return this.unit;
    }

    @Override
    public boolean isExplicitUnit() {
        return this.isExplicitUnit;
    }

    @Override
    @NotNull
    public DasBuiltinTypeWithLength<DasSimpleBuiltinTypeClass> copy(int length) {
        return Companion.of(this.typeClass, length, this.unit, this.isExplicitUnit);
    }

    @Override
    @NotNull
    public DasBuiltinTypeWithLengthUnits<DasSimpleBuiltinTypeClass> copy(int length, @NotNull LengthUnit unit, boolean isExplicitUnit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return Companion.of(this.typeClass, length, unit, isExplicitUnit);
    }

    @NotNull
    public DasBuiltinTypeWithLengthUnitsImpl withTypeClass(@NotNull DasSimpleBuiltinTypeClass newTypeClass) {
        Intrinsics.checkNotNullParameter((Object)newTypeClass, (String)"newTypeClass");
        return Companion.of(newTypeClass, this.length, this.unit, this.isExplicitUnit);
    }

    @Override
    @NotNull
    public String getDescription() {
        StringBuilder stringBuilder;
        String string = DasTypeUtilsKt.renderSize(this.length);
        if (string == null) {
            return DasTypeUtilsKt.getDebugName(this.typeClass);
        }
        String lengthStr = string;
        StringBuilder $this$getDescription_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getDescription_u24lambda_u240.append(DasTypeUtilsKt.getDebugName(this.typeClass));
        $this$getDescription_u24lambda_u240.append("(");
        $this$getDescription_u24lambda_u240.append(lengthStr);
        if (!Intrinsics.areEqual((Object)this.unit, (Object)LengthUnit.NONE) && this.isExplicitUnit) {
            $this$getDescription_u24lambda_u240.append(" ").append(this.unit.suffix);
        }
        $this$getDescription_u24lambda_u240.append(")");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @Override
    @NotNull
    public DataType toDataType() {
        DataType dataType = DataTypeFactory.of(null, this.typeClass.getName(), this.length, 0, this.unit, null, this.isExplicitUnit, false);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
        return dataType;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.database.types.DasBuiltinTypeWithLengthUnitsImpl");
        DasBuiltinTypeWithLengthUnitsImpl cfr_ignored_0 = (DasBuiltinTypeWithLengthUnitsImpl)other;
        if (!Intrinsics.areEqual((Object)this.typeClass, (Object)((DasBuiltinTypeWithLengthUnitsImpl)other).typeClass)) {
            return false;
        }
        if (this.length != ((DasBuiltinTypeWithLengthUnitsImpl)other).length) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.unit, (Object)((DasBuiltinTypeWithLengthUnitsImpl)other).unit)) {
            return false;
        }
        return this.isExplicitUnit == ((DasBuiltinTypeWithLengthUnitsImpl)other).isExplicitUnit;
    }

    public int hashCode() {
        int result2 = this.typeClass.hashCode();
        result2 = 31 * result2 + this.length;
        result2 = 31 * result2 + this.unit.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.isExplicitUnit);
        return result2;
    }

    public /* synthetic */ DasBuiltinTypeWithLengthUnitsImpl(DasSimpleBuiltinTypeClass typeClass, int length, LengthUnit unit, boolean isExplicitUnit, DefaultConstructorMarker $constructor_marker) {
        this(typeClass, length, unit, isExplicitUnit);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/intellij/database/types/DasBuiltinTypeWithLengthUnitsImpl$Companion;", "", "()V", "of", "Lcom/intellij/database/types/DasBuiltinTypeWithLengthUnitsImpl;", "typeClass", "Lcom/intellij/database/types/DasSimpleBuiltinTypeClass;", "length", "", "unit", "Lcom/intellij/database/model/LengthUnit;", "isExplicitUnit", "", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DasBuiltinTypeWithLengthUnitsImpl of(@NotNull DasSimpleBuiltinTypeClass typeClass, int length, @NotNull LengthUnit unit, boolean isExplicitUnit) {
            Intrinsics.checkNotNullParameter((Object)typeClass, (String)"typeClass");
            Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
            return (DasBuiltinTypeWithLengthUnitsImpl)DasTypeInternerKt.intern((DasType)new DasBuiltinTypeWithLengthUnitsImpl(typeClass, length, unit, isExplicitUnit, null));
        }

        public static /* synthetic */ DasBuiltinTypeWithLengthUnitsImpl of$default(Companion companion, DasSimpleBuiltinTypeClass dasSimpleBuiltinTypeClass, int n, LengthUnit lengthUnit, boolean bl, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = -1;
            }
            if ((n3 & 4) != 0) {
                LengthUnit lengthUnit2 = LengthUnit.NONE;
                Intrinsics.checkNotNullExpressionValue((Object)lengthUnit2, (String)"NONE");
                lengthUnit = lengthUnit2;
            }
            if ((n3 & 8) != 0) {
                bl = false;
            }
            return companion.of(dasSimpleBuiltinTypeClass, n, lengthUnit, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

