/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.types;

import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasArrayType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0096\u0002J\b\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/types/DasArrayTypeBase;", "Lcom/intellij/database/types/DasArrayType;", "componentType", "Lcom/intellij/database/types/DasType;", "(Lcom/intellij/database/types/DasType;)V", "equals", "", "other", "", "getComponentType", "getDescription", "", "hashCode", "", "toDataType", "Lcom/intellij/database/model/DataType;", "intellij.database.core.impl"})
public abstract class DasArrayTypeBase
implements DasArrayType {
    @NotNull
    private final DasType componentType;

    public DasArrayTypeBase(@NotNull DasType componentType) {
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        this.componentType = componentType;
    }

    @Override
    @NotNull
    public DasType getComponentType() {
        return this.componentType;
    }

    @Override
    @NotNull
    public String getDescription() {
        if (Intrinsics.areEqual((Object)this.componentType, DasTypeSystemBase.UNKNOWN)) {
            String string = this.getTypeClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }
        return this.getTypeClass().getName() + "(" + this.componentType.getDescription() + ")";
    }

    @Override
    @NotNull
    public DataType toDataType() {
        Object object = Intrinsics.areEqual((Object)this.componentType, DasTypeSystemBase.UNKNOWN) ? this.getTypeClass().getName() : this.componentType.getSpecification() + "[]";
        Intrinsics.checkNotNull((Object)object);
        Object spec2 = object;
        DataType dataType = DataTypeFactory.of((String)spec2);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
        return dataType;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.database.types.DasArrayTypeBase");
        DasArrayTypeBase cfr_ignored_0 = (DasArrayTypeBase)other;
        return Intrinsics.areEqual((Object)this.componentType, (Object)((DasArrayTypeBase)other).componentType) && Intrinsics.areEqual((Object)this.getTypeClass(), (Object)((DasArrayTypeBase)other).getTypeClass());
    }

    public int hashCode() {
        int result2 = this.componentType.hashCode();
        result2 = 31 * result2 + this.getTypeClass().hashCode();
        return result2;
    }
}

