/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.targetChooser;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.targetChooser.DataSourceTargetItem;
import com.intellij.database.targetChooser.DataSourceTargetUtilKt;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J:\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/targetChooser/DataSourceTargetItemRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/intellij/database/targetChooser/DataSourceTargetItem;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.database.impl"})
public final class DataSourceTargetItemRenderer
extends ColoredListCellRenderer<DataSourceTargetItem> {
    @NotNull
    private final Project project;

    public DataSourceTargetItemRenderer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    protected void customizeCellRenderer(@NotNull JList<? extends DataSourceTargetItem> list, @Nullable DataSourceTargetItem value2, int index2, boolean selected, boolean hasFocus) {
        Object object;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        if (value2 == null) {
            this.setIcon(null);
            return;
        }
        if (!selected) {
            Color color = value2.getColor();
            if (color != null) {
                Color it2 = color;
                boolean bl = false;
                this.setBackground(it2);
            }
        }
        if ((object = value2.getDs()) == null || (object = ((LocalDataSource)object).getIcon()) == null) {
            object = Dbms.UNKNOWN.getIcon();
        }
        this.setIcon((Icon)object);
        if (value2.getDs() != null) {
            this.append(value2.getDs().getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else {
            this.append(DatabaseBundle.message("DatabaseScriptRunConfigurationSettingsEditor.Targets.missing", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
        this.append(" / ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        ColoredListCellRenderer coloredListCellRenderer = this;
        LocalDataSource localDataSource = value2.getDs();
        String string = value2.getDsId();
        ObjectPath objectPath = value2.getPath();
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
        DataSourceTargetUtilKt.appendPath(coloredListCellRenderer, localDataSource, string, objectPath, this.project, simpleTextAttributes);
    }
}

