/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.targetChooser;

import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationOptions;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ColoredItem;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/targetChooser/DataSourceTargetItem;", "Lcom/intellij/openapi/util/ColoredItem;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "dsId", "", "path", "Lcom/intellij/database/util/ObjectPath;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/database/dataSource/LocalDataSource;Ljava/lang/String;Lcom/intellij/database/util/ObjectPath;Lcom/intellij/openapi/project/Project;)V", "getDs", "()Lcom/intellij/database/dataSource/LocalDataSource;", "getDsId", "()Ljava/lang/String;", "getPath", "()Lcom/intellij/database/util/ObjectPath;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getColor", "Ljava/awt/Color;", "prepareTarget", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationOptions$Target;", "toString", "intellij.database.impl"})
public final class DataSourceTargetItem
implements ColoredItem {
    @Nullable
    private final LocalDataSource ds;
    @NotNull
    private final String dsId;
    @Nullable
    private final ObjectPath path;
    @NotNull
    private final Project project;

    public DataSourceTargetItem(@Nullable LocalDataSource ds, @NotNull String dsId, @Nullable ObjectPath path, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)dsId, (String)"dsId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.ds = ds;
        this.dsId = dsId;
        this.path = path;
        this.project = project;
    }

    @Nullable
    public final LocalDataSource getDs() {
        return this.ds;
    }

    @NotNull
    public final String getDsId() {
        return this.dsId;
    }

    @Nullable
    public final ObjectPath getPath() {
        return this.path;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DatabaseScriptRunConfigurationOptions.Target prepareTarget() {
        ObjectPath objectPath = this.path;
        return new DatabaseScriptRunConfigurationOptions.Target(this.dsId, objectPath != null ? objectPath.serialize() : null);
    }

    @NotNull
    public String toString() {
        Object object;
        Object object2 = this.ds;
        if (object2 == null || (object2 = ((AbstractDataSource)object2).getName()) == null) {
            object2 = this.dsId;
        }
        if ((object = this.path) == null || (object = ((ObjectPath)object).toString()) == null) {
            object = "";
        }
        return (String)object2 + "/" + (String)object;
    }

    @Nullable
    public Color getColor() {
        return DatabaseColorManager.getColor(this.project, this.ds);
    }
}

