/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.statistic;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DatabaseIntrospectionSession;
import com.intellij.database.introspection.DatabaseModelLoader;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.statistic.DbFusIntrospectionCollector;
import com.intellij.database.statistic.DbFusIntrospectionLogger;
import com.intellij.database.util.DbImplUtil;
import com.intellij.util.containers.JBTreeTraverser;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/statistic/DbFusIntrospectionLogger;", "Lcom/intellij/database/introspection/DatabaseModelLoader$Listener;", "()V", "finished", "", "session", "Lcom/intellij/database/introspection/DatabaseIntrospectionSession;", "result", "Lcom/intellij/database/introspection/DatabaseModelLoader$FinishedState;", "started", "ObjectCounts", "intellij.database.impl"})
public final class DbFusIntrospectionLogger
implements DatabaseModelLoader.Listener {
    @Override
    public void started(@NotNull DatabaseIntrospectionSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        DbFusIntrospectionCollector.INSTANCE.logStarted(session2);
    }

    @Override
    public void finished(@NotNull DatabaseIntrospectionSession session2, @NotNull DatabaseModelLoader.FinishedState result2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        DbFusIntrospectionCollector.INSTANCE.logFinished$intellij_database_impl(session2, result2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/statistic/DbFusIntrospectionLogger$ObjectCounts;", "", "schemas", "", "visibleSchemas", "total", "(III)V", "getSchemas", "()I", "getTotal", "getVisibleSchemas", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "intellij.database.impl"})
    public static final class ObjectCounts {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int schemas;
        private final int visibleSchemas;
        private final int total;

        public ObjectCounts(int schemas2, int visibleSchemas, int total) {
            this.schemas = schemas2;
            this.visibleSchemas = visibleSchemas;
            this.total = total;
        }

        public final int getSchemas() {
            return this.schemas;
        }

        public final int getVisibleSchemas() {
            return this.visibleSchemas;
        }

        public final int getTotal() {
            return this.total;
        }

        public final int component1() {
            return this.schemas;
        }

        public final int component2() {
            return this.visibleSchemas;
        }

        public final int component3() {
            return this.total;
        }

        @NotNull
        public final ObjectCounts copy(int schemas2, int visibleSchemas, int total) {
            return new ObjectCounts(schemas2, visibleSchemas, total);
        }

        public static /* synthetic */ ObjectCounts copy$default(ObjectCounts objectCounts, int n, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = objectCounts.schemas;
            }
            if ((n5 & 2) != 0) {
                n3 = objectCounts.visibleSchemas;
            }
            if ((n5 & 4) != 0) {
                n4 = objectCounts.total;
            }
            return objectCounts.copy(n, n3, n4);
        }

        @NotNull
        public String toString() {
            return "ObjectCounts(schemas=" + this.schemas + ", visibleSchemas=" + this.visibleSchemas + ", total=" + this.total + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.schemas);
            result2 = result2 * 31 + Integer.hashCode(this.visibleSchemas);
            result2 = result2 * 31 + Integer.hashCode(this.total);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ObjectCounts)) {
                return false;
            }
            ObjectCounts objectCounts = (ObjectCounts)other;
            if (this.schemas != objectCounts.schemas) {
                return false;
            }
            if (this.visibleSchemas != objectCounts.visibleSchemas) {
                return false;
            }
            return this.total == objectCounts.total;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/statistic/DbFusIntrospectionLogger$ObjectCounts$Companion;", "", "()V", "countObjects", "Lcom/intellij/database/statistic/DbFusIntrospectionLogger$ObjectCounts;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "model", "Lcom/intellij/database/model/DasModel;", "intellij.database.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ObjectCounts countObjects(@NotNull LocalDataSource ds, @NotNull DasModel model2) {
                Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
                Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
                int schemas2 = 0;
                int visibleSchemas = 0;
                for (BasicSchema schema2 : ((JBTreeTraverser)model2.traverser().expand(arg_0 -> Companion.countObjects$lambda$0(countObjects.1.INSTANCE, arg_0))).filter(BasicSchema.class)) {
                    ++schemas2;
                    if (!ds.getSchemaMapping().isIntrospected(schema2)) continue;
                    ++visibleSchemas;
                }
                JBTreeTraverser<DasObject> jBTreeTraverser = DbImplUtil.traverseVisibleObjects(model2.traverser(), ds.getIntrospectionScope());
                Intrinsics.checkNotNullExpressionValue(jBTreeTraverser, (String)"traverseVisibleObjects(...)");
                int total = CollectionsKt.count((Iterable)((Iterable)jBTreeTraverser));
                return new ObjectCounts(schemas2, visibleSchemas, total);
            }

            public static /* synthetic */ ObjectCounts countObjects$default(Companion companion, LocalDataSource localDataSource, DasModel dasModel, int n, Object object) {
                if ((n & 2) != 0) {
                    DasModel dasModel2 = localDataSource.getModel();
                    Intrinsics.checkNotNullExpressionValue((Object)dasModel2, (String)"getModel(...)");
                    dasModel = dasModel2;
                }
                return companion.countObjects(localDataSource, dasModel);
            }

            private static final boolean countObjects$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

