/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.statistic;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicMateDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.statistic.BooleanTransition;
import com.intellij.database.statistic.DatabaseUsagesCollectors;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternEntryKey;
import com.intellij.database.util.TreePatternFun;
import com.intellij.database.util.TreePatternNode;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003JKLB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0016H\u0002J(\u0010.\u001a\u00020/2\u000e\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u000202012\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000204H\u0002J\b\u00106\u001a\u00020\u0014H\u0016J \u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000204H\u0007JB\u0010;\u001a\u0004\u0018\u00010/2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\r2\u0006\u0010>\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u00162\u0006\u0010?\u001a\u00020@2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000204H\u0002J0\u0010A\u001a\u0002082\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\r2\u0006\u0010>\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020\"2\u0006\u0010C\u001a\u00020/H\u0002JB\u0010D\u001a\u0002082\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\r2\u0006\u0010>\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u00162\b\u0010E\u001a\u0004\u0018\u00010\u000b2\u0006\u0010F\u001a\u00020\u00122\u0006\u0010G\u001a\u00020\u0012H\u0002JF\u0010D\u001a\u0002082\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\r2\u0006\u0010>\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u00162\b\u0010E\u001a\u0004\u0018\u00010\u000b2\b\u0010H\u001a\u0004\u0018\u00010,2\b\u0010I\u001a\u0004\u0018\u00010,H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/intellij/database/statistic/DatabaseAndSchemaSelectionCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "COUNT_PLAIN_NEW", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "", "COUNT_PLAIN_OLD", "COUNT_REGEX_NEW", "COUNT_REGEX_OLD", "DBH", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "", "DBMS", "Lcom/intellij/database/Dbms;", "DB_CUR", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "DSH", "EMPTY_STATS", "Lcom/intellij/database/statistic/DatabaseAndSchemaSelectionCollector$ScopeGroupStats;", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "KIND", "Lcom/intellij/database/statistic/DatabaseAndSchemaSelectionCollector$UnitKind;", "MATCHING_CHANGED_ID", "MATCHING_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "NAMESPACES_ALL", "NAMESPACES_DELTA", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "NAMESPACES_NEW", "NAMESPACES_OLD", "OPTION_ALL_INFLUENCED_ID", "OPT_ALL", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/database/statistic/BooleanTransition;", "OPT_ALL_TRANSITION_EVENT", "OPT_CUR", "SELECTION_CHANGED_ID", "SELECTION_EVENT", "SID", "seanceCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "collectScopeGroupStats", "node", "Lcom/intellij/database/util/TreePatternNode;", "unitKind", "countMatchingFractionChange", "Lcom/intellij/database/statistic/DatabaseAndSchemaSelectionCollector$FractionChange;", "family", "Lcom/intellij/database/model/families/Family;", "Lcom/intellij/database/model/basic/BasicNamespace;", "oldScope", "Lcom/intellij/database/util/TreePattern;", "newScope", "getGroup", "record", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "recordMatching", "seanceId", "dbms", "dataSourceId", "nso", "Lcom/intellij/database/model/basic/BasicNamespaceOwner;", "recordOptAllTransition", "transition", "schemasMatchingFractionChange", "recordSelection", "databaseName", "oldStats", "newStats", "oldNode", "newNode", "FractionChange", "ScopeGroupStats", "UnitKind", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseAndSchemaSelectionCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseAndSchemaSelectionCollector.kt\ncom/intellij/database/statistic/DatabaseAndSchemaSelectionCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,257:1\n1774#2,4:258\n1774#2,4:262\n262#3,3:266\n262#3,3:269\n262#3,3:272\n*S KotlinDebug\n*F\n+ 1 DatabaseAndSchemaSelectionCollector.kt\ncom/intellij/database/statistic/DatabaseAndSchemaSelectionCollector\n*L\n195#1:258,4\n196#1:262,4\n47#1:266,3\n55#1:269,3\n56#1:272,3\n*E\n"})
public final class DatabaseAndSchemaSelectionCollector
extends CounterUsagesCollector {
    @NotNull
    public static final DatabaseAndSchemaSelectionCollector INSTANCE;
    @NotNull
    private static final EventLogGroup GROUP;
    @NotNull
    private static final String SELECTION_CHANGED_ID = "selection.changed";
    @NotNull
    private static final String MATCHING_CHANGED_ID = "matching.changed";
    @NotNull
    private static final String OPTION_ALL_INFLUENCED_ID = "option.all.influenced";
    @NotNull
    private static final EventField<Integer> SID;
    @NotNull
    private static final EventField<Dbms> DBMS;
    @NotNull
    private static final EventField<UnitKind> KIND;
    @NotNull
    private static final EventField<String> DSH;
    @NotNull
    private static final EventField<String> DBH;
    @NotNull
    private static final BooleanEventField DB_CUR;
    @NotNull
    private static final EnumEventField<BooleanTransition> OPT_ALL;
    @NotNull
    private static final EnumEventField<BooleanTransition> OPT_CUR;
    @NotNull
    private static final PrimitiveEventField<Integer> COUNT_REGEX_OLD;
    @NotNull
    private static final PrimitiveEventField<Integer> COUNT_REGEX_NEW;
    @NotNull
    private static final PrimitiveEventField<Integer> COUNT_PLAIN_OLD;
    @NotNull
    private static final PrimitiveEventField<Integer> COUNT_PLAIN_NEW;
    @NotNull
    private static final PrimitiveEventField<Integer> NAMESPACES_ALL;
    @NotNull
    private static final PrimitiveEventField<Integer> NAMESPACES_OLD;
    @NotNull
    private static final PrimitiveEventField<Integer> NAMESPACES_NEW;
    @NotNull
    private static final IntEventField NAMESPACES_DELTA;
    @NotNull
    private static final VarargEventId SELECTION_EVENT;
    @NotNull
    private static final VarargEventId MATCHING_EVENT;
    @NotNull
    private static final VarargEventId OPT_ALL_TRANSITION_EVENT;
    @NotNull
    private static final ScopeGroupStats EMPTY_STATS;
    @NotNull
    private static final AtomicInteger seanceCounter;

    private DatabaseAndSchemaSelectionCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @JvmStatic
    public static final void record(@NotNull LocalDataSource dataSource2, @NotNull TreePattern oldScope, @NotNull TreePattern newScope) {
        BasicModel model2;
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)oldScope, (String)"oldScope");
        Intrinsics.checkNotNullParameter((Object)newScope, (String)"newScope");
        Dbms dbms = dataSource2.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        String string = dataSource2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        String dataSourceId = string;
        int seanceId = seanceCounter.incrementAndGet();
        DasModel dasModel = dataSource2.getModel();
        BasicModel basicModel = model2 = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
        if (ModelFun.isMultiDatabase(dbms2)) {
            BasicModel basicModel2 = model2;
            BasicRoot basicRoot = basicModel2 != null ? basicModel2.getRoot() : null;
            BasicMultiDatabaseRoot root2 = basicRoot instanceof BasicMultiDatabaseRoot ? (BasicMultiDatabaseRoot)basicRoot : null;
            TreePatternNode treePatternNode = oldScope.root;
            if (treePatternNode == null) {
                return;
            }
            TreePatternNode oldDatabasesPattern = treePatternNode;
            TreePatternNode treePatternNode2 = newScope.root;
            if (treePatternNode2 == null) {
                return;
            }
            TreePatternNode newDatabasesPattern = treePatternNode2;
            INSTANCE.recordSelection(seanceId, dbms2, dataSourceId, UnitKind.UnitDatabase, null, oldDatabasesPattern, newDatabasesPattern);
            if (root2 != null) {
                INSTANCE.recordMatching(seanceId, dbms2, dataSourceId, UnitKind.UnitDatabase, root2, oldScope, newScope);
            }
            ObjectKind objectKind = ObjectKind.DATABASE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"DATABASE");
            NavigableMap<TreePatternEntryKey, TreePatternNode> oldDatabasesMap = TreePatternFun.extractMap(oldDatabasesPattern, objectKind);
            ObjectKind objectKind2 = ObjectKind.DATABASE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"DATABASE");
            NavigableMap<TreePatternEntryKey, TreePatternNode> newDatabasesMap = TreePatternFun.extractMap(newDatabasesPattern, objectKind2);
            Set set = oldDatabasesMap.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            Iterable iterable = set;
            Set set2 = newDatabasesMap.keySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
            TreeSet entryKeys = new TreeSet(CollectionsKt.union((Iterable)iterable, (Iterable)set2));
            for (Object e2 : entryKeys) {
                TreePatternNode entryNode;
                CasingProvider casingProvider;
                Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
                TreePatternEntryKey entryKey = (TreePatternEntryKey)e2;
                TreePatternNode oldSchemasPattern = (TreePatternNode)oldDatabasesMap.get(entryKey);
                TreePatternNode newSchemasPattern = (TreePatternNode)newDatabasesMap.get(entryKey);
                TreePatternEntryKey treePatternEntryKey = entryKey;
                String relatedDatabaseName = treePatternEntryKey instanceof TreePatternEntryKey.Cur ? ((casingProvider = root2) != null && (casingProvider = casingProvider.getCurrentDatabase()) != null ? casingProvider.getName() : null) : (treePatternEntryKey instanceof TreePatternEntryKey.Plain ? entryKey.getName() : null);
                INSTANCE.recordSelection(seanceId, dbms2, dataSourceId, UnitKind.UnitSchema, relatedDatabaseName, oldSchemasPattern, newSchemasPattern);
                TreePatternNode treePatternNode3 = (TreePatternNode)oldDatabasesMap.get(entryKey);
                if (treePatternNode3 == null) {
                    treePatternNode3 = entryNode = (TreePatternNode)newDatabasesMap.get(entryKey);
                }
                if (root2 == null || entryNode == null) continue;
                for (BasicMateDatabase basicMateDatabase : root2.getDatabases()) {
                    boolean matched = Intrinsics.areEqual((Object)entryKey, (Object)TreePatternEntryKey.Cur.INSTANCE) && basicMateDatabase.isCurrent() || entryNode.naming.matches(ObjectName.plain(basicMateDatabase.getName()), null);
                    if (!matched) continue;
                    Intrinsics.checkNotNull((Object)basicMateDatabase);
                    INSTANCE.recordMatching(seanceId, dbms2, dataSourceId, UnitKind.UnitSchema, basicMateDatabase, oldScope, newScope);
                }
            }
        } else {
            ScopeGroupStats scopeGroupStats;
            TreePatternNode treePatternNode = oldScope.root;
            if (treePatternNode == null) {
                return;
            }
            TreePatternNode oldSchemasPattern = treePatternNode;
            TreePatternNode treePatternNode4 = newScope.root;
            if (treePatternNode4 == null) {
                return;
            }
            TreePatternNode newSchemasPattern = treePatternNode4;
            ScopeGroupStats old2 = INSTANCE.collectScopeGroupStats(oldSchemasPattern, UnitKind.UnitSchema);
            if (!Intrinsics.areEqual((Object)old2, (Object)(scopeGroupStats = INSTANCE.collectScopeGroupStats(newSchemasPattern, UnitKind.UnitSchema)))) {
                FractionChange mfc;
                BasicRoot root3;
                INSTANCE.recordSelection(seanceId, dbms2, dataSourceId, UnitKind.UnitSchema, null, old2, scopeGroupStats);
                BasicModel basicModel3 = model2;
                BasicRoot basicRoot = root3 = basicModel3 != null ? basicModel3.getRoot() : null;
                if (root3 != null && (mfc = INSTANCE.recordMatching(seanceId, dbms2, dataSourceId, UnitKind.UnitSchema, root3, oldScope, newScope)) != null && old2.getOptAll() != scopeGroupStats.getOptAll()) {
                    INSTANCE.recordOptAllTransition(seanceId, dbms2, dataSourceId, BooleanTransition.Companion.of(old2.getOptAll(), scopeGroupStats.getOptAll()), mfc);
                }
            }
        }
    }

    private final void recordSelection(int seanceId, Dbms dbms, String dataSourceId, UnitKind unitKind, String databaseName, TreePatternNode oldNode, TreePatternNode newNode) {
        ScopeGroupStats scopeGroupStats;
        TreePatternNode treePatternNode = oldNode;
        ScopeGroupStats old2 = treePatternNode != null ? this.collectScopeGroupStats(treePatternNode, unitKind) : EMPTY_STATS;
        TreePatternNode treePatternNode2 = newNode;
        ScopeGroupStats scopeGroupStats2 = scopeGroupStats = treePatternNode2 != null ? this.collectScopeGroupStats(treePatternNode2, unitKind) : EMPTY_STATS;
        if (!Intrinsics.areEqual((Object)old2, (Object)scopeGroupStats)) {
            this.recordSelection(seanceId, dbms, dataSourceId, unitKind, databaseName, old2, scopeGroupStats);
        }
    }

    private final void recordSelection(int seanceId, Dbms dbms, String dataSourceId, UnitKind unitKind, String databaseName, ScopeGroupStats oldStats, ScopeGroupStats newStats) {
        List list;
        List $this$recordSelection_u24lambda_u240 = list = CollectionsKt.createListBuilder((int)16);
        boolean bl = false;
        $this$recordSelection_u24lambda_u240.add(SID.with((Object)seanceId));
        $this$recordSelection_u24lambda_u240.add(DBMS.with((Object)dbms));
        $this$recordSelection_u24lambda_u240.add(KIND.with((Object)unitKind));
        $this$recordSelection_u24lambda_u240.add(DSH.with((Object)dataSourceId));
        if (databaseName != null) {
            $this$recordSelection_u24lambda_u240.add(DBH.with((Object)databaseName));
        }
        $this$recordSelection_u24lambda_u240.add(OPT_ALL.with((Object)BooleanTransition.Companion.of(oldStats.getOptAll(), newStats.getOptAll())));
        $this$recordSelection_u24lambda_u240.add(OPT_CUR.with((Object)BooleanTransition.Companion.of(oldStats.getOptCur(), newStats.getOptCur())));
        $this$recordSelection_u24lambda_u240.add(COUNT_REGEX_OLD.with((Object)oldStats.getCntRegex()));
        $this$recordSelection_u24lambda_u240.add(COUNT_REGEX_NEW.with((Object)newStats.getCntRegex()));
        $this$recordSelection_u24lambda_u240.add(COUNT_PLAIN_OLD.with((Object)oldStats.getCntNames()));
        $this$recordSelection_u24lambda_u240.add(COUNT_PLAIN_NEW.with((Object)newStats.getCntNames()));
        List recordValues = CollectionsKt.build((List)list);
        SELECTION_EVENT.log(recordValues);
    }

    private final ScopeGroupStats collectScopeGroupStats(TreePatternNode node2, UnitKind unitKind) {
        int n;
        int n3;
        TreePatternEntryKey key2;
        int count$iv;
        int n4;
        Iterable $this$count$iv;
        NavigableMap<TreePatternEntryKey, TreePatternNode> map2 = TreePatternFun.extractMap(node2, unitKind.getObjectKind());
        Set set = map2.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Set keys2 = set;
        Iterable iterable = keys2;
        boolean bl = keys2.contains(TreePatternEntryKey.Cur.INSTANCE);
        boolean bl2 = keys2.contains(TreePatternEntryKey.All.INSTANCE);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n4 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                key2 = (TreePatternEntryKey)element$iv;
                boolean bl3 = false;
                if (!(key2 instanceof TreePatternEntryKey.Regex) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n4 = count$iv;
        }
        int n5 = n4;
        $this$count$iv = keys2;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n3 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                key2 = (TreePatternEntryKey)element$iv;
                boolean bl4 = false;
                if (!(key2 instanceof TreePatternEntryKey.Plain) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n3 = count$iv;
        }
        int n6 = n = n3;
        int n7 = n5;
        boolean bl5 = bl;
        boolean bl6 = bl2;
        ScopeGroupStats stats = new ScopeGroupStats(bl6, bl5, n7, n6);
        return stats;
    }

    private final FractionChange recordMatching(int seanceId, Dbms dbms, String dataSourceId, UnitKind unitKind, BasicNamespaceOwner nso, TreePattern oldScope, TreePattern newScope) {
        List list;
        Family family;
        String databaseName = nso instanceof BasicDatabase && !(nso instanceof BasicRoot) ? ((BasicDatabase)nso).getName() : null;
        BasicNamespaceOwner basicNamespaceOwner = nso;
        Family family2 = basicNamespaceOwner instanceof BasicMultiDatabaseRoot ? (Family)(unitKind == UnitKind.UnitDatabase ? ((BasicMultiDatabaseRoot)nso).getDatabases() : null) : (basicNamespaceOwner instanceof BasicDatabase ? (Family)(unitKind == UnitKind.UnitSchema ? ((BasicDatabase)nso).getSchemas() : null) : (family = null));
        if (family == null) {
            return null;
        }
        FractionChange mfc = this.countMatchingFractionChange(family, oldScope, newScope);
        if (mfc.getOld() == mfc.getNew()) {
            return null;
        }
        List $this$recordMatching_u24lambda_u243 = list = CollectionsKt.createListBuilder((int)16);
        boolean bl = false;
        $this$recordMatching_u24lambda_u243.add(SID.with((Object)seanceId));
        $this$recordMatching_u24lambda_u243.add(DBMS.with((Object)dbms));
        $this$recordMatching_u24lambda_u243.add(KIND.with((Object)unitKind));
        $this$recordMatching_u24lambda_u243.add(DSH.with((Object)dataSourceId));
        if (databaseName != null) {
            $this$recordMatching_u24lambda_u243.add(DBH.with((Object)databaseName));
        }
        if (nso instanceof BasicMateDatabase) {
            $this$recordMatching_u24lambda_u243.add(DB_CUR.with((Object)((BasicMateDatabase)nso).isCurrent()));
        }
        $this$recordMatching_u24lambda_u243.add(NAMESPACES_ALL.with((Object)mfc.getAll()));
        $this$recordMatching_u24lambda_u243.add(NAMESPACES_OLD.with((Object)mfc.getOld()));
        $this$recordMatching_u24lambda_u243.add(NAMESPACES_NEW.with((Object)mfc.getNew()));
        $this$recordMatching_u24lambda_u243.add(NAMESPACES_DELTA.with((Object)mfc.getDelta()));
        List recordValues = CollectionsKt.build((List)list);
        MATCHING_EVENT.log(recordValues);
        return mfc;
    }

    private final FractionChange countMatchingFractionChange(Family<? extends BasicNamespace> family, TreePattern oldScope, TreePattern newScope) {
        int all2 = family.size();
        JBIterable jBIterable = family.jbi().filter(arg_0 -> DatabaseAndSchemaSelectionCollector.countMatchingFractionChange$lambda$4((Function1)new Function1<BasicNamespace, Boolean>(oldScope){
            final /* synthetic */ TreePattern $oldScope;
            {
                this.$oldScope = $oldScope;
                super(1);
            }

            @NotNull
            public final Boolean invoke(BasicNamespace it2) {
                Intrinsics.checkNotNull((Object)it2);
                return TreePatternFun.contains(this.$oldScope, it2);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        int old2 = CollectionsKt.count((Iterable)((Iterable)jBIterable));
        JBIterable jBIterable2 = family.jbi().filter(arg_0 -> DatabaseAndSchemaSelectionCollector.countMatchingFractionChange$lambda$5((Function1)new Function1<BasicNamespace, Boolean>(newScope){
            final /* synthetic */ TreePattern $newScope;
            {
                this.$newScope = $newScope;
                super(1);
            }

            @NotNull
            public final Boolean invoke(BasicNamespace it2) {
                Intrinsics.checkNotNull((Object)it2);
                return TreePatternFun.contains(this.$newScope, it2);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        int n = CollectionsKt.count((Iterable)((Iterable)jBIterable2));
        return new FractionChange(all2, old2, n);
    }

    private final void recordOptAllTransition(int seanceId, Dbms dbms, String dataSourceId, BooleanTransition transition, FractionChange schemasMatchingFractionChange) {
        EventPair[] eventPairArray = new EventPair[]{SID.with((Object)seanceId), DBMS.with((Object)dbms), DSH.with((Object)dataSourceId), OPT_ALL.with((Object)transition), NAMESPACES_ALL.with((Object)schemasMatchingFractionChange.getAll()), NAMESPACES_OLD.with((Object)schemasMatchingFractionChange.getOld()), NAMESPACES_NEW.with((Object)schemasMatchingFractionChange.getNew()), NAMESPACES_DELTA.with((Object)schemasMatchingFractionChange.getDelta())};
        OPT_ALL_TRANSITION_EVENT.log(eventPairArray);
    }

    private static final boolean countMatchingFractionChange$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean countMatchingFractionChange$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        EventFields $this$iv;
        INSTANCE = new DatabaseAndSchemaSelectionCollector();
        GROUP = new EventLogGroup("db.datasource.selections", 8, null, 4, null);
        SID = (EventField)EventFields.Int((String)"seance_id");
        DBMS = (EventField)new DatabaseUsagesCollectors.DbmsEventField("dbms");
        EventField[] eventFieldArray = EventFields.INSTANCE;
        String name$iv = "unit_kind";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        KIND = (EventField)new EnumEventField(name$iv, UnitKind.class, null, transform$iv);
        DSH = EventFields.ShortAnonymizedField$default((String)"ds_hash", null, (int)2, null);
        DBH = EventFields.ShortAnonymizedField$default((String)"db_hash", null, (int)2, null);
        DB_CUR = EventFields.Boolean((String)"db_is_current");
        $this$iv = EventFields.INSTANCE;
        name$iv = "option_all";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        OPT_ALL = new EnumEventField(name$iv, BooleanTransition.class, null, transform$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "option_current";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        OPT_CUR = new EnumEventField(name$iv, BooleanTransition.class, null, transform$iv);
        COUNT_REGEX_OLD = EventFields.LimitedInt$default((EventFields)EventFields.INSTANCE, (String)"count_regex_old", (IntRange)new IntRange(0, 100), null, (int)4, null);
        COUNT_REGEX_NEW = EventFields.LimitedInt$default((EventFields)EventFields.INSTANCE, (String)"count_regex_new", (IntRange)new IntRange(0, 100), null, (int)4, null);
        COUNT_PLAIN_OLD = EventFields.LimitedInt$default((EventFields)EventFields.INSTANCE, (String)"count_plain_old", (IntRange)new IntRange(0, 100), null, (int)4, null);
        COUNT_PLAIN_NEW = EventFields.LimitedInt$default((EventFields)EventFields.INSTANCE, (String)"count_plain_new", (IntRange)new IntRange(0, 100), null, (int)4, null);
        NAMESPACES_ALL = EventFields.LogarithmicInt$default((EventFields)EventFields.INSTANCE, (String)"count_namespaces_all", null, (int)2, null);
        NAMESPACES_OLD = EventFields.LogarithmicInt$default((EventFields)EventFields.INSTANCE, (String)"count_namespaces_old", null, (int)2, null);
        NAMESPACES_NEW = EventFields.LogarithmicInt$default((EventFields)EventFields.INSTANCE, (String)"count_namespaces_new", null, (int)2, null);
        NAMESPACES_DELTA = EventFields.Int((String)"count_namespaces_delta");
        eventFieldArray = new EventField[]{SID, DBMS, KIND, DSH, DBH, OPT_ALL, OPT_CUR, COUNT_REGEX_OLD, COUNT_REGEX_NEW, COUNT_PLAIN_OLD, COUNT_PLAIN_NEW};
        SELECTION_EVENT = GROUP.registerVarargEvent(SELECTION_CHANGED_ID, eventFieldArray);
        eventFieldArray = new EventField[]{SID, DBMS, KIND, DSH, DBH, DB_CUR, NAMESPACES_ALL, NAMESPACES_OLD, NAMESPACES_NEW, NAMESPACES_DELTA};
        MATCHING_EVENT = GROUP.registerVarargEvent(MATCHING_CHANGED_ID, eventFieldArray);
        eventFieldArray = new EventField[]{SID, DBMS, DSH, OPT_ALL, NAMESPACES_ALL, NAMESPACES_OLD, NAMESPACES_NEW, NAMESPACES_DELTA};
        OPT_ALL_TRANSITION_EVENT = GROUP.registerVarargEvent(OPTION_ALL_INFLUENCED_ID, eventFieldArray);
        EMPTY_STATS = new ScopeGroupStats(false, false, 0, 0);
        seanceCounter = new AtomicInteger();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/statistic/DatabaseAndSchemaSelectionCollector$FractionChange;", "", "all", "", "old", "new", "(III)V", "getAll", "()I", "delta", "getDelta", "getNew", "getOld", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.database.impl"})
    private static final class FractionChange {
        private final int all;
        private final int old;
        private final int new;

        public FractionChange(int all2, int old2, int n) {
            this.all = all2;
            this.old = old2;
            this.new = n;
        }

        public final int getAll() {
            return this.all;
        }

        public final int getOld() {
            return this.old;
        }

        public final int getNew() {
            return this.new;
        }

        public final int getDelta() {
            return this.new - this.old;
        }

        @NotNull
        public String toString() {
            return "(" + this.old + "->" + this.new + ")/" + this.all;
        }

        public final int component1() {
            return this.all;
        }

        public final int component2() {
            return this.old;
        }

        public final int component3() {
            return this.new;
        }

        @NotNull
        public final FractionChange copy(int all2, int old2, int n) {
            return new FractionChange(all2, old2, n);
        }

        public static /* synthetic */ FractionChange copy$default(FractionChange fractionChange, int n, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = fractionChange.all;
            }
            if ((n5 & 2) != 0) {
                n3 = fractionChange.old;
            }
            if ((n5 & 4) != 0) {
                n4 = fractionChange.new;
            }
            return fractionChange.copy(n, n3, n4);
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.all);
            result2 = result2 * 31 + Integer.hashCode(this.old);
            result2 = result2 * 31 + Integer.hashCode(this.new);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FractionChange)) {
                return false;
            }
            FractionChange fractionChange = (FractionChange)other;
            if (this.all != fractionChange.all) {
                return false;
            }
            if (this.old != fractionChange.old) {
                return false;
            }
            return this.new == fractionChange.new;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/statistic/DatabaseAndSchemaSelectionCollector$ScopeGroupStats;", "", "optAll", "", "optCur", "cntRegex", "", "cntNames", "(ZZII)V", "getCntNames", "()I", "getCntRegex", "getOptAll", "()Z", "getOptCur", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "intellij.database.impl"})
    private static final class ScopeGroupStats {
        private final boolean optAll;
        private final boolean optCur;
        private final int cntRegex;
        private final int cntNames;

        public ScopeGroupStats(boolean optAll, boolean optCur, int cntRegex, int cntNames) {
            this.optAll = optAll;
            this.optCur = optCur;
            this.cntRegex = cntRegex;
            this.cntNames = cntNames;
        }

        public final boolean getOptAll() {
            return this.optAll;
        }

        public final boolean getOptCur() {
            return this.optCur;
        }

        public final int getCntRegex() {
            return this.cntRegex;
        }

        public final int getCntNames() {
            return this.cntNames;
        }

        public final boolean component1() {
            return this.optAll;
        }

        public final boolean component2() {
            return this.optCur;
        }

        public final int component3() {
            return this.cntRegex;
        }

        public final int component4() {
            return this.cntNames;
        }

        @NotNull
        public final ScopeGroupStats copy(boolean optAll, boolean optCur, int cntRegex, int cntNames) {
            return new ScopeGroupStats(optAll, optCur, cntRegex, cntNames);
        }

        public static /* synthetic */ ScopeGroupStats copy$default(ScopeGroupStats scopeGroupStats, boolean bl, boolean bl2, int n, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                bl = scopeGroupStats.optAll;
            }
            if ((n4 & 2) != 0) {
                bl2 = scopeGroupStats.optCur;
            }
            if ((n4 & 4) != 0) {
                n = scopeGroupStats.cntRegex;
            }
            if ((n4 & 8) != 0) {
                n3 = scopeGroupStats.cntNames;
            }
            return scopeGroupStats.copy(bl, bl2, n, n3);
        }

        @NotNull
        public String toString() {
            return "ScopeGroupStats(optAll=" + this.optAll + ", optCur=" + this.optCur + ", cntRegex=" + this.cntRegex + ", cntNames=" + this.cntNames + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.optAll);
            result2 = result2 * 31 + Boolean.hashCode(this.optCur);
            result2 = result2 * 31 + Integer.hashCode(this.cntRegex);
            result2 = result2 * 31 + Integer.hashCode(this.cntNames);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScopeGroupStats)) {
                return false;
            }
            ScopeGroupStats scopeGroupStats = (ScopeGroupStats)other;
            if (this.optAll != scopeGroupStats.optAll) {
                return false;
            }
            if (this.optCur != scopeGroupStats.optCur) {
                return false;
            }
            if (this.cntRegex != scopeGroupStats.cntRegex) {
                return false;
            }
            return this.cntNames == scopeGroupStats.cntNames;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/statistic/DatabaseAndSchemaSelectionCollector$UnitKind;", "", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "(Ljava/lang/String;ILcom/intellij/database/model/ObjectKind;)V", "getObjectKind", "()Lcom/intellij/database/model/ObjectKind;", "UnitDatabase", "UnitSchema", "intellij.database.impl"})
    private static final class UnitKind
    extends Enum<UnitKind> {
        @NotNull
        private final ObjectKind objectKind;
        public static final /* enum */ UnitKind UnitDatabase;
        public static final /* enum */ UnitKind UnitSchema;
        private static final /* synthetic */ UnitKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private UnitKind(ObjectKind objectKind) {
            this.objectKind = objectKind;
        }

        @NotNull
        public final ObjectKind getObjectKind() {
            return this.objectKind;
        }

        public static UnitKind[] values() {
            return (UnitKind[])$VALUES.clone();
        }

        public static UnitKind valueOf(String value2) {
            return Enum.valueOf(UnitKind.class, value2);
        }

        @NotNull
        public static EnumEntries<UnitKind> getEntries() {
            return $ENTRIES;
        }

        static {
            ObjectKind objectKind = ObjectKind.DATABASE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"DATABASE");
            UnitDatabase = new UnitKind(objectKind);
            ObjectKind objectKind2 = ObjectKind.SCHEMA;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"SCHEMA");
            UnitSchema = new UnitKind(objectKind2);
            $VALUES = unitKindArray = new UnitKind[]{UnitKind.UnitDatabase, UnitKind.UnitSchema};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

