/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DatabaseToggleNotebookModeAction;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.settings.DatabaseSettingsOutputResults;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.MutableProperty;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/settings/DatabaseSettingsOutputResults;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "()V", "textAsTitleAfterTextField", "Lcom/intellij/ui/components/JBTextField;", "apply", "", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "Companion", "intellij.database.impl"})
public final class DatabaseSettingsOutputResults
extends BoundSearchableConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private JBTextField textAsTitleAfterTextField;
    @NotNull
    private static final Predicate<JTextComponent> STATUS_VISIBILITY_PREDICATE = DatabaseSettingsOutputResults::STATUS_VISIBILITY_PREDICATE$lambda$0;

    public DatabaseSettingsOutputResults() {
        String string = IdeBundle.message((String)"configurable.DatabaseSettingsConfigurable.OutputResults.display.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "preferences.database.outputResults", "database.output.results");
    }

    public void apply() {
        DatabaseSettings settings = DatabaseSettings.getSettings();
        boolean oldNotebookMode = settings.notebookMode;
        super.apply();
        DatabaseSettings.fireSettingsChanged();
        if (oldNotebookMode != settings.notebookMode) {
            DatabaseToggleNotebookModeAction.forgetSavedState();
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            for (Project project : projectArray) {
                List<JdbcConsole> consoles;
                Intrinsics.checkNotNullExpressionValue(JdbcConsole.getActiveConsoles(project), (String)"getActiveConsoles(...)");
                for (JdbcConsole console : consoles) {
                    console.setNotebookMode(settings.notebookMode, false);
                }
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }
        }
    }

    @NotNull
    public DialogPanel createPanel() {
        DatabaseSettings settings = DatabaseSettings.getSettings();
        DialogPanel panel2 = com.intellij.ui.dsl.builder.BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(settings, this){
            final /* synthetic */ DatabaseSettings $settings;
            final /* synthetic */ DatabaseSettingsOutputResults this$0;
            {
                this.$settings = $settings;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.group$default((Panel)$this$panel, (String)DatabaseBundle.message("settings.output", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.$settings){
                    final /* synthetic */ DatabaseSettings $settings;
                    {
                        this.$settings = $settings;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$group) {
                        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
                        Panel.row$default((Panel)$this$group, null, (Function1)((Function1)new Function1<Row, Unit>(this.$settings){
                            final /* synthetic */ DatabaseSettings $settings;
                            {
                                this.$settings = $settings;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string = DatabaseBundle.message("settings.show.timestamp.for.query.output", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                Cell cell = $this$row.checkBox(string);
                                DatabaseSettings databaseSettings = this.$settings;
                                Intrinsics.checkNotNullExpressionValue((Object)databaseSettings, (String)"$settings");
                                ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(databaseSettings){

                                    @Nullable
                                    public Object get() {
                                        return ((DatabaseSettings)this.receiver).showQueryOutputTimestamp;
                                    }

                                    public void set(@Nullable Object value2) {
                                        ((DatabaseSettings)this.receiver).showQueryOutputTimestamp = (Boolean)value2;
                                    }
                                }));
                            }
                        }), (int)1, null);
                    }
                }), (int)2, null);
                Panel.group$default((Panel)$this$panel, (String)DatabaseBundle.message("settings.results", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.$settings, this.this$0){
                    final /* synthetic */ DatabaseSettings $settings;
                    final /* synthetic */ DatabaseSettingsOutputResults this$0;
                    {
                        this.$settings = $settings;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$group) {
                        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
                        Panel.row$default((Panel)$this$group, null, (Function1)((Function1)new Function1<Row, Unit>(this.$settings){
                            final /* synthetic */ DatabaseSettings $settings;
                            {
                                this.$settings = $settings;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string = DatabaseBundle.message("settings.database.notebook.mode", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                Cell cell = $this$row.checkBox(string);
                                DatabaseSettings databaseSettings = this.$settings;
                                Intrinsics.checkNotNullExpressionValue((Object)databaseSettings, (String)"$settings");
                                ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(databaseSettings){

                                    @Nullable
                                    public Object get() {
                                        return ((DatabaseSettings)this.receiver).notebookMode;
                                    }

                                    public void set(@Nullable Object value2) {
                                        ((DatabaseSettings)this.receiver).notebookMode = (Boolean)value2;
                                    }
                                }));
                            }
                        }), (int)1, null);
                        Ref.ObjectRef resultsTitlePrefixCheckBox = new Ref.ObjectRef();
                        Panel.row$default((Panel)$this$group, null, (Function1)((Function1)new Function1<Row, Unit>((Ref.ObjectRef<Cell<JBCheckBox>>)resultsTitlePrefixCheckBox, this.$settings){
                            final /* synthetic */ Ref.ObjectRef<Cell<JBCheckBox>> $resultsTitlePrefixCheckBox;
                            final /* synthetic */ DatabaseSettings $settings;
                            {
                                this.$resultsTitlePrefixCheckBox = $resultsTitlePrefixCheckBox;
                                this.$settings = $settings;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string = DatabaseBundle.message("settings.create.title.for.results.from.comment.before.query", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                Cell cell = $this$row.checkBox(string);
                                DatabaseSettings databaseSettings = this.$settings;
                                Intrinsics.checkNotNullExpressionValue((Object)databaseSettings, (String)"$settings");
                                this.$resultsTitlePrefixCheckBox.element = ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(databaseSettings){

                                    @Nullable
                                    public Object get() {
                                        return ((DatabaseSettings)this.receiver).resultsTitlePrefixEnabled;
                                    }

                                    public void set(@Nullable Object value2) {
                                        ((DatabaseSettings)this.receiver).resultsTitlePrefixEnabled = (Boolean)value2;
                                    }
                                }));
                            }
                        }), (int)1, null);
                        $this$group.indent((Function1)new Function1<Panel, Unit>((Ref.ObjectRef<Cell<JBCheckBox>>)resultsTitlePrefixCheckBox, this.this$0, this.$settings){
                            final /* synthetic */ Ref.ObjectRef<Cell<JBCheckBox>> $resultsTitlePrefixCheckBox;
                            final /* synthetic */ DatabaseSettingsOutputResults this$0;
                            final /* synthetic */ DatabaseSettings $settings;
                            {
                                this.$resultsTitlePrefixCheckBox = $resultsTitlePrefixCheckBox;
                                this.this$0 = $receiver;
                                this.$settings = $settings;
                                super(1);
                            }

                            public final void invoke(@NotNull Panel $this$indent) {
                                Cell cell;
                                Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
                                String string = DatabaseBundle.message("settings.treat.text.as.title.after", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                Row row = $this$indent.row(string, (Function1)new Function1<Row, Unit>(this.this$0, this.$settings){
                                    final /* synthetic */ DatabaseSettingsOutputResults this$0;
                                    final /* synthetic */ DatabaseSettings $settings;
                                    {
                                        this.this$0 = $receiver;
                                        this.$settings = $settings;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Row $this$row) {
                                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                        DatabaseSettingsOutputResults.access$setTextAsTitleAfterTextField$p(this.this$0, (JBTextField)$this$row.textField().onApply((Function0)new Function0<Unit>(this.$settings, this.this$0){
                                            final /* synthetic */ DatabaseSettings $settings;
                                            final /* synthetic */ DatabaseSettingsOutputResults this$0;
                                            {
                                                this.$settings = $settings;
                                                this.this$0 = $receiver;
                                                super(0);
                                            }

                                            public final void invoke() {
                                                JBTextField jBTextField = DatabaseSettingsOutputResults.access$getTextAsTitleAfterTextField$p(this.this$0);
                                                if (jBTextField == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException((String)"textAsTitleAfterTextField");
                                                    jBTextField = null;
                                                }
                                                this.$settings.resultsTitlePrefix = StringUtil.nullize((String)jBTextField.getText(), (boolean)true);
                                            }
                                        }).onReset((Function0)new Function0<Unit>(this.this$0, this.$settings){
                                            final /* synthetic */ DatabaseSettingsOutputResults this$0;
                                            final /* synthetic */ DatabaseSettings $settings;
                                            {
                                                this.this$0 = $receiver;
                                                this.$settings = $settings;
                                                super(0);
                                            }

                                            public final void invoke() {
                                                JBTextField jBTextField = DatabaseSettingsOutputResults.access$getTextAsTitleAfterTextField$p(this.this$0);
                                                if (jBTextField == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException((String)"textAsTitleAfterTextField");
                                                    jBTextField = null;
                                                }
                                                jBTextField.setText(this.$settings.resultsTitlePrefix);
                                            }
                                        }).onIsModified((Function0)new Function0<Boolean>(this.$settings, this.this$0){
                                            final /* synthetic */ DatabaseSettings $settings;
                                            final /* synthetic */ DatabaseSettingsOutputResults this$0;
                                            {
                                                this.$settings = $settings;
                                                this.this$0 = $receiver;
                                                super(0);
                                            }

                                            @NotNull
                                            public final Boolean invoke() {
                                                String string = this.$settings.resultsTitlePrefix;
                                                JBTextField jBTextField = DatabaseSettingsOutputResults.access$getTextAsTitleAfterTextField$p(this.this$0);
                                                if (jBTextField == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException((String)"textAsTitleAfterTextField");
                                                    jBTextField = null;
                                                }
                                                return !Intrinsics.areEqual((Object)string, (Object)StringUtil.nullize((String)jBTextField.getText(), (boolean)true));
                                            }
                                        }).applyToComponent((Function1)createPanel.panel.4.INSTANCE).getComponent());
                                    }
                                });
                                if (this.$resultsTitlePrefixCheckBox.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"resultsTitlePrefixCheckBox");
                                    cell = null;
                                } else {
                                    cell = (Cell)this.$resultsTitlePrefixCheckBox.element;
                                }
                                row.enabledIf(ButtonKt.getSelected((Cell)cell));
                            }
                        });
                    }
                }), (int)2, null);
                Panel.group$default((Panel)$this$panel, (String)DatabaseBundle.message("settings.services.tool.window", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.$settings){
                    final /* synthetic */ DatabaseSettings $settings;
                    {
                        this.$settings = $settings;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$group) {
                        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
                        Panel.row$default((Panel)$this$group, null, (Function1)((Function1)new Function1<Row, Unit>(this.$settings){
                            final /* synthetic */ DatabaseSettings $settings;
                            {
                                this.$settings = $settings;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                Cell cell = $this$row.comboBox((Collection)ArraysKt.toList((Object[])DatabaseSettings.ShowServicesMode.values()), BuilderKt.textListCellRenderer((Function1)createPanel.panel.1.INSTANCE));
                                String string = DatabaseBundle.message("settings.show.services.tool.window.for.query.console.output", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                Cell cell2 = cell.label(string, LabelPosition.TOP).applyToComponent((Function1)createPanel.panel.2.INSTANCE);
                                DatabaseSettings databaseSettings = this.$settings;
                                Intrinsics.checkNotNullExpressionValue((Object)databaseSettings, (String)"$settings");
                                ComboBoxKt.bindItem((Cell)cell2, (MutableProperty)MutablePropertyKt.toNullableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(databaseSettings){

                                    @Nullable
                                    public Object get() {
                                        return ((DatabaseSettings)this.receiver).showServicesMode;
                                    }

                                    public void set(@Nullable Object value2) {
                                        ((DatabaseSettings)this.receiver).showServicesMode = (DatabaseSettings.ShowServicesMode)((Object)value2);
                                    }
                                })));
                            }
                        }), (int)1, null);
                        Panel.row$default((Panel)$this$group, null, (Function1)((Function1)new Function1<Row, Unit>(this.$settings){
                            final /* synthetic */ DatabaseSettings $settings;
                            {
                                this.$settings = $settings;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string = DatabaseBundle.message("settings.focus.on.services.tool.window.in.window.mode", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                Cell cell = $this$row.checkBox(string);
                                DatabaseSettings databaseSettings = this.$settings;
                                Intrinsics.checkNotNullExpressionValue((Object)databaseSettings, (String)"$settings");
                                ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(databaseSettings){

                                    @Nullable
                                    public Object get() {
                                        return ((DatabaseSettings)this.receiver).focusOnServicesInWindowMode;
                                    }

                                    public void set(@Nullable Object value2) {
                                        ((DatabaseSettings)this.receiver).focusOnServicesInWindowMode = (Boolean)value2;
                                    }
                                }));
                            }
                        }), (int)1, null);
                        Panel.row$default((Panel)$this$group, null, (Function1)((Function1)new Function1<Row, Unit>(this.$settings){
                            final /* synthetic */ DatabaseSettings $settings;
                            {
                                this.$settings = $settings;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string = DatabaseBundle.message("settings.open.output.in.services.tab", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                Cell cell = $this$row.checkBox(string);
                                DatabaseSettings databaseSettings = this.$settings;
                                Intrinsics.checkNotNullExpressionValue((Object)databaseSettings, (String)"$settings");
                                ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(databaseSettings){

                                    @Nullable
                                    public Object get() {
                                        return ((DatabaseSettings)this.receiver).showOutputInTab;
                                    }

                                    public void set(@Nullable Object value2) {
                                        ((DatabaseSettings)this.receiver).showOutputInTab = (Boolean)value2;
                                    }
                                }));
                            }
                        }), (int)1, null);
                        Panel.row$default((Panel)$this$group, null, (Function1)((Function1)new Function1<Row, Unit>(this.$settings){
                            final /* synthetic */ DatabaseSettings $settings;
                            {
                                this.$settings = $settings;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string = DatabaseBundle.message("settings.activate.services.output.pane.for.selected.query.console.only", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                Cell cell = $this$row.checkBox(string);
                                DatabaseSettings databaseSettings = this.$settings;
                                Intrinsics.checkNotNullExpressionValue((Object)databaseSettings, (String)"$settings");
                                ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(databaseSettings){

                                    @Nullable
                                    public Object get() {
                                        return ((DatabaseSettings)this.receiver).showOnlySelectedClientOutput;
                                    }

                                    public void set(@Nullable Object value2) {
                                        ((DatabaseSettings)this.receiver).showOnlySelectedClientOutput = (Boolean)value2;
                                    }
                                }));
                            }
                        }), (int)1, null);
                    }
                }), (int)2, null);
            }
        }));
        return panel2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean STATUS_VISIBILITY_PREDICATE$lambda$0(JTextComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        if (!component2.isEnabled()) return false;
        if (component2.isFocusOwner()) return false;
        String string = component2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() != 0) return false;
        return true;
    }

    public static final /* synthetic */ void access$setTextAsTitleAfterTextField$p(DatabaseSettingsOutputResults $this, JBTextField jBTextField) {
        $this.textAsTitleAfterTextField = jBTextField;
    }

    public static final /* synthetic */ JBTextField access$getTextAsTitleAfterTextField$p(DatabaseSettingsOutputResults $this) {
        return $this.textAsTitleAfterTextField;
    }

    public static final /* synthetic */ Predicate access$getSTATUS_VISIBILITY_PREDICATE$cp() {
        return STATUS_VISIBILITY_PREDICATE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/settings/DatabaseSettingsOutputResults$Companion;", "", "()V", "STATUS_VISIBILITY_PREDICATE", "Ljava/util/function/Predicate;", "Ljavax/swing/text/JTextComponent;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

