/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.families.Family;
import com.intellij.database.util.common.NumberFun;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u001a\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a%\u0010\t\u001a\u0004\u0018\u00010\u00062\u0016\u0010\n\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u000b\"\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\f\u001a\u001b\u0010\r\u001a\u0004\u0018\u00010\u0006*\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0086\u0004\u001a\n\u0010\u000f\u001a\u00020\u0006*\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u0004*\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0014\u001a\n\u0010\u0015\u001a\u00020\u0006*\u00020\u0004\u001a\n\u0010\u0016\u001a\u00020\u0006*\u00020\u0017\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"HeadingEmptyLinesPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "__0__", "", "makeTriggerEventString", "", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "phrase", "words", "", "([Ljava/lang/String;)Ljava/lang/String;", "concatWithSpace", "that", "orderString", "Lcom/intellij/database/model/ObjectKind;", "positionSafe", "Lcom/intellij/database/model/basic/BasicArrangedElement;", "removeHeadingEmptyLines", "", "toFixedOrderString", "toOrderString", "", "intellij.database.core.impl"})
public final class ScriptingUtilsKt {
    private static final short __0__ = 0;
    private static final Pattern HeadingEmptyLinesPattern = Pattern.compile("^(\\s*\\n)+", 32);

    @Nullable
    public static final String phrase(String ... words) {
        Intrinsics.checkNotNullParameter((Object)words, (String)"words");
        int n = words.length;
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return words[0];
        }
        StringBuilder b2 = new StringBuilder();
        for (String word : words) {
            if (word == null) continue;
            if (((CharSequence)b2).length() > 0) {
                b2.append(' ');
            }
            b2.append(word);
        }
        return ((CharSequence)b2).length() > 0 ? b2.toString() : null;
    }

    @Nullable
    public static final String concatWithSpace(@Nullable String $this$concatWithSpace, @Nullable String that) {
        CharSequence charSequence = $this$concatWithSpace;
        boolean y1 = !(charSequence == null || charSequence.length() == 0);
        CharSequence charSequence2 = that;
        boolean y2 = !(charSequence2 == null || charSequence2.length() == 0);
        return y1 && y2 ? $this$concatWithSpace + " " + that : (y1 ? $this$concatWithSpace : (y2 ? that : null));
    }

    @NotNull
    public static final String toOrderString(long $this$toOrderString) {
        if ($this$toOrderString == 0L) {
            return "0";
        }
        if ($this$toOrderString > 0L) {
            char c2;
            String s2 = String.valueOf($this$toOrderString);
            int n = s2.length();
            char c3 = c2 = (char)(65 + (n - 1));
            return c3 + s2;
        }
        if ($this$toOrderString == Long.MIN_VALUE) {
            return "[NO_ID]";
        }
        if ($this$toOrderString < 0L) {
            long p2 = -$this$toOrderString;
            StringBuilder b2 = new StringBuilder(24);
            b2.append(p2);
            int n = b2.length();
            int i2 = 0;
            int n3 = n - 1;
            if (i2 <= n3) {
                while (true) {
                    char d2 = b2.charAt(i2);
                    char c4 = (char)(90 - (d2 - 48));
                    b2.setCharAt(i2, c4);
                    if (i2 == n3) break;
                    ++i2;
                }
            }
            b2.insert(0, '-');
            b2.insert(1, (char)(90 - n));
            String string = b2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        return "";
    }

    @NotNull
    public static final String orderString(@NotNull ObjectKind $this$orderString) {
        Intrinsics.checkNotNullParameter((Object)$this$orderString, (String)"<this>");
        int order2 = $this$orderString.getOrder();
        boolean bl = 1 <= order2 ? order2 < 10000 : false;
        if (bl) {
            return NumberFun.toStringWithLeadingZeros(order2, 4);
        }
        return "ZZZZ";
    }

    @NotNull
    public static final String toFixedOrderString(short $this$toFixedOrderString) {
        if ($this$toFixedOrderString < 0) {
            return "-X";
        }
        String s2 = String.valueOf($this$toFixedOrderString);
        String string = "00000".substring(s2.length(), 5);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string + s2;
    }

    public static final short positionSafe(@NotNull BasicArrangedElement $this$positionSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$positionSafe, (String)"<this>");
        if ($this$positionSafe.getPosition() != 0) {
            return $this$positionSafe.getPosition();
        }
        Family<? extends BasicElement> family = $this$positionSafe.getParentFamily();
        int idx = family != null ? family.indexOf($this$positionSafe) : -1;
        return idx == -1 ? $this$positionSafe.getPosition() : (short)idx;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final String makeTriggerEventString(@NotNull BasicTrigger trigger) {
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        table = trigger.getLikeTable();
        v0 = trigger.getTurn();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getTurn(...)");
        turn = v0;
        v1 = trigger.getEvents();
        Intrinsics.checkNotNullExpressionValue(v1, (String)"getEvents(...)");
        events = v1;
        onUpdate = events.contains((Object)TrigEvent.UPDATE);
        v2 = table;
        tableColumnsCount = v2 != null && (v2 = v2.getColumns()) != null ? v2.size() : 0;
        v3 = trigger.getColNames();
        Intrinsics.checkNotNullExpressionValue(v3, (String)"getColNames(...)");
        specificColumns = v3;
        if (!onUpdate) ** GOTO lbl-1000
        var8_7 = tableColumnsCount - 1;
        var9_9 = specificColumns.size();
        v4 = 1 <= var9_9 ? var9_9 <= var8_7 : false;
        if (v4) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        explicitColumns = v5;
        switch (WhenMappings.$EnumSwitchMapping$0[turn.ordinal()]) {
            case 1: 
            case 2: {
                v6 = "before ";
                break;
            }
            case 3: 
            case 4: {
                v6 = "after ";
                break;
            }
            case 5: {
                v6 = "instead of ";
                break;
            }
            default: {
                v6 = ev = null;
            }
        }
        if (events.isEmpty()) {
            return (String)ev + "???";
        }
        var9_10 = new TrigEvent[]{TrigEvent.INSERT, TrigEvent.UPDATE, TrigEvent.DELETE, TrigEvent.TRUNCATE};
        ev = (String)ev + SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)SequencesKt.sequenceOf((Object[])var9_10), (Function1)((Function1)new Function1<TrigEvent, Boolean>(events){
            final /* synthetic */ Set<TrigEvent> $events;
            {
                this.$events = $events;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TrigEvent it2) {
                Intrinsics.checkNotNullParameter((Object)((Object)it2), (String)"it");
                return this.$events.contains((Object)((Object)it2));
            }
        })), (CharSequence)" or ", null, null, (int)0, null, (Function1)((Function1)new Function1<TrigEvent, CharSequence>(explicitColumns, specificColumns){
            final /* synthetic */ boolean $explicitColumns;
            final /* synthetic */ List<String> $specificColumns;
            {
                this.$explicitColumns = $explicitColumns;
                this.$specificColumns = $specificColumns;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull TrigEvent it2) {
                Intrinsics.checkNotNullParameter((Object)((Object)it2), (String)"it");
                return StringUtil.toLowerCase((String)it2.name()) + (String)(it2 == TrigEvent.UPDATE && this.$explicitColumns ? " of " + CollectionsKt.joinToString$default((Iterable)this.$specificColumns, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : "");
            }
        }), (int)30, null);
        return ev;
    }

    @NotNull
    public static final CharSequence removeHeadingEmptyLines(@NotNull CharSequence $this$removeHeadingEmptyLines) {
        Intrinsics.checkNotNullParameter((Object)$this$removeHeadingEmptyLines, (String)"<this>");
        Matcher m = HeadingEmptyLinesPattern.matcher($this$removeHeadingEmptyLines);
        if (m.find()) {
            int emptyLength = m.group(0).length();
            return $this$removeHeadingEmptyLines.subSequence(emptyLength, $this$removeHeadingEmptyLines.length());
        }
        return $this$removeHeadingEmptyLines;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrigTurn.values().length];
            try {
                nArray[TrigTurn.BEFORE_STMT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrigTurn.BEFORE_ROW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrigTurn.AFTER_STMT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrigTurn.AFTER_ROW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrigTurn.INSTEAD_OF.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

