/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptConsumer;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskKt;
import com.intellij.database.util.Version;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0089\u0001\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012.\b\u0002\u0010\r\u001a(\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000f\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010\u0018\u00010\u000e\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0016\u00a2\u0006\u0002\u0010\u0017J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000b\u0010.\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010/\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u00100\u001a\u00020\fH\u00c6\u0003J/\u00101\u001a(\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000f\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010\u0018\u00010\u000eH\u00c6\u0003J\t\u00102\u001a\u00020\u0014H\u00c6\u0003J\u000f\u00103\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0016H\u00c6\u0003J\u008f\u0001\u00104\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2.\b\u0002\u0010\r\u001a(\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000f\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010\u0018\u00010\u000e2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0016H\u00c6\u0001J\u0013\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u000108H\u00d6\u0003J\t\u00109\u001a\u00020:H\u00d6\u0001J\t\u0010;\u001a\u00020\u0012H\u00d6\u0001R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R7\u0010\r\u001a(\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000f\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006<"}, d2={"Lcom/intellij/database/script/generator/ScriptingNativeDefinitionTask;", "Lcom/intellij/database/script/generator/ScriptingTask;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "currentDatabase", "Lcom/intellij/database/model/basic/BasicDatabase;", "currentSchema", "Lcom/intellij/database/model/basic/BasicSchema;", "options", "Lcom/intellij/database/script/generator/ScriptingOptions;", "nativeDefinitionsRetriever", "Lkotlin/Function1;", "", "", "", "", "version", "Lcom/intellij/database/util/Version;", "consumer", "Lcom/intellij/database/script/generator/ScriptConsumer;", "(Lcom/intellij/database/model/basic/BasicModel;Ljava/util/Collection;Lcom/intellij/database/model/basic/BasicDatabase;Lcom/intellij/database/model/basic/BasicSchema;Lcom/intellij/database/script/generator/ScriptingOptions;Lkotlin/jvm/functions/Function1;Lcom/intellij/database/util/Version;Lcom/intellij/database/script/generator/ScriptConsumer;)V", "category", "Lcom/intellij/database/script/generator/ScriptCategory;", "getCategory", "()Lcom/intellij/database/script/generator/ScriptCategory;", "getConsumer", "()Lcom/intellij/database/script/generator/ScriptConsumer;", "getCurrentDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "getElements", "()Ljava/util/Collection;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "getNativeDefinitionsRetriever", "()Lkotlin/jvm/functions/Function1;", "getOptions", "()Lcom/intellij/database/script/generator/ScriptingOptions;", "getVersion", "()Lcom/intellij/database/util/Version;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.database.core.impl"})
public final class ScriptingNativeDefinitionTask
extends ScriptingTask {
    @NotNull
    private final BasicModel model;
    @NotNull
    private final Collection<BasicElement> elements;
    @Nullable
    private final BasicDatabase currentDatabase;
    @Nullable
    private final BasicSchema currentSchema;
    @NotNull
    private final ScriptingOptions options;
    @Nullable
    private final Function1<List<? extends BasicElement>, Map<BasicElement, String[]>> nativeDefinitionsRetriever;
    @NotNull
    private final Version version;
    @Nullable
    private final ScriptConsumer<?> consumer;
    @NotNull
    private final ScriptCategory category;

    public ScriptingNativeDefinitionTask(@NotNull BasicModel model2, @NotNull Collection<? extends BasicElement> elements2, @Nullable BasicDatabase currentDatabase, @Nullable BasicSchema currentSchema, @NotNull ScriptingOptions options2, @Nullable Function1<? super List<? extends BasicElement>, ? extends Map<BasicElement, String[]>> nativeDefinitionsRetriever, @NotNull Version version, @Nullable ScriptConsumer<?> consumer2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        super(null);
        this.model = model2;
        this.elements = elements2;
        this.currentDatabase = currentDatabase;
        this.currentSchema = currentSchema;
        this.options = options2;
        this.nativeDefinitionsRetriever = nativeDefinitionsRetriever;
        this.version = version;
        this.consumer = consumer2;
        this.category = ScriptCategory.NATIVE_DEFINITION;
        boolean bl2 = bl = this.getCurrentDatabase() == null || this.model.contains(this.getCurrentDatabase());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = this.getCurrentSchema() == null || this.model.contains(this.getCurrentSchema()) && Intrinsics.areEqual((Object)this.getCurrentSchema().getDatabase(), (Object)this.getCurrentDatabase());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public /* synthetic */ ScriptingNativeDefinitionTask(BasicModel basicModel, Collection collection2, BasicDatabase basicDatabase, BasicSchema basicSchema, ScriptingOptions scriptingOptions, Function1 function1, Version version, ScriptConsumer scriptConsumer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            basicDatabase = basicModel.getRoot().getCurrentDatabase();
        }
        if ((n & 8) != 0) {
            BasicDatabase basicDatabase2 = basicDatabase;
            BasicSchema basicSchema2 = basicSchema = basicDatabase2 != null ? ModelFun.getCurrentSchema(basicDatabase2) : null;
        }
        if ((n & 0x10) != 0) {
            scriptingOptions = ScriptingTaskKt.defaultScriptingOptions(basicModel);
        }
        if ((n & 0x20) != 0) {
            function1 = null;
        }
        if ((n & 0x40) != 0) {
            Version version2 = basicModel.getRoot().getServerVersion();
            if (version2 == null) {
                Version version3 = Version.ZERO;
                version2 = version3;
                Intrinsics.checkNotNullExpressionValue((Object)version3, (String)"ZERO");
            }
            version = version2;
        }
        if ((n & 0x80) != 0) {
            scriptConsumer = null;
        }
        this(basicModel, collection2, basicDatabase, basicSchema, scriptingOptions, (Function1<? super List<? extends BasicElement>, ? extends Map<BasicElement, String[]>>)function1, version, scriptConsumer);
    }

    @NotNull
    public final BasicModel getModel() {
        return this.model;
    }

    @NotNull
    public final Collection<BasicElement> getElements() {
        return this.elements;
    }

    @Override
    @Nullable
    public BasicDatabase getCurrentDatabase() {
        return this.currentDatabase;
    }

    @Override
    @Nullable
    public BasicSchema getCurrentSchema() {
        return this.currentSchema;
    }

    @Override
    @NotNull
    public ScriptingOptions getOptions() {
        return this.options;
    }

    @Nullable
    public final Function1<List<? extends BasicElement>, Map<BasicElement, String[]>> getNativeDefinitionsRetriever() {
        return this.nativeDefinitionsRetriever;
    }

    @Override
    @NotNull
    public Version getVersion() {
        return this.version;
    }

    @Override
    @Nullable
    public ScriptConsumer<?> getConsumer() {
        return this.consumer;
    }

    @Override
    @NotNull
    public ScriptCategory getCategory() {
        return this.category;
    }

    @NotNull
    public final BasicModel component1() {
        return this.model;
    }

    @NotNull
    public final Collection<BasicElement> component2() {
        return this.elements;
    }

    @Nullable
    public final BasicDatabase component3() {
        return this.currentDatabase;
    }

    @Nullable
    public final BasicSchema component4() {
        return this.currentSchema;
    }

    @NotNull
    public final ScriptingOptions component5() {
        return this.options;
    }

    @Nullable
    public final Function1<List<? extends BasicElement>, Map<BasicElement, String[]>> component6() {
        return this.nativeDefinitionsRetriever;
    }

    @NotNull
    public final Version component7() {
        return this.version;
    }

    @Nullable
    public final ScriptConsumer<?> component8() {
        return this.consumer;
    }

    @NotNull
    public final ScriptingNativeDefinitionTask copy(@NotNull BasicModel model2, @NotNull Collection<? extends BasicElement> elements2, @Nullable BasicDatabase currentDatabase, @Nullable BasicSchema currentSchema, @NotNull ScriptingOptions options2, @Nullable Function1<? super List<? extends BasicElement>, ? extends Map<BasicElement, String[]>> nativeDefinitionsRetriever, @NotNull Version version, @Nullable ScriptConsumer<?> consumer2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return new ScriptingNativeDefinitionTask(model2, elements2, currentDatabase, currentSchema, options2, nativeDefinitionsRetriever, version, consumer2);
    }

    public static /* synthetic */ ScriptingNativeDefinitionTask copy$default(ScriptingNativeDefinitionTask scriptingNativeDefinitionTask, BasicModel basicModel, Collection collection2, BasicDatabase basicDatabase, BasicSchema basicSchema, ScriptingOptions scriptingOptions, Function1 function1, Version version, ScriptConsumer scriptConsumer, int n, Object object) {
        if ((n & 1) != 0) {
            basicModel = scriptingNativeDefinitionTask.model;
        }
        if ((n & 2) != 0) {
            collection2 = scriptingNativeDefinitionTask.elements;
        }
        if ((n & 4) != 0) {
            basicDatabase = scriptingNativeDefinitionTask.currentDatabase;
        }
        if ((n & 8) != 0) {
            basicSchema = scriptingNativeDefinitionTask.currentSchema;
        }
        if ((n & 0x10) != 0) {
            scriptingOptions = scriptingNativeDefinitionTask.options;
        }
        if ((n & 0x20) != 0) {
            function1 = scriptingNativeDefinitionTask.nativeDefinitionsRetriever;
        }
        if ((n & 0x40) != 0) {
            version = scriptingNativeDefinitionTask.version;
        }
        if ((n & 0x80) != 0) {
            scriptConsumer = scriptingNativeDefinitionTask.consumer;
        }
        return scriptingNativeDefinitionTask.copy(basicModel, collection2, basicDatabase, basicSchema, scriptingOptions, function1, version, scriptConsumer);
    }

    @NotNull
    public String toString() {
        return "ScriptingNativeDefinitionTask(model=" + this.model + ", elements=" + this.elements + ", currentDatabase=" + this.currentDatabase + ", currentSchema=" + this.currentSchema + ", options=" + this.options + ", nativeDefinitionsRetriever=" + this.nativeDefinitionsRetriever + ", version=" + this.version + ", consumer=" + this.consumer + ")";
    }

    public int hashCode() {
        int result2 = this.model.hashCode();
        result2 = result2 * 31 + ((Object)this.elements).hashCode();
        result2 = result2 * 31 + (this.currentDatabase == null ? 0 : this.currentDatabase.hashCode());
        result2 = result2 * 31 + (this.currentSchema == null ? 0 : this.currentSchema.hashCode());
        result2 = result2 * 31 + this.options.hashCode();
        result2 = result2 * 31 + (this.nativeDefinitionsRetriever == null ? 0 : this.nativeDefinitionsRetriever.hashCode());
        result2 = result2 * 31 + this.version.hashCode();
        result2 = result2 * 31 + (this.consumer == null ? 0 : this.consumer.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScriptingNativeDefinitionTask)) {
            return false;
        }
        ScriptingNativeDefinitionTask scriptingNativeDefinitionTask = (ScriptingNativeDefinitionTask)other;
        if (!Intrinsics.areEqual((Object)this.model, (Object)scriptingNativeDefinitionTask.model)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.elements, scriptingNativeDefinitionTask.elements)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.currentDatabase, (Object)scriptingNativeDefinitionTask.currentDatabase)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.currentSchema, (Object)scriptingNativeDefinitionTask.currentSchema)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.options, (Object)scriptingNativeDefinitionTask.options)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.nativeDefinitionsRetriever, scriptingNativeDefinitionTask.nativeDefinitionsRetriever)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.version, (Object)scriptingNativeDefinitionTask.version)) {
            return false;
        }
        return Intrinsics.areEqual(this.consumer, scriptingNativeDefinitionTask.consumer);
    }
}

