/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlModelBuilderUtils {
    private static final Logger LOG = Logger.getInstance(SqlModelBuilderUtils.class);

    public static void hardWarning(@NotNull String message2) {
        Application app;
        if (message2 == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(0);
        }
        if ((app = ApplicationManager.getApplication()) == null || app.isUnitTestMode()) {
            throw new AssertionError((Object)message2);
        }
        LOG.warn(message2);
    }

    @Nullable
    public static BasicModElement createObject(@NotNull BasicModElement parent2, @NotNull String name2, boolean isQuoted, @Nullable String identity, @NotNull ObjectKind kind) {
        Object obj2;
        Family family;
        if (parent2 == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(1);
        }
        if (name2 == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(3);
        }
        if ((family = parent2.familyOf(kind)) == null) {
            return null;
        }
        if (family instanceof ModSingletonFamily) {
            obj2 = ((ModSingletonFamily)family).createOrGet();
        } else {
            Condition c2 = DbSqlUtilCore.byName(name2, isQuoted, identity, parent2.getModel());
            obj2 = family.find(o2 -> c2.value(o2));
            if (obj2 != null && !obj2.isSyncPending() && StringUtil.isEmpty((String)name2) && !(obj2 instanceof BasicNamespace)) {
                obj2 = null;
            }
            if (obj2 instanceof BasicOverloadable) {
                boolean bl = false;
            }
            if (obj2 == null) {
                obj2 = family.createNewOne();
                if (obj2 instanceof BasicModNamedElement) {
                    ((BasicModNamedElement)obj2).setName(name2);
                }
            } else {
                obj2.resetSyncPending();
            }
        }
        return obj2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/script/SqlModelBuilderUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hardWarning";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createObject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

