/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTrackerBase;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.editor.DatabaseEditorNotifications;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasObjectFun;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingInternalTask;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DetailsSyncHelper;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbSrcMigration {
    private static final Logger LOG = Logger.getInstance(DbSrcMigration.class);
    private static final Set<ObjectKind> DEPENDANT_OBJECTS = Set.of(ObjectKind.COLUMN, ObjectKind.OBJECT_ATTRIBUTE, ObjectKind.FOREIGN_KEY, ObjectKind.KEY, ObjectKind.CHECK, ObjectKind.INDEX);

    public static boolean isSupported(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcMigration.$$$reportNull$$$0(0);
        }
        if (!DbSrcUtilsCore.isDbSrcFile(file)) {
            return false;
        }
        BasicElement element2 = DbSrcUtils.findObject(null, file.getPath(), BasicElement.class);
        return DbSrcMigration.isSupported(element2);
    }

    public static boolean isSupported(@Nullable BasicElement element2) {
        BasicModel model2;
        BasicModel basicModel = model2 = element2 == null ? null : element2.getModel();
        if (model2 == null) {
            return true;
        }
        ScriptGenerator service = ScriptGenerators.INSTANCE.byModel(model2);
        return DbSrcMigration.canRefactor(service, element2);
    }

    private static boolean canRefactor(ScriptGenerator service, BasicElement element2) {
        BasicModel model2 = element2.getModel();
        return service.capabilities(element2).getAlterAnything().get(model2 == null ? null : model2.getRoot().getServerVersion());
    }

    @NotNull
    public static List<Pair<ObjectPath, VirtualFile>> getObjects(@NotNull Project project, @NotNull Iterable<VirtualFile> files2) {
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            DbSrcMigration.$$$reportNull$$$0(2);
        }
        ArrayList<Pair<ObjectPath, VirtualFile>> objects2 = new ArrayList<Pair<ObjectPath, VirtualFile>>();
        BasicModel model2 = null;
        ScriptGenerator ss2 = null;
        for (VirtualFile file : files2) {
            ObjectPath path;
            if (!DbSrcUtilsCore.isDbSrcFile(file)) continue;
            BasicElement element2 = DbSrcUtils.findObject(project, file.getPath(), BasicElement.class);
            if (element2 != null) {
                if (model2 == null) {
                    model2 = element2.getModel();
                }
                if (model2 != null) {
                    ss2 = ScriptGenerators.INSTANCE.byModel(model2);
                }
                if (ss2 != null && !DbSrcMigration.canRefactor(ss2, element2)) continue;
            }
            if ((path = DbSrcUtilsCore.getFullPath(file.getPath())) == null) continue;
            objects2.add((Pair<ObjectPath, VirtualFile>)Pair.create((Object)path, (Object)file));
        }
        ArrayList<Pair<ObjectPath, VirtualFile>> arrayList = objects2;
        if (arrayList == null) {
            DbSrcMigration.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public static ScriptingAlterTaskBuilder migrationTaskBuilder(@NotNull Project project, @NotNull DbDataSource dataSource2, @NotNull Iterable<Pair<ObjectPath, VirtualFile>> files2, @Nullable ObjectPath currentNamespace) {
        List<Pair<ObjectPath, SqlFile>> objects2;
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(4);
        }
        if (dataSource2 == null) {
            DbSrcMigration.$$$reportNull$$$0(5);
        }
        if (files2 == null) {
            DbSrcMigration.$$$reportNull$$$0(6);
        }
        if ((objects2 = DbSrcMigration.findObjects(project, files2)).isEmpty()) {
            return null;
        }
        BasicModel model2 = (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class);
        if (model2 == null) {
            return null;
        }
        BasicModModel targetModel = new ModelFactory(new MemoryTextStorage()).createModel(model2.getDbms());
        ScriptingAlterTaskBuilder task = new ScriptingAlterTaskBuilder(model2, targetModel);
        HashMap<BasicModElement, ObjectPath> copied = new HashMap<BasicModElement, ObjectPath>();
        Function resolver = p2 -> p2 == null ? model2.getRoot() : (BasicElement)DbSqlUtilCore.findObjects(dataSource2, p2).filter(BasicElement.class).first();
        DbSrcMigration.buildFromSql(project, (Function<ObjectPath, BasicElement>)resolver, objects2, targetModel, copied);
        DbSrcMigration.pullDeps(project, (Function<ObjectPath, BasicElement>)resolver, objects2, targetModel, copied);
        DbSrcMigration.fillCorrespondence(task, copied, (Iterable<ObjectPath>)JBIterable.from(objects2).map(Functions.pairFirst()), (Function<ObjectPath, BasicElement>)resolver);
        task.setCurrentNamespace(currentNamespace == null ? null : (BasicNamespace)ObjectUtils.tryCast((Object)resolver.fun((Object)currentNamespace), BasicNamespace.class));
        task.setCodeStyle(ScriptingTaskBuilderKt.getCodeStyle(dataSource2));
        return task;
    }

    private static void pullDeps(@NotNull Project project, @NotNull Function<ObjectPath, BasicElement> pathResolver, List<Pair<ObjectPath, SqlFile>> objects2, BasicModModel targetModel, Map<BasicModElement, ObjectPath> copied) {
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(7);
        }
        if (pathResolver == null) {
            DbSrcMigration.$$$reportNull$$$0(8);
        }
        HashMap<ObjectPath, BasicModElement> revCopied = new HashMap<ObjectPath, BasicModElement>();
        for (Map.Entry<BasicModElement, ObjectPath> entry : copied.entrySet()) {
            revCopied.put(entry.getValue(), entry.getKey());
        }
        Set src2 = JBIterable.from(objects2).filterMap(o2 -> (BasicElement)pathResolver.fun((Object)((ObjectPath)o2.first))).toSet();
        Set tgt = (Set)JBIterable.from((Iterable)src2).flatten(m -> ModelLightCopier.getDependencies(m).append(ModelLightCopier.getGrantees(m))).addAllTo(new LinkedHashSet());
        for (BasicElement element2 : src2) {
            tgt.remove(element2.getParentFamily());
        }
        for (Family srcF : tgt) {
            Family tgtF;
            BasicElement parent2;
            ObjectPath pPath;
            BasicModElement parentTgt;
            if (srcF.isEmpty() || (parentTgt = (BasicModElement)revCopied.get(pPath = ObjectPaths.of(parent2 = srcF.first().getParent()))) == null || (tgtF = parentTgt.familyOf(srcF.getMetaObject().kind)) == null || tgtF.isNotEmpty()) continue;
            ModelLightCopier.copyFamily(srcF, tgtF, true);
            for (BasicModElement o3 : tgtF) {
                ObjectPath path = ObjectPaths.of(o3);
                copied.put(o3, path);
                revCopied.put(path, o3);
            }
        }
    }

    private static void fillCorrespondence(ScriptingAlterTaskBuilder task, Map<BasicModElement, ObjectPath> copied, Iterable<ObjectPath> objects2, Function<ObjectPath, BasicElement> pathResolver) {
        HashMap<ObjectPath, BasicModElement> rev = new HashMap<ObjectPath, BasicModElement>();
        for (Map.Entry<BasicModElement, ObjectPath> entry : copied.entrySet()) {
            task.getCorrespondence().add(ElementDelta.create((BasicElement)pathResolver.fun((Object)entry.getValue()), (BasicElement)entry.getKey()));
            rev.put(entry.getValue(), entry.getKey());
        }
        for (ObjectPath objectPath : objects2) {
            DbSrcMigration.fillCorrespondence((BasicElement)pathResolver.fun((Object)objectPath), task, copied, rev);
            JBTreeTraverser<BasicElement> traverser2 = task.getModel().basicTraverser();
            for (BasicModElement element2 : ((JBTreeTraverser)traverser2.withRoot((Object)((BasicElement)rev.get(objectPath)))).filter(BasicModElement.class)) {
                if (copied.containsKey(element2)) continue;
                task.getCorrespondence().add(ElementDelta.create(null, element2));
            }
        }
    }

    private static void fillCorrespondence(@Nullable BasicElement element2, ScriptingAlterTaskBuilder task, Map<BasicModElement, ObjectPath> copied, Map<ObjectPath, BasicModElement> rev) {
        if (element2 == null) {
            return;
        }
        if (!rev.containsKey(element2)) {
            BasicModElement object = (BasicModElement)DbSrcMigration.findObject(element2, rev);
            if (object != null) {
                rev.put(ObjectPaths.of(element2), object);
                copied.put(object, ObjectPaths.of(element2));
            } else {
                ObjectKind kind = element2.getKind();
                if (!DEPENDANT_OBJECTS.contains(kind)) {
                    return;
                }
            }
            task.getCorrespondence().add(ElementDelta.create(element2, object));
        }
        for (BasicElement child : element2.getChildren()) {
            DbSrcMigration.fillCorrespondence(child, task, copied, rev);
        }
    }

    private static void buildFromSql(@NotNull Project project, @NotNull Function<ObjectPath, BasicElement> pathResolver, List<Pair<ObjectPath, SqlFile>> objects2, BasicModModel targetModel, Map<BasicModElement, ObjectPath> copied) {
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(9);
        }
        if (pathResolver == null) {
            DbSrcMigration.$$$reportNull$$$0(10);
        }
        ArrayList<SqlFile> files2 = new ArrayList<SqlFile>(objects2.size());
        HashMap topObjects = new HashMap();
        HashSet<ObjectPath> rootBranch = new HashSet<ObjectPath>();
        for (Pair<ObjectPath, SqlFile> p2 : objects2) {
            files2.add((SqlFile)p2.second);
            ObjectPath e2 = (ObjectPath)p2.first;
            DasObject def = DbSrcMigration.findObjectDefinition((SqlFile)p2.second, e2);
            BasicElement ee = (BasicElement)pathResolver.fun((Object)e2);
            rootBranch.add(e2);
            while (def != null && e2 != null && def.getKind() == e2.kind) {
                ContainerUtil.putIfNotNull((Object)def, (Object)e2, topObjects);
                def = def.getDasParent();
                e2 = e2.parent;
                ee = ee == null ? (e2 == null ? null : (BasicElement)pathResolver.fun((Object)e2)) : ee.getParent();
            }
        }
        SqlPsiFacade.getInstance((Project)project).buildModel((DasModel)targetModel, files2, (t, s2) -> {
            BasicElement srcResolved;
            BasicModElement mod = (BasicModElement)t;
            if (copied.containsKey(mod)) {
                return true;
            }
            ObjectPath src2 = (ObjectPath)topObjects.get(s2);
            if (src2 == null) {
                src2 = DbSrcMigration.findObject(mod, copied, pathResolver);
                if (src2 != null && !rootBranch.contains(src2.parent)) {
                    src2 = null;
                }
                if (src2 != null) {
                    rootBranch.add(src2);
                }
            }
            if (src2 == null) {
                return true;
            }
            BasicModElement root2 = (BasicModElement)((Object)mod.getModel().getRoot());
            if (!copied.containsKey(root2)) {
                BasicElement srcRoot = Objects.requireNonNull((BasicElement)pathResolver.fun(null));
                ModelLightCopier.copyProperties(srcRoot, root2, true, true);
                copied.put(root2, null);
            }
            if ((srcResolved = (BasicElement)pathResolver.fun((Object)src2)) != null) {
                ModelLightCopier.copyProperties(srcResolved, mod, true, true);
            }
            copied.put(mod, src2);
            return rootBranch.contains(src2);
        });
    }

    @Nullable
    private static ObjectPath findObject(@Nullable BasicElement mod, Map<? extends BasicElement, ObjectPath> copied, @NotNull Function<ObjectPath, BasicElement> pathResolver) {
        if (pathResolver == null) {
            DbSrcMigration.$$$reportNull$$$0(11);
        }
        if (mod == null) {
            return null;
        }
        ObjectPath element2 = copied.get(mod);
        if (element2 != null) {
            return element2;
        }
        ObjectPath p2 = DbSrcMigration.findObject(mod.getParent(), copied, pathResolver);
        BasicElement parent2 = p2 == null ? null : (BasicElement)pathResolver.fun((Object)p2);
        Family<? extends BasicElement> family = parent2 == null ? null : parent2.familyOf(mod.getKind());
        BasicElement child = family == null ? null : ModelUtil.findObject(family, mod);
        return ObjectPaths.of(child);
    }

    @Nullable
    private static BasicElement findObject(@Nullable BasicElement mod, Map<ObjectPath, ? extends BasicElement> copied) {
        if (mod == null) {
            return null;
        }
        BasicElement element2 = copied.get(ObjectPaths.of(mod));
        if (element2 != null) {
            return element2;
        }
        BasicElement parent2 = DbSrcMigration.findObject(mod.getParent(), copied);
        Family<? extends BasicElement> family = parent2 == null ? null : parent2.familyOf(mod.getKind());
        return family == null ? null : ModelUtil.findObject(family, mod);
    }

    private static DasObject findObjectDefinition(SqlFile file, @NotNull ObjectPath target2) {
        if (target2 == null) {
            DbSrcMigration.$$$reportNull$$$0(12);
        }
        return (DasObject)JBIterable.from((Iterable)file.getDdl()).filter(DasObject.class).filter(DasUtil.byKind(target2.kind)).first();
    }

    @NotNull
    private static List<Pair<ObjectPath, SqlFile>> findObjects(@NotNull Project project, @NotNull Iterable<Pair<ObjectPath, VirtualFile>> files2) {
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(13);
        }
        if (files2 == null) {
            DbSrcMigration.$$$reportNull$$$0(14);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList<Pair<ObjectPath, SqlFile>> objects2 = new ArrayList<Pair<ObjectPath, SqlFile>>();
        for (Pair<ObjectPath, VirtualFile> file : files2) {
            SqlFile psiFile = (SqlFile)ObjectUtils.tryCast((Object)psiManager.findFile((VirtualFile)file.second), SqlFile.class);
            if (psiFile == null) continue;
            objects2.add((Pair<ObjectPath, SqlFile>)Pair.create((Object)((ObjectPath)file.first), (Object)psiFile));
        }
        ArrayList<Pair<ObjectPath, SqlFile>> arrayList = objects2;
        if (arrayList == null) {
            DbSrcMigration.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    public static void showMigrationDialog(@NotNull DbDataSource dataSource2, final @NotNull Iterable<VirtualFile> files2, boolean showInEditor) {
        String statements2;
        if (dataSource2 == null) {
            DbSrcMigration.$$$reportNull$$$0(16);
        }
        if (files2 == null) {
            DbSrcMigration.$$$reportNull$$$0(17);
        }
        Project project = dataSource2.getProject();
        LocalDataSource localDataSource = DbImplUtilCore.getLocalDataSource(dataSource2);
        if (DbSrcMigration.checkDetails(dataSource2, files2, project)) {
            return;
        }
        List<Pair<ObjectPath, VirtualFile>> objects2 = DbSrcMigration.getObjects(project, files2);
        ObjectPath any = (ObjectPath)JBIterable.from(objects2).filterMap(Functions.pairFirst()).first();
        ObjectPath spObject = DbImplUtilCore.getSearchPathObject(localDataSource.getDbms(), any);
        SearchPath searchPath = DbImplUtil.getAutoSwitchPath(localDataSource, SearchPath.of(spObject));
        ScriptingAlterTaskBuilder task = null;
        if (any != null) {
            task = DbSrcMigration.migrationTaskBuilder(project, dataSource2, objects2, SearchPath.getCurrent(searchPath));
        }
        if ((statements2 = DbSrcMigration.generateStatements(dataSource2, searchPath, task, any == null)) == null) {
            return;
        }
        DatabaseRefactoringHandler handler2 = new DatabaseRefactoringHandler(project, localDataSource, searchPath){

            @Override
            protected void showError(Project project, ErrorHandler handler2) {
                DatabaseEditorNotifications.showErrorInEditor(project, handler2, (VirtualFile)JBIterable.from((Iterable)files2).single());
                super.showError(project, handler2);
            }
        };
        handler2.setStatement(statements2);
        for (VirtualFile file : files2) {
            DbElement item = DbSrcUtilsCore.findDbElement(project, file.getPath(), DbElement.class);
            if (item != null) {
                BasicElement element2 = DasObjectFun.getBasicElement(item);
                handler2.include(element2);
                continue;
            }
            ObjectPath path = DbSrcUtilsCore.getFullPath(file.getPath());
            handler2.include(path);
        }
        AsyncTask<Boolean> submit = handler2.runStatements(false);
        if (Registry.is((String)"database.migration.source.revert.on.success")) {
            submit.apply(AsyncUtil.getEdtExecutor(), x -> {
                try {
                    DbSrcUtils.revert(files2);
                }
                catch (IOException e2) {
                    LOG.warn("Failed to revert user changes after refactoring", (Throwable)e2);
                }
                return null;
            });
        }
    }

    @Nullable
    private static String generateStatements(@NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath, @Nullable ScriptingAlterTaskBuilder task, boolean noObjects) {
        String statements2;
        int ec;
        if (dataSource2 == null) {
            DbSrcMigration.$$$reportNull$$$0(18);
        }
        Project project = dataSource2.getProject();
        ArrayList<@NlsContexts.Label String> errors = new ArrayList<String>();
        CompositeText text2 = null;
        if (task != null && !task.getCorrespondence().isEmpty()) {
            text2 = ScriptGenerators.INSTANCE.makeScript(project, task.build()).getScript();
        } else {
            errors.add(noObjects ? DatabaseBundle.message("label.no.objects.found", new Object[0]) : DatabaseBundle.message("label.no.create.statements.found", new Object[0]));
        }
        if (text2 != null && (ec = JBIterable.from(text2.getFragments()).filter(f -> f.getError() != null).size()) != 0) {
            errors.add(DatabaseBundle.message("label.script.contains.choice.error.errors", ec, ec == 1 ? 0 : 1));
        }
        String string = statements2 = text2 == null ? "" : text2.getText().toString();
        if (DatabaseSettings.getSettings().skipRefactoringPreview && text2 != null && !DbSrcMigration.hasErrors(text2)) {
            return statements2;
        }
        return DbSrcMigration.previewScript(dataSource2, searchPath, task, errors);
    }

    @Nullable
    private static String previewScript(final @NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath, final @Nullable ScriptingAlterTaskBuilder task, final @NotNull List<@NlsContexts.Label String> errors) {
        DatabaseScriptDialog dialog;
        if (dataSource2 == null) {
            DbSrcMigration.$$$reportNull$$$0(19);
        }
        if (errors == null) {
            DbSrcMigration.$$$reportNull$$$0(20);
        }
        if (!(dialog = new DatabaseScriptDialog(dataSource2.getProject(), dataSource2.getDelegate(), searchPath, DatabaseBundle.message("dialog.title.object.migration", new Object[0])){

            @Override
            protected ScriptingTask getTask() {
                if (task == null) {
                    return new ScriptingInternalTask(dataSource2.getDbms(), ScriptCategory.ALTER, DefaultScriptingOptions.INSTANCE);
                }
                return task.build();
            }

            @Override
            protected AsyncTask<ScriptingTask> applyAndGetTask() {
                return AsyncTask.completed(this.getTask());
            }

            @Override
            protected void init() {
                super.init();
                this.generate();
            }

            @Override
            @NotNull
            protected JComponent createCenterPanel() {
                BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel().addToTop((Component)JBUI.Panels.simplePanel().addToCenter((Component)new TitledSeparator(DatabaseBundle.message("separator.preview", new Object[0]))).addToRight((Component)this.myPreviewPanel.createToolbar())).addToCenter((Component)this.myLoadingPanel);
                if (borderLayoutPanel == null) {
                    2.$$$reportNull$$$0(0);
                }
                return borderLayoutPanel;
            }

            @Override
            @NotNull
            protected List<AnAction> createPreviewActions() {
                List<AnAction> list = Collections.singletonList(2.createSettingsPopupAction(() -> this.getTask(), o2 -> this.settingsChanged(this.appendCodeStyle((ScriptingOptions)o2))));
                if (list == null) {
                    2.$$$reportNull$$$0(1);
                }
                return list;
            }

            @Override
            protected void settingsChanged(ScriptingOptions options2) {
                if (task != null) {
                    task.setOptions(options2);
                }
                this.generate();
            }

            private void generate() {
                if (task == null || task.getCorrespondence().isEmpty()) {
                    StringBuilder text2 = new StringBuilder();
                    PersistentMarkup.Builder b2 = new PersistentMarkup.Builder();
                    text2.append("-- errors:\n");
                    for (String error2 : errors) {
                        text2.append(" -- * ");
                        b2.add(CompositeText.Kind.PLAIN_TEXT, text2.length(), null);
                        text2.append(error2);
                        b2.add(CompositeText.Kind.PLAIN_TEXT, text2.length(), error2);
                        text2.append("\n");
                    }
                    this.updateText(b2.build(text2));
                } else {
                    this.updateText(ScriptGenerators.INSTANCE.makeScript(dataSource2.getProject(), this.getTask()));
                }
            }

            @Override
            protected boolean perform() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/database/script/DbSrcMigration$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createCenterPanel";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPreviewActions";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }).initAndGet()) {
            return null;
        }
        return dialog.getStatement();
    }

    private static boolean hasErrors(CompositeText text2) {
        return JBIterable.from(text2.getFragments()).filter(f -> f.getError() != null).isNotEmpty();
    }

    private static boolean checkDetails(@NotNull DbDataSource dataSource2, @NotNull Iterable<VirtualFile> files2, Project project) {
        if (dataSource2 == null) {
            DbSrcMigration.$$$reportNull$$$0(21);
        }
        if (files2 == null) {
            DbSrcMigration.$$$reportNull$$$0(22);
        }
        JBIterable objects2 = JBIterable.from(files2).filterMap(f -> DbImplUtilCore.findElement(project, f)).filterMap(DbImplUtilCore::getMaybeBasicElement);
        return DetailsSyncHelper.of(dataSource2).check((Iterable<BasicElement>)objects2).askAbortIfSyncRequired(DatabaseBundle.message("dialog.title.migration", new Object[0]));
    }

    public static boolean isToolbarPlace(String place) {
        return place != null && StringUtil.endsWithIgnoreCase((String)place, (String)"toolbar");
    }

    private static VirtualFile @NotNull [] getMigrationFiles(@NotNull AnActionEvent e2) {
        Object files2;
        if (e2 == null) {
            DbSrcMigration.$$$reportNull$$$0(23);
        }
        if ((files2 = (VirtualFile[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null || ContainerUtil.find((Object[])files2, DbSrcUtilsCore::isDbSrcFile) == null) {
            Object[] els = (PsiElement[])e2.getData(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY);
            files2 = els != null ? (VirtualFile[])ContainerUtil.mapNotNull((Object[])els, o2 -> o2 instanceof DbElement ? DbSrcUtils.findDbSrcFile((DbElement)o2, false) : null, (Object[])VirtualFile.EMPTY_ARRAY) : null;
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])ObjectUtils.chooseNotNull((Object)files2, (Object)VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            DbSrcMigration.$$$reportNull$$$0(24);
        }
        return virtualFileArray;
    }

    @NotNull
    private static FileStatus getStatus(VirtualFile f, DbSrcFileStatus fileStatus) {
        FileStatus status = DbSrcUtilsCore.isDbSrcFile(f) ? fileStatus.getStatus(f).getStatus() : null;
        FileStatus fileStatus2 = status == null ? FileStatus.NOT_CHANGED : status;
        if (fileStatus2 == null) {
            DbSrcMigration.$$$reportNull$$$0(25);
        }
        return fileStatus2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 15, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 14: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 15: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/script/DbSrcMigration";
                break;
            }
            case 5: 
            case 16: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/script/DbSrcMigration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjects";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findObjects";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getMigrationFiles";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getObjects";
                break;
            }
            case 3: 
            case 15: 
            case 24: 
            case 25: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "migrationTaskBuilder";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "pullDeps";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildFromSql";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findObject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findObjectDefinition";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findObjects";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showMigrationDialog";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "generateStatements";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "previewScript";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkDetails";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getMigrationFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 15, 24, 25 -> new IllegalStateException(string);
        };
    }

    public static final class DiffAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DiffAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                DiffAction.$$$reportNull$$$0(1);
            }
            Object[] files2 = DbSrcMigration.getMigrationFiles(e2);
            DbSrcFileStatus fileStatus = DbSrcChangesTracker.getFileStatuses();
            boolean enabled = e2.getProject() != null && ContainerUtil.find((Object[])files2, f -> DbSrcMigration.getStatus(f, fileStatus) != FileStatus.NOT_CHANGED) != null;
            e2.getPresentation().setEnabled(enabled);
            e2.getPresentation().setVisible(enabled || DbSrcMigration.isToolbarPlace(e2.getPlace()) && files2.length != 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                DiffAction.$$$reportNull$$$0(2);
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            Object[] files2 = DbSrcMigration.getMigrationFiles(e2);
            if (files2.length == 0) {
                return;
            }
            DbSrcChangesTracker.flushAndUpdateFiles(Arrays.asList(files2));
            List changes = JBIterable.of((Object[])files2).filterMap(DbSrcChangesTrackerBase::getChange).toList();
            if (changes.isEmpty()) {
                return;
            }
            ShowDiffAction.showDiffForChange((Project)e2.getProject(), (Iterable)changes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/script/DbSrcMigration$DiffAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/script/DbSrcMigration$DiffAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class RevertAction
    extends DumbAwareAction {
        public static AnAction getInstance() {
            return ActionManager.getInstance().getAction("DatabaseView.Tools.RevertChanges");
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                RevertAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                RevertAction.$$$reportNull$$$0(1);
            }
            VirtualFile[] files2 = DbSrcMigration.getMigrationFiles(e2);
            DbSrcFileStatus fileStatus = DbSrcChangesTracker.getFileStatuses();
            boolean forget = true;
            boolean enabled = false;
            if (e2.getProject() != null) {
                for (VirtualFile file : files2) {
                    FileStatus status = DbSrcMigration.getStatus(file, fileStatus);
                    enabled |= status != FileStatus.NOT_CHANGED;
                    forget &= status == FileStatus.DELETED || status == FileStatus.UNKNOWN || status == FileStatus.MERGED_WITH_PROPERTY_CONFLICTS;
                }
            }
            Supplier<@Nls String> text2 = DatabaseBundle.messagePointer((forget &= enabled) ? "action.DatabaseView.Tools.ForgetChanges.text" : "action.DatabaseView.Tools.RevertChanges.text", new Object[0]);
            e2.getPresentation().setText(text2);
            Supplier<@Nls String> desc = DatabaseBundle.messagePointer(forget ? "action.DatabaseView.Tools.ForgetChanges.description" : "action.DatabaseView.Tools.RevertChanges.description", new Object[0]);
            e2.getPresentation().setIcon(forget ? AllIcons.Actions.GC : AllIcons.Actions.Rollback);
            e2.getPresentation().setDescription(desc);
            e2.getPresentation().setEnabled(enabled);
            e2.getPresentation().setVisible(enabled || DbSrcMigration.isToolbarPlace(e2.getPlace()) && files2.length != 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            VirtualFile[] files2;
            if (e2 == null) {
                RevertAction.$$$reportNull$$$0(2);
            }
            if ((files2 = DbSrcMigration.getMigrationFiles(e2)).length == 0) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    DbSrcUtils.revert(Arrays.asList(files2));
                }
                catch (IOException ex) {
                    LOG.error((Throwable)ex);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/script/DbSrcMigration$RevertAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/script/DbSrcMigration$RevertAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class SubmitAction
    extends DumbAwareAction {
        public static AnAction getInstance() {
            return ActionManager.getInstance().getAction("DatabaseView.Tools.SubmitChanges");
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SubmitAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                SubmitAction.$$$reportNull$$$0(1);
            }
            Object[] files2 = DbSrcMigration.getMigrationFiles(e2);
            DbSrcFileStatus fileStatus = DbSrcChangesTracker.getFileStatuses();
            boolean enabled = e2.getProject() != null && ContainerUtil.find((Object[])files2, f -> DbSrcMigration.isSupported(f) && DbSrcMigration.getStatus(f, fileStatus) != FileStatus.NOT_CHANGED) != null;
            e2.getPresentation().setVisible(enabled || DbSrcMigration.isToolbarPlace(e2.getPlace()) && files2.length != 0);
            e2.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            JBIterable files2;
            Project project;
            DbDataSource dataSource2;
            if (e2 == null) {
                SubmitAction.$$$reportNull$$$0(2);
            }
            if ((dataSource2 = DbImplUtilCore.findDataSource(project = Objects.requireNonNull(e2.getProject()), (VirtualFile)(files2 = JBIterable.of((Object[])DbSrcMigration.getMigrationFiles(e2))).first())) != null) {
                DbSrcMigration.showMigrationDialog(dataSource2, (Iterable<VirtualFile>)files2, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/script/DbSrcMigration$SubmitAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/script/DbSrcMigration$SubmitAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

