/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.GrantData;
import com.intellij.database.schemaEditor.StateKey;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.ui.BaseRenderer;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.GrantsColumnInfo;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.UiNotifyConnector;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.BitSet;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00010\u0003:\u0004!\"#$B\u0015\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0017\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00028\u00002\b\u0010\u001c\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 R\u001b\u0010\u0007\u001a\f0\bR\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo;", "D", "Lcom/intellij/database/schemaEditor/GrantData;", "Lcom/intellij/util/ui/ColumnInfo;", "grantCtl", "Lcom/intellij/database/model/properties/Grants$Controller;", "(Lcom/intellij/database/model/properties/Grants$Controller;)V", "myEditor", "Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo$GrantsEditor;", "getMyEditor", "()Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo$GrantsEditor;", "myRenderer", "Ljavax/swing/table/TableCellRenderer;", "getColName", "", "idx", "", "getEditor", "Ljavax/swing/table/TableCellEditor;", "user", "(Lcom/intellij/database/schemaEditor/GrantData;)Ljavax/swing/table/TableCellEditor;", "getRenderer", "(Lcom/intellij/database/schemaEditor/GrantData;)Ljavax/swing/table/TableCellRenderer;", "isCellEditable", "", "(Lcom/intellij/database/schemaEditor/GrantData;)Z", "setValue", "", "value", "(Lcom/intellij/database/schemaEditor/GrantData;Lcom/intellij/database/schemaEditor/GrantData;)V", "valueOf", "o", "(Lcom/intellij/database/schemaEditor/GrantData;)Lcom/intellij/database/schemaEditor/GrantData;", "ColumnPermData", "GrantsEditor", "GrantsRenderer", "PermData", "intellij.database.impl"})
public class GrantsColumnInfo<D extends GrantData>
extends ColumnInfo<D, D> {
    @NotNull
    private final TableCellRenderer myRenderer;
    @NotNull
    private final GrantsEditor myEditor;

    public GrantsColumnInfo(@NotNull Grants.Controller<?, ?> grantCtl) {
        Intrinsics.checkNotNullParameter(grantCtl, (String)"grantCtl");
        super("");
        this.myRenderer = new GrantsRenderer();
        this.myEditor = new GrantsEditor(grantCtl);
    }

    @NotNull
    public final GrantsEditor getMyEditor() {
        return this.myEditor;
    }

    @NotNull
    public D valueOf(@NotNull D o2) {
        Intrinsics.checkNotNullParameter(o2, (String)"o");
        return o2;
    }

    public void setValue(@NotNull D user, @Nullable D value2) {
        Intrinsics.checkNotNullParameter(user, (String)"user");
        ((GrantData)user).getGrants().clear();
        if (value2 != null) {
            ((GrantData)user).getGrants().putAll((Map<StateKey, Grants.State>)((GrantData)value2).getGrants());
        }
    }

    @NotNull
    public TableCellRenderer getRenderer(@NotNull D user) {
        Intrinsics.checkNotNullParameter(user, (String)"user");
        return this.myRenderer;
    }

    public boolean isCellEditable(@NotNull D user) {
        Intrinsics.checkNotNullParameter(user, (String)"user");
        return true;
    }

    @NotNull
    public TableCellEditor getEditor(@Nullable D user) {
        return (TableCellEditor)((Object)this.myEditor);
    }

    private final String getColName(int idx) {
        return (String)this.myEditor.getCNames().get(idx);
    }

    public static final /* synthetic */ String access$getColName(GrantsColumnInfo $this, int idx) {
        return $this.getColName(idx);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B$\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0012\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u00c6\u0003J.\u0010\u0015\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo$ColumnPermData;", "", "colName", "", "Lorg/jetbrains/annotations/Nls;", "position", "", "state", "Lcom/intellij/database/model/properties/Grants$State;", "(Ljava/lang/String;ILcom/intellij/database/model/properties/Grants$State;)V", "getColName", "()Ljava/lang/String;", "getPosition", "()I", "getState", "()Lcom/intellij/database/model/properties/Grants$State;", "setState", "(Lcom/intellij/database/model/properties/Grants$State;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.database.impl"})
    public static final class ColumnPermData {
        @NotNull
        private final String colName;
        private final int position;
        @Nullable
        private Grants.State state;

        public ColumnPermData(@NotNull String colName, int position, @Nullable Grants.State state) {
            Intrinsics.checkNotNullParameter((Object)colName, (String)"colName");
            this.colName = colName;
            this.position = position;
            this.state = state;
        }

        @NotNull
        public final String getColName() {
            return this.colName;
        }

        public final int getPosition() {
            return this.position;
        }

        @Nullable
        public final Grants.State getState() {
            return this.state;
        }

        public final void setState(@Nullable Grants.State state) {
            this.state = state;
        }

        @NotNull
        public final String component1() {
            return this.colName;
        }

        public final int component2() {
            return this.position;
        }

        @Nullable
        public final Grants.State component3() {
            return this.state;
        }

        @NotNull
        public final ColumnPermData copy(@NotNull String colName, int position, @Nullable Grants.State state) {
            Intrinsics.checkNotNullParameter((Object)colName, (String)"colName");
            return new ColumnPermData(colName, position, state);
        }

        public static /* synthetic */ ColumnPermData copy$default(ColumnPermData columnPermData, String string, int n, Grants.State state, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = columnPermData.colName;
            }
            if ((n3 & 2) != 0) {
                n = columnPermData.position;
            }
            if ((n3 & 4) != 0) {
                state = columnPermData.state;
            }
            return columnPermData.copy(string, n, state);
        }

        @NotNull
        public String toString() {
            return "ColumnPermData(colName=" + this.colName + ", position=" + this.position + ", state=" + this.state + ")";
        }

        public int hashCode() {
            int result2 = this.colName.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.position);
            result2 = result2 * 31 + (this.state == null ? 0 : this.state.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColumnPermData)) {
                return false;
            }
            ColumnPermData columnPermData = (ColumnPermData)other;
            if (!Intrinsics.areEqual((Object)this.colName, (Object)columnPermData.colName)) {
                return false;
            }
            if (this.position != columnPermData.position) {
                return false;
            }
            return this.state == columnPermData.state;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u001c\u001a\u00020\u0017J\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\u0006\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0002J\b\u0010#\u001a\u00020$H\u0016J2\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010$2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0016J\b\u0010/\u001a\u00020+H\u0016J$\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u000e\u00103\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006J\u001c\u00100\u001a\u0002012\u0006\u00104\u001a\u0002052\f\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"J\u0012\u00106\u001a\u0002012\b\u00107\u001a\u0004\u0018\u00010\rH\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00068"}, d2={"Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo$GrantsEditor;", "Lcom/intellij/util/ui/AbstractTableCellEditor;", "myGrantCtl", "Lcom/intellij/database/model/properties/Grants$Controller;", "(Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo;Lcom/intellij/database/model/properties/Grants$Controller;)V", "cNames", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "", "getCNames", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "current", "Lcom/intellij/openapi/ui/popup/JBPopup;", "editedValue", "Lcom/intellij/database/schemaEditor/GrantData;", "getMyGrantCtl", "()Lcom/intellij/database/model/properties/Grants$Controller;", "myMeta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "myModel", "Lcom/intellij/ui/treeStructure/treetable/ListTreeTableModelOnColumns;", "myTable", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "root", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getRoot", "()Ljavax/swing/tree/DefaultMutableTreeNode;", "children", "Lcom/intellij/util/containers/JBIterable;", "node", "extractColNames", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "owner", "Lcom/intellij/database/schemaEditor/ElementOwner;", "identity", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "getCellEditorValue", "", "getTableCellEditorComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "isSelected", "", "row", "", "column", "stopCellEditing", "updateStructure", "", "meta", "colNames", "controller", "Lcom/intellij/database/schemaEditor/ui/DbEditorController;", "updateValues", "grants", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbGrantsEditorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbGrantsEditorUtils.kt\ncom/intellij/database/schemaEditor/ui/GrantsColumnInfo$GrantsEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,417:1\n1#2:418\n1855#3,2:419\n1194#3,2:426\n1222#3,4:428\n215#4,2:421\n215#4,2:423\n14#5:425\n*S KotlinDebug\n*F\n+ 1 DbGrantsEditorUtils.kt\ncom/intellij/database/schemaEditor/ui/GrantsColumnInfo$GrantsEditor\n*L\n223#1:419,2\n340#1:426,2\n340#1:428,4\n287#1:421,2\n300#1:423,2\n313#1:425\n*E\n"})
    public final class GrantsEditor
    extends AbstractTableCellEditor {
        @NotNull
        private final Grants.Controller<?, ?> myGrantCtl;
        @NotNull
        private final DefaultMutableTreeNode root;
        @NotNull
        private final Int2ObjectMap<String> cNames;
        @Nullable
        private BasicMetaObject<?> myMeta;
        @NotNull
        private final ListTreeTableModelOnColumns myModel;
        @NotNull
        private final TreeTable myTable;
        @Nullable
        private JBPopup current;
        @Nullable
        private GrantData editedValue;

        public GrantsEditor(Grants.Controller<?, ?> myGrantCtl) {
            Intrinsics.checkNotNullParameter(myGrantCtl, (String)"myGrantCtl");
            this.myGrantCtl = myGrantCtl;
            this.root = new DefaultMutableTreeNode("ROOT");
            this.cNames = (Int2ObjectMap)new Int2ObjectOpenHashMap();
            ListTreeTableModelOnColumns listTreeTableModelOnColumns = new ListTreeTableModelOnColumns[]{new TreeColumnInfo(""), new ColumnInfo<DefaultMutableTreeNode, Grants.State>(this){
                final /* synthetic */ GrantsEditor this$0;
                {
                    this.this$0 = $receiver;
                    super("");
                }

                @Nullable
                public Grants.State valueOf(@NotNull DefaultMutableTreeNode o2) {
                    Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                    Object uo = o2.getUserObject();
                    return uo instanceof PermData ? ((PermData)uo).getState() : (uo instanceof ColumnPermData ? ((ColumnPermData)uo).getState() : null);
                }

                public void setValue(@NotNull DefaultMutableTreeNode node2, @Nullable Grants.State value2) {
                    Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
                    Object uo = node2.getUserObject();
                    if (uo instanceof PermData) {
                        ((PermData)uo).setState(value2);
                    } else if (uo instanceof ColumnPermData) {
                        ((ColumnPermData)uo).setState(value2);
                    }
                }

                public boolean isCellEditable(@NotNull DefaultMutableTreeNode node2) {
                    Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
                    return true;
                }

                @NotNull
                public TableCellRenderer getRenderer(@NotNull DefaultMutableTreeNode node2) {
                    Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
                    return (TableCellRenderer)new ColoredTableCellRenderer(this){
                        final /* synthetic */ myModel.1<D> this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value2, boolean selected, boolean hasFocus, int row, int column2) {
                            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                            myModel.1.access$render(this.this$0, (SimpleColoredComponent)this, value2);
                        }
                    };
                }

                private final void render(SimpleColoredComponent c2, Object value2) {
                    Object object = value2;
                    if (object == Grants.State.GRANT) {
                        c2.append(DatabaseBundle.message("DbObjectGrantsEditor.state.label.grant", new Object[0]));
                    } else if (object == Grants.State.GRANT_WITH_GRANT_OPTION) {
                        c2.append(DatabaseBundle.message("DbObjectGrantsEditor.state.label.grant.with.option", new Object[0]));
                    } else if (object == Grants.State.REVOKE) {
                        c2.append(DatabaseBundle.message("DbObjectGrantsEditor.state.label.revoke", new Object[0]));
                    } else if (object == Grants.State.DENY) {
                        c2.append(DatabaseBundle.message("DbObjectGrantsEditor.state.label.deny", new Object[0]));
                    } else {
                        c2.append(DatabaseBundle.message("DbObjectGrantsEditor.state.label.not.granted", new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                }

                @NotNull
                public TableCellEditor getEditor(@NotNull DefaultMutableTreeNode node2) {
                    Grants.State[] stateArray;
                    block8: {
                        block7: {
                            Grants.State[] meta;
                            Object object;
                            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
                            if (node2.getUserObject() instanceof ColumnPermData) {
                                object = BasicMetaUtils.findChild(GrantsEditor.access$getMyMeta$p(this.this$0), ObjectKind.COLUMN);
                                if (object == null) {
                                    object = GrantsEditor.access$getMyMeta$p(this.this$0);
                                }
                            } else {
                                object = GrantsEditor.access$getMyMeta$p(this.this$0);
                            }
                            stateArray = meta = object;
                            if (meta == null) break block7;
                            Grants.State[] stateArray2 = stateArray;
                            GrantsEditor grantsEditor = this.this$0;
                            Grants.State[] it2 = stateArray2;
                            boolean bl = false;
                            Grants.State[] stateArray3 = grantsEditor.getMyGrantCtl().possibleStates((BasicMetaObject<?>)it2);
                            stateArray = stateArray3;
                            if (stateArray3 != null) break block8;
                        }
                        stateArray = Grants.State.values();
                    }
                    List states2 = ArraysKt.toMutableList((Object[])stateArray);
                    states2.add(0, null);
                    Collection $this$toTypedArray$iv = states2;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    ComboBox box = new ComboBox((Object[])thisCollection$iv.toArray(new Grants.State[0]));
                    box.setRenderer((ListCellRenderer)new ColoredListCellRenderer<Grants.State>(this){
                        final /* synthetic */ myModel.1<D> this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        protected void customizeCellRenderer(@NotNull JList<? extends Grants.State> list, @Nullable Grants.State value2, int index2, boolean selected, boolean hasFocus) {
                            Intrinsics.checkNotNullParameter(list, (String)"list");
                            myModel.1.access$render(this.this$0, (SimpleColoredComponent)this, (Object)((Object)value2));
                        }
                    });
                    UiNotifyConnector.Companion.doWhenFirstShown((JComponent)box, () -> box.showPopup());
                    return new DefaultCellEditor((JComboBox)box);
                }

                public static final /* synthetic */ void access$render(myModel.1 $this, SimpleColoredComponent c2, Object value2) {
                    $this.render(c2, value2);
                }
            }};
            listTreeTableModelOnColumns = this.myModel = new ListTreeTableModelOnColumns((TreeNode)this.root, (ColumnInfo[])listTreeTableModelOnColumns);
            this.myTable = new TreeTable(listTreeTableModelOnColumns){

                @NotNull
                public TableCellRenderer getCellRenderer(int row, int column2) {
                    Object object;
                    block6: {
                        block5: {
                            TableCellRenderer tableCellRenderer;
                            object = this.getColumnInfo(column2);
                            if (object == null) break block5;
                            ColumnInfo<Object, ?> colInfo = object;
                            boolean bl = false;
                            Object object2 = this.getRow(row);
                            if (object2 != null) {
                                Object it2 = object2;
                                boolean bl2 = false;
                                tableCellRenderer = colInfo.getRenderer(it2);
                            } else {
                                tableCellRenderer = null;
                            }
                            object = tableCellRenderer;
                            if (tableCellRenderer != null) break block6;
                        }
                        TableCellRenderer tableCellRenderer = super.getCellRenderer(row, column2);
                        object = tableCellRenderer;
                        Intrinsics.checkNotNullExpressionValue((Object)tableCellRenderer, (String)"getCellRenderer(...)");
                    }
                    return object;
                }

                @NotNull
                public TableCellEditor getCellEditor(int row, int column2) {
                    Object object;
                    block6: {
                        block5: {
                            TableCellEditor tableCellEditor;
                            object = this.getColumnInfo(column2);
                            if (object == null) break block5;
                            ColumnInfo<Object, ?> colInfo = object;
                            boolean bl = false;
                            Object object2 = this.getRow(row);
                            if (object2 != null) {
                                Object it2 = object2;
                                boolean bl2 = false;
                                tableCellEditor = colInfo.getEditor(it2);
                            } else {
                                tableCellEditor = null;
                            }
                            object = tableCellEditor;
                            if (tableCellEditor != null) break block6;
                        }
                        TableCellEditor tableCellEditor = super.getCellEditor(row, column2);
                        object = tableCellEditor;
                        Intrinsics.checkNotNullExpressionValue((Object)tableCellEditor, (String)"getCellEditor(...)");
                    }
                    return object;
                }

                public boolean editCellAt(int row, int column2, @Nullable EventObject e2) {
                    return super.editCellAt(row, column2, e2) || column2 == 0 && super.editCellAt(row, 1, e2);
                }

                public boolean editCellAt(int row, int column2) {
                    return super.editCellAt(row, column2) || column2 == 0 && super.editCellAt(row, 1);
                }

                private final Object getRow(int row) {
                    TreePath treePath = this.getTree().getPathForRow(row);
                    return treePath != null ? treePath.getLastPathComponent() : null;
                }

                private final ColumnInfo<Object, ?> getColumnInfo(int column2) {
                    ColumnInfo[] columnInfoArray;
                    TreeTableModel $this$asSafely$iv = this.getTableModel();
                    boolean $i$f$asSafely = false;
                    TreeTableModel treeTableModel = $this$asSafely$iv;
                    if (!(treeTableModel instanceof ListTreeTableModelOnColumns)) {
                        treeTableModel = null;
                    }
                    return (columnInfoArray = (ColumnInfo[])treeTableModel) != null && (columnInfoArray = columnInfoArray.getColumns()) != null ? columnInfoArray[this.convertColumnIndexToModel(column2)] : null;
                }
            };
            this.myTable.setRootVisible(false);
            this.myTable.setTableHeader(null);
            this.myTable.setTreeCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

                public void customizeCellRenderer(@NotNull JTree tree2, @NotNull Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    Object uo;
                    Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
                    Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                    Object $this$asSafely$iv = value2;
                    boolean $i$f$asSafely = false;
                    Object object = $this$asSafely$iv;
                    if (!(object instanceof DefaultMutableTreeNode)) {
                        object = null;
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                    Object object2 = uo = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
                    if (uo instanceof PermData) {
                        this.append(((PermData)uo).getPerm(), ((PermData)uo).getUnknown() ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else if (uo instanceof ColumnPermData) {
                        String string = StringKt.nullize$default((String)((ColumnPermData)uo).getColName(), (boolean)false, (int)1, null);
                        if (string != null) {
                            String string2;
                            String it2 = string2 = string;
                            boolean bl = false;
                            this.append(it2);
                        } else {
                            Object[] objectArray = new Object[]{((ColumnPermData)uo).getPosition()};
                            this.append(DatabaseBundle.message("column.0", objectArray), SimpleTextAttributes.GRAY_ATTRIBUTES);
                        }
                    }
                }
            });
        }

        @NotNull
        public final Grants.Controller<?, ?> getMyGrantCtl() {
            return this.myGrantCtl;
        }

        @NotNull
        public final DefaultMutableTreeNode getRoot() {
            return this.root;
        }

        @NotNull
        public final Int2ObjectMap<String> getCNames() {
            return this.cNames;
        }

        private final Int2ObjectOpenHashMap<String> extractColNames(ElementOwner owner, ElementIdentity<?> identity) {
            Int2ObjectOpenHashMap colNames;
            block3: {
                colNames = new Int2ObjectOpenHashMap();
                BasicMetaObject cMeta = BasicMetaUtils.findChild(identity.getMetaObject(), ObjectKind.COLUMN);
                colNames.clear();
                BasicMetaObject basicMetaObject = cMeta;
                if (basicMetaObject == null) break block3;
                BasicMetaObject it2 = basicMetaObject;
                boolean bl = false;
                JBIterable jBIterable = owner.getChildren(identity, it2);
                basicMetaObject = jBIterable;
                if (jBIterable != null) {
                    Iterable $this$forEach$iv = (Iterable)((Object)basicMetaObject);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ElementIdentity it3 = (ElementIdentity)element$iv;
                        boolean bl2 = false;
                        if ((BasicArrangedElement)owner.find(it3) != null) {
                            BasicArrangedElement c2;
                            boolean bl3 = false;
                            colNames.put((int)c2.getPosition(), (Object)c2.getName());
                        }
                    }
                }
            }
            return colNames;
        }

        public final void updateStructure(@NotNull DbEditorController controller, @Nullable ElementIdentity<?> identity) {
            ElementOwner owner;
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            DbEditorModelController dbEditorModelController = controller.getModelController();
            Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController, (String)"getModelController(...)");
            DbEditorModelController modelController = dbEditorModelController;
            ElementOwner elementOwner = modelController.getActualOwner();
            if (elementOwner == null) {
                elementOwner = modelController.getMatcher().getOriginalOwner();
            }
            Int2ObjectOpenHashMap<String> colNames = (owner = elementOwner) != null && identity != null ? this.extractColNames(owner, identity) : null;
            ElementIdentity<?> elementIdentity = identity;
            this.updateStructure(elementIdentity != null ? elementIdentity.getMetaObject() : null, (Int2ObjectMap<String>)((Int2ObjectMap)colNames));
        }

        public final void updateStructure(@Nullable BasicMetaObject<?> meta, @Nullable Int2ObjectMap<String> colNames) {
            BasicMetaObject basicMetaObject;
            List privs;
            IntSet poses;
            block10: {
                block9: {
                    this.root.removeAllChildren();
                    this.cNames.clear();
                    Object object = colNames;
                    if (object == null || (object = (IntSet)object.keySet()) == null || (object = CollectionsKt.sorted((Iterable)((Iterable)object))) == null) {
                        object = CollectionsKt.emptyList();
                    }
                    poses = object;
                    for (Integer pos : poses) {
                        Intrinsics.checkNotNull((Object)pos);
                        Object object2 = colNames;
                        this.cNames.put(pos.intValue(), object2 != null ? (String)object2.get(pos.intValue()) : null);
                    }
                    this.myMeta = meta;
                    if (meta == null) {
                        return;
                    }
                    privs = CollectionsKt.sorted(this.myGrantCtl.possiblePrivileges(meta));
                    basicMetaObject = BasicMetaUtils.findChild(meta, ObjectKind.COLUMN);
                    if (basicMetaObject == null) break block9;
                    BasicMetaObject it2 = basicMetaObject;
                    boolean bl = false;
                    Set set = CollectionsKt.toSet(this.myGrantCtl.possiblePrivileges(it2));
                    basicMetaObject = set;
                    if (set != null) break block10;
                }
                basicMetaObject = SetsKt.emptySet();
            }
            BasicMetaObject colPrivs = basicMetaObject;
            for (String p2 : privs) {
                DefaultMutableTreeNode pNode = new DefaultMutableTreeNode(new PermData(p2, null, false));
                if (!this.cNames.isEmpty() && colPrivs.contains(p2)) {
                    for (Integer pos : poses) {
                        Intrinsics.checkNotNull((Object)pos);
                        Object object = this.cNames.get(pos.intValue());
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        pNode.add(new DefaultMutableTreeNode(new ColumnPermData((String)object, pos, null)));
                    }
                }
                this.root.add(pNode);
            }
            this.myModel.reload();
        }

        private final void updateValues(GrantData grants) {
            DefaultMutableTreeNode pNode;
            StateKey k;
            Map.Entry element$iv;
            this.editedValue = grants;
            Cloneable cloneable = grants;
            Map values2 = cloneable != null && (cloneable = cloneable.getGrants()) != null ? (Map)((Object)cloneable) : MapsKt.emptyMap();
            LinkedHashMap processed = new LinkedHashMap();
            for (DefaultMutableTreeNode pNode2 : this.children(this.root)) {
                Object object = pNode2.getUserObject();
                PermData permData = object instanceof PermData ? (PermData)object : null;
                if (permData == null) continue;
                PermData p2 = permData;
                if (p2.getUnknown()) {
                    pNode2.removeFromParent();
                    continue;
                }
                StateKey key2 = new StateKey(p2.getPerm(), null);
                boolean bl = false;
                p2.setState((Grants.State)((Object)values2.get(key2)));
                Map map2 = processed;
                Intrinsics.checkNotNull((Object)pNode2);
                map2.put(key2, pNode2);
                for (DefaultMutableTreeNode cNode : this.children(pNode2)) {
                    ColumnPermData cp;
                    Object object2 = cNode.getUserObject();
                    if ((object2 instanceof ColumnPermData ? (ColumnPermData)object2 : null) == null) continue;
                    cp = cp;
                    StateKey key3 = new StateKey(p2.getPerm(), cp.getPosition());
                    boolean bl2 = false;
                    cp.setState((Grants.State)((Object)values2.get(key3)));
                    Map map3 = processed;
                    Intrinsics.checkNotNull((Object)cNode);
                    map3.put(key3, cNode);
                    if (!(((CharSequence)cp.getColName()).length() == 0)) continue;
                    cNode.removeFromParent();
                }
            }
            Set set = this.cNames.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            List poses = CollectionsKt.sorted((Iterable)set);
            Map $this$forEach$iv = values2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                k = (StateKey)entry.getKey();
                Grants.State s2 = (Grants.State)((Object)entry.getValue());
                if (k.getPos() != null || processed.containsKey(k)) continue;
                pNode = new DefaultMutableTreeNode(new PermData(k.getPerm(), s2, true));
                this.root.add(pNode);
                ((Map)processed).put(k, pNode);
                for (Integer pos : poses) {
                    StateKey key4 = new StateKey(k.getPerm(), pos);
                    Intrinsics.checkNotNull((Object)pos);
                    Object object = this.cNames.get(pos.intValue());
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(new ColumnPermData((String)object, pos, (Grants.State)((Object)values2.get(key4))));
                    pNode.add(cNode);
                    ((Map)processed).put(key4, cNode);
                }
            }
            $this$forEach$iv = values2;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                k = (StateKey)entry.getKey();
                Grants.State s3 = (Grants.State)((Object)entry.getValue());
                if (k.getPos() == null || processed.containsKey(k) || (DefaultMutableTreeNode)processed.get(new StateKey(k.getPerm(), null)) == null) continue;
                Intrinsics.checkNotNull((Object)pNode);
                DefaultMutableTreeNode pNode3 = pNode;
                Integer n = k.getPos();
                Intrinsics.checkNotNull((Object)n);
                DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(new ColumnPermData("", n, s3));
                pNode3.add(cNode);
            }
            this.myModel.reload();
        }

        @NotNull
        public Component getTableCellEditorComponent(@NotNull JTable table, @Nullable Object value2, boolean isSelected, int row, int column2) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Component component2 = new GrantsRenderer().getTableCellRendererComponent(table, value2, isSelected, true, row, column2);
            Object $this$asSafely$iv = value2;
            boolean $i$f$asSafely = false;
            Object object = $this$asSafely$iv;
            if (!(object instanceof GrantData)) {
                object = null;
            }
            this.updateValues((GrantData)object);
            UiNotifyConnector.Companion.doWhenFirstShown$default((UiNotifyConnector.Companion)UiNotifyConnector.Companion, (Component)component2, (boolean)false, (Function0)((Function0)new Function0<Unit>(this, component2){
                final /* synthetic */ GrantsEditor this$0;
                final /* synthetic */ Component $component;
                {
                    this.this$0 = $receiver;
                    this.$component = $component;
                    super(0);
                }

                public final void invoke() {
                    JBPopup prev;
                    JBPopup jBPopup = prev = GrantsEditor.access$getCurrent$p(this.this$0);
                    if (jBPopup != null) {
                        jBPopup.closeOk(null);
                    }
                    JBPopup jBPopup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)ScrollPaneFactory.createScrollPane((Component)((Component)GrantsEditor.access$getMyTable$p(this.this$0)), (boolean)true), (JComponent)GrantsEditor.access$getMyTable$p(this.this$0)).addListener(new JBPopupListener(this.this$0){
                        final /* synthetic */ GrantsEditor this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public void onClosed(@NotNull LightweightWindowEvent event) {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            this.this$0.stopCellEditing();
                        }
                    }).setMinSize((Dimension)JBUI.size((int)300, (int)250)).setRequestFocus(true).createPopup();
                    Intrinsics.checkNotNullExpressionValue((Object)jBPopup2, (String)"createPopup(...)");
                    JBPopup popup2 = jBPopup2;
                    popup2.show(new RelativePoint(this.$component, new Point(0, 0)));
                    GrantsEditor.access$setCurrent$p(this.this$0, popup2);
                }
            }), (int)2, null);
            return component2;
        }

        public boolean stopCellEditing() {
            block0: {
                JBPopup popup2;
                JBPopup jBPopup = popup2 = this.current;
                if (jBPopup == null) break block0;
                jBPopup.closeOk(null);
            }
            return super.stopCellEditing();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Object getCellEditorValue() {
            Object object;
            void $this$associateByTo$iv$iv;
            Cloneable cloneable = this.editedValue;
            Set set = cloneable != null && (cloneable = ((GrantData)cloneable).getGrants()) != null ? ((LinkedHashMap)cloneable).keySet() : null;
            Iterable $this$associateBy$iv = set == null ? (Collection)CollectionsKt.emptyList() : (Collection)set;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it2;
                object = (StateKey)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(it2, element$iv$iv);
            }
            Map existingKeys = destination$iv$iv;
            GrantData res2 = new GrantData();
            for (DefaultMutableTreeNode pNode : this.children(this.root)) {
                Object $i$f$associateByTo2 = pNode.getUserObject();
                PermData permData = $i$f$associateByTo2 instanceof PermData ? (PermData)$i$f$associateByTo2 : null;
                if (permData == null) continue;
                PermData p2 = permData;
                if (p2.getState() != null) {
                    Grants.State it3;
                    boolean bl = false;
                    ((Map)res2.getGrants()).put(GrantsEditor.getCellEditorValue$useExisting(new StateKey(p2.getPerm(), null), existingKeys), it3);
                }
                Intrinsics.checkNotNull((Object)pNode);
                for (DefaultMutableTreeNode cNode : this.children(pNode)) {
                    Grants.State it4;
                    object = cNode.getUserObject();
                    ColumnPermData columnPermData = object instanceof ColumnPermData ? (ColumnPermData)object : null;
                    if (columnPermData == null) continue;
                    ColumnPermData cp = columnPermData;
                    if (cp.getState() == null) continue;
                    boolean bl = false;
                    ((Map)res2.getGrants()).put(GrantsEditor.getCellEditorValue$useExisting(new StateKey(p2.getPerm(), cp.getPosition()), existingKeys), it4);
                }
            }
            return res2;
        }

        @NotNull
        public final JBIterable<DefaultMutableTreeNode> children(@NotNull DefaultMutableTreeNode node2) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            JBIterable jBIterable = JBIterable.once(node2.children().asIterator()).filter(DefaultMutableTreeNode.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            return jBIterable;
        }

        private static final StateKey getCellEditorValue$useExisting(StateKey $this$getCellEditorValue_u24useExisting, Map<StateKey, StateKey> existingKeys) {
            StateKey stateKey = existingKeys.get($this$getCellEditorValue_u24useExisting);
            if (stateKey == null) {
                stateKey = $this$getCellEditorValue_u24useExisting;
            }
            return stateKey;
        }

        public static final /* synthetic */ JBPopup access$getCurrent$p(GrantsEditor $this) {
            return $this.current;
        }

        public static final /* synthetic */ TreeTable access$getMyTable$p(GrantsEditor $this) {
            return $this.myTable;
        }

        public static final /* synthetic */ void access$setCurrent$p(GrantsEditor $this, JBPopup jBPopup) {
            $this.current = jBPopup;
        }

        public static final /* synthetic */ BasicMetaObject access$getMyMeta$p(GrantsEditor $this) {
            return $this.myMeta;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\b\b\u0001\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J:\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo$GrantsRenderer;", "Lcom/intellij/database/schemaEditor/ui/BaseRenderer;", "(Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo;)V", "myDeny", "Lcom/intellij/ui/SimpleColoredComponent;", "myGrant", "myRevoke", "appendGrants", "", "comp", "title", "", "perms", "", "extractPermissions", "grants", "Lcom/intellij/database/schemaEditor/GrantData;", "state", "Lcom/intellij/database/model/properties/Grants$State;", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "setUp", "line", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbGrantsEditorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbGrantsEditorUtils.kt\ncom/intellij/database/schemaEditor/ui/GrantsColumnInfo$GrantsRenderer\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,417:1\n14#2:418\n*S KotlinDebug\n*F\n+ 1 DbGrantsEditorUtils.kt\ncom/intellij/database/schemaEditor/ui/GrantsColumnInfo$GrantsRenderer\n*L\n71#1:418\n*E\n"})
    public final class GrantsRenderer
    extends BaseRenderer {
        @NotNull
        private final SimpleColoredComponent myGrant;
        @NotNull
        private final SimpleColoredComponent myRevoke;
        @NotNull
        private final SimpleColoredComponent myDeny;

        public GrantsRenderer() {
            super(new Box(1));
            this.myGrant = new SimpleColoredComponent();
            this.myRevoke = new SimpleColoredComponent();
            this.myDeny = new SimpleColoredComponent();
            this.setUp(this.myGrant);
            this.setUp(this.myRevoke);
            this.setUp(this.myDeny);
            this.getMyComponent().add((Component)this.myGrant);
            this.getMyComponent().add((Component)this.myRevoke);
            this.getMyComponent().add((Component)this.myDeny);
            this.getMyComponent().setBorder((Border)JBUI.Borders.empty((int)JBUI.scale((int)2), (int)0));
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row, int column2) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Object $this$asSafely$iv = value2;
            boolean $i$f$asSafely = false;
            Object object = $this$asSafely$iv;
            if (!(object instanceof GrantData)) {
                object = null;
            }
            GrantData g2 = (GrantData)object;
            String string = DatabaseBundle.message("DbObjectGrantsEditor.label.grant", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.appendGrants(this.myGrant, string, this.extractPermissions(g2, Grants.State.GRANT));
            String string2 = DatabaseBundle.message("DbObjectGrantsEditor.label.revoke", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            this.appendGrants(this.myRevoke, string2, this.extractPermissions(g2, Grants.State.REVOKE));
            String string3 = DatabaseBundle.message("DbObjectGrantsEditor.label.deny", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            this.appendGrants(this.myDeny, string3, this.extractPermissions(g2, Grants.State.DENY));
            if (g2 == null || g2.getGrants().isEmpty()) {
                this.myGrant.setVisible(true);
                this.myGrant.append(DatabaseBundle.message("DbObjectGrantsEditor.label.no.grants", new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            return super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column2);
        }

        private final void setUp(SimpleColoredComponent line) {
            line.setOpaque(false);
            line.setIpad((Insets)JBInsets.emptyInsets());
        }

        private final void appendGrants(SimpleColoredComponent comp, @Nls String title, Set<String> perms) {
            boolean visible = !((Collection)perms).isEmpty();
            comp.setVisible(visible);
            comp.clear();
            if (!visible) {
                return;
            }
            comp.append(title, SimpleTextAttributes.GRAY_ATTRIBUTES);
            comp.append(" ");
            comp.append(StringUtil.join((Collection)perms, (String)", "));
        }

        private final Set<String> extractPermissions(GrantData grants, Grants.State state) {
            if (grants == null) {
                return SetsKt.emptySet();
            }
            Set res2 = new TreeSet();
            Map<String, BitSet> items2 = grants.groupColumnsForState(state);
            for (Map.Entry<String, BitSet> entry : items2.entrySet()) {
                String perm;
                StringBuilder text2 = new StringBuilder();
                text2.append(entry.getKey());
                if (state.getWithGrantOption()) {
                    text2.append("+");
                }
                if (!entry.getValue().isEmpty()) {
                    text2.append('(');
                    StringUtil.join((Iterable)((Iterable)JBIterable.once(entry.getValue().stream().boxed().iterator())), arg_0 -> GrantsRenderer.extractPermissions$lambda$0((Function1)new Function1<Integer, CharSequence>(GrantsColumnInfo.this){
                        final /* synthetic */ GrantsColumnInfo<D> this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final CharSequence invoke(Integer idx) {
                            Intrinsics.checkNotNull((Object)idx);
                            return GrantsColumnInfo.access$getColName(this.this$0, idx);
                        }
                    }, arg_0), (String)",", (StringBuilder)text2);
                    text2.append(')');
                }
                Intrinsics.checkNotNullExpressionValue((Object)text2.toString(), (String)"toString(...)");
                res2.add(perm);
            }
            if (state == Grants.State.GRANT) {
                res2.addAll((Collection)this.extractPermissions(grants, Grants.State.GRANT_WITH_GRANT_OPTION));
            }
            return res2;
        }

        private static final CharSequence extractPermissions$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (CharSequence)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0014\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo$PermData;", "", "perm", "", "state", "Lcom/intellij/database/model/properties/Grants$State;", "unknown", "", "(Ljava/lang/String;Lcom/intellij/database/model/properties/Grants$State;Z)V", "getPerm", "()Ljava/lang/String;", "getState", "()Lcom/intellij/database/model/properties/Grants$State;", "setState", "(Lcom/intellij/database/model/properties/Grants$State;)V", "getUnknown", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.database.impl"})
    public static final class PermData {
        @NotNull
        private final String perm;
        @Nullable
        private Grants.State state;
        private final boolean unknown;

        public PermData(@Nls @NotNull String perm, @Nullable Grants.State state, boolean unknown2) {
            Intrinsics.checkNotNullParameter((Object)perm, (String)"perm");
            this.perm = perm;
            this.state = state;
            this.unknown = unknown2;
        }

        @NotNull
        public final String getPerm() {
            return this.perm;
        }

        @Nullable
        public final Grants.State getState() {
            return this.state;
        }

        public final void setState(@Nullable Grants.State state) {
            this.state = state;
        }

        public final boolean getUnknown() {
            return this.unknown;
        }

        @NotNull
        public final String component1() {
            return this.perm;
        }

        @Nullable
        public final Grants.State component2() {
            return this.state;
        }

        public final boolean component3() {
            return this.unknown;
        }

        @NotNull
        public final PermData copy(@Nls @NotNull String perm, @Nullable Grants.State state, boolean unknown2) {
            Intrinsics.checkNotNullParameter((Object)perm, (String)"perm");
            return new PermData(perm, state, unknown2);
        }

        public static /* synthetic */ PermData copy$default(PermData permData, String string, Grants.State state, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = permData.perm;
            }
            if ((n & 2) != 0) {
                state = permData.state;
            }
            if ((n & 4) != 0) {
                bl = permData.unknown;
            }
            return permData.copy(string, state, bl);
        }

        @NotNull
        public String toString() {
            return "PermData(perm=" + this.perm + ", state=" + this.state + ", unknown=" + this.unknown + ")";
        }

        public int hashCode() {
            int result2 = this.perm.hashCode();
            result2 = result2 * 31 + (this.state == null ? 0 : this.state.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.unknown);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PermData)) {
                return false;
            }
            PermData permData = (PermData)other;
            if (!Intrinsics.areEqual((Object)this.perm, (Object)permData.perm)) {
                return false;
            }
            if (this.state != permData.state) {
                return false;
            }
            return this.unknown == permData.unknown;
        }
    }
}

