/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbStructureObjectModelApplier;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorBase;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbVisualEditor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbVisualEditorBase<E extends BasicElement, S extends DbModelState>
extends DbEditorBase<E, S>
implements DbVisualEditor<E, S> {
    private static final Key<DbVisualEditor<?, ?>> DB_EDITOR_KEY = Key.create((String)"DB_EDITOR_KEY");

    protected DbVisualEditorBase(@NotNull DbEditorController controller, @NotNull DbModelRef<E, S> modelRef) {
        if (controller == null) {
            DbVisualEditorBase.$$$reportNull$$$0(0);
        }
        if (modelRef == null) {
            DbVisualEditorBase.$$$reportNull$$$0(1);
        }
        super(controller, modelRef);
    }

    protected void setEnabled(boolean state) {
        DbVisualEditorBase.setEnabled(this.getComponent(), state);
    }

    public static void setEnabled(JComponent component2, boolean enabled) {
        component2.setEnabled(enabled);
        component2.setToolTipText(enabled ? "" : DatabaseBundle.message("not.supported", new Object[0]));
        JLabel label2 = DbVisualEditorBase.getLabel(component2);
        if (label2 != null) {
            DbVisualEditorBase.setEnabled(label2, enabled);
        }
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusComponent() {
        JComponent jComponent = this.getComponent();
        if (jComponent == null) {
            DbVisualEditorBase.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @Nullable
    private static JLabel getLabel(JComponent component2) {
        if (component2 instanceof JLabel) {
            return null;
        }
        return DatabaseUIUtils.getLabelOf(component2);
    }

    @Nullable
    private static TabLabel getTabLabel(JComponent component2) {
        if (component2 instanceof TabLabel) {
            return null;
        }
        return DatabaseUIUtils.getLabelComponentOf(component2, TabLabel.class);
    }

    @Override
    public boolean isVertical() {
        return false;
    }

    @Override
    public boolean isScrolling() {
        return false;
    }

    @Nullable
    public static DbVisualEditor<?, ?> getEditor(@Nullable Component comp) {
        JLabel lbl;
        Component buddy;
        if (comp == null) {
            return null;
        }
        DbVisualEditor res2 = (DbVisualEditor)ClientProperty.get((Component)comp, DB_EDITOR_KEY);
        if (res2 != null) {
            return res2;
        }
        if (comp instanceof JLabel && (buddy = (lbl = (JLabel)comp).getLabelFor()) != null && buddy != comp) {
            return DbVisualEditorBase.getEditor(buddy);
        }
        if (comp instanceof TabLabel) {
            lbl = (TabLabel)comp;
            return (DbVisualEditor)ObjectUtils.tryCast((Object)lbl.getInfo().getObject(), DbVisualEditor.class);
        }
        return DbVisualEditorBase.getEditor(comp.getParent());
    }

    @Override
    public void updateState() {
        ClientProperty.put((JComponent)this.getComponent(), DB_EDITOR_KEY, (Object)this);
        this.updateEnabled();
        this.updateStatus(DbVisualEditorBase.getStatus(this));
    }

    protected void updateEnabled() {
        this.setEnabled(this.getState().isEnabled());
    }

    protected void updateStatus(FileStatus status) {
        JLabel label2 = DbVisualEditorBase.getLabel(this.getComponent());
        if (label2 != null) {
            label2.setForeground(status == FileStatus.NOT_CHANGED ? UIUtil.getLabelForeground() : status.getColor());
        } else {
            TabLabel tabLabel = DbVisualEditorBase.getTabLabel(this.getComponent());
            if (tabLabel != null) {
                tabLabel.getInfo().setDefaultForeground(status == FileStatus.NOT_CHANGED ? UIUtil.getLabelForeground() : status.getColor());
            }
        }
    }

    public static FileStatus getStatus(@NotNull DbEditor<?, ?> editor2) {
        if (editor2 == null) {
            DbVisualEditorBase.$$$reportNull$$$0(3);
        }
        return DbVisualEditorBase.getStatus(editor2.getModelRef().resolve(editor2.getController().getModelController()));
    }

    public static <E extends BasicElement> FileStatus getStatus(@NotNull DbEditorModel<E, ?> model2) {
        if (model2 == null) {
            DbVisualEditorBase.$$$reportNull$$$0(4);
        }
        DbEditorModelController controller = model2.getController();
        ElementMatcher matcher = controller.getMatcher();
        ElementOwner oOwner = matcher.getOriginalOwner();
        ElementIdentity<E> identity = model2.getIdentity();
        if (identity instanceof MultiElementIdentity) {
            return FileStatus.NOT_CHANGED;
        }
        Object original = oOwner == null ? null : oOwner.find(identity);
        BasicMetaId key2 = model2.getModelInternalKey();
        if (original == null) {
            if (key2 != DbStructureObjectModelApplier.ID) {
                return FileStatus.NOT_CHANGED;
            }
            ElementIdentity<?> parentId = matcher.getParent(identity);
            if (parentId != null && (oOwner == null || oOwner.find(parentId) == null)) {
                return FileStatus.NOT_CHANGED;
            }
            return FileStatus.ADDED;
        }
        return controller.getModifiedCache().isModified(model2) ? FileStatus.MODIFIED : FileStatus.NOT_CHANGED;
    }

    public static int columnsToWidth(@NotNull JComponent component2, int columns2) {
        if (component2 == null) {
            DbVisualEditorBase.$$$reportNull$$$0(5);
        }
        return GraphicsUtil.stringWidth((String)"m", (Font)component2.getFont()) * columns2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelRef";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbVisualEditorBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbVisualEditorBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "columnsToWidth";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

