/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.ddl.CreateObjectActionHelper;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.schemaEditor.DbObjectEditorBuilder;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelModifiedCache;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.DbModelResetHelper;
import com.intellij.database.schemaEditor.model.applier.DbObjectModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbStructureObjectModelApplier;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureNodeState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.schemaEditor.ui.DbCreateObjectAction;
import com.intellij.database.schemaEditor.ui.DbEditorBase;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbStructureEditor;
import com.intellij.database.schemaEditor.ui.DbStructureNodeEditor;
import com.intellij.database.schemaEditor.ui.DbStructureNodeTreeModel;
import com.intellij.database.schemaEditor.ui.DbVisualEditor;
import com.intellij.database.schemaEditor.ui.DbVisualEditorBase;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.UIBundle;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import kotlin.collections.ArraysKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public final class DbStructureEditorActions {
    public static final DataKey<Consumer<Job>> ACTION_JOB_CONSUMER = DataKey.create((String)"ACTION_JOB_CONSUMER");

    public static void report(@NotNull DataContext dataContext, @NotNull Supplier<? extends Job> job2) {
        Consumer consumer2;
        if (dataContext == null) {
            DbStructureEditorActions.$$$reportNull$$$0(0);
        }
        if (job2 == null) {
            DbStructureEditorActions.$$$reportNull$$$0(1);
        }
        if ((consumer2 = (Consumer)dataContext.getData(ACTION_JOB_CONSUMER)) != null) {
            consumer2.accept(job2.get());
        }
    }

    public static void report(@NotNull AnActionEvent e2, @Nullable Job job2) {
        if (e2 == null) {
            DbStructureEditorActions.$$$reportNull$$$0(2);
        }
        DbStructureEditorActions.report(e2.getDataContext(), () -> job2);
    }

    public static void report(@NotNull AnActionEvent e2, @Nullable Promise<?> promise) {
        if (e2 == null) {
            DbStructureEditorActions.$$$reportNull$$$0(3);
        }
        DbStructureEditorActions.report(e2.getDataContext(), () -> {
            if (promise == null) {
                return null;
            }
            CompletableJob job2 = JobKt.Job(null);
            promise.onSuccess(r -> job2.complete()).onError(ex -> job2.completeExceptionally(ex));
            return job2;
        });
    }

    @Nullable
    public static DbModelRef<?, DbStructureObjectModelState<?>> getSelectedObject(@Nullable AnActionEvent e2) {
        DbStructureNodeEditor<?, ?> node2 = DbStructureEditorActions.getSelectedNode(e2);
        return node2 == null ? null : node2.getModelRef().castState((DbStructureObjectModelState)ObjectUtils.tryCast(node2.getState(), DbStructureObjectModelState.class));
    }

    @Nullable
    static DbStructureNodeEditor<?, ?> getSelectedNode(@Nullable AnActionEvent e2) {
        return e2 == null ? null : (DbStructureNodeEditor)ObjectUtils.tryCast((Object)e2.getData(PlatformCoreDataKeys.SELECTED_ITEM), DbStructureNodeEditor.class);
    }

    @NotNull
    public static JBIterable<DbStructureNodeEditor<?, ?>> getSelectedNodes(@Nullable AnActionEvent e2) {
        JBIterable jBIterable = JBIterable.of(e2 == null ? null : (Object[])e2.getData(PlatformCoreDataKeys.SELECTED_ITEMS)).filterMap(o2 -> {
            DbStructureNodeEditor editor2;
            return o2 instanceof DbStructureNodeEditor ? (editor2 = (DbStructureNodeEditor)o2) : null;
        });
        if (jBIterable == null) {
            DbStructureEditorActions.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    public static void registerActionsRecursively(@Nullable AnAction action, @NotNull JComponent component2) {
        if (component2 == null) {
            DbStructureEditorActions.$$$reportNull$$$0(5);
        }
        if (action == null) {
            return;
        }
        action.registerCustomShortcutSet(component2, null);
        if (action instanceof ActionGroup) {
            AnAction[] children2;
            for (AnAction stub : children2 = action instanceof DefaultActionGroup ? ((DefaultActionGroup)action).getChildActionsOrStubs() : ((ActionGroup)action).getChildren(null)) {
                DbStructureEditorActions.registerActionsRecursively(stub, component2);
            }
        }
    }

    @Nullable
    public static DbStructureEditor<?> getStructureEditor(@Nullable AnActionEvent e2) {
        return e2 == null ? null : (DbStructureEditor)e2.getData(DbStructureEditor.KEY);
    }

    @Nullable
    public static DbEditorController getEditorController(@Nullable AnActionEvent e2) {
        DbStructureEditor<?> editor2 = DbStructureEditorActions.getStructureEditor(e2);
        return editor2 == null ? null : editor2.getController();
    }

    @Nullable
    public static DbEditorModelController getModelController(@Nullable AnActionEvent e2) {
        DbEditorController controller = DbStructureEditorActions.getEditorController(e2);
        return controller == null ? null : controller.getModelController();
    }

    @Nullable
    static DbModelRef<?, ? extends DbStructureNodeState> getSelectedNodeModelOrRoot(@Nullable AnActionEvent e2) {
        DbStructureNodeEditor<?, ?> node2 = DbStructureEditorActions.getSelectedNode(e2);
        if (node2 != null) {
            return node2.getModelRef();
        }
        return DbStructureEditorActions.getRootNode(e2);
    }

    @Nullable
    private static DbModelRef<?, ? extends DbStructureNodeState> getRootNode(@Nullable AnActionEvent e2) {
        DbStructureEditor<?> editor2 = DbStructureEditorActions.getStructureEditor(e2);
        if (editor2 == null) {
            return null;
        }
        ElementIdentity identity = editor2.getIdentity();
        return DbStructureNodeTreeModel.getNodeModel(editor2.getController(), identity);
    }

    public static boolean isMoveSupported(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> identity, int deltaIdx, @Nullable ElementIdentity<?> targetId) {
        int idx2;
        int idx;
        BasicMetaObject<?> meta;
        BasicMetaField<?> position;
        if (controller == null) {
            DbStructureEditorActions.$$$reportNull$$$0(6);
        }
        if (identity == null) {
            DbStructureEditorActions.$$$reportNull$$$0(7);
        }
        if ((position = (meta = identity.getMetaObject()).getField(BasicModArrangedElement.POSITION)) == null || position.isAbstract()) {
            return false;
        }
        if (controller.getBuilder().isEnabled(controller, identity, BasicModArrangedElement.POSITION)) {
            return true;
        }
        ElementOwner oOwner = controller.getMatcher().getOriginalOwner();
        ElementIdentity<?> parent2 = oOwner == null ? null : controller.getMatcher().getParent(identity);
        DbStructureObjectModelState<?> parentState = parent2 == null ? null : controller.getStructureNodeModelState(parent2);
        DbModelRef<?, DbStructureFamilyModelState<?>> familyModelRef = parentState == null ? null : parentState.getFamily(identity.getMetaObject());
        List<DbModelRef<?, DbStructureNodeState<?, ?>>> children2 = familyModelRef == null ? null : familyModelRef.getState().getStructureChildren();
        int n = idx = children2 == null ? -1 : ContainerUtil.indexOf(children2, r -> r.getIdentity() == identity);
        if (idx == -1) {
            return false;
        }
        int n3 = idx2 = targetId == null ? -1 : ContainerUtil.indexOf(children2, r -> r.getIdentity() == targetId) + 1;
        if (idx2 != -1 && idx2 < idx) {
            idx = idx2;
        }
        if (deltaIdx < 0) {
            idx = Math.max(idx + deltaIdx, 0);
        }
        for (int i2 = idx; i2 < children2.size(); ++i2) {
            if (oOwner.find(children2.get(i2).getIdentity()) == null) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerActionsRecursively";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMoveSupported";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    public static class ColumnKeyAction
    extends DumbAwareAction {
        private final ModelHelper.ObjectKindVariant myVariant;

        public ColumnKeyAction(@NotNull ModelHelper.ObjectKindVariant variant) {
            if (variant == null) {
                ColumnKeyAction.$$$reportNull$$$0(0);
            }
            this.myVariant = variant;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ColumnKeyAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            DbModelRef<BasicModKey, DbStructureObjectModelState<BasicModKey>> existing;
            DbModelRef<?, DbStructureObjectModelState<?>> object;
            DbEditorModelController controller;
            BasicMetaObject<BasicModKey> key2;
            if (e2 == null) {
                ColumnKeyAction.$$$reportNull$$$0(2);
            }
            if ((key2 = this.getMetaKey(controller = DbStructureEditorActions.getModelController(e2), object = DbStructureEditorActions.getSelectedObject(e2))) == null) {
                e2.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e2.getPresentation().setText(DatabaseBundle.message("action.ModifyObject.add.context.text", this.myVariant.getText(key2)));
            DbCreateObjectAction.update(e2, key2, this.myVariant);
            if (e2.getPresentation().isEnabled() && (existing = this.getExistingKey(controller, object, key2)) != null) {
                e2.getPresentation().setEnabledAndVisible(false);
            }
        }

        @Nullable
        private DbModelRef<BasicModKey, DbStructureObjectModelState<BasicModKey>> getExistingKey(@NotNull DbEditorModelController controller, @NotNull DbModelRef<?, DbStructureObjectModelState<?>> object, @NotNull BasicMetaObject<BasicModKey> keyMeta) {
            if (controller == null) {
                ColumnKeyAction.$$$reportNull$$$0(3);
            }
            if (object == null) {
                ColumnKeyAction.$$$reportNull$$$0(4);
            }
            if (keyMeta == null) {
                ColumnKeyAction.$$$reportNull$$$0(5);
            }
            List<String> colNames = Collections.singletonList(object.getState().getObjectRef().getState().getProperties().getName());
            DbModelRef<?, DbStructureFamilyModelState<BasicModKey>> keys2 = ColumnKeyAction.getKeysFamily(controller, object, keyMeta);
            if (keys2 == null) {
                return null;
            }
            return (DbModelRef)ContainerUtil.find(keys2.getState().getCollection(), k -> this.matches(colNames, (BasicModKey)((DbStructureObjectModelState)k.getState()).getObjectRef().getState().getProperties()));
        }

        private boolean matches(List<String> colNames, BasicModKey p2) {
            boolean primary = this.myVariant == ModelHelper.PRIMARY_KEY;
            return p2.isPrimary() == primary && (primary || p2.getColNames().equals(colNames));
        }

        @Nullable
        private static DbModelRef<?, DbStructureFamilyModelState<BasicModKey>> getKeysFamily(@NotNull DbEditorModelController controller, @NotNull DbModelRef<?, DbStructureObjectModelState<?>> object, @NotNull BasicMetaObject<BasicModKey> keyMeta) {
            ElementIdentity<?> tableId;
            if (controller == null) {
                ColumnKeyAction.$$$reportNull$$$0(6);
            }
            if (object == null) {
                ColumnKeyAction.$$$reportNull$$$0(7);
            }
            if (keyMeta == null) {
                ColumnKeyAction.$$$reportNull$$$0(8);
            }
            DbStructureObjectModelState<?> tableStructure = (tableId = controller.getMatcher().getParent(object.getIdentity())) == null ? null : controller.getStructureNodeModelState(tableId);
            return tableStructure == null ? null : tableStructure.getFamily(keyMeta);
        }

        @Nullable
        private BasicMetaObject<BasicModKey> getMetaKey(@Nullable DbEditorModelController controller, @Nullable DbModelRef<?, DbStructureObjectModelState<?>> object) {
            if (object == null || controller == null) {
                return null;
            }
            ElementIdentity<?> identity = object.getIdentity();
            if (identity.getMetaObject().kind != ObjectKind.COLUMN) {
                return null;
            }
            BasicMetaObject<BasicModKey> key2 = BasicMetaUtils.findChild(identity.getMetaObject().getParent(), ObjectKind.KEY);
            if (key2 == null) {
                return null;
            }
            ModelHelper helper = ModelFacade.forDbms(controller.getDbms(identity)).getModelHelper();
            return helper.generationVariants(key2).contains((Object)this.myVariant) ? key2 : null;
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            DbModelRef<?, DbStructureObjectModelState<?>> object;
            DbStructureEditor editor2;
            if (e2 == null) {
                ColumnKeyAction.$$$reportNull$$$0(9);
            }
            if ((editor2 = (DbStructureEditor)e2.getData(DbStructureEditor.KEY)) == null) {
                return;
            }
            DbEditorModelController controller = editor2.getController().getModelController();
            BasicMetaObject<BasicModKey> key2 = this.getMetaKey(controller, object = DbStructureEditorActions.getSelectedObject(e2));
            if (key2 == null) {
                return;
            }
            DbCreateObjectAction.create(e2, key2, this.myVariant, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variant";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$ColumnKeyAction";
                    break;
                }
                case 2: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controller";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyMeta";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$ColumnKeyAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getExistingKey";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getKeysFamily";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class MoreAction
    extends AnAction {
        private final ActionGroup myDelegate;

        public MoreAction(@NotNull ActionGroup delegate) {
            if (delegate == null) {
                MoreAction.$$$reportNull$$$0(0);
            }
            super((String)null, null, AllIcons.Actions.More);
            this.myDelegate = delegate;
            this.setShortcutSet(ActionUtil.getShortcutSet((String)"ShowIntentionActions"));
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                MoreAction.$$$reportNull$$$0(1);
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(e2.getPresentation().getText(), this.myDelegate, e2.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true, "EditorPopup");
            Component context = (Component)e2.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
            if (context != null) {
                popup2.showUnderneathOf(context);
            } else {
                popup2.showInBestPositionFor(e2.getDataContext());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$MoreAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CloseTabAction
    extends DumbAwareAction {
        CloseTabAction() {
            super(UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]), null, AllIcons.Actions.Close);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            DbStructureEditor editor2;
            TabInfo info2;
            if (e2 == null) {
                CloseTabAction.$$$reportNull$$$0(0);
            }
            TabInfo tabInfo = info2 = (editor2 = (DbStructureEditor)e2.getData(DbStructureEditor.KEY)) == null ? null : editor2.getCurrentTab(e2);
            if (info2 != null) {
                editor2.closeEditor(info2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$CloseTabAction", "actionPerformed"));
        }
    }

    static class PinTabAction
    extends ToggleAction {
        PinTabAction() {
            super(UIBundle.message((String)"tabbed.pane.pin.tab.action.name", (Object[])new Object[0]), null, AllIcons.Actions.PinTab);
            this.getTemplatePresentation().setHoveredIcon(AllIcons.Actions.PinTab);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                PinTabAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isDumbAware() {
            return true;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                PinTabAction.$$$reportNull$$$0(1);
            }
            super.update(e2);
            if (e2.getPlace().equals("debuggerTabToolbar")) {
                DbStructureEditor editor2 = (DbStructureEditor)e2.getData(DbStructureEditor.KEY);
                TabInfo info2 = editor2 == null ? null : editor2.getCurrentTab(e2);
                e2.getPresentation().setIcon(info2 == null || info2.isPinned() ? AllIcons.Actions.PinTab : EmptyIcon.ICON_16);
            }
        }

        public boolean isSelected(@NotNull AnActionEvent e2) {
            DbStructureEditor editor2;
            if (e2 == null) {
                PinTabAction.$$$reportNull$$$0(2);
            }
            TabInfo info2 = (editor2 = (DbStructureEditor)e2.getData(DbStructureEditor.KEY)) == null ? null : editor2.getCurrentTab(e2);
            return info2 != null && info2.isPinned();
        }

        public void setSelected(@NotNull AnActionEvent e2, boolean state) {
            DbStructureEditor editor2;
            TabInfo info2;
            if (e2 == null) {
                PinTabAction.$$$reportNull$$$0(3);
            }
            TabInfo tabInfo = info2 = (editor2 = (DbStructureEditor)e2.getData(DbStructureEditor.KEY)) == null ? null : editor2.getCurrentTab(e2);
            if (info2 != null) {
                ClientProperty.put((JComponent)info2.getComponent(), (Key)JBTabsImpl.PINNED, (Object)state);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$PinTabAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$PinTabAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class MoveAction
    extends AnAction {
        private final boolean myUp;

        public MoveAction(boolean up) {
            super(up ? AllIcons.Actions.MoveUp : AllIcons.Actions.MoveDown);
            this.myUp = up;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MoveAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            DbStructureEditor editor2;
            if (e2 == null) {
                MoveAction.$$$reportNull$$$0(1);
            }
            if ((editor2 = (DbStructureEditor)e2.getData(DbStructureEditor.KEY)) == null) {
                return;
            }
            MultiMap byParent = ContainerUtil.groupBy((Iterable)MoveAction.getObjectNodes(editor2, e2).filter(n -> this.isEnabled(editor2, (DbStructureNodeEditor<?, ?>)n)), editor2.getStructure()::getParent);
            for (Map.Entry entry : byParent.entrySet()) {
                this.moveNodes(editor2, (DbStructureNodeEditor)entry.getKey(), (Collection)entry.getValue());
            }
        }

        private void moveNodes(@NotNull DbStructureEditor<?> editor2, @NotNull DbStructureNodeEditor<?, ?> parent2, @NotNull Collection<DbStructureNodeEditor<?, ?>> nodes) {
            if (editor2 == null) {
                MoveAction.$$$reportNull$$$0(2);
            }
            if (parent2 == null) {
                MoveAction.$$$reportNull$$$0(3);
            }
            if (nodes == null) {
                MoveAction.$$$reportNull$$$0(4);
            }
            List sorted = ContainerUtil.sorted(nodes, Comparator.comparing(n -> (this.myUp ? 1 : -1) * parent2.getChildren().indexOf(n)));
            for (DbStructureNodeEditor node2 : sorted) {
                this.moveNode(editor2, node2);
            }
            editor2.getTree().setSelectionPaths((TreePath[])ContainerUtil.mapNotNull(nodes, editor2.getStructure()::pathOf).toArray(TreePath[]::new));
        }

        @NotNull
        private static JBIterable<DbStructureNodeEditor<?, ?>> getObjectNodes(@NotNull DbStructureEditor<?> editor2, @NotNull AnActionEvent e2) {
            if (editor2 == null) {
                MoveAction.$$$reportNull$$$0(5);
            }
            if (e2 == null) {
                MoveAction.$$$reportNull$$$0(6);
            }
            DbStructureNodeTreeModel structure = editor2.getStructure();
            JBIterable jBIterable = DbStructureEditorActions.getSelectedNodes(e2).filter(node2 -> structure.getParentNode(node2) != structure.getRoot() && node2.getState() instanceof DbStructureObjectModelState);
            if (jBIterable == null) {
                MoveAction.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }

        @NotNull
        private static JBIterable<DbModelRef<?, ? extends DbStructureNodeState>> getObjectModelsNodes(@NotNull DbStructureModelState structureState, @NotNull AnActionEvent e2) {
            if (structureState == null) {
                MoveAction.$$$reportNull$$$0(8);
            }
            if (e2 == null) {
                MoveAction.$$$reportNull$$$0(9);
            }
            JBIterable jBIterable = DbStructureEditorActions.getSelectedNodes(e2).map(n -> n.getModelRef()).filter(node2 -> !structureState.isInRoots((DbModelRef<?, ? extends DbStructureNodeState>)node2) && node2.getState() instanceof DbStructureObjectModelState);
            if (jBIterable == null) {
                MoveAction.$$$reportNull$$$0(10);
            }
            return jBIterable;
        }

        private void moveNode(@NotNull DbStructureEditor<?> editor2, @NotNull DbStructureNodeEditor<?, ?> node2) {
            DbStructureNodeEditor<?, ?> parent2;
            if (editor2 == null) {
                MoveAction.$$$reportNull$$$0(11);
            }
            if (node2 == null) {
                MoveAction.$$$reportNull$$$0(12);
            }
            if ((parent2 = editor2.getStructure().getParent(node2)) == null || !(node2.getState() instanceof DbStructureObjectModelState)) {
                return;
            }
            ArrayList children2 = new ArrayList(parent2.getChildren());
            int idx1 = children2.indexOf(node2);
            int idx2 = this.myUp ? idx1 - 1 : idx1 + 1;
            DbStructureNodeEditor tmp = (DbStructureNodeEditor)children2.get(idx1);
            children2.set(idx1, (DbStructureNodeEditor)children2.get(idx2));
            children2.set(idx2, tmp);
            parent2.setChildren(children2);
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                MoveAction.$$$reportNull$$$0(13);
            }
            e2.getPresentation().setEnabled(this.isEnabled(e2));
        }

        public boolean isEnabled(@NotNull AnActionEvent e2) {
            DbStructureEditor editor2;
            if (e2 == null) {
                MoveAction.$$$reportNull$$$0(14);
            }
            if ((editor2 = (DbStructureEditor)e2.getData(DbStructureEditor.KEY)) == null) {
                return false;
            }
            DbStructureModelState structureState = (DbStructureModelState)editor2.getState();
            DbEditorModelController controller = editor2.getController().getModelController();
            JBIterable nodes = MoveAction.getObjectModelsNodes(structureState, e2).collect();
            return nodes.isNotEmpty() && nodes.find(node2 -> !this.isEnabled(controller, structureState, (DbModelRef<?, ? extends DbStructureNodeState>)node2)) == null;
        }

        private boolean isEnabled(@NotNull DbStructureEditor<?> editor2, DbStructureNodeEditor<?, ?> node2) {
            if (editor2 == null) {
                MoveAction.$$$reportNull$$$0(15);
            }
            return this.isEnabled(editor2.getController().getModelController(), (DbStructureModelState)editor2.getState(), node2.getModelRef());
        }

        private boolean isEnabled(@NotNull DbEditorModelController controller, @NotNull DbStructureModelState structureState, DbModelRef<?, ? extends DbStructureNodeState> modelRef) {
            int index2;
            DbStructureObjectModelState state;
            if (controller == null) {
                MoveAction.$$$reportNull$$$0(16);
            }
            if (structureState == null) {
                MoveAction.$$$reportNull$$$0(17);
            }
            if ((state = (DbStructureObjectModelState)ObjectUtils.tryCast((Object)modelRef.getState(), DbStructureObjectModelState.class)) == null) {
                return false;
            }
            boolean enabled = DbStructureEditorActions.isMoveSupported(controller, modelRef.getIdentity(), this.myUp ? -1 : 1, null);
            if (!enabled) {
                return false;
            }
            if (structureState.isInRoots(modelRef)) {
                return false;
            }
            DbModelRef<?, DbStructureNodeState<?, ?>> parentModelRef = DbStructureModelState.getParentModel(controller, modelRef);
            List children2 = parentModelRef == null ? Collections.emptyList() : parentModelRef.getState().getStructureChildren();
            int n = index2 = parentModelRef == null ? -1 : children2.indexOf(modelRef);
            if (index2 == -1) {
                return false;
            }
            return index2 != (this.myUp ? 0 : children2.size() - 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 8, 9, 11, 12, 13, 14, 15, 16, 17 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$MoveAction";
                    break;
                }
                case 1: 
                case 6: 
                case 9: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 5: 
                case 11: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 8: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "structureState";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controller";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$MoveAction";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjectNodes";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjectModelsNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "moveNodes";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getObjectNodes";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getObjectModelsNodes";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "moveNode";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 8, 9, 11, 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class CreateObjectGroup
    extends ActionGroup
    implements DumbAware {
        public CreateObjectGroup() {
            super(DatabaseBundle.message("action.new.text", new Object[0]), true);
            this.setShortcutSet(ActionUtil.getShortcutSet((String)"NewElement"));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                CreateObjectGroup.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                CreateObjectGroup.$$$reportNull$$$0(1);
            }
            ListPopupStep step2 = JBPopupFactory.getInstance().createActionsStep((ActionGroup)this, e2.getDataContext(), ActionPlaces.getPopupPlace((String)e2.getPlace()), false, false, e2.getPresentation().getText(), null, true, 0, true);
            ListPopup popup2 = JBPopupFactory.getInstance().createListPopup(step2);
            popup2.setHandleAutoSelectionBeforeShow(true);
            popup2.showInBestPositionFor(e2.getDataContext());
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                CreateObjectGroup.$$$reportNull$$$0(2);
            }
            super.update(e2);
            e2.getPresentation().setIcon(ActionPlaces.isPopupPlace((String)e2.getPlace()) ? null : AllIcons.General.Add);
            if (e2.getPlace().equals("keyboard shortcut")) {
                e2.getPresentation().setPerformGroup(true);
            }
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e2) {
            DbEditorModelController controller = DbStructureEditorActions.getModelController(e2);
            if (controller == null || e2 == null) {
                if (AnAction.EMPTY_ARRAY == null) {
                    CreateObjectGroup.$$$reportNull$$$0(3);
                }
                return AnAction.EMPTY_ARRAY;
            }
            DbModelRef<?, ? extends DbStructureNodeState> nodeModel = DbStructureEditorActions.getSelectedNodeModelOrRoot(e2);
            String place = e2.getPlace();
            boolean isButton = (place.contains("ToolbarDecorator") || place.contains("keyboard shortcut")) && !CreateObjectGroup.isRootChild(controller, e2, nodeModel);
            Object[] children2 = (AnAction[])CreateObjectGroup.getTargets(controller, nodeModel, isButton).filterMap(p2 -> p2 == null ? Separator.getInstance() : CreateObjectGroup.createAction(((CreateObjectActionHelper.ObjectCursor)p2.first).getDbms(), (CreateObjectActionHelper.CreateData)p2.second)).toArray((Object[])AnAction.EMPTY_ARRAY);
            boolean isFastAction = isButton && ArraysKt.count((Object[])children2, c2 -> !(c2 instanceof Separator)) == 1;
            e2.getPresentation().setPerformGroup(isFastAction);
            if (children2 == null) {
                CreateObjectGroup.$$$reportNull$$$0(4);
            }
            return children2;
        }

        private static boolean isRootChild(@NotNull DbEditorModelController controller, @NotNull AnActionEvent e2, @Nullable DbModelRef<?, ?> nodeModel) {
            if (controller == null) {
                CreateObjectGroup.$$$reportNull$$$0(5);
            }
            if (e2 == null) {
                CreateObjectGroup.$$$reportNull$$$0(6);
            }
            DbModelRef<?, DbStructureNodeState> sm = nodeModel != null ? nodeModel.castState((DbStructureNodeState)ObjectUtils.tryCast(nodeModel.getState(), DbStructureNodeState.class)) : null;
            return !CreateObjectGroup.isUnderRoot(e2, DbStructureModelState.getParentModel(controller, sm));
        }

        private static boolean isUnderRoot(@NotNull AnActionEvent e2, @Nullable DbModelRef<?, ? extends DbStructureNodeState<?, ?>> parent2) {
            if (e2 == null) {
                CreateObjectGroup.$$$reportNull$$$0(7);
            }
            if (parent2 == null) {
                return true;
            }
            DbStructureEditor<?> editor2 = DbStructureEditorActions.getStructureEditor(e2);
            if (editor2 == null) {
                return true;
            }
            return ((DbStructureModelState)editor2.getState()).isUnderRoots(editor2.getController().getModelController(), parent2);
        }

        private static @NotNull JBIterable<@Nullable Pair<CreateObjectActionHelper.ObjectCursor<?>, CreateObjectActionHelper.CreateData>> getTargets(@NotNull DbEditorModelController controller, @Nullable DbModelRef<?, ?> nodeModel, boolean isButton) {
            if (controller == null) {
                CreateObjectGroup.$$$reportNull$$$0(8);
            }
            if (nodeModel == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    CreateObjectGroup.$$$reportNull$$$0(9);
                }
                return jBIterable;
            }
            CreateObjectActionHelper.ObjectCursor<?> cursor2 = DbObjectEditorBuilder.cursor(controller, nodeModel.getIdentity());
            DbStructureFamilyModelState fState = (DbStructureFamilyModelState)ObjectUtils.tryCast(nodeModel.getState(), DbStructureFamilyModelState.class);
            Dbms dbms = controller.getDbms(nodeModel.getIdentity());
            BasicMetaObject context = fState != null ? fState.getMetaObject() : null;
            JBIterable<@Nullable Pair<CreateObjectActionHelper.ObjectCursor<?>, CreateObjectActionHelper.CreateData>> res2 = CreateObjectActionHelper.getCreateTargets(dbms, cursor2, context);
            if (isButton) {
                if (context != null) {
                    JBIterable jBIterable = res2.filter(p2 -> p2 == null || ((CreateObjectActionHelper.CreateData)p2.second).meta == context);
                    if (jBIterable == null) {
                        CreateObjectGroup.$$$reportNull$$$0(10);
                    }
                    return jBIterable;
                }
                BasicMetaObject<?> meta = nodeModel.getIdentity().getMetaObject();
                JBIterable jBIterable = res2.filter(p2 -> p2 == null || BasicMetaUtils.isAncestor(meta, ((CreateObjectActionHelper.CreateData)p2.second).meta, false));
                if (jBIterable == null) {
                    CreateObjectGroup.$$$reportNull$$$0(11);
                }
                return jBIterable;
            }
            JBIterable<Pair<CreateObjectActionHelper.ObjectCursor<?>, CreateObjectActionHelper.CreateData>> jBIterable = res2;
            if (jBIterable == null) {
                CreateObjectGroup.$$$reportNull$$$0(12);
            }
            return jBIterable;
        }

        @NotNull
        private static AnAction createAction(@NotNull Dbms dbms, CreateObjectActionHelper.CreateData data) {
            if (dbms == null) {
                CreateObjectGroup.$$$reportNull$$$0(13);
            }
            return new DbCreateObjectAction(dbms, data.meta, data.variant);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 5, 6, 7, 8, 13 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$CreateObjectGroup";
                    break;
                }
                case 1: 
                case 2: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controller";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$CreateObjectGroup";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargets";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isRootChild";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isUnderRoot";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getTargets";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "createAction";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 5, 6, 7, 8, 13 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class RevertAction
    extends DumbAwareAction {
        public RevertAction() {
            super(DiffBundle.message((String)"action.presentation.diff.revert.text", (Object[])new Object[0]), null, AllIcons.Actions.Rollback);
            this.setShortcutSet(ActionUtil.getShortcutSet((String)"ChangesView.Revert"));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                RevertAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            DbEditorModelController controller;
            if (e2 == null) {
                RevertAction.$$$reportNull$$$0(1);
            }
            if ((controller = DbStructureEditorActions.getModelController(e2)) == null) {
                return;
            }
            for (DbModelRef object : RevertAction.getObjects(e2)) {
                RevertAction.revert(controller, object);
            }
        }

        public static void revert(@NotNull DbEditorModelController controller, @NotNull DbModelRef<?, ?> model2) {
            ElementOwner original;
            if (controller == null) {
                RevertAction.$$$reportNull$$$0(2);
            }
            if (model2 == null) {
                RevertAction.$$$reportNull$$$0(3);
            }
            if ((original = controller.getMatcher().getOriginalOwner()) == null) {
                return;
            }
            RevertAction.revert(controller, model2, original);
        }

        public static void revert(@NotNull DbEditorModelController controller, @NotNull DbModelRef<?, ?> model2, @NotNull ElementOwner owner) {
            BasicMetaId key2;
            if (controller == null) {
                RevertAction.$$$reportNull$$$0(4);
            }
            if (model2 == null) {
                RevertAction.$$$reportNull$$$0(5);
            }
            if (owner == null) {
                RevertAction.$$$reportNull$$$0(6);
            }
            if ((key2 = model2.getModelInternalKey()) == DbStructureObjectModelApplier.ID) {
                DbStructureObjectModelState ss2 = (DbStructureObjectModelState)ObjectUtils.tryCast(model2.getState(), DbStructureObjectModelState.class);
                if (ss2 != null) {
                    RevertAction.revert(controller, ss2.getObjectRef(), owner);
                }
                return;
            }
            ArrayList models2 = new ArrayList();
            if (key2 == DbObjectModelApplier.ID) {
                ElementIdentity<?> id = model2.getIdentity();
                for (DbEditorModel<?, ?> m : controller.getAllModels()) {
                    if (m.getIdentity() != id) continue;
                    models2.add(m);
                }
            } else {
                models2.add(model2.resolve(controller));
            }
            DbModelResetHelper.reset(controller, owner, models2);
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                RevertAction.$$$reportNull$$$0(7);
            }
            DbEditorModelController controller = DbStructureEditorActions.getModelController(e2);
            JBIterable objects2 = RevertAction.getObjects(e2).collect();
            DbModelRef first2 = (DbModelRef)objects2.first();
            DbModelModifiedCache cache2 = controller == null || first2 == null ? null : controller.getModifiedCache();
            boolean enabled = cache2 != null && objects2.find(m -> cache2.isModified(m.resolve(controller))) != null;
            e2.getPresentation().setVisible(true);
            e2.getPresentation().setEnabled(enabled);
        }

        @NotNull
        private static JBIterable<DbModelRef<?, ?>> getObjects(@NotNull AnActionEvent e2) {
            DbVisualEditor<?, ?> editor2;
            if (e2 == null) {
                RevertAction.$$$reportNull$$$0(8);
            }
            if ((editor2 = DbVisualEditorBase.getEditor((Component)e2.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT))) != null) {
                JBIterable jBIterable = JBIterable.of(editor2.getModelRef());
                if (jBIterable == null) {
                    RevertAction.$$$reportNull$$$0(9);
                }
                return jBIterable;
            }
            JBIterable jBIterable = DeleteAction.getObjectNodeModels(e2).filter(m -> m.getState() instanceof DbStructureObjectModelState);
            if (jBIterable == null) {
                RevertAction.$$$reportNull$$$0(10);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$RevertAction";
                    break;
                }
                case 1: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controller";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$RevertAction";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjects";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "revert";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getObjects";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class DeleteAction
    extends DumbAwareAction {
        public DeleteAction() {
            super(IdeBundle.message((String)"button.delete", (Object[])new Object[0]));
            this.setShortcutSet(ActionUtil.getShortcutSet((String)"$Delete"));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DeleteAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            DbStructureEditor editor2;
            if (e2 == null) {
                DeleteAction.$$$reportNull$$$0(1);
            }
            if ((editor2 = (DbStructureEditor)e2.getData(DbStructureEditor.KEY)) == null) {
                return;
            }
            Set nodes = DeleteAction.getObjectNodes(e2).toSet();
            DbStructureNodeEditor<?, ?> selection2 = DeleteAction.chooseSelection(editor2.getStructure(), nodes, (DbStructureNodeEditor)ContainerUtil.getFirstItem((Collection)nodes));
            for (DbStructureNodeEditor node2 : nodes) {
                editor2.removeNode(node2, false);
            }
            editor2.getTree().setSelectionPath(editor2.getStructure().pathOf(selection2));
        }

        public void update(@NotNull AnActionEvent e2) {
            DbStructureEditor editor2;
            if (e2 == null) {
                DeleteAction.$$$reportNull$$$0(2);
            }
            DbStructureModelState structureState = (editor2 = (DbStructureEditor)e2.getData(DbStructureEditor.KEY)) == null ? null : (DbStructureModelState)editor2.getState();
            JBIterable nodes = DeleteAction.getObjectNodes(e2).collect().filter(n -> {
                DbEditorModelController controller = n.getController().getModelController();
                return controller.getBuilder().canDrop(controller, n.getIdentity());
            });
            e2.getPresentation().setIcon(ActionPlaces.isPopupPlace((String)e2.getPlace()) ? null : AllIcons.General.Remove);
            e2.getPresentation().setVisible(!nodes.isEmpty());
            e2.getPresentation().setEnabled(structureState != null && nodes.find(n -> !structureState.getRoots().contains(n.getModelRef())) != null);
        }

        @Nullable
        private static DbStructureNodeEditor<?, ?> chooseSelection(@NotNull DbStructureNodeTreeModel model2, @NotNull Set<DbStructureNodeEditor<?, ?>> toRemove, @NotNull DbStructureNodeEditor<?, ?> guess) {
            DbStructureNodeEditor<?, ?> parent2;
            if (model2 == null) {
                DeleteAction.$$$reportNull$$$0(3);
            }
            if (toRemove == null) {
                DeleteAction.$$$reportNull$$$0(4);
            }
            if (guess == null) {
                DeleteAction.$$$reportNull$$$0(5);
            }
            if ((parent2 = model2.getParent(guess)) == null) {
                return null;
            }
            List<?> children2 = model2.getChildren(parent2);
            int index2 = children2.indexOf(guess);
            int e2 = children2.size();
            for (int i2 = 0; i2 < e2; ++i2) {
                Object candidate2;
                int cIdx = index2 + i2;
                if (index2 + i2 >= e2) {
                    cIdx = index2 - (cIdx - e2 + 1);
                }
                if (toRemove.contains(candidate2 = children2.get(cIdx)) || !(candidate2 instanceof DbStructureNodeEditor)) continue;
                DbStructureNodeEditor n = (DbStructureNodeEditor)candidate2;
                return n;
            }
            return DeleteAction.chooseSelection(model2, toRemove, parent2);
        }

        @NotNull
        private static JBIterable<DbStructureNodeEditor<?, ?>> getObjectNodes(AnActionEvent e2) {
            JBIterable jBIterable = DbStructureEditorActions.getSelectedNodes(e2).filter(node2 -> node2.getState() instanceof DbStructureObjectModelState);
            if (jBIterable == null) {
                DeleteAction.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        @NotNull
        private static JBIterable<DbModelRef<?, ?>> getObjectNodeModels(AnActionEvent e2) {
            JBIterable jBIterable = DeleteAction.getObjectNodes(e2).map(DbEditorBase::getModelRef);
            if (jBIterable == null) {
                DeleteAction.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$DeleteAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toRemove";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "guess";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$DeleteAction";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjectNodes";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjectNodeModels";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "chooseSelection";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class EditAction
    extends DumbAwareAction {
        public EditAction() {
            super(DatabaseBundle.message("action.edit.text", new Object[0]), null, AllIcons.Actions.Edit);
            this.setShortcutSet(ActionUtil.getShortcutSet((String)"EditSource"));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                EditAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public JBIterable<DbStructureNodeEditor<?, ?>> getSelectedNodesSameType(@NotNull AnActionEvent e2) {
            JBIterable nodes;
            DbStructureNodeEditor first2;
            if (e2 == null) {
                EditAction.$$$reportNull$$$0(1);
            }
            if ((first2 = (DbStructureNodeEditor)(nodes = DbStructureEditorActions.getSelectedNodes(e2).collect()).first()) == null) {
                return JBIterable.empty();
            }
            return nodes.filter(n -> n.getIdentity().getMetaObject() == first2.getIdentity().getMetaObject() && n.getModelInternalKey() == first2.getModelInternalKey());
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            DbStructureEditor editor2;
            if (e2 == null) {
                EditAction.$$$reportNull$$$0(2);
            }
            if ((editor2 = (DbStructureEditor)e2.getData(DbStructureEditor.KEY)) == null) {
                return;
            }
            JBIterable<DbStructureNodeEditor<?, ?>> nodes = this.getSelectedNodesSameType(e2);
            if (nodes.isEmpty()) {
                return;
            }
            editor2.edit(nodes, true);
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                EditAction.$$$reportNull$$$0(3);
            }
            DbStructureEditor editor2 = (DbStructureEditor)e2.getData(DbStructureEditor.KEY);
            e2.getPresentation().setEnabled(this.getSelectedNodesSameType(e2).isNotEmpty());
            e2.getPresentation().setVisible(editor2 != null && editor2.isDblClickEditing() || !e2.getPlace().equals("ToolbarDecorator"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$EditAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$EditAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedNodesSameType";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    static class ToggleDblClickAction
    extends ToggleAction {
        ToggleDblClickAction() {
            super(DatabaseBundle.message("action.edit.on.selection.text", new Object[0]), null, AllIcons.General.AutoscrollToSource);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ToggleDblClickAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e2) {
            DbStructureEditor editor2;
            if (e2 == null) {
                ToggleDblClickAction.$$$reportNull$$$0(1);
            }
            return (editor2 = (DbStructureEditor)e2.getData(DbStructureEditor.KEY)) != null && !editor2.isDblClickEditing();
        }

        public void setSelected(@NotNull AnActionEvent e2, boolean state) {
            DbStructureEditor editor2;
            if (e2 == null) {
                ToggleDblClickAction.$$$reportNull$$$0(2);
            }
            if ((editor2 = (DbStructureEditor)e2.getData(DbStructureEditor.KEY)) != null) {
                editor2.setDblClickEditing(!state);
            }
        }

        public boolean isDumbAware() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$ToggleDblClickAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureEditorActions$ToggleDblClickAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

