/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.remote.jdba.util.Function;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbCompoundModelState;
import com.intellij.database.schemaEditor.ui.DbCompoundEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbStructureEditor;
import com.intellij.database.schemaEditor.ui.DbStructureEditorActions;
import com.intellij.database.schemaEditor.ui.DbVisualEditor;
import com.intellij.database.schemaEditor.ui.DbVisualEditorBase;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbFormCompoundEditor<E extends BasicElement, S extends DbCompoundModelState>
extends DbCompoundEditor<E, S> {
    public static final DefaultActionGroup FIELD_POPUP_GROUP = new DefaultActionGroup(new AnAction[]{new DbStructureEditorActions.RevertAction()});
    public static final int SMALL_WIDTH = 2;
    public static final int GRID_WIDTH = 6;
    private final JComponent myComponent;

    public DbFormCompoundEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, S> modelRef, @NotNull Condition<DbModelRef<?, ?>> filter2) {
        if (controller == null) {
            DbFormCompoundEditor.$$$reportNull$$$0(0);
        }
        if (modelRef == null) {
            DbFormCompoundEditor.$$$reportNull$$$0(1);
        }
        if (filter2 == null) {
            DbFormCompoundEditor.$$$reportNull$$$0(2);
        }
        super(controller, modelRef, JBIterable.from(((DbCompoundModelState)modelRef.getState()).getSubStates()).filter(filter2).toList());
        this.myComponent = this.createComponent();
    }

    @NotNull
    protected JComponent createComponent() {
        FieldSize size = this.getFieldSize();
        JComponent jComponent = this.createForm(DbFormCompoundEditor.getWidth(size));
        if (jComponent == null) {
            DbFormCompoundEditor.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @NotNull
    protected JComponent createForm(int width) {
        return DbFormCompoundEditor.createFormComponent(this.getVisualEditors(), width, this.getController().getBuilder()::decorateEditor);
    }

    @NotNull
    protected List<DbVisualEditor<?, ?>> getVisualEditors() {
        List list = ContainerUtil.mapNotNull(this.getEditors(), e2 -> e2 instanceof DbVisualEditorBase ? (DbVisualEditorBase)e2 : null);
        if (list == null) {
            DbFormCompoundEditor.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    protected void setEnabled(boolean state) {
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusComponent() {
        DbVisualEditor editor2 = (DbVisualEditor)ContainerUtil.findInstance(this.getEditors(), DbVisualEditor.class);
        JComponent jComponent = editor2 == null ? super.getPreferredFocusComponent() : editor2.getPreferredFocusComponent();
        if (jComponent == null) {
            DbFormCompoundEditor.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    @NotNull
    public static JComponent createFormComponent(@NotNull List<DbVisualEditor<?, ?>> editors2, int width, @Nullable Function<? super DbVisualEditor<?, ?>, ? extends JComponent> decorator) {
        if (editors2 == null) {
            DbFormCompoundEditor.$$$reportNull$$$0(6);
        }
        List<Pair<Integer, Integer>> cells = DbFormCompoundEditor.getCells(editors2, width);
        Pair last2 = (Pair)ContainerUtil.getLastItem(cells);
        boolean toLimit = !DbFormCompoundEditor.isVertical(editors2);
        GridLayoutManager layout = new GridLayoutManager(((Integer)last2.first).intValue(), width);
        JPanel grid = new JPanel((LayoutManager)layout);
        int i2 = 0;
        while (i2 < editors2.size()) {
            int span = DbFormCompoundEditor.getMergeSpan(cells, i2);
            if (span == i2 + 1) {
                DbFormCompoundEditor.addEditor(grid, (Integer)cells.get((int)i2).first, (Integer)cells.get((int)i2).second, width, editors2.get(i2), decorator);
                ++i2;
                continue;
            }
            DbFormCompoundEditor.addMergedEditor(grid, (Integer)cells.get((int)i2).first, (Integer)cells.get((int)i2).second, width, editors2.subList(i2, span), decorator);
            i2 = span;
        }
        if (!toLimit) {
            JPanel jPanel = grid;
            if (jPanel == null) {
                DbFormCompoundEditor.$$$reportNull$$$0(7);
            }
            return jPanel;
        }
        NonStretchablePanel res2 = new NonStretchablePanel(new GridLayoutManager(1, width));
        res2.add((Component)grid, DatabaseUIUtils.createConstraints(0, 0, width, 1, 1, -2, true));
        NonStretchablePanel nonStretchablePanel = res2;
        if (nonStretchablePanel == null) {
            DbFormCompoundEditor.$$$reportNull$$$0(8);
        }
        return nonStretchablePanel;
    }

    private static int getMergeSpan(List<Pair<Integer, Integer>> cells, int s2) {
        Pair<Integer, Integer> c2 = cells.get(s2);
        for (int i2 = s2; i2 < cells.size(); ++i2) {
            if (c2.equals(cells.get(i2))) continue;
            return i2;
        }
        return cells.size();
    }

    private static void addEditor(JPanel grid, int row, int col, int width, DbVisualEditor<?, ?> editor2, @Nullable Function<? super DbVisualEditor<?, ?>, ? extends JComponent> decorator) {
        FieldSize size = editor2.getFieldSize();
        boolean vertical = editor2.isVertical();
        boolean unaligned = editor2.getController().getBuilder().isUnaligned(editor2);
        JComponent gridComponent = decorator == null ? editor2.getComponent() : (Component)decorator.apply(editor2);
        DbFormCompoundEditor.addComponent(grid, row, col, width, size, vertical, unaligned, gridComponent, DbFormCompoundEditor.createFieldLabel(editor2));
    }

    @Nullable
    private static JBLabel createFieldLabel(DbVisualEditor<?, ?> editor2) {
        String title = editor2.getTitle();
        JBLabel label2 = null;
        if (title != null) {
            label2 = new JBLabel(title);
            label2.setLabelFor((Component)editor2.getComponent());
            DbFormCompoundEditor.installFieldPopupHandler((JComponent)label2);
            editor2.updateState();
        }
        return label2;
    }

    private static void addComponent(JPanel grid, int row, int col, int width, FieldSize size, boolean vertical, boolean unaligned, Component component2, JBLabel label2) {
        if (label2 != null) {
            GridConstraints lc = DatabaseUIUtils.createLabelConstraints(row, col, label2.getPreferredSize().getWidth());
            if (vertical) {
                lc.setColSpan(width);
            }
            grid.add((Component)label2, lc);
        }
        if (unaligned && label2 != null) {
            Box box = new Box(0);
            box.add((Component)label2);
            box.add(Box.createHorizontalStrut(10));
            box.add(component2);
            component2 = box;
            label2 = null;
        }
        int vOffset = vertical && label2 != null ? 1 : 0;
        int hOffset = vertical || label2 == null ? 0 : 1;
        GridConstraints constraints = DbFormCompoundEditor.createConstraint(row + vOffset, col + hOffset, DbFormCompoundEditor.getWidth(size) - hOffset, vertical);
        grid.add(component2, constraints);
    }

    private static void addMergedEditor(JPanel grid, int row, int col, int width, List<DbVisualEditor<?, ?>> editors2, @Nullable Function<? super DbVisualEditor<?, ?>, ? extends JComponent> decorator) {
        DbEditorController controller = editors2.get(0).getController();
        Project project = controller.getProject();
        DbStructureEditor.ProperTabs tabs = new DbStructureEditor.ProperTabs(project, controller);
        tabs.setPopupGroup((ActionGroup)FIELD_POPUP_GROUP, "EditorTabPopup", false);
        for (DbVisualEditor<?, ?> editor2 : editors2) {
            JComponent gridComponent = decorator == null ? editor2.getComponent() : (JComponent)decorator.apply(editor2);
            TabInfo info2 = new TabInfo(gridComponent);
            DbFormCompoundEditor.setEditor(info2, editor2);
            info2.setText(DbFormCompoundEditor.getTitle(editor2));
            tabs.addTab(info2);
            editor2.getComponent().putClientProperty("labeledBy", tabs.getTabLabel(info2));
        }
        DbFormCompoundEditor.addComponent(grid, row, col, width, FieldSize.LARGE, true, false, (Component)((Object)tabs), null);
    }

    public static DbVisualEditor<?, ?> getEditor(@Nullable TabInfo info2) {
        return info2 == null ? null : (DbVisualEditor)ObjectUtils.tryCast((Object)info2.getObject(), DbVisualEditor.class);
    }

    private static void setEditor(@Nullable TabInfo info2, @NotNull DbVisualEditor<?, ?> editor2) {
        if (editor2 == null) {
            DbFormCompoundEditor.$$$reportNull$$$0(9);
        }
        if (info2 != null) {
            info2.setObject(editor2);
        }
    }

    @NlsContexts.Label
    @NotNull
    private static String getTitle(@NotNull DbVisualEditor<?, ?> editor2) {
        String title;
        if (editor2 == null) {
            DbFormCompoundEditor.$$$reportNull$$$0(10);
        }
        if ((title = editor2.getTitle()) != null) {
            String string = title;
            if (string == null) {
                DbFormCompoundEditor.$$$reportNull$$$0(11);
            }
            return string;
        }
        title = editor2.getModelTitle();
        if (title != null) {
            String string = title;
            if (string == null) {
                DbFormCompoundEditor.$$$reportNull$$$0(12);
            }
            return string;
        }
        DbObjectEditorFactory factory = editor2.getController().getBuilder().getFactory(editor2.getDbms());
        String string = factory.getTitle(editor2.getIdentity(), editor2.getModelInternalKey());
        if (string == null) {
            DbFormCompoundEditor.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    protected static GridConstraints createConstraint(int row, int col, int colSpan, boolean vertical) {
        GridConstraints constraints = DatabaseUIUtils.createConstraints(row, col, colSpan, 0, vertical ? 3 : 1, -2, true);
        if (vertical) {
            constraints.setVSizePolicy(DatabaseUIUtils.getPolicy(true));
        }
        GridConstraints gridConstraints = constraints;
        if (gridConstraints == null) {
            DbFormCompoundEditor.$$$reportNull$$$0(14);
        }
        return gridConstraints;
    }

    public static void installFieldPopupHandler(JComponent comp) {
        PopupHandler.installPopupMenu((JComponent)comp, (ActionGroup)FIELD_POPUP_GROUP, (String)"popup");
    }

    @NotNull
    public static List<Pair<Integer, Integer>> getCells(@NotNull List<DbVisualEditor<?, ?>> editors2, int width) {
        if (editors2 == null) {
            DbFormCompoundEditor.$$$reportNull$$$0(15);
        }
        ArrayList<Pair<Integer, Integer>> cells = new ArrayList<Pair<Integer, Integer>>();
        int row = 0;
        int col = 0;
        ListIterator<DbVisualEditor<?, ?>> it2 = editors2.listIterator();
        while (it2.hasNext()) {
            DbVisualEditor<?, ?> editor2 = it2.next();
            FieldSize s2 = editor2.getFieldSize();
            int w = DbFormCompoundEditor.getWidth(s2);
            if (col + w > width || col != 0 && editor2.getController().getBuilder().startsNewLine(editor2)) {
                col = 0;
                ++row;
            }
            cells.add((Pair<Integer, Integer>)Pair.create((Object)row, (Object)col));
            col += w;
            if (!editor2.isVertical()) continue;
            assert (s2 == FieldSize.LARGE);
            if (DbFormCompoundEditor.mergeVerticalEditors(cells, it2)) continue;
            ++row;
        }
        cells.add(Pair.create((Object)(row + 1), (Object)0));
        ArrayList<Pair<Integer, Integer>> arrayList = cells;
        if (arrayList == null) {
            DbFormCompoundEditor.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private static boolean mergeVerticalEditors(List<Pair<Integer, Integer>> cells, ListIterator<DbVisualEditor<?, ?>> it2) {
        boolean merged = false;
        while (it2.hasNext()) {
            DbVisualEditor<?, ?> ne = it2.next();
            if (!ne.isVertical()) {
                it2.previous();
                break;
            }
            cells.add(cells.get(cells.size() - 1));
            merged = true;
        }
        return merged;
    }

    public static int getWidth(FieldSize s2) {
        return s2 == FieldSize.LARGE ? 6 : (s2 == FieldSize.MEDIUM ? 4 : 2);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            DbFormCompoundEditor.$$$reportNull$$$0(17);
        }
        return jComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7, 8, 11, 12, 13, 14, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelRef";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbFormCompoundEditor";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbFormCompoundEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualEditors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusComponent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFormComponent";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstraint";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCells";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFormComponent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setEditor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCells";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7, 8, 11, 12, 13, 14, 16, 17 -> new IllegalStateException(string);
        };
    }

    private static class NonStretchablePanel
    extends JPanel {
        private NonStretchablePanel(GridLayoutManager layout) {
            super((LayoutManager)layout);
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension m = super.getMaximumSize();
            Dimension p2 = this.getPreferredSize();
            return new Dimension(m.width, p2.height);
        }
    }
}

