/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridAppearance;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridHelperImpl;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.GridRowComparator;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbFamilyGridDataHookup;
import com.intellij.database.schemaEditor.ui.DbStructureEditor;
import com.intellij.database.schemaEditor.ui.DbVisualEditorBase;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DbFamilyTableEditor<E extends BasicElement, C extends BasicElement>
extends DbVisualEditorBase<E, DbStructureFamilyModelState<C>> {
    private final DbFamilyGridDataHookup<C> myHookup;
    private final JComponent myWrapperPanel;
    private DataGrid myGrid;

    protected DbFamilyTableEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, DbStructureFamilyModelState<C>> modelRef) {
        if (controller == null) {
            DbFamilyTableEditor.$$$reportNull$$$0(0);
        }
        if (modelRef == null) {
            DbFamilyTableEditor.$$$reportNull$$$0(1);
        }
        super(controller, modelRef);
        this.myHookup = new DbFamilyGridDataHookup(this.getController());
        this.myWrapperPanel = new JPanel(new BorderLayout());
        DataManager.registerDataProvider((JComponent)this.myWrapperPanel, this::getData);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    protected void applyImpl() {
    }

    @Override
    protected void resetImpl() {
        this.myHookup.reset(((DbStructureFamilyModelState)this.getState()).getCollection());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        if (this.myGrid == null && this.getController().isEditorRegistered(this)) {
            this.initGrid();
        }
        JComponent jComponent = this.myWrapperPanel;
        if (jComponent == null) {
            DbFamilyTableEditor.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public FieldSize getFieldSize() {
        FieldSize fieldSize = FieldSize.LARGE;
        if (fieldSize == null) {
            DbFamilyTableEditor.$$$reportNull$$$0(3);
        }
        return fieldSize;
    }

    @Override
    public boolean unregister(boolean keepModel) {
        if (!super.unregister(keepModel)) {
            return false;
        }
        this.disposeGrid();
        return true;
    }

    private void initGrid() {
        if (this.myGrid == null) {
            this.myGrid = GridUtil.createDataGrid((Project)this.getController().getProject(), this.myHookup, (ActionGroup)new DefaultActionGroup(), DbFamilyTableEditor::configureGrid);
            Disposer.register((Disposable)this.getController(), (Disposable)this.myGrid);
            this.myWrapperPanel.add((Component)this.myGrid.getPanel().getComponent());
        }
    }

    private static void configureGrid(final @NotNull DataGrid grid, @NotNull DataGridAppearance appearance) {
        if (grid == null) {
            DbFamilyTableEditor.$$$reportNull$$$0(4);
        }
        if (appearance == null) {
            DbFamilyTableEditor.$$$reportNull$$$0(5);
        }
        DataGridUtil.configure(grid, appearance);
        grid.getPanel().getComponent().setPreferredSize((Dimension)JBUI.size((int)100, (int)100));
        grid.setObjectFormatterProvider(g2 -> DbFamilyGridDataHookup.FORMATTER);
        new NavigateAction().registerCustomShortcutSet((JComponent)grid.getPanel().getComponent(), null);
        GridHelper.set((CoreGrid)grid, (GridHelper)new GridHelperImpl(){

            public GridRowComparator createComparator(@NotNull GridColumn column2) {
                if (column2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                final ObjectFormatter formatter = grid.getObjectFormatter();
                return new GridRowComparator(column2){

                    public int compareObjects(Object v1, Object v2) {
                        return Comparing.compare((Comparable)((Object)formatter.objectToString(v1, this.myColumn, DatabaseObjectFormatterConfig.get((ObjectFormatterMode)ObjectFormatterMode.DISPLAY))), (Comparable)((Object)formatter.objectToString(v2, this.myColumn, DatabaseObjectFormatterConfig.get((ObjectFormatterMode)ObjectFormatterMode.DISPLAY))));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/schemaEditor/ui/DbFamilyTableEditor$1", "createComparator"));
            }
        });
    }

    private void disposeGrid() {
        if (this.myGrid != null) {
            this.myWrapperPanel.removeAll();
            Disposer.dispose((Disposable)this.myGrid);
            this.myGrid = null;
        }
    }

    private Object getData(String dataId) {
        if (PlatformCoreDataKeys.FILE_EDITOR.is(dataId)) {
            return this.myGrid == null ? null : GridUtil.getOrCreateEditorWrapper((DataGrid)this.myGrid, (Project)this.getController().getProject(), this::getTitle);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelRef";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbFamilyTableEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appearance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbFamilyTableEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configureGrid";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class NavigateAction
    extends DumbAwareAction {
        private NavigateAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"EditSource");
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                NavigateAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                NavigateAction.$$$reportNull$$$0(1);
            }
            DbStructureEditor structureEditor = (DbStructureEditor)e2.getData(DbStructureEditor.KEY);
            DataGrid grid = (DataGrid)e2.getData(DatabaseDataKeys.DATA_GRID_KEY);
            e2.getPresentation().setEnabledAndVisible(structureEditor != null && grid != null && !grid.getSelectionModel().isSelectionEmpty());
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                NavigateAction.$$$reportNull$$$0(2);
            }
            DbStructureEditor structureEditor = (DbStructureEditor)e2.getData(DbStructureEditor.KEY);
            DataGrid grid = (DataGrid)e2.getData(DatabaseDataKeys.DATA_GRID_KEY);
            if (grid == null || structureEditor == null) {
                return;
            }
            ModelIndexSet selectedRows = grid.getSelectionModel().getSelectedRows();
            if (selectedRows.size() == 0) {
                return;
            }
            List rows = grid.getDataModel(DataAccessType.DATABASE_DATA).getRows(selectedRows);
            ElementIdentity<?> id = MultiElementIdentity.asSingleIdentityFiltered(JBIterable.from((Iterable)rows).filterMap(r -> {
                ElementIdentity elementIdentity;
                if (r instanceof DbFamilyGridDataHookup.DbFamilyGridRow) {
                    DbFamilyGridDataHookup.DbFamilyGridRow fr = (DbFamilyGridDataHookup.DbFamilyGridRow)r;
                    elementIdentity = fr.getIdentity();
                } else {
                    elementIdentity = null;
                }
                return elementIdentity;
            }));
            if (id == null) {
                return;
            }
            structureEditor.edit(id);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbFamilyTableEditor$NavigateAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbFamilyTableEditor$NavigateAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

