/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.state;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelBase;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbStructureFamilyModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbStructureModelApplier;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureNodeState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.schemaEditor.ui.DbEditorUtilsKt;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbStructureModelState
extends DbEditorModelBase.StateBase {
    public static final BasicMetaId ID = BasicMetaId.create("DbStructureModelState");
    private final List<Object> myRoots = new ArrayList<Object>();

    @NotNull
    public List<?> getRoots() {
        List<Object> list = this.myRoots;
        if (list == null) {
            DbStructureModelState.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public boolean register(@NotNull DbEditorModel<?, ?> model2) {
        if (model2 == null) {
            DbStructureModelState.$$$reportNull$$$0(1);
        }
        if (!super.register(model2)) {
            return false;
        }
        DbStructureModelApplier applier = (DbStructureModelApplier)ObjectUtils.tryCast(model2.getApplier(), DbStructureModelApplier.class);
        if (applier != null) {
            DbEditorModelController controller = model2.getController();
            for (DbModelRef<?, ?> m : controller.getAllModelsRefs()) {
                Object obj2 = m.getState();
                if (!(obj2 instanceof DbStructureNodeState)) continue;
                DbStructureNodeState s2 = (DbStructureNodeState)obj2;
                DbModelRef<?, DbStructureNodeState> ref2 = m.castState(s2);
                String group2 = applier.getRootsChecker().getRootGroup(controller, m.getIdentity(), ref2);
                if (group2 == null) continue;
                this.addRoot(ref2, group2.isEmpty() ? null : group2);
            }
        }
        return true;
    }

    @Override
    public boolean unregister(@NotNull DbEditorModel<?, ?> model2) {
        if (model2 == null) {
            DbStructureModelState.$$$reportNull$$$0(2);
        }
        if (!super.unregister(model2)) {
            return false;
        }
        this.setRoots(Collections.emptyList());
        return true;
    }

    public void removeRoot(@NotNull DbModelRef<?, ? extends DbStructureNodeState> root2) {
        if (root2 == null) {
            DbStructureModelState.$$$reportNull$$$0(3);
        }
        this.setRoots(Group.mapWithGroups(this.getRoots(), DbModelRef.class, r -> r.equals(root2) ? null : r));
    }

    public void addRoot(@NotNull DbModelRef<?, ? extends DbStructureNodeState> root2, @Nullable String group2) {
        if (root2 == null) {
            DbStructureModelState.$$$reportNull$$$0(4);
        }
        ArrayList<Object> roots2 = new ArrayList<Object>(this.getRoots());
        if (group2 == null) {
            DbStructureModelState.addToRoots(roots2, root2);
        } else {
            int idx = ContainerUtil.indexOf(roots2, r -> {
                if (!(r instanceof Group)) return false;
                Group g2 = (Group)r;
                if (!g2.name.equals(group2)) return false;
                return true;
            });
            ArrayList<Object> children2 = new ArrayList<Object>();
            if (idx != -1) {
                children2.addAll(((Group)roots2.get((int)idx)).children);
            }
            DbStructureModelState.addToRoots(children2, root2);
            Group<Object> ng = new Group<Object>(group2, children2);
            if (idx != -1) {
                roots2.set(idx, ng);
            } else {
                DbStructureModelState.addToRoots(roots2, ng);
            }
        }
        this.setRoots(roots2);
    }

    private static void addToRoots(List<Object> roots2, Object rt) {
        int insIdx = Collections.binarySearch(roots2, rt, DbStructureModelState::compareRoots);
        roots2.add(insIdx >= 0 ? insIdx : -insIdx - 1, rt);
    }

    private void setRoots(@NotNull List<?> roots2) {
        if (roots2 == null) {
            DbStructureModelState.$$$reportNull$$$0(5);
        }
        if (this.myRoots.equals(roots2)) {
            return;
        }
        this.myRoots.clear();
        this.myRoots.addAll(roots2);
        this.modified();
    }

    public boolean isUnderRoots(@NotNull DbEditorModelController controller, @NotNull DbModelRef<?, ? extends DbStructureNodeState> modelRef) {
        if (controller == null) {
            DbStructureModelState.$$$reportNull$$$0(6);
        }
        if (modelRef == null) {
            DbStructureModelState.$$$reportNull$$$0(7);
        }
        return DbStructureModelState.hasAncestor(controller, this.myRoots, modelRef, false);
    }

    private static boolean hasAncestor(@NotNull DbEditorModelController controller, @NotNull List<?> ancestors, @NotNull DbModelRef<?, ? extends DbStructureNodeState> child, boolean strict) {
        if (controller == null) {
            DbStructureModelState.$$$reportNull$$$0(8);
        }
        if (ancestors == null) {
            DbStructureModelState.$$$reportNull$$$0(9);
        }
        if (child == null) {
            DbStructureModelState.$$$reportNull$$$0(10);
        }
        for (Object a : ancestors) {
            if (!(a instanceof Group ? DbStructureModelState.hasAncestor(controller, ((Group)a).children, child, strict) : DbStructureModelState.isAncestor(controller, (DbModelRef)a, child, strict))) continue;
            return true;
        }
        return false;
    }

    public static boolean isAncestor(@NotNull DbEditorModelController controller, @NotNull DbModelRef<?, ? extends DbStructureNodeState> ancestor, @NotNull DbModelRef<?, ? extends DbStructureNodeState> child, boolean strict) {
        ElementIdentity<?> childId;
        if (controller == null) {
            DbStructureModelState.$$$reportNull$$$0(11);
        }
        if (ancestor == null) {
            DbStructureModelState.$$$reportNull$$$0(12);
        }
        if (child == null) {
            DbStructureModelState.$$$reportNull$$$0(13);
        }
        if (ancestor.equals(child)) {
            return !strict;
        }
        ElementIdentity<?> ancestorId = ancestor.getIdentity();
        if (ancestorId == (childId = child.getIdentity())) {
            return !(ancestor.getState() instanceof DbStructureFamilyModelState);
        }
        ElementIdentity<?> underId = DbEditorUtilsKt.getAncestorUnder(controller.getMatcher(), ancestorId, childId);
        if (underId == null) {
            return false;
        }
        DbStructureNodeState dbStructureNodeState = ancestor.getState();
        if (dbStructureNodeState instanceof DbStructureFamilyModelState) {
            DbStructureFamilyModelState fs = (DbStructureFamilyModelState)dbStructureNodeState;
            return fs.getMetaObject() == underId.getMetaObject();
        }
        return true;
    }

    public boolean isInRoots(@NotNull DbModelRef<?, ? extends DbStructureNodeState> modelRef) {
        if (modelRef == null) {
            DbStructureModelState.$$$reportNull$$$0(14);
        }
        return this.isInRootsImpl(modelRef);
    }

    private boolean isInRootsImpl(@NotNull DbModelRef<?, ? extends DbStructureNodeState> modelRef) {
        if (modelRef == null) {
            DbStructureModelState.$$$reportNull$$$0(15);
        }
        return this.myRoots.contains(modelRef) || this.getContainingGroup(modelRef) != null;
    }

    @Nullable
    public Group<DbModelRef<?, ? extends DbStructureNodeState>> getContainingGroup(@NotNull DbModelRef<?, ? extends DbStructureNodeState> modelRef) {
        if (modelRef == null) {
            DbStructureModelState.$$$reportNull$$$0(16);
        }
        for (Object root2 : this.myRoots) {
            if (!(root2 instanceof Group)) continue;
            Group g2 = (Group)root2;
            if (!g2.children.contains(modelRef)) continue;
            return g2;
        }
        return null;
    }

    @Nullable
    public Group<DbModelRef<?, ? extends DbStructureNodeState>> findGroup(@NotNull String name2) {
        if (name2 == null) {
            DbStructureModelState.$$$reportNull$$$0(17);
        }
        return (Group)JBIterable.from(this.getRoots()).filter(Group.class).find(g2 -> g2.name.equals(name2));
    }

    @Nullable
    public static <E extends BasicElement, S extends DbStructureNodeState<?, ?>> DbModelRef<?, ? extends DbStructureNodeState<?, ?>> getParentModel(@NotNull DbEditorModelController controller, @Nullable DbModelRef<E, S> mm) {
        DbModelRef<E, DbStructureNodeState<E, E>> res2;
        if (controller == null) {
            DbStructureModelState.$$$reportNull$$$0(18);
        }
        if ((res2 = DbStructureFamilyModelState.getParentStructureNode(controller, mm)) != null && controller.getBuilder().isHideFromStructure(res2)) {
            return DbStructureModelState.getParentModel(controller, res2);
        }
        return res2;
    }

    private static int compareObjects(DbModelRef<?, ?> o1, DbModelRef<?, ?> o2) {
        int n;
        ElementIdentity<?> id1 = o1.getIdentity();
        ElementIdentity<?> id2 = o2.getIdentity();
        if (id1 instanceof Comparable) {
            Comparable c2 = (Comparable)((Object)id1);
            n = c2.compareTo(id2);
        } else {
            n = 0;
        }
        return n;
    }

    private static int compareFamilies(DbStructureFamilyModelApplier<?, ?> f1, DbStructureFamilyModelApplier<?, ?> f2) {
        return Integer.compare(f1.getWeight(), f2.getWeight());
    }

    private static int compareGroups(Group<?> g1, Group<?> g2) {
        return Comparing.compare((Comparable)((Object)g1.name), (Comparable)((Object)g2.name));
    }

    private static int compareRoots(Object o1, Object o2) {
        DbStructureObjectModelState os2;
        Group g1 = (Group)ObjectUtils.tryCast((Object)o1, Group.class);
        Group g2 = (Group)ObjectUtils.tryCast((Object)o2, Group.class);
        DbModelRef m1 = (DbModelRef)ObjectUtils.tryCast((Object)o1, DbModelRef.class);
        DbModelRef m2 = (DbModelRef)ObjectUtils.tryCast((Object)o2, DbModelRef.class);
        DbStructureFamilyModelApplier f1 = m1 == null ? null : (DbStructureFamilyModelApplier)ObjectUtils.tryCast(m1.getApplier(), DbStructureFamilyModelApplier.class);
        DbStructureFamilyModelApplier f2 = m2 == null ? null : (DbStructureFamilyModelApplier)ObjectUtils.tryCast(m2.getApplier(), DbStructureFamilyModelApplier.class);
        DbStructureObjectModelState os1 = m1 == null ? null : (DbStructureObjectModelState)ObjectUtils.tryCast(m1.getState(), DbStructureObjectModelState.class);
        DbStructureObjectModelState dbStructureObjectModelState = os2 = m2 == null ? null : (DbStructureObjectModelState)ObjectUtils.tryCast(m2.getState(), DbStructureObjectModelState.class);
        if (g1 != null && g2 != null) {
            return DbStructureModelState.compareGroups(g1, g2);
        }
        if (f1 != null && f2 != null) {
            return DbStructureModelState.compareFamilies(f1, f2);
        }
        if (os1 != null && os2 != null) {
            return DbStructureModelState.compareObjects(m1, m2);
        }
        if (f1 != null) {
            return -1;
        }
        if (f2 != null) {
            return 1;
        }
        if (g1 != null) {
            return -1;
        }
        if (g2 != null) {
            return 1;
        }
        if (os1 != null) {
            return -1;
        }
        if (os2 != null) {
            return 1;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/state/DbStructureModelState";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 7: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelRef";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestors";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/state/DbStructureModelState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setRoots";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUnderRoots";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasAncestor";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInRoots";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isInRootsImpl";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getContainingGroup";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findGroup";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getParentModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18 -> new IllegalArgumentException(string);
        };
    }

    public static class Group<T> {
        public final String name;
        public final List<T> children;

        public Group(@NotNull String name2, @NotNull List<T> children2) {
            if (name2 == null) {
                Group.$$$reportNull$$$0(0);
            }
            if (children2 == null) {
                Group.$$$reportNull$$$0(1);
            }
            this.name = name2;
            this.children = children2;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof Group)) {
                return false;
            }
            Group group2 = (Group)o2;
            return this.name.equals(group2.name) && this.children.equals(group2.children);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.children);
        }

        public static <T, U> List<Object> mapWithGroups(@NotNull List<?> l, final @NotNull Class<T> clazz, final @NotNull Function<T, U> m) {
            if (l == null) {
                Group.$$$reportNull$$$0(2);
            }
            if (clazz == null) {
                Group.$$$reportNull$$$0(3);
            }
            if (m == null) {
                Group.$$$reportNull$$$0(4);
            }
            return ContainerUtil.mapNotNull(l, (Function)new Function<Object, Object>(){

                public Object fun(Object o2) {
                    Object t = ObjectUtils.tryCast((Object)o2, (Class)clazz);
                    if (t != null) {
                        return m.fun(t);
                    }
                    Group g2 = (Group)o2;
                    List newChildren = ContainerUtil.mapNotNull(g2.children, (Function)this);
                    if (newChildren.isEmpty()) {
                        return null;
                    }
                    return new Group(g2.name, newChildren);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "l";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "m";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/model/state/DbStructureModelState$Group";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mapWithGroups";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

