/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.state;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelBase;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelIdentity;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbObjectModelState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbEmbeddedObjectModelState<T extends BasicElement>
extends DbEditorModelBase.StateBase {
    private final ElementIdentity<T> myFallbackIdentity;
    private DbModelRef<T, DbObjectModelState<T>> myTargetRef;
    private boolean myActivated;

    public DbEmbeddedObjectModelState(@Nullable ElementIdentity<T> fallbackIdentity, @NotNull DbEditorModelController controller) {
        if (controller == null) {
            DbEmbeddedObjectModelState.$$$reportNull$$$0(0);
        }
        this.myFallbackIdentity = fallbackIdentity;
        this.setTargetId(this.myFallbackIdentity, controller);
    }

    public void setActivated(@NotNull DbEditorModelController controller, boolean activated) {
        if (controller == null) {
            DbEmbeddedObjectModelState.$$$reportNull$$$0(1);
        }
        if (this.myActivated == activated) {
            return;
        }
        this.myActivated = activated;
        DbModelRef<T, DbObjectModelState<T>> targetRef = this.getTargetRef();
        if (targetRef != null) {
            DbEditorModel<T, DbObjectModelState<T>> targetModel = targetRef.resolve(controller);
            targetModel.getState().setDropped(!activated);
        }
        this.modified();
    }

    private void updateStructure(@NotNull DbEditorModelController controller, ElementIdentity<T> targetId, boolean add) {
        if (controller == null) {
            DbEmbeddedObjectModelState.$$$reportNull$$$0(2);
        }
        if (targetId == null) {
            return;
        }
        controller.updateStructure(targetId, add);
    }

    public boolean isActivated() {
        return this.myActivated;
    }

    @Nullable
    public ElementIdentity<T> getFallbackTargetId() {
        return this.myFallbackIdentity;
    }

    @Nullable
    public ElementIdentity<T> getTargetId() {
        DbModelRef<T, DbObjectModelState<T>> targetRef = this.getTargetRef();
        return targetRef == null ? null : targetRef.getIdentity();
    }

    public void setTargetId(@Nullable ElementIdentity<T> targetId, @NotNull DbEditorModelController controller) {
        DbEditorModel<T, DbObjectModelState<T>> targetModel;
        if (controller == null) {
            DbEmbeddedObjectModelState.$$$reportNull$$$0(3);
        }
        if (this.getTargetId() == targetId) {
            return;
        }
        if (this.myTargetRef != null) {
            targetModel = this.myTargetRef.resolve(controller);
            targetModel.getState().setDropped(true);
            this.myTargetRef.unregister(controller);
        }
        DbModelRef<T, DbObjectModelState<T>> dbModelRef = this.myTargetRef = targetId == null ? null : new DbModelRef<T, DbObjectModelState<T>>(controller.createObjectEditorModel(targetId));
        if (this.myTargetRef != null) {
            targetModel = this.myTargetRef.resolve(controller);
            this.myTargetRef.getState().setDropped(!this.myActivated);
        }
    }

    @Nullable
    public DbModelRef<T, DbObjectModelState<T>> getTargetRef() {
        return this.myTargetRef;
    }

    public static <E extends BasicElement, T extends BasicElement> ElementIdentity<T> createFallbackId(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> identity, @NotNull BasicMetaReference<E, T> reference, boolean inline) {
        if (controller == null) {
            DbEmbeddedObjectModelState.$$$reportNull$$$0(4);
        }
        if (identity == null) {
            DbEmbeddedObjectModelState.$$$reportNull$$$0(5);
        }
        if (reference == null) {
            DbEmbeddedObjectModelState.$$$reportNull$$$0(6);
        }
        if (identity instanceof MultiElementIdentity) {
            return DbEmbeddedObjectModelState.extractFallbackId(controller, new DbModelIdentity(identity, reference.id));
        }
        return controller.getOrCreateFallbackIdentity(identity, reference, () -> inline ? DbEmbeddedObjectModelState.createInlineIdentity(controller, identity, reference) : DbEmbeddedObjectModelState.createIdentity(controller, identity, reference));
    }

    @Nullable
    public static <E extends BasicElement, T extends BasicElement> ElementIdentity<T> createInlineIdentity(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> identity, @NotNull BasicMetaReference<E, T> reference) {
        BasicMetaObject<? extends T>[] targets2;
        if (controller == null) {
            DbEmbeddedObjectModelState.$$$reportNull$$$0(7);
        }
        if (identity == null) {
            DbEmbeddedObjectModelState.$$$reportNull$$$0(8);
        }
        if (reference == null) {
            DbEmbeddedObjectModelState.$$$reportNull$$$0(9);
        }
        BasicMetaObject meta = (targets2 = reference.getReferenceDesc().targets).length == 0 ? null : targets2[0];
        ElementMatcher matcher = controller.getMatcher();
        return meta == null ? null : matcher.createInlineRef(identity, reference, meta);
    }

    @Nullable
    public static <E extends BasicElement, T extends BasicElement> ElementIdentity<T> createIdentity(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> identity, @NotNull BasicMetaReference<E, T> reference) {
        BasicMetaObject<? extends T>[] targets2;
        if (controller == null) {
            DbEmbeddedObjectModelState.$$$reportNull$$$0(10);
        }
        if (identity == null) {
            DbEmbeddedObjectModelState.$$$reportNull$$$0(11);
        }
        if (reference == null) {
            DbEmbeddedObjectModelState.$$$reportNull$$$0(12);
        }
        BasicMetaObject meta = (targets2 = reference.getReferenceDesc().targets).length == 0 ? null : targets2[0];
        ElementIdentity<Object> id = identity;
        BasicMetaObject<?> common = BasicMetaUtils.commonAncestor(id.getMetaObject(), meta);
        if (common == null) {
            return null;
        }
        ElementMatcher matcher = controller.getMatcher();
        while (id != null && id.getMetaObject() != common) {
            id = matcher.getParent(id);
        }
        if (id == null) {
            return null;
        }
        return DbEmbeddedObjectModelState.createIdentityImpl(matcher, id, meta);
    }

    public static <E extends BasicElement, T extends BasicElement> ElementIdentity<T> createMultiFallbackId(@NotNull DbEditorModelController controller, MultiElementIdentity<E> multi, BasicMetaId modelKey) {
        if (controller == null) {
            DbEmbeddedObjectModelState.$$$reportNull$$$0(13);
        }
        DbModelIdentity modelId = new DbModelIdentity(multi, modelKey);
        return DbEmbeddedObjectModelState.extractFallbackId(controller, modelId);
    }

    @Nullable
    private static <E extends BasicElement, T extends BasicElement> ElementIdentity<T> extractFallbackId(@NotNull DbEditorModelController controller, @NotNull DbModelIdentity<E, DbEmbeddedObjectModelState<T>> modelId) {
        if (controller == null) {
            DbEmbeddedObjectModelState.$$$reportNull$$$0(14);
        }
        if (modelId == null) {
            DbEmbeddedObjectModelState.$$$reportNull$$$0(15);
        }
        if (modelId.getIdentity() instanceof MultiElementIdentity) {
            return MultiElementIdentity.create(MultiElementIdentity.expand(modelId.getIdentity()).map(id -> id == null ? null : DbEmbeddedObjectModelState.extractFallbackId(controller, modelId.switchTo((ElementIdentity)id))).toList());
        }
        DbEditorModel<E, DbEmbeddedObjectModelState<T>> subModel = controller.resolveRegisteredOrCachedModel(modelId);
        DbEmbeddedObjectModelState<T> subState = subModel == null ? null : subModel.getState();
        return subState == null ? null : subState.getFallbackTargetId();
    }

    private static <U extends BasicElement> ElementIdentity<U> createIdentityImpl(ElementMatcher matcher, ElementIdentity<?> id, BasicMetaObject<U> meta) {
        if (id.getMetaObject() == meta) {
            ElementIdentity<?> casted = id;
            return casted;
        }
        BasicMetaObject<?> metaParent = meta.getParent();
        if (metaParent == null) {
            return null;
        }
        ElementIdentity<?> parentId = DbEmbeddedObjectModelState.createIdentityImpl(matcher, id, metaParent);
        if (parentId == null) {
            return null;
        }
        return matcher.create(parentId, meta);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/schemaEditor/model/state/DbEmbeddedObjectModelState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setActivated";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateStructure";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setTargetId";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createFallbackId";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createInlineIdentity";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createIdentity";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createMultiFallbackId";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "extractFallbackId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

